/*
 * Decompiled with CFR 0.152.
 */
package solver;

import constraints.Constraint;
import heuristics.HeuristicValuesDynamic;
import heuristics.HeuristicVariables;
import interfaces.Observers;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import learning.IpsRecorder;
import learning.NogoodMinimizer;
import learning.NogoodRecorder;
import main.Head;
import org.xcsp.common.Types;
import problem.Problem;
import propagation.Forward;
import propagation.Propagation;
import sets.SetDense;
import sets.SetSparseReversible;
import solver.DecisionRecorder;
import solver.FutureVariables;
import solver.LastConflict;
import solver.Restarter;
import solver.SolutionRecorder;
import solver.Statistics;
import utility.Enums;
import utility.Kit;
import variables.DomainInfinite;
import variables.Variable;

public class Solver
implements Observers.ObserverRuns,
Observers.ObserverBacktracking.ObserverBacktrackingSystematic {
    public static int cnt = 0;
    public final List<Observers.ObserverSearch> observersSearch;
    public List<Observers.ObserverRuns> observersRuns;
    public List<Observers.ObserverAssignment> observersAssignment;
    public List<Observers.ObserverConflicts> observersConflicts;
    public final Head head;
    public final Problem problem;
    public final FutureVariables futVars;
    public final SolutionRecorder solRecorder;
    public final Restarter restarter;
    public Propagation propagation;
    public final DecisionRecorder decRecorder;
    public HeuristicVariables heuristic;
    public final LastConflict lastConflict;
    public final NogoodRecorder nogoodRecorder;
    public final IpsRecorder ipsRecorder;
    public final Proofer proofer;
    public final StackedVariables stackedVariables;
    public final SetSparseReversible entailed;
    public final List<Observers.ObserverBacktracking.ObserverBacktrackingSystematic> observersBacktrackingSystematic;
    public final RunProgressSaver runProgressSaver;
    public final WarmStarter warmStarter;
    public final Tracer tracer;
    public int minDepth;
    public int maxDepth;
    public NogoodMinimizer nogoodMinimizer;
    public Enums.EStopping stopping;
    public Statistics stats;
    private final Variable[] lastPastBeforeRun = new Variable[2];
    private int nRecursiveRuns = 0;

    @Override
    public void beforeRun() {
        if (this.runProgressSaver != null) {
            this.runProgressSaver.beforeRun();
        }
    }

    @Override
    public void afterRun() {
        if (this.runProgressSaver != null) {
            this.runProgressSaver.afterRun();
        }
    }

    @Override
    public void restoreBefore(int depth) {
        this.stackedVariables.restoreBefore(depth);
        this.entailed.restoreLimitAtLevel(depth);
    }

    public int stackVariable(Variable x) {
        return this.stackedVariables.push(x);
    }

    private List<Observers.ObserverBacktracking.ObserverBacktrackingSystematic> collectObserversBacktrackingSystematic() {
        ArrayList<Observers.ObserverBacktracking.ObserverBacktrackingSystematic> list = new ArrayList<Observers.ObserverBacktracking.ObserverBacktrackingSystematic>();
        list.add(this);
        Stream.of(this.problem.constraints).filter(c -> c instanceof Observers.ObserverBacktracking.ObserverBacktrackingSystematic).forEach(c -> list.add((Observers.ObserverBacktracking.ObserverBacktrackingSystematic)((Object)c)));
        if (this.propagation instanceof Observers.ObserverBacktracking.ObserverBacktrackingSystematic) {
            list.add((Observers.ObserverBacktracking.ObserverBacktrackingSystematic)((Object)this.propagation));
        }
        return list;
    }

    protected List<Observers.ObserverRuns> collectObserversRuns() {
        ArrayList<Observers.ObserverRuns> list = new ArrayList<Observers.ObserverRuns>();
        if (this.head.control.solving.enableSearch) {
            if (this.nogoodRecorder != null && this.nogoodRecorder.symmetryHandler != null) {
                list.add(this.nogoodRecorder.symmetryHandler);
            }
            Stream.of(this, this.restarter, this.ipsRecorder, this.heuristic, this.lastConflict, this.stats).filter(o -> o instanceof Observers.ObserverRuns).forEach(o -> list.add((Observers.ObserverRuns)o));
        }
        Stream.of(this.problem.constraints).filter(c -> c instanceof Observers.ObserverRuns).forEach(c -> list.add((Observers.ObserverRuns)((Object)c)));
        if (this.propagation instanceof Observers.ObserverRuns) {
            list.add((Observers.ObserverRuns)((Object)this.propagation));
        }
        list.add(this.head.output);
        return list;
    }

    protected List<Observers.ObserverAssignment> collectObserversAssignment() {
        ArrayList<Observers.ObserverAssignment> list = new ArrayList<Observers.ObserverAssignment>();
        if (this.heuristic instanceof Observers.ObserverAssignment) {
            list.add((Observers.ObserverAssignment)((Object)this.heuristic));
        }
        return list;
    }

    protected List<Observers.ObserverConflicts> collectObserversPropagation() {
        ArrayList<Observers.ObserverConflicts> list = new ArrayList<Observers.ObserverConflicts>();
        if (this.heuristic instanceof Observers.ObserverConflicts) {
            list.add((Observers.ObserverConflicts)((Object)this.heuristic));
        }
        return list;
    }

    public final boolean isFullExploration() {
        return this.stopping == Enums.EStopping.FULL_EXPLORATION;
    }

    public final boolean finished() {
        if (this.stopping != null) {
            return true;
        }
        if (this.head.isTimeExpiredForCurrentInstance()) {
            this.stopping = Enums.EStopping.EXCEEDED_TIME;
            return true;
        }
        return false;
    }

    public final void resetNoSolutions() {
        this.stopping = null;
        this.solRecorder.found = 0L;
    }

    public void reset() {
        Kit.control(this.futVars.nDiscarded() == 0);
        this.propagation.reset();
        this.restarter.reset();
        this.resetNoSolutions();
        this.decRecorder.reset();
        this.heuristic.setPriorityVars(this.problem.priorityVars, 0);
        this.lastConflict.beforeRun();
        if (this.nogoodRecorder != null) {
            this.nogoodRecorder.reset();
        }
        Kit.control(this.ipsRecorder == null);
        Kit.control(this.stackedVariables.top == -1, () -> "Top= " + this.stackedVariables.top);
        this.stats = new Statistics.StatisticsBacktrack(this);
        Kit.control(!this.proofer.active);
    }

    public Solver(Head head) {
        this.head = head;
        this.problem = head.problem;
        this.problem.solver = this;
        this.futVars = new FutureVariables(this.problem.variables);
        this.solRecorder = new SolutionRecorder(this, head.control.general.nSearchedSolutions);
        this.propagation = Propagation.buildFor(this);
        if (!head.control.propagation.useAuxiliaryQueues) {
            Stream.of(this.problem.constraints).forEach(c -> {
                c.filteringComplexity = 0;
            });
        }
        this.restarter = Restarter.buildFor(this);
        this.observersSearch = Stream.of(this.problem.constraints).filter(c -> c instanceof Observers.ObserverSearch).map(c -> (Observers.ObserverSearch)((Object)c)).collect(Collectors.toCollection(ArrayList::new));
        this.observersSearch.add(head.output);
        this.decRecorder = new DecisionRecorder(this);
        this.heuristic = HeuristicVariables.buildFor(this);
        for (Variable x2 : this.problem.variables) {
            x2.buildValueOrderingHeuristic();
        }
        this.lastConflict = new LastConflict(this, head.control.varh.lc);
        this.nogoodRecorder = NogoodRecorder.buildFor(this);
        this.ipsRecorder = IpsRecorder.buildFor(this);
        this.proofer = new Proofer(this.ipsRecorder);
        int nLevels = this.problem.variables.length + 1;
        int size = Stream.of(this.problem.variables).mapToInt(x -> x.dom.initSize()).reduce(0, (sum, domSize) -> sum + Math.min(nLevels, domSize));
        this.stackedVariables = new StackedVariables(size + nLevels);
        this.entailed = new SetSparseReversible(this.problem.constraints.length, false, nLevels);
        this.observersBacktrackingSystematic = this.collectObserversBacktrackingSystematic();
        this.observersRuns = this.collectObserversRuns();
        this.observersAssignment = this.collectObserversAssignment();
        this.observersConflicts = this.collectObserversPropagation();
        this.tracer = new Tracer(head.control.general.trace);
        this.stats = new Statistics.StatisticsBacktrack(this);
        this.observersSearch.add(0, this.stats);
        this.runProgressSaver = head.control.valh.runProgressSaving ? new RunProgressSaver() : null;
        this.warmStarter = head.control.valh.warmStart.length() > 0 ? new WarmStarter(head.control.valh.warmStart) : null;
        this.nogoodMinimizer = new NogoodMinimizer(this);
    }

    public int depth() {
        return this.futVars.nDiscarded();
    }

    public void entail(Constraint c) {
        this.entailed.add(c.num, this.depth());
    }

    public boolean isEntailed(Constraint c) {
        return this.entailed.isPresent(c.num);
    }

    public void assign(Variable x, int a) {
        assert (!x.assigned());
        ++this.stats.nAssignments;
        this.futVars.assign(x);
        x.doAssignment(a);
        this.decRecorder.addPositiveDecision(x, a);
        for (Observers.ObserverAssignment obs : this.observersAssignment) {
            obs.afterAssignment(x, a);
        }
    }

    public final void backtrack(Variable x) {
        int depthBeforeBacktrack = this.depth();
        this.futVars.unassign(x);
        x.undoAssignment();
        this.decRecorder.delPositiveDecision(x);
        for (Observers.ObserverAssignment observerAssignment : this.observersAssignment) {
            observerAssignment.afterUnassignment(x);
        }
        for (Observers.ObserverBacktracking.ObserverBacktrackingSystematic observerBacktrackingSystematic : this.observersBacktrackingSystematic) {
            observerBacktrackingSystematic.restoreBefore(depthBeforeBacktrack);
        }
        if (this.propagation instanceof Forward) {
            this.propagation.queue.clear();
        }
    }

    public final void backtrack() {
        this.backtrack(this.futVars.lastPast());
    }

    public final boolean tryAssignment(Variable x, int a) {
        boolean consistent;
        SetDense inconsistent;
        boolean b = false;
        if (b && x.heuristic instanceof HeuristicValuesDynamic.Bivs && (inconsistent = ((HeuristicValuesDynamic.Bivs)x.heuristic).inconsistent).size() > 0) {
            boolean inc;
            boolean bl = inc = inconsistent.size() == x.dom.size();
            if (!inc) {
                boolean r = x.dom.remove(inconsistent);
                assert (r);
                inc = !this.propagation.propagate();
            }
            inconsistent.clear();
            if (inc) {
                ++this.stats.nWrongDecisions;
                ++this.stats.nFailedAssignments;
                return false;
            }
        }
        this.tracer.onAssignment(x, a);
        this.stats.onAssignment(x);
        this.lastConflict.onAssignment(x);
        this.assign(x, a);
        this.proofer.reset();
        boolean bl = consistent = this.propagation.runAfterAssignment(x) && (this.ipsRecorder == null || this.ipsRecorder.dealWhenOpeningNode());
        if (!consistent) {
            int n = a;
            x.failed[n] = x.failed[n] + 1;
            ++this.stats.nWrongDecisions;
            ++this.stats.nFailedAssignments;
            return false;
        }
        return true;
    }

    public final boolean tryAssignment(Variable x) {
        return this.tryAssignment(x, x.heuristic.bestIndex());
    }

    protected void manageEmptyDomainBeforeBacktracking() {
        if (this.runProgressSaver != null) {
            this.runProgressSaver.manageEmptyDomainBeforeBacktracking();
        }
        this.tracer.onBacktrack();
        ++this.stats.nBacktracks;
        if (this.ipsRecorder != null) {
            this.ipsRecorder.dealWhenClosingNode();
        }
        if (this.futVars.nDiscarded() == 0) {
            this.stopping = Enums.EStopping.FULL_EXPLORATION;
        }
    }

    protected final boolean tryRefutation(Variable x, int a) {
        boolean consistent;
        if (x.dom instanceof DomainInfinite) {
            return false;
        }
        this.tracer.onRefutation(x, a);
        this.stats.onRefutation(x);
        this.lastConflict.onRefutation(x, a);
        this.decRecorder.addNegativeDecision(x, a);
        this.proofer.recopy();
        x.dom.removeElementary(a);
        boolean bl = consistent = x.dom.size() > 0;
        if (consistent) {
            if (this.head.control.solving.branching == Enums.EBranching.NON) {
                return true;
            }
            consistent = this.propagation.runAfterRefutation(x);
            if (!consistent) {
                ++this.stats.nWrongDecisions;
            }
        }
        if (!consistent) {
            this.manageEmptyDomainBeforeBacktracking();
        }
        return consistent;
    }

    private void manageContradiction(Constraint.CtrGlobal objectiveToCheck) {
        boolean consistent = false;
        while (!consistent && this.stopping != Enums.EStopping.FULL_EXPLORATION) {
            Variable x = this.futVars.lastPast();
            if (x == this.lastPastBeforeRun[this.nRecursiveRuns - 1] && !this.head.control.lns.enabled) {
                this.stopping = Enums.EStopping.FULL_EXPLORATION;
                continue;
            }
            int a = x.dom.unique();
            this.backtrack(x);
            consistent = this.tryRefutation(x, a) && this.propagation.propagate(objectiveToCheck);
        }
    }

    public void explore() {
        this.maxDepth = 0;
        while (!this.finished() && !this.restarter.currRunFinished()) {
            Constraint.CtrGlobal objectiveCtr;
            while (!this.finished() && !this.restarter.currRunFinished() && this.futVars.size() != 0) {
                this.maxDepth = Math.max(this.maxDepth, this.depth());
                if (this.tryAssignment(this.heuristic.bestVar())) continue;
                this.manageContradiction(null);
            }
            if (this.futVars.size() != 0) continue;
            this.solRecorder.handleNewSolution();
            boolean copContinue = this.problem.settings.framework == Types.TypeFramework.COP && !this.head.control.restarts.restartAfterSolution;
            Constraint.CtrGlobal ctrGlobal = objectiveCtr = copContinue ? (Constraint.CtrGlobal)((Object)this.problem.optimizer.ctr) : null;
            if (copContinue) {
                Variable x;
                this.problem.optimizer.ctr.limit(this.problem.optimizer.ctr.objectiveValue() + (long)(this.problem.optimizer.minimization ? -1 : 1));
                int backtrackLevel = -1;
                for (int i = 0; i < objectiveCtr.scp.length && (x = objectiveCtr.scp[objectiveCtr.futvars.dense[i]]).assignmentLevel() > backtrackLevel; ++i) {
                    backtrackLevel = Math.max(backtrackLevel, x.dom.lastRemovedLevel());
                }
                assert (backtrackLevel != -1);
                while (this.depth() > backtrackLevel) {
                    this.backtrack(this.futVars.lastPast());
                }
            }
            if (this.problem.settings.framework == Types.TypeFramework.COP) {
                this.entailed.clear();
            }
            if (this.finished() || this.restarter.currRunFinished()) continue;
            this.manageContradiction(objectiveCtr);
        }
        this.minDepth = this.decRecorder.minDepth();
        if (this.nogoodRecorder != null && !this.finished() && !this.restarter.allRunsFinished()) {
            this.nogoodRecorder.addNogoodsOfCurrentBranch();
        }
    }

    private void backtrackTo(Variable x) {
        if (x != null && !x.assigned()) {
            x = null;
        }
        while (this.futVars.lastPast() != x) {
            this.backtrack(this.futVars.lastPast());
        }
    }

    public void backtrackToTheRoot() {
        this.backtrackTo(null);
    }

    public Solver doRun() {
        this.lastPastBeforeRun[this.nRecursiveRuns++] = this.futVars.lastPast();
        this.explore();
        this.backtrackTo(this.lastPastBeforeRun[--this.nRecursiveRuns]);
        return this;
    }

    private final void doPrepro() {
        for (Observers.ObserverSearch observer : this.observersSearch) {
            observer.beforePreprocessing();
        }
        if (!this.propagation.runInitially()) {
            this.stopping = Enums.EStopping.FULL_EXPLORATION;
        }
        for (Observers.ObserverSearch observer : this.observersSearch) {
            observer.afterPreprocessing();
        }
    }

    protected final void doSearch() {
        for (Observers.ObserverSearch observerSearch : this.observersSearch) {
            observerSearch.beforeSearch();
        }
        while (!this.finished() && !this.restarter.allRunsFinished()) {
            for (Observers.ObserverRuns observerRuns : this.observersRuns) {
                observerRuns.beforeRun();
            }
            if (this.stopping != Enums.EStopping.FULL_EXPLORATION) {
                this.doRun();
            }
            for (Observers.ObserverRuns observerRuns : this.observersRuns) {
                observerRuns.afterRun();
            }
            this.decRecorder.reset();
        }
        for (Observers.ObserverSearch observerSearch : this.observersSearch) {
            observerSearch.afterSearch();
        }
    }

    public void solve() {
        for (Observers.ObserverSearch observer : this.observersSearch) {
            observer.beforeSolving();
        }
        if (Variable.firstWipeoutVariableIn(this.problem.variables) != null) {
            this.stopping = Enums.EStopping.FULL_EXPLORATION;
        }
        if (!this.finished() && this.head.control.solving.enablePrepro) {
            this.doPrepro();
        }
        if (!this.finished() && this.head.control.solving.enableSearch) {
            this.doSearch();
        }
        for (Observers.ObserverSearch observer : this.observersSearch) {
            observer.afterSolving();
        }
        this.restoreProblem();
    }

    public final void restoreProblem() {
        this.backtrackToTheRoot();
        this.stackedVariables.restoreBefore(0);
        this.observersBacktrackingSystematic.stream().forEach(obs -> obs.restoreBefore(0));
        this.decRecorder.reset();
        assert (Stream.of(this.problem.variables).allMatch(x -> x.dom.controlStructures()));
    }

    public final class Tracer {
        private boolean active;
        private int minDepthLimit;
        private int maxDepthLimit;

        private Tracer(String s) {
            this.active = s.length() != 0;
            StringTokenizer st = this.active && s.contains("-") ? new StringTokenizer(s, "-") : null;
            this.minDepthLimit = st != null && st.hasMoreTokens() ? Integer.parseInt(st.nextToken()) : Integer.MIN_VALUE;
            this.maxDepthLimit = st != null && st.hasMoreTokens() ? Integer.parseInt(st.nextToken()) : Integer.MAX_VALUE;
        }

        private boolean canCurrentlyPrint() {
            return this.active && !Solver.this.propagation.performingProperSearch && this.minDepthLimit <= Solver.this.depth() && Solver.this.depth() <= this.maxDepthLimit;
        }

        public void onBacktrack() {
            if (this.canCurrentlyPrint()) {
                Kit.log.fine("        Backtrack ");
            }
        }

        public void onAssignment(Variable x, int a) {
            if (this.canCurrentlyPrint()) {
                Kit.log.fine("At " + Solver.this.depth() + ", " + x + " = " + x.dom.toVal(a) + (x.dom.indexesMatchValues() ? "" : " (index " + a + ") ") + (x.dom.size() == 1 ? " singleton" : ""));
            }
        }

        public void onRefutation(Variable x, int a) {
            if (this.canCurrentlyPrint()) {
                Kit.log.fine("At " + Solver.this.depth() + ", " + x + " != " + x.dom.toVal(a));
            }
        }
    }

    public final class Proofer {
        private final boolean active;
        public final boolean[][] proofVariables;

        public Proofer(IpsRecorder recorder) {
            this.active = recorder != null && Solver.this.ipsRecorder.reductionOperator.enablePElimination();
            this.proofVariables = this.active ? new boolean[Solver.this.problem.variables.length + 1][Solver.this.problem.variables.length] : null;
        }

        public void updateProof(Constraint c) {
            if (this.active) {
                for (Variable x : c.scp) {
                    this.proofVariables[Solver.this.depth()][x.num] = true;
                }
            }
        }

        public void updateProof(int[] nums) {
            if (this.active) {
                for (int num : nums) {
                    this.proofVariables[Solver.this.depth()][num] = true;
                }
            }
        }

        public void updateProofAll() {
            if (this.active) {
                Arrays.fill(this.proofVariables[Solver.this.depth()], true);
            }
        }

        public void reset() {
            if (this.active) {
                Arrays.fill(this.proofVariables[Solver.this.depth()], false);
            }
        }

        public void recopy() {
            if (this.active) {
                int d = Solver.this.depth();
                for (int i = Solver.this.problem.variables.length - 1; i >= 0; --i) {
                    if (!this.proofVariables[d + 1][i]) continue;
                    this.proofVariables[d][i] = true;
                }
            }
        }
    }

    public final class StackedVariables {
        public final Variable[] stack;
        public int top = -1;

        public StackedVariables(int size) {
            this.stack = new Variable[size];
        }

        public int push(Variable x) {
            int depth = Solver.this.depth();
            assert (x.dom.lastRemovedLevel() <= depth);
            if (x.dom.lastRemovedLevel() != depth) {
                if (this.top == -1 || this.stack[this.top].dom.lastRemovedLevel() != depth) {
                    this.stack[++this.top] = null;
                }
                this.stack[++this.top] = x;
            }
            return depth;
        }

        public void restoreBefore(int depth) {
            if (this.top == -1 || this.stack[this.top].dom.lastRemovedLevel() < depth) {
                return;
            }
            while (this.stack[this.top] != null) {
                this.stack[this.top].restoreBefore(depth);
                --this.top;
            }
            --this.top;
            assert (this.controlStack(depth));
        }

        private boolean controlStack(int depth) {
            if (this.top < -1) {
                return false;
            }
            if (this.top == -1) {
                return true;
            }
            if (this.stack[this.top] == null) {
                return false;
            }
            assert (this.stack[this.top] instanceof Variable);
            Variable x = Stream.of(Solver.this.problem.variables).filter(y -> !(y.dom instanceof DomainInfinite) && y.dom.lastRemovedLevel() >= depth).findFirst().orElse(null);
            if (x != null) {
                System.out.println("Pb with " + x);
                x.dom.display(true);
                return false;
            }
            return true;
        }
    }

    public final class RunProgressSaver {
        int[] prevLongestRunBranch;
        int prevSize;
        int[] currLongestRunBranch;
        int currSize;

        RunProgressSaver() {
            this.prevLongestRunBranch = new int[Solver.this.problem.variables.length];
            this.currLongestRunBranch = new int[Solver.this.problem.variables.length];
        }

        boolean desactivated() {
            return Solver.this.solRecorder.found > 0L && Solver.this.head.control.valh.solutionSaving;
        }

        void manageEmptyDomainBeforeBacktracking() {
            if (this.desactivated()) {
                return;
            }
            int d = Solver.this.depth();
            if (d >= this.currSize) {
                this.currSize = d;
                for (int i = 0; i < this.prevLongestRunBranch.length; ++i) {
                    this.prevLongestRunBranch[i] = Solver.this.problem.variables[i].dom.size() == 1 ? Solver.this.problem.variables[i].dom.unique() : -1;
                }
            }
        }

        void beforeRun() {
            this.currSize = 0;
        }

        void afterRun() {
            if (this.desactivated()) {
                return;
            }
            for (int i = 0; i < this.prevLongestRunBranch.length; ++i) {
                this.prevLongestRunBranch[i] = this.currLongestRunBranch[i];
            }
            this.prevSize = this.currSize;
        }

        public int valueOf(Variable x) {
            return this.prevSize == 0 ? -1 : this.prevLongestRunBranch[x.num];
        }
    }

    public final class WarmStarter {
        int[] sol;

        private String[] possiblyDecompact(String[] t) {
            ArrayList<String> list = null;
            for (int i = 0; i < t.length; ++i) {
                boolean compact = t[i].contains("x");
                if (compact && list == null) {
                    list = new ArrayList<String>();
                    for (int j = 0; j < i; ++j) {
                        list.add(t[j]);
                    }
                }
                if (list == null) continue;
                if (compact) {
                    String[] tmp = t[i].split("x");
                    assert (tmp.length == 2);
                    for (int j = Integer.parseInt(tmp[1]) - 1; j >= 0; --j) {
                        list.add(tmp[0]);
                    }
                    continue;
                }
                list.add(t[i]);
            }
            return list != null ? (String[])list.stream().toArray(String[]::new) : t;
        }

        WarmStarter(String s) {
            File file = new File(s);
            if (file.exists()) {
                try (BufferedReader in = new BufferedReader(new FileReader(s));){
                    StringBuilder sb = new StringBuilder();
                    String line = in.readLine();
                    while (line != null) {
                        sb.append(line);
                        line = in.readLine();
                    }
                    s = sb.toString().trim();
                }
                catch (IOException e) {
                    Kit.exit(e);
                }
            }
            String[] t = this.possiblyDecompact(s.split("\\s+"));
            int p = t.length;
            int n = Solver.this.problem.variables.length;
            Kit.control(1 < p && p <= n, () -> p + " vs " + n + (p == 1 ? " did you control the path for the file?" : ""));
            if (p < n) {
                Kit.log.warning("Missing values are completed with * (for presumably auxiliary variables). Is that correct?");
                t = (String[])Stream.concat(Stream.of(t), IntStream.range(0, n - p).mapToObj(i -> "*")).toArray(String[]::new);
            }
            this.sol = new int[t.length];
            for (int i2 = 0; i2 < this.sol.length; ++i2) {
                if (t[i2].equals("*")) {
                    this.sol[i2] = -1;
                    continue;
                }
                int a = Solver.this.problem.variables[i2].dom.toPresentIdx(Integer.parseInt(t[i2]));
                Kit.control(a != -1);
                this.sol[i2] = a;
            }
        }

        public int valueOf(Variable x) {
            return this.sol[x.num];
        }
    }
}

