/*
 * Decompiled with CFR 0.152.
 */
package solver;

import constraints.Constraint;
import constraints.global.Sum;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.xcsp.common.Types;
import org.xcsp.modeler.entities.VarEntities;
import solver.Solver;
import utility.Enums;
import utility.Kit;
import variables.Variable;

public final class SolutionRecorder {
    public final Solver solver;
    public long limit;
    public long found;
    public long bestBound;
    public int[] lastSolution;
    public int lastSolutionRun = -1;
    public String lastSolutionXml;
    public final List<int[]> allSolutions;
    private AtomicBoolean lock = new AtomicBoolean();
    public final String listVars;
    public final String listVarsWithoutAuxiliary;
    private int h1 = -1;
    private int h2 = -1;

    private void update(Object object, List<Integer> list) {
        if (object == null) {
            list.add(0x7FFFFFFE);
        } else if (object instanceof Variable) {
            list.add(((Variable)object).dom.toVal(((Variable)object).valueIndexInLastSolution));
        } else {
            Stream.of((Object[])object).forEach(o -> this.update(o, list));
        }
    }

    private void addls(int value, int cnt, List<String> ls) {
        String v;
        String string = v = value == 0x7FFFFFFE ? "*" : value + "";
        if (cnt > 1) {
            ls.add(v + "x" + cnt);
        } else {
            for (int k = 0; k < cnt; ++k) {
                ls.add(v);
            }
        }
    }

    private String compactValues(boolean discardAuxiliary) {
        Kit.control(this.solver.problem.features.nSymbolicVars == 0);
        ArrayList<String> ls = new ArrayList<String>();
        ArrayList<Integer> list = new ArrayList<Integer>();
        block0: for (VarEntities.VarEntity va : this.solver.problem.varEntities.allEntities) {
            if (this.solver.problem.undisplay.contains(va.id) || discardAuxiliary && va.id.startsWith("_ax_")) continue;
            this.update(va instanceof VarEntities.VarAlone ? ((VarEntities.VarAlone)va).var : ((VarEntities.VarArray)VarEntities.VarArray.class.cast((Object)va)).vars, list);
            int last = (Integer)list.get(list.size() - 1);
            for (int i = list.size() - 2; i >= 0; --i) {
                int j;
                if ((Integer)list.get(i) == last) continue;
                int prev = (Integer)list.get(0);
                int cnt = 1;
                for (j = 1; j <= i; ++j) {
                    if ((Integer)list.get(j) == prev) {
                        ++cnt;
                        continue;
                    }
                    this.addls(prev, cnt, ls);
                    prev = (Integer)list.get(j);
                    cnt = 1;
                }
                this.addls(prev, cnt, ls);
                for (j = 0; j <= i; ++j) {
                    list.remove(0);
                }
                continue block0;
            }
        }
        this.addls((Integer)list.get(0), list.size(), ls);
        return ls.stream().collect(Collectors.joining(" "));
    }

    private String valsForXml(boolean compact, boolean discardAuxiliary) {
        if (compact && this.solver.problem.features.nSymbolicVars == 0) {
            return this.compactValues(discardAuxiliary);
        }
        StringBuilder sb = new StringBuilder();
        for (VarEntities.VarEntity va : this.solver.problem.varEntities.allEntities) {
            if (this.solver.problem.undisplay.contains(va.id) || discardAuxiliary && va.id.startsWith("_ax_")) continue;
            if (sb.length() > 0) {
                sb.append(" ");
            }
            if (va instanceof VarEntities.VarAlone) {
                Variable x = (Variable)((VarEntities.VarAlone)va).var;
                sb.append(x.dom.prettyValueOf(x.valueIndexInLastSolution));
                continue;
            }
            sb.append(Variable.rawInstantiationOf(((VarEntities.VarArray)VarEntities.VarArray.class.cast((Object)va)).vars));
        }
        return sb.toString();
    }

    private String varsForXml(boolean discardAuxiliary) {
        StringBuilder sb = new StringBuilder();
        for (VarEntities.VarEntity va : this.solver.problem.varEntities.allEntities) {
            if (this.solver.problem.undisplay.contains(va.id) || discardAuxiliary && va.id.startsWith("_ax_")) continue;
            sb.append(sb.length() > 0 ? " " : "").append(va.id).append(va instanceof VarEntities.VarArray ? ((VarEntities.VarArray)va).getEmptyStringSize() : "");
        }
        return sb.toString();
    }

    public String lastSolutionInXmlFormat() {
        assert (this.found > 0L);
        StringBuilder sb = new StringBuilder("<instantiation id='sol").append(this.found).append("' type='solution'");
        sb.append(this.solver.problem.settings.framework != Types.TypeFramework.CSP ? " cost='" + this.bestBound + "'" : "").append(">");
        sb.append(" <list> ").append(this.listVarsWithoutAuxiliary).append(" </list> <values> ").append(this.valsForXml(this.solver.problem.settings.xmlCompact, true));
        String s = sb.append(" </values> </instantiation>").toString();
        if (this.lastSolutionXml != null) {
            this.lastSolutionXml = s;
        }
        return s;
    }

    public String lastSolutionInJsonFormat() {
        assert (this.found > 0L);
        boolean discardAuxiliary = !this.solver.head.control.general.jsonAux;
        String PREFIX = "   ";
        StringBuilder sb = new StringBuilder(PREFIX).append("{\n");
        for (VarEntities.VarEntity va : this.solver.problem.varEntities.allEntities) {
            if (this.solver.problem.undisplay.contains(va.id) || discardAuxiliary && va.id.startsWith("_ax_")) continue;
            sb.append(PREFIX).append(" ").append(va.id).append(": ");
            if (va instanceof VarEntities.VarAlone) {
                Variable x = (Variable)((VarEntities.VarAlone)va).var;
                sb.append(x.dom.prettyValueOf(x.valueIndexInLastSolution));
            } else {
                sb.append(Variable.instantiationOf(((VarEntities.VarArray)VarEntities.VarArray.class.cast((Object)va)).vars, PREFIX));
            }
            sb.append(",\n");
        }
        sb.delete(sb.length() - 2, sb.length());
        return sb.append("\n").append(PREFIX).append("}").toString();
    }

    public SolutionRecorder(Solver solver, long nSolutionsLimit) {
        this.solver = solver;
        this.limit = nSolutionsLimit;
        this.bestBound = solver.head.control.optimization.ub;
        this.allSolutions = solver.head.control.general.recordSolutions ? new ArrayList() : null;
        Runtime.getRuntime().addShutdownHook(new Thread(() -> this.displayFinalResults()));
        this.listVars = this.varsForXml(false);
        this.listVarsWithoutAuxiliary = this.varsForXml(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void displayFinalResults() {
        Types.TypeFramework framework = this.solver.problem.settings.framework;
        boolean fullExploration = this.solver.stopping == Enums.EStopping.FULL_EXPLORATION;
        AtomicBoolean atomicBoolean = this.lock;
        synchronized (atomicBoolean) {
            if (!this.lock.get()) {
                this.lock.set(true);
                System.out.println();
                if (this.found > 0L && this.solver.problem.variables.length <= this.solver.head.control.general.jsonLimit) {
                    System.out.println("\n  Solution " + this.found + " in JSON format:\n" + this.lastSolutionInJsonFormat() + "\n");
                }
                if (fullExploration) {
                    if (this.found == 0L) {
                        System.out.println(Kit.preprint("s UNSATISFIABLE", "\u001b[92m"));
                    } else {
                        System.out.println(framework == Types.TypeFramework.COP ? Kit.preprint("s OPTIMUM FOUND", "\u001b[92m") : Kit.preprint("s SATISFIABLE", "\u001b[92m"));
                    }
                } else if (this.found == 0L) {
                    System.out.println(Kit.preprint("s UNKNOWN", "\u001b[91m"));
                } else {
                    System.out.println(framework == Types.TypeFramework.COP ? Kit.preprint("s SATISFIABLE", "\u001b[92m") : Kit.preprint("s SATISFIABLE", "\u001b[92m"));
                }
                if (this.found > 0L) {
                    System.out.println("\n" + Kit.preprint("v", "\u001b[92m") + " " + (this.lastSolutionXml != null ? this.lastSolutionXml : this.lastSolutionInXmlFormat()));
                }
                System.out.println("\n" + Kit.preprint("d WRONG DECISIONS", "\u001b[92m") + " " + this.solver.stats.nWrongDecisions);
                System.out.println(Kit.preprint("d NUMBER OF" + (fullExploration ? "" : " FOUND") + " SOLUTIONS", "\u001b[92m") + " " + this.found);
                if (framework == Types.TypeFramework.COP && this.found > 0L) {
                    System.out.println(Kit.preprint("d BOUND " + this.bestBound, "\u001b[92m"));
                }
                System.out.println(fullExploration ? Kit.preprint("d COMPLETE EXPLORATION", "\u001b[92m") : Kit.preprint("d INCOMPLETE EXPLORATION", "\u001b[91m"));
                System.out.println("\nc real time : " + this.solver.head.stopwatch.cpuTimeInSeconds());
                System.out.flush();
            }
        }
    }

    public void storeSolution(int[] t) {
        Variable[] variables = this.solver.problem.variables;
        assert (t == null || t.length == variables.length);
        this.lastSolution = this.lastSolution == null ? new int[variables.length] : this.lastSolution;
        for (int i = 0; i < this.lastSolution.length; ++i) {
            this.lastSolution[i] = t != null ? t[i] : variables[i].dom.unique();
            variables[i].valueIndexInLastSolution = this.lastSolution[i];
        }
    }

    private void solutionHamming() {
        if (this.found <= 1L) {
            return;
        }
        this.h1 = (int)IntStream.range(0, this.lastSolution.length).filter(i -> this.lastSolution[i] != this.solver.problem.variables[i].dom.unique()).count();
        if (this.solver.problem.optimizer != null) {
            Constraint c = (Constraint)((Object)this.solver.problem.optimizer.ctr);
            this.h2 = (int)IntStream.range(0, this.lastSolution.length).filter(i -> this.lastSolution[i] != this.solver.problem.variables[i].dom.unique() && c.involves(this.solver.problem.variables[i])).count();
        }
    }

    private Variable selectMostImpactingVariable() {
        Kit.control(this.solver.problem.optimizer != null && this.solver.problem.optimizer.ctr instanceof Sum);
        Constraint c = (Constraint)((Object)this.solver.problem.optimizer.ctr);
        return null;
    }

    public void handleNewSolution(boolean controlSolution) {
        Kit.control(!controlSolution || this.controlFoundSolution());
        ++this.found;
        this.lastSolutionRun = this.solver.restarter.numRun;
        this.solutionHamming();
        if (this.found >= this.limit) {
            this.solver.stopping = Enums.EStopping.REACHED_GOAL;
        }
        this.storeSolution(null);
        if (this.allSolutions != null) {
            this.allSolutions.add((int[])this.lastSolution.clone());
        }
        this.solver.stats.manageSolution();
        if (this.solver.propagation.performingProperSearch) {
            return;
        }
        if (this.solver.problem.settings.framework == Types.TypeFramework.MAXCSP) {
            int z = (int)Stream.of(this.solver.problem.constraints).filter(c -> !c.checkCurrentInstantiation()).count();
            Kit.control((long)z < this.bestBound, () -> "z=" + z + " bb=" + this.bestBound);
            this.bestBound = z;
        } else if (this.solver.problem.optimizer != null) {
            this.bestBound = this.solver.problem.optimizer.value();
            System.out.println(Kit.preprint("o " + this.bestBound, "\u001b[92m") + "  " + this.solver.head.instanceStopwatch.wckTimeInSeconds());
        }
        if (this.solver.head.control.general.verbose > 1) {
            Kit.log.config(this.lastSolutionInJsonFormat() + "\n");
        }
        String s = this.lastSolutionInXmlFormat();
        if (this.solver.head.control.general.verbose > 2 || this.solver.head.control.general.xmlAllSolutions) {
            Kit.log.config("     " + s);
        }
    }

    public void handleNewSolution() {
        this.handleNewSolution(true);
    }

    private boolean controlFoundSolution() {
        Constraint c;
        if (this.solver instanceof Solver) {
            Variable x = Variable.firstNonSingletonVariableIn(this.solver.problem.variables);
            Kit.control(x == null, () -> "Problem with last solution: variable " + x + " has not a unique value");
            if (this.solver.problem.settings.framework == Types.TypeFramework.MAXCSP) {
                return true;
            }
        }
        Kit.control((c = Constraint.firstUnsatisfiedHardConstraint(this.solver.problem.constraints)) == null, () -> "Problem with last solution: constraint " + c + " " + c.getClass().getName() + " not satisfied : ");
        return true;
    }
}

