/*
 * Decompiled with CFR 0.152.
 */
package sets;

import java.util.Arrays;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import sets.SetDense;
import utility.Kit;

public class SetSparse
extends SetDense {
    public int[] sparse;

    public static final SetSparse[] factoryArray(IntFunction<Integer> capacityFunction, int arraySize) {
        return (SetSparse[])IntStream.range(0, arraySize).mapToObj(i -> new SetSparse((Integer)capacityFunction.apply(i))).toArray(SetSparse[]::new);
    }

    public static final SetSparse[] factoryArray(int capacity, int arraySize) {
        return SetSparse.factoryArray(i -> capacity, arraySize);
    }

    public SetSparse(int capacity, boolean initiallyFull) {
        super(capacity, initiallyFull);
        this.sparse = Kit.range(capacity);
        Kit.control(Arrays.equals(this.dense, this.sparse));
    }

    public SetSparse(int capacity) {
        this(capacity, false);
    }

    @Override
    public void increaseCapacity() {
        super.increaseCapacity();
        this.sparse = IntStream.range(0, this.dense.length).map(i -> i < this.sparse.length ? this.sparse[i] : i).toArray();
    }

    public SetSparse fill() {
        this.limit = this.dense.length - 1;
        return this;
    }

    @Override
    public boolean isPresent(int a) {
        return this.sparse[a] <= this.limit;
    }

    @Override
    public boolean add(int a) {
        int i = this.sparse[a];
        if (i <= this.limit) {
            return false;
        }
        ++this.limit;
        if (i > this.limit) {
            int b;
            this.dense[i] = b = this.dense[this.limit];
            this.dense[this.limit] = a;
            this.sparse[a] = this.limit;
            this.sparse[b] = i;
        }
        return true;
    }

    @Override
    public void removeAtPosition(int i) {
        assert (0 <= i && i <= this.limit);
        if (i != this.limit) {
            int b;
            int a = this.dense[i];
            this.dense[i] = b = this.dense[this.limit];
            this.dense[this.limit] = a;
            this.sparse[a] = this.limit;
            this.sparse[b] = i;
        }
        --this.limit;
    }

    @Override
    public int shift() {
        assert (this.limit >= 0);
        int a = this.dense[0];
        if (this.limit != 0) {
            int b = this.dense[this.limit];
            this.dense[0] = this.dense[this.limit];
            this.dense[this.limit] = a;
            this.sparse[a] = this.limit;
            this.sparse[b] = 0;
        }
        --this.limit;
        return a;
    }

    @Override
    public void swapAtPositions(int i, int j) {
        int b;
        int a = this.dense[i];
        this.dense[i] = b = this.dense[j];
        this.dense[j] = a;
        this.sparse[a] = j;
        this.sparse[b] = i;
    }

    public boolean remove(int a) {
        int i = this.sparse[a];
        if (i > this.limit) {
            return false;
        }
        if (i != this.limit) {
            int b;
            this.dense[i] = b = this.dense[this.limit];
            this.dense[this.limit] = a;
            this.sparse[a] = this.limit;
            this.sparse[b] = i;
        }
        --this.limit;
        return true;
    }

    public final void swap(int a, int b) {
        int i = this.sparse[a];
        int j = this.sparse[b];
        this.dense[i] = b;
        this.dense[j] = a;
        this.sparse[a] = j;
        this.sparse[b] = i;
    }

    public final void moveElementsAt(int oldTailLimit) {
        int nSwaps = Math.min(this.limit + 1, oldTailLimit - this.limit);
        int i = 0;
        while (i < nSwaps) {
            int b;
            int j = oldTailLimit - i;
            int a = this.dense[i];
            this.dense[i] = b = this.dense[j];
            this.dense[j] = a;
            this.sparse[a] = j;
            this.sparse[b] = i++;
        }
    }

    @Override
    public String toString() {
        return super.toString() + "\nsparse={" + IntStream.range(0, this.size()).mapToObj(i -> this.sparse[i] + "").collect(Collectors.joining(",")) + "}";
    }
}

