/*
 * Decompiled with CFR 0.152.
 */
package sets;

import java.util.Arrays;
import java.util.stream.IntStream;
import sets.SetDense;
import utility.Kit;

public class SetDenseReversible
extends SetDense {
    public final int[] limits;

    @Override
    public void clear() {
        super.clear();
        Arrays.fill(this.limits, -2);
    }

    public SetDenseReversible(int[] dense, boolean initiallyFull, int nLevels) {
        super(dense, initiallyFull);
        Kit.control(nLevels > 0);
        this.limits = IntStream.generate(() -> -2).limit(nLevels).toArray();
    }

    public SetDenseReversible(int capacity, boolean initiallyFull, int nLevels) {
        this(IntStream.range(0, capacity).toArray(), initiallyFull, nLevels);
    }

    public SetDenseReversible(int capacity, int nLevels) {
        this(capacity, true, nLevels);
    }

    public final void storeLimitAtLevel(int level) {
        if (this.limits[level] == -2) {
            this.limits[level] = this.limit;
        }
    }

    public void restoreLimitAtLevel(int level) {
        if (this.limits[level] != -2) {
            this.limit = this.limits[level];
            this.limits[level] = -2;
        }
    }

    public void moveLimitAtLevel(int gap, int level) {
        assert (this.limit - gap >= -1);
        this.storeLimitAtLevel(level);
        this.limit -= gap;
    }

    public void removeAtPosition(int i, int level) {
        assert (0 <= i && i <= this.limit);
        if (this.limits[level] == -2) {
            this.limits[level] = this.limit;
        }
        int e = this.dense[i];
        this.dense[i] = this.dense[this.limit];
        this.dense[this.limit] = e;
        --this.limit;
    }
}

