/*
 * Decompiled with CFR 0.152.
 */
package propagation;

import propagation.GAC;
import solver.Solver;
import utility.Kit;
import variables.Variable;

public abstract class StrongConsistency
extends GAC {
    protected int nPassesLimit = Integer.MAX_VALUE;
    protected boolean onlyBounds;
    protected boolean onlyNeighbours;
    protected final int verbose;

    public StrongConsistency(Solver solver) {
        super(solver);
        this.verbose = solver.head.control.general.verbose;
        Kit.control(solver.observersSearch == null || solver.observersSearch.size() == 0);
    }

    protected abstract boolean enforceStrongConsistency();

    protected boolean enforceMore() {
        this.solver.stats.store();
        boolean consistent = this.enforceStrongConsistency();
        this.solver.stats.restore();
        return consistent;
    }

    @Override
    public boolean runInitially() {
        int nBefore = this.solver.problem.nValuesRemoved;
        if (!this.enforceArcConsistency()) {
            return false;
        }
        if (this.settings.strongOnlyWhenACEffective && this.solver.problem.nValuesRemoved == nBefore) {
            return true;
        }
        if (this.settings.strongOnlyAtPreprocessing && this.solver.restarter.numRun % 60 != 0) {
            return true;
        }
        System.out.println("more");
        return this.enforceMore();
    }

    @Override
    public boolean runAfterAssignment(Variable x) {
        int nBefore = this.solver.problem.nValuesRemoved;
        if (!this.enforceArcConsistencyAfterAssignment(x)) {
            return false;
        }
        if (this.performingProperSearch || this.settings.strongOnlyAtPreprocessing || this.settings.strongOnlyWhenACEffective && this.solver.problem.nValuesRemoved == nBefore || this.settings.strongOnlyWhenNotSingleton && x.dom.lastRemovedLevel() != this.solver.depth() && this.hasSolverPropagatedAfterLastButOneDecision()) {
            return true;
        }
        return this.enforceMore();
    }

    @Override
    public boolean runAfterRefutation(Variable x) {
        int nBefore = this.solver.problem.nValuesRemoved;
        if (!this.enforceArcConsistencyAfterRefutation(x)) {
            return false;
        }
        if (this.performingProperSearch || this.settings.strongOnlyAtPreprocessing || this.settings.strongOnlyWhenACEffective && this.solver.problem.nValuesRemoved == nBefore) {
            return true;
        }
        return this.enforceMore();
    }
}

