/*
 * Decompiled with CFR 0.152.
 */
package propagation;

import heuristics.HeuristicVariables;
import heuristics.HeuristicVariablesDynamic;
import java.util.Arrays;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import propagation.StrongConsistency;
import solver.Solver;
import utility.Kit;
import utility.Reflector;
import variables.Variable;

public class SAC
extends StrongConsistency {
    public int nFoundSingletons;

    protected boolean checkSAC(Variable x, int a) {
        this.solver.assign(x, a);
        boolean consistent = this.enforceArcConsistencyAfterAssignment(x);
        this.solver.backtrack(x);
        ++this.nSingletonTests;
        if (!consistent) {
            ++this.nEffectiveSingletonTests;
        }
        return consistent;
    }

    protected int checkSAC(Variable x) {
        int sizeBefore = x.dom.size();
        if (this.onlyBounds) {
            while (x.dom.size() > 0 && !this.checkSAC(x, x.dom.first())) {
                x.dom.removeElementary(x.dom.first());
            }
            while (x.dom.size() > 1 && !this.checkSAC(x, x.dom.last())) {
                x.dom.removeElementary(x.dom.last());
            }
        } else {
            int a = x.dom.first();
            while (a != -1) {
                if (!this.checkSAC(x, a)) {
                    x.dom.removeElementary(a);
                }
                a = x.dom.next(a);
            }
        }
        return sizeBefore - x.dom.size();
    }

    @Override
    protected boolean enforceStrongConsistency() {
        for (int cnt = 0; cnt < this.nPassesLimit; ++cnt) {
            long nBefore = this.nEffectiveSingletonTests;
            Variable x = this.solver.futVars.first();
            while (x != null) {
                if (!this.onlyNeighbours || x.isNeighbourOf(this.solver.decRecorder.varOfLastDecisionIf(true))) {
                    if (x.dom.size() == 1) {
                        ++this.nFoundSingletons;
                    } else {
                        int nRemovals = this.checkSAC(x);
                        if (!(nRemovals <= 0 || x.dom.size() != 0 && this.enforceArcConsistencyAfterRefutation(x))) {
                            return false;
                        }
                        if (this.solver.finished()) {
                            return true;
                        }
                    }
                }
                x = this.solver.futVars.next(x);
            }
            if (this.verbose > 1) {
                this.displayPassInfo(cnt, this.nEffectiveSingletonTests - nBefore, this.nEffectiveSingletonTests - nBefore == 0L);
            }
            if (nBefore == this.nEffectiveSingletonTests) break;
        }
        assert (this.controlArcConsistency());
        return true;
    }

    public SAC(Solver solver) {
        super(solver);
    }

    private boolean controlSAC(Variable x, int a) {
        this.solver.assign(x, a);
        boolean consistent = this.enforceArcConsistencyAfterAssignment(x);
        this.solver.backtrack(x);
        if (!consistent) {
            Kit.log.warning(x + " " + a + " not singleton consistent");
        }
        return consistent;
    }

    protected final boolean controlSAC() {
        if (this.nPassesLimit == Integer.MAX_VALUE) {
            return true;
        }
        Variable x = this.solver.futVars.first();
        while (x != null) {
            int a = x.dom.first();
            while (a != -1) {
                if (!this.controlSAC(x, a)) {
                    return false;
                }
                a = x.dom.next(a);
            }
            x = this.solver.futVars.next(x);
        }
        return true;
    }

    protected final void displayPassInfo(int cnt, long nEffective, boolean lastMessage) {
        Kit.log.info("Singleton Pass " + cnt + " nEfectiveTests=" + nEffective + " nbValuesRemoved=" + Variable.nRemovedValuesFor(this.solver.problem.variables) + (lastMessage ? "\n" : ""));
    }

    public static class ESAC3
    extends SACGreedy {
        private Variable lastFailedVar;
        private int lastFailedIdx;
        private Variable currSelectedVar;
        private int currSelectedIdx;
        private int currIndexOfVarHeuristic = -1;
        private HeuristicVariables[] varHeuristics;
        private QueueESAC queueESAC = new QueueESAC();

        public ESAC3(Solver solver) {
            super(solver);
            this.varHeuristics = new HeuristicVariables[]{new HeuristicVariablesDynamic.WdegOnDom(solver, false)};
            double ratio = solver.head.control.shaving.ratio;
            double alpha = solver.head.control.shaving.alpha;
            this.shavingEvaluator = ratio != 0.0 ? new SACGreedy.ShavingEvaluator(solver.problem.variables.length, alpha, ratio) : null;
        }

        private void makeSelection() {
            if (this.lastFailedVar == null || this.nBranchesBuilt < this.varHeuristics.length) {
                this.currSelectedVar = this.queueESAC.selectNextVariable();
                this.currSelectedIdx = this.currSelectedVar.dom.first();
            } else {
                this.currSelectedVar = this.queueESAC.pick(this.lastFailedVar);
                this.currSelectedIdx = this.lastFailedVar.dom.present(this.lastFailedIdx) ? this.lastFailedIdx : this.lastFailedVar.dom.first();
            }
            this.lastFailedVar = null;
            assert (!this.currSelectedVar.assigned() && this.currSelectedVar.dom.present(this.currSelectedIdx) && this.queue.isEmpty());
        }

        protected boolean buildBranch() {
            this.currIndexOfVarHeuristic = (this.currIndexOfVarHeuristic + 1) % this.varHeuristics.length;
            boolean finished = false;
            while (!finished) {
                this.makeSelection();
                ++this.nSingletonTests;
                this.solver.assign(this.currSelectedVar, this.currSelectedIdx);
                if (this.enforceArcConsistencyAfterAssignment(this.currSelectedVar)) {
                    if (this.solver.depth() != this.solver.problem.variables.length) continue;
                    this.solver.solRecorder.handleNewSolution(true);
                    finished = true;
                    continue;
                }
                this.queueESAC.addLastVariable();
                this.lastFailedVar = this.currSelectedVar;
                this.lastFailedIdx = this.currSelectedIdx;
                this.solver.backtrack(this.currSelectedVar);
                finished = !this.maximumBranchExtension || !this.canFindAnotherExtensionInsteadOf(this.currSelectedVar, this.currSelectedIdx);
            }
            int lastBuiltBranchSize = this.solver.depth() - this.nodeDepth;
            if (lastBuiltBranchSize == 0) {
                return this.manageInconsistentValue(this.currSelectedVar, this.currSelectedIdx);
            }
            this.eraseLastBuiltBranch(lastBuiltBranchSize);
            return true;
        }

        @Override
        protected boolean enforceStrongConsistency() {
            this.nodeDepth = this.solver.depth();
            this.sumBranchSizes = 0;
            this.nBranchesBuilt = 0;
            this.lastFailedVar = null;
            this.queueESAC.initialize();
            long nbEffectiveSingletonTestsBefore = this.nEffectiveSingletonTests;
            while (this.queueESAC.nUncheckedVars > 0) {
                this.performingProperSearch = true;
                boolean consistent = this.buildBranch();
                this.solver.resetNoSolutions();
                this.performingProperSearch = false;
                if (!consistent) {
                    return false;
                }
                if (!this.solver.finished()) continue;
                return true;
            }
            if (this.verbose > 1) {
                this.displayPassInfo(0, this.nEffectiveSingletonTests - nbEffectiveSingletonTestsBefore, true);
            }
            return true;
        }

        class QueueESAC {
            private int nUncheckedVars;
            private Variable[] uncheckedVars;
            private HeuristicVariables.BestScoredVariable bestScoredVariable = new HeuristicVariables.BestScoredVariable();

            private QueueESAC() {
                this.uncheckedVars = new Variable[ESAC3.this.solver.problem.variables.length];
                Kit.control(!ESAC3.this.solver.head.control.varh.discardAux);
            }

            public void initialize() {
                this.nUncheckedVars = 0;
                Variable x = ESAC3.this.solver.futVars.first();
                while (x != null) {
                    if (ESAC3.this.shavingEvaluator == null || ESAC3.this.shavingEvaluator.isEligible(x)) {
                        this.uncheckedVars[this.nUncheckedVars++] = x;
                    } else {
                        ESAC3.this.shavingEvaluator.updateRatioAfterUntest(x);
                    }
                    x = ESAC3.this.solver.futVars.next(x);
                }
            }

            public Variable selectNextVariable() {
                this.bestScoredVariable.reset(false);
                if (this.nUncheckedVars == 0) {
                    ESAC3.this.solver.futVars.execute(x -> this.bestScoredVariable.update((Variable)x, ESAC3.this.varHeuristics[ESAC3.this.currIndexOfVarHeuristic].scoreOptimizedOf((Variable)x)));
                } else {
                    assert (this.controlUncheckedVariables());
                    int bestPos = 0;
                    for (int i = 0; i < this.nUncheckedVars; ++i) {
                        if (!this.bestScoredVariable.update(this.uncheckedVars[i], ESAC3.this.varHeuristics[ESAC3.this.currIndexOfVarHeuristic].scoreOptimizedOf(this.uncheckedVars[i]))) continue;
                        bestPos = i;
                    }
                    Kit.swap(this.uncheckedVars, --this.nUncheckedVars, bestPos);
                }
                return this.bestScoredVariable.variable;
            }

            public Variable pick(Variable x) {
                assert (this.uncheckedVars[this.nUncheckedVars - 1] == x) : "should always be the case, because we always swap the selected variable with the one at the last position ";
                return this.uncheckedVars[--this.nUncheckedVars];
            }

            public void addLastVariable() {
                if (this.nUncheckedVars > 0 || this.uncheckedVars[0] == ESAC3.this.currSelectedVar) {
                    ++this.nUncheckedVars;
                }
            }

            private boolean controlUncheckedVariables() {
                IntStream.range(0, this.nUncheckedVars).forEach(i -> Kit.control(!this.uncheckedVars[i].assigned(), () -> this.uncheckedVars[i] + " is assigned"));
                return true;
            }
        }
    }

    public static class SAC3
    extends SACGreedy {
        protected final QueueForSAC3 queueOfCells;
        protected final int lastConflictMode;

        public SAC3(Solver solver) {
            super(solver);
            this.queueOfCells = new QueueForSAC3(solver, true);
            this.lastConflictMode = 1;
        }

        @Override
        protected boolean manageInconsistentValue(Variable x, int a) {
            if (!super.manageInconsistentValue(x, a)) {
                return false;
            }
            if (this.lastConflictMode == 2) {
                this.queueOfCells.setPriorityOf(x);
            }
            return true;
        }

        @Override
        protected void eraseLastBuiltBranch(int branchSize) {
            if (branchSize > 0) {
                super.eraseLastBuiltBranch(branchSize);
            } else {
                this.queueOfCells.clear();
            }
        }

        protected final boolean buildBranch() {
            QueueForSAC3.Cell cell = this.queueOfCells.pickNextCell();
            while (cell != null) {
                block6: {
                    int a;
                    Variable x;
                    block5: {
                        x = cell.x;
                        a = cell.a;
                        ++this.nSingletonTests;
                        if (x.dom.size() == 1) {
                            ++this.nFoundSingletons;
                        }
                        assert (!x.assigned() && x.dom.present(a) && this.queue.isEmpty());
                        this.solver.assign(x, a);
                        if (!this.enforceArcConsistencyAfterAssignment(x)) break block5;
                        if (this.solver.depth() != this.solver.problem.variables.length) break block6;
                        System.out.println("found solution");
                        if (!this.stopSACWhenFoundSolution) break block6;
                        this.solver.solRecorder.handleNewSolution(true);
                        break block6;
                    }
                    this.solver.backtrack(x);
                    int lastBuiltBranchSize = this.solver.depth() - this.nodeDepth;
                    if (lastBuiltBranchSize == 0) {
                        return this.manageInconsistentValue(x, a);
                    }
                    this.queueOfCells.add(x, a);
                    if (!this.maximumBranchExtension || !this.canFindAnotherExtensionInsteadOf(x, a)) {
                        if (this.lastConflictMode <= 0) break;
                        this.queueOfCells.setPriorityTo(x, a);
                        break;
                    }
                }
                cell = this.queueOfCells.pickNextCell();
            }
            this.eraseLastBuiltBranch(this.solver.depth() - this.nodeDepth);
            return true;
        }

        @Override
        protected boolean enforceStrongConsistency() {
            this.nodeDepth = this.solver.depth();
            this.sumBranchSizes = 0;
            this.nBranchesBuilt = 0;
            for (int cnt = 0; cnt < this.nPassesLimit; ++cnt) {
                long nBefore = this.nEffectiveSingletonTests;
                this.queueOfCells.fill();
                while (this.queueOfCells.size > 0) {
                    this.performingProperSearch = true;
                    boolean consistent = this.buildBranch();
                    this.performingProperSearch = false;
                    if (!consistent) {
                        return false;
                    }
                    if (!this.stopSACWhenFoundSolution || !this.solver.finished()) continue;
                    return true;
                }
                if (this.verbose > 1) {
                    this.displayPassInfo(cnt, this.nEffectiveSingletonTests - nBefore, this.nEffectiveSingletonTests - nBefore == 0L);
                }
                if (nBefore == this.nEffectiveSingletonTests) break;
            }
            assert (this.solver.finished() || this.controlArcConsistency() && this.controlSAC());
            return true;
        }
    }

    public static final class QueueForSAC3 {
        private Solver solver;
        private boolean priorityToSingletons;
        private Cell head;
        private Cell tail;
        private Cell trash;
        private Cell priorityCell;
        public int size;
        private Cell[][] positions;
        private int[] sizes;
        private CellSelector cellSelector;

        public boolean isPresent(Variable x, int a) {
            return this.positions[x.num][a] != null;
        }

        public void setPriorityTo(Variable x, int a) {
            assert (this.priorityCell == null && this.isPresent(x, a));
            this.priorityCell = this.positions[x.num][a];
        }

        public void setPriorityOf(Variable x) {
            assert (this.priorityCell == null);
            if (this.sizes[x.num] == 0) {
                return;
            }
            int a = x.dom.first();
            while (a != -1) {
                Cell cell = this.positions[x.num][a];
                if (cell != null) {
                    this.priorityCell = cell;
                    break;
                }
                a = x.dom.next(a);
            }
        }

        private Cell firstSingletonCell() {
            Variable x = this.solver.futVars.first();
            while (x != null) {
                Cell cell;
                if (x.dom.size() == 1 && (cell = this.positions[x.num][x.dom.first()]) != null) {
                    return cell;
                }
                x = this.solver.futVars.next(x);
            }
            return null;
        }

        public Cell pickNextCell() {
            if (this.size == 0) {
                return null;
            }
            Cell cell = this.priorityCell != null ? this.priorityCell : this.cellSelector.select();
            this.priorityCell = null;
            if (cell != null) {
                this.remove(cell);
            }
            return cell;
        }

        public QueueForSAC3(Solver solver, boolean priorityToSingletons) {
            this.solver = solver;
            this.priorityToSingletons = priorityToSingletons;
            this.positions = (Cell[][])Stream.of(solver.problem.variables).map(x -> new Cell[x.dom.initSize()]).toArray(x$0 -> new Cell[x$0][]);
            IntStream.range(0, Variable.nInitValuesFor(solver.problem.variables)).forEach(i -> {
                this.trash = new Cell(this.trash);
            });
            this.sizes = new int[solver.problem.variables.length];
            String s = solver.head.control.propagation.classForSACSelector.substring(solver.head.control.propagation.classForSACSelector.lastIndexOf(36) + 1);
            this.cellSelector = Reflector.buildObject(s, CellSelector.class, this);
        }

        public void clear() {
            this.size = 0;
            for (int i = 0; i < this.positions.length; ++i) {
                for (int j = 0; j < this.positions[i].length; ++j) {
                    this.positions[i][j] = null;
                }
            }
            Arrays.fill(this.sizes, 0);
            if (this.head == null) {
                return;
            }
            if (this.trash != null) {
                this.tail.next = this.trash;
                this.trash.prev = this.tail;
            }
            this.trash = this.head;
            this.tail = null;
            this.head = null;
        }

        public void add(Variable x, int a) {
            if (this.positions[x.num][a] != null) {
                return;
            }
            Cell cell = this.trash;
            this.trash = this.trash.next;
            cell.set(x, a, this.tail, null);
            if (this.head == null) {
                this.head = cell;
            } else {
                this.tail.next = cell;
            }
            this.tail = cell;
            this.positions[x.num][a] = cell;
            int n = x.num;
            this.sizes[n] = this.sizes[n] + 1;
            ++this.size;
        }

        public void remove(Cell cell) {
            Variable x = cell.x;
            int a = cell.a;
            Cell prev = cell.prev;
            Cell next = cell.next;
            if (prev == null) {
                this.head = next;
            } else {
                prev.next = next;
            }
            if (next == null) {
                this.tail = prev;
            } else {
                next.prev = prev;
            }
            cell.next = this.trash;
            this.trash = cell;
            this.positions[x.num][a] = null;
            int n = x.num;
            this.sizes[n] = this.sizes[n] - 1;
            --this.size;
        }

        public boolean remove(Variable x, int a) {
            Cell cell = this.positions[x.num][a];
            if (cell == null) {
                return false;
            }
            this.remove(cell);
            return true;
        }

        public void fill(boolean onlyBounds) {
            this.clear();
            Variable x = this.solver.futVars.first();
            while (x != null) {
                if (onlyBounds) {
                    this.add(x, x.dom.first());
                    this.add(x, x.dom.last());
                } else {
                    int a = x.dom.first();
                    while (a != -1) {
                        this.add(x, a);
                        a = x.dom.next(a);
                    }
                }
                x = this.solver.futVars.next(x);
            }
        }

        public void fill() {
            this.fill(false);
        }

        public void display() {
            Cell cell = this.head;
            while (cell != null) {
                System.out.print(cell.x + "-" + cell.a + " ");
                cell = cell.next;
            }
            System.out.println();
        }

        public final class CellIterator
        implements CellSelector {
            protected HeuristicVariables heuristic;

            public CellIterator() {
                this.heuristic = new HeuristicVariablesDynamic.WdegOnDom(QueueForSAC3.this.solver, false);
            }

            @Override
            public Cell select() {
                Cell bestCell = null;
                double bestEvaluation = -1.0;
                Variable x = ((QueueForSAC3)QueueForSAC3.this).solver.futVars.first();
                while (x != null) {
                    if (QueueForSAC3.this.sizes[x.num] != 0) {
                        if (QueueForSAC3.this.priorityToSingletons && x.dom.size() == 1) {
                            Cell cell = QueueForSAC3.this.positions[x.num][x.dom.first()];
                            if (cell != null) {
                                return cell;
                            }
                        } else {
                            double evaluation;
                            double d = evaluation = this.heuristic == null ? (double)QueueForSAC3.this.sizes[x.num] : this.heuristic.scoreOptimizedOf(x);
                            if (bestCell == null || evaluation > bestEvaluation) {
                                int a = x.dom.first();
                                while (a != -1) {
                                    Cell cell = QueueForSAC3.this.positions[x.num][a];
                                    if (cell != null) {
                                        bestCell = cell;
                                        bestEvaluation = evaluation;
                                        break;
                                    }
                                    a = x.dom.next(a);
                                }
                            }
                        }
                    }
                    x = ((QueueForSAC3)QueueForSAC3.this).solver.futVars.next(x);
                }
                return bestCell;
            }
        }

        public final class Lifo
        implements CellSelector {
            @Override
            public Cell select() {
                Cell cell;
                if (QueueForSAC3.this.priorityToSingletons && (cell = QueueForSAC3.this.firstSingletonCell()) != null) {
                    return cell;
                }
                cell = QueueForSAC3.this.tail;
                while (cell != null) {
                    if (cell.x.dom.present(cell.a)) {
                        return cell;
                    }
                    cell = cell.prev;
                }
                return null;
            }
        }

        public final class Fifo
        implements CellSelector {
            @Override
            public Cell select() {
                Cell cell;
                if (QueueForSAC3.this.priorityToSingletons && (cell = QueueForSAC3.this.firstSingletonCell()) != null) {
                    return cell;
                }
                cell = QueueForSAC3.this.head;
                while (cell != null) {
                    if (cell.x.dom.present(cell.a)) {
                        return cell;
                    }
                    cell = cell.next;
                }
                return null;
            }
        }

        public static interface CellSelector {
            public Cell select();
        }

        public final class Cell {
            public Variable x;
            public int a;
            private Cell prev;
            private Cell next;

            private Cell(Cell next) {
                this.next = next;
            }

            private void set(Variable x, int a, Cell prev, Cell next) {
                this.x = x;
                this.a = a;
                this.prev = prev;
                this.next = next;
            }
        }
    }

    public static abstract class SACGreedy
    extends SAC {
        public int nBranchesBuilt;
        public int sumBranchSizes;
        protected boolean maximumBranchExtension = false;
        protected boolean stopSACWhenFoundSolution = false;
        protected int nodeDepth;
        protected ShavingEvaluator shavingEvaluator;

        public SACGreedy(Solver solver) {
            super(solver);
        }

        protected boolean canFindAnotherExtensionInsteadOf(Variable x, int a) {
            if (this.solver.depth() == this.nodeDepth) {
                return false;
            }
            x.dom.removeElementary(a);
            return x.dom.size() > 0 && this.enforceArcConsistencyAfterRefutation(x);
        }

        protected boolean manageInconsistentValue(Variable x, int a) {
            ++this.nEffectiveSingletonTests;
            x.dom.removeElementary(a);
            if (this.shavingEvaluator != null) {
                this.shavingEvaluator.updateRatioAfterShavingSuccess(x);
            }
            if (x.dom.size() == 0) {
                return false;
            }
            assert (this.queue.isEmpty());
            return this.enforceArcConsistencyAfterRefutation(x);
        }

        protected void eraseLastBuiltBranch(int branchSize) {
            ++this.nBranchesBuilt;
            this.sumBranchSizes += branchSize;
            for (int i = 0; i < branchSize; ++i) {
                Variable lastPast = this.solver.futVars.lastPast();
                this.solver.backtrack(lastPast);
                if (this.shavingEvaluator == null) continue;
                this.shavingEvaluator.updateRatioAfterShavingFailure(lastPast);
            }
        }

        public class ShavingEvaluator {
            private static final double INCREMENT = 0.05;
            private double ratiosThreshold;
            private double[] sucessRatios;
            private int[] nFailuresSinceLastSuccess;
            private double alpha;
            private double beta;

            public ShavingEvaluator(int nVariables, double alpha, double ratiosThreshold) {
                this.sucessRatios = Kit.repeat(1.0, nVariables);
                this.nFailuresSinceLastSuccess = new int[nVariables];
                this.ratiosThreshold = ratiosThreshold;
                this.alpha = alpha;
                this.beta = 1.0 - alpha;
                assert (ratiosThreshold > 0.0 && ratiosThreshold < 1.0 && alpha > 0.0 && alpha < 1.0);
            }

            public boolean isEligible(Variable x) {
                return this.sucessRatios[x.num] >= this.ratiosThreshold;
            }

            public void updateRatioAfterShavingSuccess(Variable x) {
                this.sucessRatios[x.num] = this.sucessRatios[x.num] * this.alpha + this.beta;
                this.nFailuresSinceLastSuccess[x.num] = 0;
            }

            public void updateRatioAfterShavingFailure(Variable x) {
                this.sucessRatios[x.num] = this.sucessRatios[x.num] * this.alpha;
                int n = x.num;
                this.nFailuresSinceLastSuccess[n] = this.nFailuresSinceLastSuccess[n] + 1;
            }

            public void updateRatioAfterUntest(Variable x) {
                int n = x.num;
                this.sucessRatios[n] = this.sucessRatios[n] + 0.05 / (double)this.nFailuresSinceLastSuccess[x.num];
            }
        }
    }
}

