/*
 * Decompiled with CFR 0.152.
 */
package propagation;

import constraints.Constraint;
import constraints.extension.structures.Bits;
import dashboard.Control;
import interfaces.FilteringSpecific;
import problem.Problem;
import propagation.Forward;
import sets.LinkedSetOrdered;
import sets.SetSparse;
import utility.Kit;
import variables.Domain;
import variables.Variable;

public class Reviser {
    protected Forward propagation;
    public long nRevisions;
    public long nUselessRevisions;

    public Reviser(Forward propagation) {
        this.propagation = propagation;
    }

    public boolean mustBeAppliedTo(Constraint c, Variable x) {
        return true;
    }

    public void applyTo(Constraint c, Variable x) {
        int px = c.positionOf(x);
        Domain dom = x.dom;
        int a = dom.first();
        while (a != -1) {
            if (!c.findArcSupportFor(px, a)) {
                x.dom.removeElementary(a);
            }
            a = dom.next(a);
        }
    }

    public final boolean revise(Constraint c, Variable x) {
        assert (!x.assigned() && c.involves(x));
        if (this.mustBeAppliedTo(c, x)) {
            ++this.nRevisions;
            int sizeBefore = x.dom.size();
            this.applyTo(c, x);
            int sizeAfter = x.dom.size();
            if (sizeBefore != sizeAfter) {
                return this.propagation.handleReduction(x, sizeAfter);
            }
            ++this.nUselessRevisions;
        }
        return true;
    }

    public static final class Reviser3
    extends Reviser2 {
        final int residueLimitForBitRm = 499;
        final int memoryLimitForBitRm = 550000000;
        private final short[][][] bitRmResidues;
        private boolean variant = false;

        public Reviser3(Forward propagation) {
            super(propagation);
            Problem pb = propagation.solver.problem;
            Control.SettingPropagation settings = pb.head.control.propagation;
            if (settings.bitResidues) {
                long nResidues = 0L;
                this.bitRmResidues = new short[pb.constraints.length][][];
                int limit = 499;
                boolean stopped = false;
                for (Constraint c : pb.constraints) {
                    if (c instanceof FilteringSpecific || !(c.extStructure() instanceof Bits)) continue;
                    int size0 = c.scp[0].dom.initSize();
                    int size1 = c.scp[1].dom.initSize();
                    this.bitRmResidues[c.num] = new short[2][];
                    if (stopped) continue;
                    if (size0 > limit) {
                        this.bitRmResidues[c.num][1] = new short[size1];
                    }
                    if (size1 > limit) {
                        this.bitRmResidues[c.num][0] = new short[size0];
                    }
                    if ((nResidues += (long)((size0 > limit ? size1 : 0) + (size1 > limit ? size0 : 0))) * 2L + Kit.memory() <= 550000000L) continue;
                    Kit.log.info("Stop creating residues for RevisionManagerBitRm");
                    stopped = true;
                }
            } else {
                this.bitRmResidues = null;
            }
        }

        private short seekSupportPosition(long[] bitSup, long[] bitDom) {
            for (short i = 0; i < bitSup.length; i = (short)(i + 1)) {
                if ((bitSup[i] & bitDom[i]) == 0L) continue;
                return i;
            }
            return -1;
        }

        private short seekSupportPosition(long[] bitSup, long[] bitDom, int[] bitSupDense, SetSparse set) {
            if (set.size() <= bitSupDense.length) {
                int[] dense = set.dense;
                for (int i = set.limit; i >= 0; --i) {
                    int j = dense[i];
                    if ((bitSup[j] & bitDom[j]) == 0L) continue;
                    return (short)j;
                }
            } else {
                for (int i = bitSupDense.length - 1; i >= 0; --i) {
                    int j = bitSupDense[i];
                    if ((bitSup[j] & bitDom[j]) == 0L) continue;
                    return (short)j;
                }
            }
            return -1;
        }

        @Override
        public void applyTo(Constraint c, Variable x) {
            short[] residues;
            if (!(c.extStructure() instanceof Bits)) {
                super.applyTo(c, x);
                return;
            }
            int px = c.positionOf(x);
            Domain dom = x.dom;
            Variable y = c.scp[px == 0 ? 1 : 0];
            long[] bitDom = y.dom.binary();
            long[][] bitSups = ((Bits)c.extStructure()).bitSupsFor(px);
            short[] sArray = residues = this.bitRmResidues != null ? this.bitRmResidues[c.num][px] : null;
            if (!this.variant) {
                if (residues != null) {
                    int a = dom.first();
                    while (a != -1) {
                        short i = residues[a];
                        if ((bitSups[a][i] & bitDom[i]) == 0L) {
                            i = this.seekSupportPosition(bitSups[a], bitDom);
                            if (i == -1) {
                                dom.removeElementary(a);
                            } else {
                                residues[a] = i;
                            }
                        }
                        a = dom.next(a);
                    }
                } else {
                    int a = dom.first();
                    while (a != -1) {
                        if (this.seekSupportPosition(bitSups[a], bitDom) == -1) {
                            dom.removeElementary(a);
                        }
                        a = dom.next(a);
                    }
                }
            } else {
                LinkedSetOrdered.LinkedSetOrderedWithBits2 sety = (LinkedSetOrdered.LinkedSetOrderedWithBits2)((Object)y.dom);
                int[][] bitSupsDense = ((Bits)c.extStructure()).bitSupsDenseFor(px);
                if (residues != null) {
                    int a = dom.first();
                    while (a != -1) {
                        short i = residues[a];
                        if ((bitSups[a][i] & bitDom[i]) == 0L) {
                            i = this.seekSupportPosition(bitSups[a], bitDom, bitSupsDense[a], sety.set);
                            if (i == -1) {
                                dom.removeElementary(a);
                            } else {
                                residues[a] = i;
                            }
                        }
                        a = dom.next(a);
                    }
                } else {
                    int a = dom.first();
                    while (a != -1) {
                        if (this.seekSupportPosition(bitSups[a], bitDom, bitSupsDense[a], sety.set) == -1) {
                            dom.removeElementary(a);
                        }
                        a = dom.next(a);
                    }
                }
            }
        }
    }

    public static class Reviser2
    extends Reviser {
        public Reviser2(Forward propagation) {
            super(propagation);
        }

        @Override
        public boolean mustBeAppliedTo(Constraint c, Variable x) {
            if (c.conflictsStructure == null) {
                return true;
            }
            int px = c.positionOf(x);
            return (long)c.conflictsStructure.nMaxConflicts[px] >= Domain.nValidTuplesBoundedAtMaxValueFor(c.doms, px);
        }

        @Override
        public void applyTo(Constraint c, Variable x) {
            if (c.conflictsStructure == null) {
                super.applyTo(c, x);
            } else {
                int px = c.positionOf(x);
                long nb = Domain.nValidTuplesBoundedAtMaxValueFor(c.doms, px);
                int[] nc = c.conflictsStructure.nConflicts[px];
                Domain dom = x.dom;
                int a = dom.first();
                while (a != -1) {
                    if ((long)nc[a] >= nb && !c.findArcSupportFor(px, a)) {
                        x.dom.removeElementary(a);
                    }
                    a = dom.next(a);
                }
            }
        }
    }
}

