/*
 * Decompiled with CFR 0.152.
 */
package propagation;

import constraints.Constraint;
import java.util.stream.Stream;
import org.xcsp.common.Types;
import propagation.Forward;
import solver.Solver;
import variables.Variable;

public class GAC
extends Forward {
    private final boolean guaranteed;
    public int nPreproRemovals;

    public GAC(Solver solver) {
        super(solver);
        this.guaranteed = Constraint.isGuaranteedGAC(solver.problem.constraints);
    }

    public final boolean enforceArcConsistency() {
        int nBefore = this.solver.problem.nValuesRemoved;
        this.queue.fill();
        boolean consistent = this.propagate();
        this.nPreproRemovals = this.solver.problem.nValuesRemoved - nBefore;
        if (!consistent) {
            return false;
        }
        assert (this.controlArcConsistency());
        return true;
    }

    @Override
    public boolean runInitially() {
        return this.enforceArcConsistency();
    }

    public final boolean enforceArcConsistencyAfterAssignment(Variable x) {
        assert (x.assigned() && this.queue.size() == 0) : this.queue.size() + " " + x.assigned();
        if (this.getClass() != GAC.class || x.dom.lastRemovedLevel() == this.solver.depth() || !this.guaranteed || !this.hasSolverPropagatedAfterLastButOneDecision()) {
            this.queue.add(x);
            if (!this.propagate()) {
                return false;
            }
        }
        assert (this.controlArcConsistency());
        return true;
    }

    @Override
    public boolean runAfterAssignment(Variable x) {
        return this.enforceArcConsistencyAfterAssignment(x);
    }

    public boolean enforceArcConsistencyAfterRefutation(Variable x) {
        if (!super.runAfterRefutation(x)) {
            return false;
        }
        assert (!this.guaranteed || Stream.of(this.solver.problem.constraints).allMatch(c -> this.solver.problem.settings.framework == Types.TypeFramework.COP && c == this.solver.problem.optimizer.ctr || c.controlArcConsistency()));
        return true;
    }

    @Override
    public boolean runAfterRefutation(Variable x) {
        return this.enforceArcConsistencyAfterRefutation(x);
    }

    public final boolean controlArcConsistency() {
        return !this.guaranteed || Stream.of(this.solver.problem.constraints).allMatch(c -> c.controlArcConsistency());
    }
}

