/*
 * Decompiled with CFR 0.152.
 */
package propagation;

import propagation.Propagation;
import propagation.Reviser;
import solver.Solver;
import utility.Enums;
import utility.Kit;
import utility.Reflector;
import variables.Variable;

public abstract class Forward
extends Propagation {
    public Reviser reviser;

    public Forward(Solver solver) {
        super(solver);
        this.reviser = Reflector.buildObject(this.settings.reviser, Reviser.class, this);
    }

    protected final boolean hasSolverPropagatedAfterLastButOneDecision() {
        return this.solver.head.control.solving.branching != Enums.EBranching.NON || !this.solver.decRecorder.isLastButOneDecisionNegative();
    }

    @Override
    public boolean runAfterAssignment(Variable x) {
        assert (x.assigned() && this.queue.size() == 0) : this.queue.size() + " " + x.assigned();
        this.queue.add(x);
        return this.propagate();
    }

    @Override
    public boolean runAfterRefutation(Variable x) {
        assert (!x.assigned() && this.queue.size() == 0 && x.dom.size() > 0);
        this.queue.add(x);
        return this.propagate();
    }

    public static final class FC
    extends Forward {
        public FC(Solver solver) {
            super(solver);
            Kit.control(this.auxiliaryQueues.length == 0, () -> "For FC, we have to just use one queue");
        }

        @Override
        public boolean runInitially() {
            return true;
        }

        @Override
        public boolean runAfterAssignment(Variable x) {
            assert (x.assigned() && this.queue.isEmpty());
            this.queue.add(x);
            boolean consistent = this.pickAndFilter();
            this.queue.clear();
            return consistent;
        }

        @Override
        public boolean runAfterRefutation(Variable x) {
            return true;
        }
    }
}

