/*
 * Decompiled with CFR 0.152.
 */
package problem;

import constraints.Constraint;
import dashboard.Control;
import dashboard.Input;
import java.io.File;
import java.lang.reflect.Array;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.xcsp.common.Condition;
import org.xcsp.common.IVar;
import org.xcsp.common.Types;
import org.xcsp.common.Utilities;
import org.xcsp.common.domains.Domains;
import org.xcsp.common.predicates.MatcherInterface;
import org.xcsp.common.predicates.XNode;
import org.xcsp.common.predicates.XNodeParent;
import org.xcsp.common.structures.AbstractTuple;
import org.xcsp.common.structures.Automaton;
import org.xcsp.common.structures.Transition;
import org.xcsp.modeler.api.ProblemAPI;
import org.xcsp.modeler.entities.CtrEntities;
import org.xcsp.modeler.entities.ModelingEntity;
import org.xcsp.parser.XParser;
import org.xcsp.parser.callbacks.XCallbacks;
import org.xcsp.parser.callbacks.XCallbacks2;
import org.xcsp.parser.entries.ParsingEntry;
import org.xcsp.parser.entries.XConstraints;
import org.xcsp.parser.entries.XObjectives;
import org.xcsp.parser.entries.XVariables;
import problem.Problem;
import variables.Variable;

public class XCSP3
implements ProblemAPI,
XCallbacks2 {
    private XCallbacks.Implem implem = new XCallbacks.Implem(this);
    private Problem problem;
    private List<String> filenames;
    private Map<XVariables.XVar, Variable> mapVar = new LinkedHashMap<XVariables.XVar, Variable>();

    @Override
    public XCallbacks.Implem implem() {
        return this.implem;
    }

    @Override
    public String name() {
        return this.filenames.get(this.problem.head.instanceNumber);
    }

    private List<String> collect(List<String> list, File f) {
        if (f.isDirectory()) {
            Stream.of(f.listFiles()).forEach(g -> this.collect(list, (File)g));
        } else if (Stream.of(".xml", ".lzma").anyMatch(suf -> f.getName().endsWith((String)suf))) {
            list.add(f.getAbsolutePath());
        }
        return list;
    }

    public void data() {
        this.problem = (Problem)this.imp();
        String s = this.problem.askString("File or directory:");
        if (this.filenames == null) {
            this.filenames = this.collect(new ArrayList<String>(), new File(s)).stream().sorted().collect(Collectors.toList());
            Input.nInstancesToSolve = this.filenames.size();
        }
        ((AbstractMap.SimpleEntry)this.problem.parameters.get(0)).setValue(this.name());
        System.out.println();
    }

    @Override
    public void model() {
        Control.SettingXml settings = this.problem.head.control.xml;
        this.implem.currParameters.remove((Object)XCallbacks.XCallbacksParameters.RECOGNIZE_UNARY_PRIMITIVES);
        this.implem.currParameters.remove((Object)XCallbacks.XCallbacksParameters.RECOGNIZE_BINARY_PRIMITIVES);
        this.implem.currParameters.remove((Object)XCallbacks.XCallbacksParameters.RECOGNIZE_TERNARY_PRIMITIVES);
        this.implem.currParameters.remove((Object)XCallbacks.XCallbacksParameters.RECOGNIZE_LOGIC_CASES);
        this.implem.currParameters.remove((Object)XCallbacks.XCallbacksParameters.RECOGNIZE_EXTREMUM_CASES);
        this.implem.currParameters.remove((Object)XCallbacks.XCallbacksParameters.RECOGNIZE_SUM_CASES);
        try {
            if (this.problem.head.control.general.verbose > 1) {
                XParser.VERBOSE = true;
            }
            if (settings.discardedClasses.indexOf(44) < 0) {
                this.loadInstance(this.name(), settings.discardedClasses);
            } else {
                this.loadInstance(this.name(), settings.discardedClasses.split(","));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Problem when parsing the instance. Fix the problem.");
            System.exit(1);
        }
    }

    @Override
    public void beginInstance(Types.TypeFramework type) {
    }

    private void copyBasicAttributes(ModelingEntity entity, ParsingEntry entry) {
        if (entry.id != null) {
            entity.id(entry.id);
        }
        if (entry.note != null) {
            entity.note(entry.note);
        }
        if (entry.classes != null) {
            entity.tag(entry.classes);
        }
    }

    private Variable.VariableInteger trVar(IVar x) {
        return (Variable.VariableInteger)this.mapVar.get(x);
    }

    private Variable.VariableInteger trVar(XVariables.XVarInteger x) {
        return (Variable.VariableInteger)this.mapVar.get(x);
    }

    private Variable.VariableSymbolic trVar(XVariables.XVarSymbolic x) {
        return (Variable.VariableSymbolic)this.mapVar.get(x);
    }

    private Condition trVar(Condition condition) {
        return condition instanceof Condition.ConditionVar ? new Condition.ConditionVar(((Condition.ConditionVar)condition).operator, this.trVar(((Condition.ConditionVar)condition).x)) : condition;
    }

    private XNode<IVar> trVar(XNode<XVariables.XVarInteger> tree) {
        return tree.replaceLeafValues(v -> v instanceof XVariables.XVarInteger ? this.trVar((XVariables.XVarInteger)v) : v);
    }

    private XNode<IVar> trVarSymbolic(XNode<XVariables.XVarSymbolic> tree) {
        return tree.replaceLeafValues(v -> v instanceof XVariables.XVarSymbolic ? this.trVar((XVariables.XVarSymbolic)v) : v);
    }

    private XNode<IVar>[] trVar(XNode<XVariables.XVarInteger>[] trees) {
        return (XNode[])Stream.of(trees).map(t -> t.replaceLeafValues(v -> v instanceof XVariables.XVarInteger ? this.trVar((XVariables.XVarInteger)v) : v)).toArray(XNode[]::new);
    }

    private Variable.VariableInteger[] trVars(XVariables.XVarInteger[] t) {
        return (Variable.VariableInteger[])Arrays.stream(t).map(v -> this.mapVar.get(v)).toArray(Variable.VariableInteger[]::new);
    }

    private Variable.VariableSymbolic[] trVars(XVariables.XVarSymbolic[] t) {
        return (Variable.VariableSymbolic[])Arrays.stream(t).map(v -> this.mapVar.get(v)).toArray(Variable.VariableSymbolic[]::new);
    }

    private Variable.VariableInteger[][] trVars2D(XVariables.XVarInteger[][] m) {
        return (Variable.VariableInteger[][])Arrays.stream(m).map(t -> this.trVars((XVariables.XVarInteger[])t)).toArray(x$0 -> new Variable.VariableInteger[x$0][]);
    }

    @Override
    public void loadVar(XVariables.XVar v) {
        this.implem.manageIdFor(v);
        if (v.degree > 0) {
            if (v.dom instanceof Domains.Dom) {
                this.mapVar.put(v, (Variable.VariableInteger)this.var(v.id, (Domains.Dom)v.dom, v.note, v.classes));
            } else if (v.dom instanceof Domains.DomSymbolic) {
                this.mapVar.put(v, (Variable.VariableSymbolic)this.var(v.id, (Domains.DomSymbolic)v.dom, v.note, v.classes));
            } else {
                this.unimplementedCase(v);
            }
        }
    }

    private void completeMapVar(XVariables.XArray va, Object a, int ... indexes) {
        if (a != null) {
            if (a.getClass().isArray()) {
                IntStream.range(0, Array.getLength(a)).forEach(i -> this.completeMapVar(va, Array.get(a, i), this.vals(indexes, i)));
            } else {
                this.mapVar.put(va.varAt(indexes), (Variable)a);
            }
        }
    }

    @Override
    public void loadArray(XVariables.XArray va) {
        this.implem.manageIdFor(va);
        IVar[] a = null;
        int[] sz = va.size;
        if (va.getType() == Types.TypeVar.integer) {
            if (sz.length == 1) {
                a = this.array(va.id, this.size(sz[0]), (int i) -> va.domAt(i), va.note, va.classes);
            } else if (sz.length == 2) {
                a = this.array(va.id, this.size(sz[0], sz[1]), (int i, int j) -> va.domAt(i, j), va.note, va.classes);
            } else if (sz.length == 3) {
                a = this.array(va.id, this.size(sz[0], sz[1], sz[2]), (int i, int j, int k) -> va.domAt(i, j, k), va.note, va.classes);
            } else if (sz.length == 4) {
                a = this.array(va.id, this.size(sz[0], sz[1], sz[2], sz[3]), (int i, int j, int k, int l) -> va.domAt(i, j, k, l), va.note, va.classes);
            } else if (sz.length == 5) {
                a = this.array(va.id, this.size(sz[0], sz[1], sz[2], sz[3], sz[4]), (int i, int j, int k, int l, int m) -> va.domAt(i, j, k, l, m), va.note, va.classes);
            } else {
                this.unimplementedCase(va);
            }
        } else if (va.getType() == Types.TypeVar.symbolic) {
            if (sz.length == 1) {
                a = this.arraySymbolic(va.id, this.size(sz[0]), (int i) -> va.varAt(i) != null && va.varAt((int[])new int[]{i}).degree > 0 ? (Domains.DomSymbolic)va.varAt((int[])new int[]{i}).dom : null, va.note, va.classes);
            } else {
                this.unimplementedCase(va);
            }
        } else {
            this.unimplementedCase(va);
        }
        this.completeMapVar(va, a, new int[0]);
    }

    @Override
    public void buildVarInteger(XVariables.XVarInteger x, int minValue, int maxValue) {
        throw new AssertionError();
    }

    @Override
    public void buildVarInteger(XVariables.XVarInteger x, int[] values) {
        throw new AssertionError();
    }

    @Override
    public void buildVarSymbolic(XVariables.XVarSymbolic x, String[] values) {
        throw new AssertionError();
    }

    @Override
    public void loadBlock(XConstraints.XBlock block) {
        CtrEntities.CtrArray entity = this.block(() -> this.loadConstraints(block.subentries));
        this.copyBasicAttributes(entity, block);
    }

    @Override
    public void loadGroup(XConstraints.XGroup group) {
        CtrEntities.CtrArray entity = this.problem.manageLoop(() -> {
            if (group.template instanceof XConstraints.XCtr) {
                this.loadCtrs((XConstraints.XCtr)group.template, group.argss, group);
            } else if (group.template instanceof XConstraints.XLogic && ((XConstraints.XLogic)group.template).getType() == Types.TypeCtr.not) {
                XConstraints.CEntryReifiable child = ((XConstraints.XLogic)group.template).components[0];
                if (child instanceof XConstraints.XCtr && ((XConstraints.XCtr)child).type == Types.TypeCtr.allEqual) {
                    Stream.of(group.argss).forEach(o -> this.notAllEqual(this.trVars((XVariables.XVarInteger[])o)));
                } else {
                    this.unimplementedCase(group);
                }
            } else {
                this.unimplementedCase(group);
            }
        });
        if (entity != null) {
            this.copyBasicAttributes(entity, group);
        }
    }

    @Override
    public void loadSlide(XConstraints.XSlide s) {
        CtrEntities.CtrArray entity = this.problem.manageLoop(() -> XCallbacks2.super.loadSlide(s));
        this.copyBasicAttributes(entity, s);
    }

    @Override
    public void beginLogic(XConstraints.XLogic l) {
        System.out.println("Begin : " + l);
    }

    @Override
    public void endLogic(XConstraints.XLogic l) {
        System.out.println("End : " + l);
    }

    @Override
    public void loadCtr(XConstraints.XCtr c) {
        if (this.problem.features.mustDiscard(c.vars())) {
            return;
        }
        if (this.problem.head.control.constraints.ignoredCtrType == c.type) {
            ++this.problem.features.nDiscardedCtrs;
            return;
        }
        if (this.problem.head.control.constraints.ignoreCtrArity == c.vars().length) {
            ++this.problem.features.nDiscardedCtrs;
            return;
        }
        int sizeBefore = this.problem.ctrEntities.allEntities.size();
        XCallbacks2.super.loadCtr(c);
        if (sizeBefore == this.problem.ctrEntities.allEntities.size()) {
            return;
        }
        CtrEntities.CtrEntity entity = this.problem.ctrEntities.allEntities.get(this.problem.ctrEntities.allEntities.size() - 1);
        this.copyBasicAttributes(entity, c);
    }

    @Override
    public void buildCtrFalse(String id, XVariables.XVar[] list) {
        if (this.problem.settings.framework != Types.TypeFramework.MAXCSP) {
            throw new RuntimeException("Constraint with only conflicts");
        }
        this.problem.post(new Constraint.CtrFalse(this.problem, this.trVars((XVariables.XVarInteger[])Stream.of(list).map(x -> (XVariables.XVarInteger)x).toArray(XVariables.XVarInteger[]::new)), "CtrHard False for MaxCSP"), new Types.TypeClass[0]);
    }

    @Override
    public void buildCtrIntension(String id, XVariables.XVarInteger[] scope, XNodeParent<XVariables.XVarInteger> tree) {
        this.control(tree.exactlyVars(scope), "Pb with scope");
        this.problem.intension((XNodeParent)this.trVar(tree));
    }

    @Override
    public void buildCtrExtension(String id, XVariables.XVarInteger x, int[] values, boolean positive, Set<Types.TypeFlag> flags) {
        this.control(!flags.contains((Object)Types.TypeFlag.STARRED_TUPLES), new Object[0]);
        values = flags.contains((Object)Types.TypeFlag.UNCLEAN_TUPLES) ? Variable.filterValues(this.trVar(x), values, false) : values;
        this.problem.extension((IVar.Var[])this.vars(this.trVar(x), new Variable.VariableInteger[0]), this.dub(values), positive);
    }

    @Override
    public void buildCtrExtension(String id, XVariables.XVarInteger[] list, int[][] tuples, boolean positive, Set<Types.TypeFlag> flags) {
        tuples = flags.contains((Object)Types.TypeFlag.UNCLEAN_TUPLES) ? Variable.filterTuples(this.trVars(list), tuples, false) : tuples;
        this.problem.extension(this.trVars(list), (Object[])tuples, positive, flags.contains((Object)Types.TypeFlag.STARRED_TUPLES));
    }

    @Override
    public void buildCtrExtension(String id, XVariables.XVarInteger[] list, AbstractTuple[] tuples, boolean positive, Set<Types.TypeFlag> flags) {
        this.problem.extension((IVar.Var[])this.trVars(list), tuples, positive);
    }

    @Override
    public void buildCtrRegular(String id, XVariables.XVarInteger[] list, Transition[] transitions, String startState, String[] finalStates) {
        this.problem.regular(this.trVars(list), new Automaton(startState, transitions, finalStates));
    }

    @Override
    public void buildCtrMDD(String id, XVariables.XVarInteger[] list, Transition[] transitions) {
        this.problem.mdd((IVar.Var[])this.trVars(list), transitions);
    }

    @Override
    public void buildCtrAllDifferent(String id, XVariables.XVarInteger[] list) {
        this.problem.allDifferent(this.trVars(list));
    }

    @Override
    public void buildCtrAllDifferentExcept(String id, XVariables.XVarInteger[] list, int[] except) {
        this.problem.allDifferent(this.trVars(list), except);
    }

    @Override
    public void buildCtrAllDifferentList(String id, XVariables.XVarInteger[][] lists) {
        this.problem.allDifferentList(this.trVars2D(lists));
    }

    @Override
    public void buildCtrAllDifferentMatrix(String id, XVariables.XVarInteger[][] matrix) {
        this.problem.allDifferentMatrix(this.trVars2D(matrix));
    }

    @Override
    public void buildCtrAllDifferent(String id, XNode<XVariables.XVarInteger>[] trees) {
        this.problem.allDifferent(this.trVar(trees));
    }

    @Override
    public void buildCtrAllEqual(String id, XVariables.XVarInteger[] list) {
        this.problem.allEqual(this.trVars(list));
    }

    @Override
    public void buildCtrOrdered(String id, XVariables.XVarInteger[] list, Types.TypeOperatorRel operator) {
        this.problem.ordered((IVar.Var[])this.trVars(list), new int[list.length - 1], operator);
    }

    @Override
    public void buildCtrOrdered(String id, XVariables.XVarInteger[] list, int[] lengths, Types.TypeOperatorRel operator) {
        this.problem.ordered((IVar.Var[])this.trVars(list), lengths, operator);
    }

    @Override
    public void buildCtrOrdered(String id, XVariables.XVarInteger[] list, XVariables.XVarInteger[] lengths, Types.TypeOperatorRel operator) {
        this.problem.ordered((IVar.Var[])this.trVars(list), this.trVars(lengths), operator);
    }

    @Override
    public void buildCtrLex(String id, XVariables.XVarInteger[][] lists, Types.TypeOperatorRel operator) {
        this.problem.lex(this.trVars2D(lists), operator);
    }

    @Override
    public void buildCtrLexMatrix(String id, XVariables.XVarInteger[][] matrix, Types.TypeOperatorRel operator) {
        this.problem.lexMatrix(this.trVars2D(matrix), operator);
    }

    @Override
    public void buildCtrSum(String id, XVariables.XVarInteger[] list, Condition condition) {
        this.problem.sum((IVar.Var[])this.trVars(list), this.repeat(1, list.length), this.trVar(condition));
    }

    @Override
    public void buildCtrSum(String id, XVariables.XVarInteger[] list, int[] coeffs, Condition condition) {
        this.problem.sum((IVar.Var[])this.trVars(list), coeffs, this.trVar(condition));
    }

    @Override
    public void buildCtrSum(String id, XVariables.XVarInteger[] list, XVariables.XVarInteger[] coeffs, Condition condition) {
        this.problem.sum((IVar.Var[])this.trVars(list), this.trVars(coeffs), this.trVar(condition));
    }

    @Override
    public void buildCtrSum(String id, XNode<XVariables.XVarInteger>[] trees, Condition condition) {
        this.problem.sum(this.trVar(trees), this.repeat(1, trees.length), this.trVar(condition));
    }

    @Override
    public void buildCtrSum(String id, XNode<XVariables.XVarInteger>[] trees, int[] coeffs, Condition condition) {
        assert (coeffs != null);
        this.problem.sum(this.trVar(trees), coeffs, this.trVar(condition));
    }

    @Override
    public void buildCtrSum(String id, XNode<XVariables.XVarInteger>[] trees, XVariables.XVarInteger[] coeffs, Condition condition) {
        this.unimplementedCase(id, Utilities.join(trees), Utilities.join(coeffs), condition);
    }

    @Override
    public void buildCtrCount(String id, XVariables.XVarInteger[] list, int[] values, Condition condition) {
        this.problem.count((IVar.Var[])this.trVars(list), values, this.trVar(condition));
    }

    @Override
    public void buildCtrCount(String id, XVariables.XVarInteger[] list, XVariables.XVarInteger[] values, Condition condition) {
        this.problem.count((IVar.Var[])this.trVars(list), this.trVars(values), this.trVar(condition));
    }

    @Override
    public void buildCtrAtLeast(String id, XVariables.XVarInteger[] list, int value, int k) {
        this.problem.count((IVar.Var[])this.trVars(list), new int[]{value}, this.condition(GE, k));
    }

    @Override
    public void buildCtrAtMost(String id, XVariables.XVarInteger[] list, int value, int k) {
        this.problem.count((IVar.Var[])this.trVars(list), new int[]{value}, this.condition(LE, k));
    }

    @Override
    public void buildCtrExactly(String id, XVariables.XVarInteger[] list, int value, int k) {
        this.problem.count((IVar.Var[])this.trVars(list), new int[]{value}, this.condition(EQ, k));
    }

    @Override
    public void buildCtrExactly(String id, XVariables.XVarInteger[] list, int value, XVariables.XVarInteger k) {
        this.problem.count((IVar.Var[])this.trVars(list), new int[]{value}, this.trVar(this.condition(EQ, k)));
    }

    @Override
    public void buildCtrAmong(String id, XVariables.XVarInteger[] list, int[] values, int k) {
        this.problem.count((IVar.Var[])this.trVars(list), values, this.condition(EQ, k));
    }

    @Override
    public void buildCtrAmong(String id, XVariables.XVarInteger[] list, int[] values, XVariables.XVarInteger k) {
        this.problem.count((IVar.Var[])this.trVars(list), values, this.trVar(this.condition(EQ, k)));
    }

    @Override
    public void buildCtrNValues(String id, XVariables.XVarInteger[] list, Condition condition) {
        this.problem.nValues(this.trVars(list), this.trVar(condition));
    }

    @Override
    public void buildCtrNValuesExcept(String id, XVariables.XVarInteger[] list, int[] values, Condition condition) {
        this.problem.nValues(this.trVars(list), this.trVar(condition), values);
    }

    @Override
    public void buildCtrNotAllEqual(String id, XVariables.XVarInteger[] list) {
        this.buildCtrNValues(id, list, this.condition(GT, 1L));
    }

    @Override
    public void buildCtrCardinality(String id, XVariables.XVarInteger[] list, boolean closed, int[] values, XVariables.XVarInteger[] occurs) {
        this.problem.cardinality((IVar.Var[])this.trVars(list), values, closed, (IVar.Var[])this.trVars(occurs));
    }

    @Override
    public void buildCtrCardinality(String id, XVariables.XVarInteger[] list, boolean closed, int[] values, int[] occurs) {
        this.problem.cardinality((IVar.Var[])this.trVars(list), values, closed, occurs);
    }

    @Override
    public void buildCtrCardinality(String id, XVariables.XVarInteger[] list, boolean closed, int[] values, int[] occursMin, int[] occursMax) {
        this.problem.cardinality((IVar.Var[])this.trVars(list), values, closed, occursMin, occursMax);
    }

    @Override
    public void buildCtrCardinality(String id, XVariables.XVarInteger[] list, boolean closed, XVariables.XVarInteger[] values, XVariables.XVarInteger[] occurs) {
        this.problem.cardinality((IVar.Var[])this.trVars(list), (IVar.Var[])this.trVars(values), closed, (IVar.Var[])this.trVars(occurs));
    }

    @Override
    public void buildCtrCardinality(String id, XVariables.XVarInteger[] list, boolean closed, XVariables.XVarInteger[] values, int[] occurs) {
        this.problem.cardinality((IVar.Var[])this.trVars(list), (IVar.Var[])this.trVars(values), closed, occurs);
    }

    @Override
    public void buildCtrCardinality(String id, XVariables.XVarInteger[] list, boolean closed, XVariables.XVarInteger[] values, int[] occursMin, int[] occursMax) {
        this.problem.cardinality((IVar.Var[])this.trVars(list), this.trVars(values), closed, occursMin, occursMax);
    }

    @Override
    public void buildCtrMaximum(String id, XVariables.XVarInteger[] list, Condition condition) {
        this.problem.maximum(this.trVars(list), this.trVar(condition));
    }

    @Override
    public void buildCtrMaximum(String id, XVariables.XVarInteger[] list, int startIndex, XVariables.XVarInteger index, Types.TypeRank rank, Condition condition) {
        this.problem.maximum(this.trVars(list), startIndex, this.trVar(index), rank, this.trVar(condition));
    }

    @Override
    public void buildCtrMaximum(String id, XNode<XVariables.XVarInteger>[] trees, Condition condition) {
        this.problem.maximum(this.trVar(trees), this.trVar(condition));
    }

    @Override
    public void buildCtrMinimum(String id, XVariables.XVarInteger[] list, Condition condition) {
        this.problem.minimum(this.trVars(list), this.trVar(condition));
    }

    @Override
    public void buildCtrMinimum(String id, XVariables.XVarInteger[] list, int startIndex, XVariables.XVarInteger index, Types.TypeRank rank, Condition condition) {
        this.problem.minimum(this.trVars(list), startIndex, this.trVar(index), rank, this.trVar(condition));
    }

    @Override
    public void buildCtrMinimum(String id, XNode<XVariables.XVarInteger>[] trees, Condition condition) {
        this.problem.minimum(this.trVar(trees), this.trVar(condition));
    }

    @Override
    public void buildCtrElement(String id, XVariables.XVarInteger[] list, Condition condition) {
        this.problem.element(this.trVars(list), this.trVar(condition));
    }

    @Override
    public void buildCtrElement(String id, XVariables.XVarInteger[] list, int startIndex, XVariables.XVarInteger index, Types.TypeRank rank, Condition condition) {
        this.control(startIndex == 0 && rank == Types.TypeRank.ANY, new Object[0]);
        this.problem.element(this.trVars(list), startIndex, (IVar.Var)this.trVar(index), rank, this.trVar(condition));
    }

    @Override
    public void buildCtrElement(String id, int[] list, int startIndex, XVariables.XVarInteger index, Types.TypeRank rank, Condition condition) {
        this.control(rank == Types.TypeRank.ANY, new Object[0]);
        this.problem.element(list, startIndex, (IVar.Var)this.trVar(index), rank, this.trVar(condition));
    }

    @Override
    public void buildCtrElement(String id, int[][] matrix, int startRowIndex, XVariables.XVarInteger rowIndex, int startColIndex, XVariables.XVarInteger colIndex, Condition condition) {
        this.control(startRowIndex == 0 && startColIndex == 0, new Object[0]);
        this.problem.element(matrix, startRowIndex, (IVar.Var)this.trVar(rowIndex), startColIndex, (IVar.Var)this.trVar(colIndex), this.trVar(condition));
    }

    @Override
    public void buildCtrElement(String id, XVariables.XVarInteger[][] matrix, int startRowIndex, XVariables.XVarInteger rowIndex, int startColIndex, XVariables.XVarInteger colIndex, Condition condition) {
        this.control(startRowIndex == 0 && startColIndex == 0, new Object[0]);
        this.problem.element((IVar.Var[][])this.trVars2D(matrix), startRowIndex, (IVar.Var)this.trVar(rowIndex), startColIndex, (IVar.Var)this.trVar(colIndex), this.trVar(condition));
    }

    @Override
    public void buildCtrChannel(String id, XVariables.XVarInteger[] list, int startIndex) {
        this.problem.channel(this.trVars(list), startIndex);
    }

    @Override
    public void buildCtrChannel(String id, XVariables.XVarInteger[] list1, int startIndex1, XVariables.XVarInteger[] list2, int startIndex2) {
        this.problem.channel(this.trVars(list1), startIndex1, this.trVars(list2), startIndex2);
    }

    @Override
    public void buildCtrChannel(String id, XVariables.XVarInteger[] list, int startIndex, XVariables.XVarInteger value) {
        this.problem.channel(this.trVars(list), startIndex, this.trVar(value));
    }

    @Override
    public void buildCtrStretch(String id, XVariables.XVarInteger[] list, int[] values, int[] widthsMin, int[] widthsMax) {
        this.problem.stretch(this.trVars(list), values, widthsMin, widthsMax, null);
    }

    @Override
    public void buildCtrStretch(String id, XVariables.XVarInteger[] list, int[] values, int[] widthsMin, int[] widthsMax, int[][] patterns) {
        this.problem.stretch(this.trVars(list), values, widthsMin, widthsMax, patterns);
    }

    @Override
    public void buildCtrNoOverlap(String id, XVariables.XVarInteger[] origins, int[] lengths, boolean zeroIgnored) {
        this.problem.noOverlap((IVar.Var[])this.trVars(origins), lengths, zeroIgnored);
    }

    @Override
    public void buildCtrNoOverlap(String id, XVariables.XVarInteger[] origins, XVariables.XVarInteger[] lengths, boolean zeroIgnored) {
        this.problem.noOverlap((IVar.Var[])this.trVars(origins), this.trVars(lengths), zeroIgnored);
    }

    @Override
    public void buildCtrNoOverlap(String id, XVariables.XVarInteger[][] origins, int[][] lengths, boolean zeroIgnored) {
        this.problem.noOverlap((IVar.Var[][])this.trVars2D(origins), lengths, zeroIgnored);
    }

    @Override
    public void buildCtrNoOverlap(String id, XVariables.XVarInteger[][] origins, XVariables.XVarInteger[][] lengths, boolean zeroIgnored) {
        this.problem.noOverlap((IVar.Var[][])this.trVars2D(origins), this.trVars2D(lengths), zeroIgnored);
    }

    @Override
    public void buildCtrCumulative(String id, XVariables.XVarInteger[] origins, int[] lengths, int[] heights, Condition condition) {
        this.problem.cumulative((IVar.Var[])this.trVars(origins), lengths, null, heights, this.trVar(condition));
    }

    @Override
    public void buildCtrCumulative(String id, XVariables.XVarInteger[] origins, int[] lengths, XVariables.XVarInteger[] heights, Condition condition) {
        this.problem.cumulative((IVar.Var[])this.trVars(origins), lengths, null, (IVar.Var[])this.trVars(heights), this.trVar(condition));
    }

    @Override
    public void buildCtrCumulative(String id, XVariables.XVarInteger[] origins, XVariables.XVarInteger[] lengths, int[] heights, Condition condition) {
        this.problem.cumulative((IVar.Var[])this.trVars(origins), (IVar.Var[])this.trVars(lengths), null, heights, this.trVar(condition));
    }

    @Override
    public void buildCtrCumulative(String id, XVariables.XVarInteger[] origins, XVariables.XVarInteger[] lengths, XVariables.XVarInteger[] heights, Condition condition) {
        this.problem.cumulative((IVar.Var[])this.trVars(origins), (IVar.Var[])this.trVars(lengths), null, (IVar.Var[])this.trVars(heights), this.trVar(condition));
    }

    @Override
    public void buildCtrCumulative(String id, XVariables.XVarInteger[] origins, int[] lengths, XVariables.XVarInteger[] ends, int[] heights, Condition condition) {
        this.problem.cumulative((IVar.Var[])this.trVars(origins), lengths, (IVar.Var[])this.trVars(ends), heights, this.trVar(condition));
    }

    @Override
    public void buildCtrCumulative(String id, XVariables.XVarInteger[] origins, int[] lengths, XVariables.XVarInteger[] ends, XVariables.XVarInteger[] heights, Condition condition) {
        this.problem.cumulative((IVar.Var[])this.trVars(origins), lengths, (IVar.Var[])this.trVars(ends), (IVar.Var[])this.trVars(heights), this.trVar(condition));
    }

    @Override
    public void buildCtrCumulative(String id, XVariables.XVarInteger[] origins, XVariables.XVarInteger[] lengths, XVariables.XVarInteger[] ends, int[] heights, Condition condition) {
        this.problem.cumulative((IVar.Var[])this.trVars(origins), (IVar.Var[])this.trVars(lengths), (IVar.Var[])this.trVars(ends), heights, this.trVar(condition));
    }

    @Override
    public void buildCtrCumulative(String id, XVariables.XVarInteger[] origins, XVariables.XVarInteger[] lengths, XVariables.XVarInteger[] ends, XVariables.XVarInteger[] heights, Condition condition) {
        this.problem.cumulative((IVar.Var[])this.trVars(origins), (IVar.Var[])this.trVars(lengths), (IVar.Var[])this.trVars(ends), (IVar.Var[])this.trVars(heights), this.trVar(condition));
    }

    @Override
    public void buildCtrInstantiation(String id, XVariables.XVarInteger[] list, int[] values) {
        this.problem.instantiation((IVar.Var[])this.trVars(list), values);
    }

    @Override
    public void buildCtrClause(String id, XVariables.XVarInteger[] pos, XVariables.XVarInteger[] neg) {
        this.problem.clause((IVar.Var[])this.trVars(pos), this.trVars(neg));
    }

    @Override
    public void buildCtrCircuit(String id, XVariables.XVarInteger[] list, int startIndex) {
        this.problem.circuit(this.trVars(list), startIndex);
    }

    @Override
    public void buildCtrBinPacking(String id, XVariables.XVarInteger[] list, int[] sizes, Condition condition) {
        this.problem.binpacking(this.trVars(list), sizes, this.trVar(condition));
    }

    @Override
    public void loadObj(XObjectives.XObj o) {
        if (this.problem.features.mustDiscard(o.vars())) {
            return;
        }
        XCallbacks2.super.loadObj(o);
        CtrEntities.CtrEntity entity = this.problem.ctrEntities.allEntities.get(this.problem.ctrEntities.allEntities.size() - 1);
        this.copyBasicAttributes(entity, o);
    }

    @Override
    public void buildObjToMinimize(String id, XVariables.XVarInteger x) {
        this.problem.minimize(this.trVar(x));
    }

    @Override
    public void buildObjToMaximize(String id, XVariables.XVarInteger x) {
        this.problem.maximize(this.trVar(x));
    }

    private List<VarVal> isSum(XNodeParent<XVariables.XVarInteger> tree) {
        ArrayList<VarVal> list = new ArrayList<VarVal>();
        if (tree.type == Types.TypeExpr.ADD) {
            for (XNode son : tree.sons) {
                if (son.type == Types.TypeExpr.VAR) {
                    list.add(new VarVal(this.trVar((XVariables.XVarInteger)son.var(0)), 1));
                    continue;
                }
                if (MatcherInterface.x_mul_k.matches(son) || MatcherInterface.k_mul_x.matches(son)) {
                    list.add(new VarVal(this.trVar((XVariables.XVarInteger)son.var(0)), son.val(0)));
                    continue;
                }
                list.clear();
                break;
            }
        }
        return list;
    }

    @Override
    public void buildObjToMinimize(String id, XNodeParent<XVariables.XVarInteger> tree) {
        List<VarVal> list = this.isSum(tree);
        if (list.size() > 0) {
            this.problem.minimize(SUM, (IVar[])list.stream().map(vv -> vv.x).toArray(Variable.VariableInteger[]::new), list.stream().mapToInt(vv -> vv.a).toArray());
        } else {
            this.problem.minimize(this.trVar(tree));
        }
    }

    @Override
    public void buildObjToMaximize(String id, XNodeParent<XVariables.XVarInteger> tree) {
        List<VarVal> list = this.isSum(tree);
        if (list.size() > 0) {
            this.problem.maximize(SUM, (IVar[])list.stream().map(vv -> vv.x).toArray(Variable.VariableInteger[]::new), list.stream().mapToInt(vv -> vv.a).toArray());
        } else {
            this.problem.maximize(this.trVar(tree));
        }
    }

    @Override
    public void buildObjToMinimize(String id, Types.TypeObjective type, XVariables.XVarInteger[] list) {
        this.problem.minimize(type, this.trVars(list));
    }

    @Override
    public void buildObjToMaximize(String id, Types.TypeObjective type, XVariables.XVarInteger[] list) {
        this.problem.maximize(type, this.trVars(list));
    }

    @Override
    public void buildObjToMinimize(String id, Types.TypeObjective type, XVariables.XVarInteger[] list, int[] coeffs) {
        this.problem.minimize(type, this.trVars(list), coeffs);
    }

    @Override
    public void buildObjToMaximize(String id, Types.TypeObjective type, XVariables.XVarInteger[] list, int[] coeffs) {
        this.problem.maximize(type, this.trVars(list), coeffs);
    }

    @Override
    public void buildObjToMinimize(String id, Types.TypeObjective type, XNode<XVariables.XVarInteger>[] trees) {
        this.problem.minimize(type, this.trVar(trees));
    }

    @Override
    public void buildObjToMaximize(String id, Types.TypeObjective type, XNode<XVariables.XVarInteger>[] trees) {
        this.problem.maximize(type, this.trVar(trees));
    }

    @Override
    public void buildObjToMinimize(String id, Types.TypeObjective type, XNode<XVariables.XVarInteger>[] trees, int[] coeffs) {
        this.problem.minimize(type, this.trVar(trees), coeffs);
    }

    @Override
    public void buildObjToMaximize(String id, Types.TypeObjective type, XNode<XVariables.XVarInteger>[] trees, int[] coeffs) {
        this.problem.maximize(type, this.trVar(trees), coeffs);
    }

    @Override
    public void buildCtrIntension(String id, XVariables.XVarSymbolic[] scope, XNodeParent<XVariables.XVarSymbolic> tree) {
        this.control(tree.exactlyVars(scope), "Pb with scope");
        this.problem.intension((XNodeParent)this.trVarSymbolic(tree));
    }

    @Override
    public void buildCtrExtension(String id, XVariables.XVarSymbolic x, String[] values, boolean positive, Set<Types.TypeFlag> flags) {
        this.control(!flags.contains((Object)Types.TypeFlag.STARRED_TUPLES), "Forbidden for unary constraints");
        values = flags.contains((Object)Types.TypeFlag.UNCLEAN_TUPLES) ? Variable.filterValues(this.trVar(x), values) : values;
        this.problem.extension((IVar.VarSymbolic[])this.vars(this.trVar(x), new Variable.VariableSymbolic[0]), this.dub(values), positive);
    }

    @Override
    public void buildCtrExtension(String id, XVariables.XVarSymbolic[] list, String[][] tuples, boolean positive, Set<Types.TypeFlag> flags) {
        tuples = flags.contains((Object)Types.TypeFlag.UNCLEAN_TUPLES) ? Variable.filterTuples(this.trVars(list), tuples) : tuples;
        this.problem.extension(this.trVars(list), (Object[])tuples, positive, flags.contains((Object)Types.TypeFlag.STARRED_TUPLES));
    }

    @Override
    public void buildCtrAllDifferent(String id, XVariables.XVarSymbolic[] list) {
        this.problem.allDifferent(this.trVars(list));
    }

    @Override
    public void buildAnnotationDecision(XVariables.XVarInteger[] list) {
        this.decisionVariables(this.trVars(list));
    }

    static class VarVal {
        Variable x;
        int a;

        VarVal(Variable x, int a) {
            this.x = x;
            this.a = a;
        }
    }
}

