/*
 * Decompiled with CFR 0.152.
 */
package problem;

import constraints.Constraint;
import constraints.global.Lexicographic;
import constraints.intension.Intension;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.xcsp.common.IVar;
import problem.Problem;
import sets.SetSparse;
import utility.Enums;
import utility.Kit;
import variables.Domain;
import variables.Variable;

public class Remodeler {

    public static final class DeducingAutomorphism {
        public static final String N_GENERATORS = "nGenerators";
        public static final String SYMMETRY_WALL_CLOCK_TIME = "symmetryWckTime";
        private Problem problem;
        private int nCurrentNodes;
        private int nCurrentColors;
        private int[] variableNodes;
        private Map<String, Variable> mapOfDomainColors;
        private List<Node> constraintNodes;
        private Map<String, int[]> mapOfRelationColors;
        private Map<Integer, List<Integer>> groupsOfColors;
        public List<List<int[]>> generators;
        private Kit.Stopwatch stopwatch;
        private int nFusions;
        private String graphFileName;
        private Map<String, Domain> mapOfModifiedDomains;

        public DeducingAutomorphism(Problem pb) {
            this.problem = pb;
        }

        private void clear() {
            this.variableNodes = null;
            this.mapOfDomainColors.clear();
            this.constraintNodes.clear();
            this.mapOfRelationColors.clear();
            this.groupsOfColors.clear();
        }

        private void addColorNode(int id, int color) {
            this.groupsOfColors.computeIfAbsent(color, k -> new ArrayList()).add(id);
        }

        private String manageDomainKeyOf(Domain dom) {
            if (dom.nRemoved() == 0) {
                return dom.typeName() + "0";
            }
            if (this.mapOfModifiedDomains == null) {
                this.mapOfModifiedDomains = new HashMap<String, Domain>();
            }
            int i = 1;
            while (true) {
                String key;
                Domain d;
                if ((d = this.mapOfModifiedDomains.get(key = dom.typeName() + i)) == null) {
                    this.mapOfModifiedDomains.put(key, d);
                    return key;
                }
                if (dom.size() == d.size()) {
                    boolean equal = true;
                    int idx = dom.first();
                    while (equal && idx != -1) {
                        if (!d.present(idx)) {
                            equal = false;
                        }
                        idx = dom.next(idx);
                    }
                    if (equal) {
                        return key;
                    }
                }
                ++i;
            }
        }

        private void buildVariableNodes(Variable[] vars) {
            this.mapOfDomainColors = new HashMap<String, Variable>();
            this.variableNodes = new int[vars.length];
            for (int i = 0; i < vars.length; ++i) {
                String key = this.manageDomainKeyOf(vars[i].dom);
                Variable var = this.mapOfDomainColors.get(key);
                if (var == null) {
                    this.mapOfDomainColors.put(key, vars[i]);
                    ++this.nCurrentColors;
                } else {
                    this.variableNodes[i] = this.variableNodes[var.num];
                }
                this.addColorNode(i, this.variableNodes[i]);
            }
            this.nCurrentNodes = this.variableNodes.length;
        }

        private void buildConstraintNodes(Collection<Constraint> ctrs) {
            this.mapOfRelationColors = new HashMap<String, int[]>();
            this.constraintNodes = new ArrayList<Node>();
            for (Constraint c : ctrs) {
                int i;
                Variable[] scope = c.scp;
                String key = c.key;
                int[] t = this.mapOfRelationColors.get(key);
                if (t == null) {
                    int[] symmetryMatching = c.symmetryMatching();
                    t = new int[scope.length + 1];
                    if (symmetryMatching != null) {
                        t[t.length - 1] = this.nCurrentColors++;
                        int max = 0;
                        for (int i2 = 0; i2 < symmetryMatching.length; ++i2) {
                            if (symmetryMatching[i2] > max) {
                                max = symmetryMatching[i2];
                            }
                            t[i2] = this.nCurrentColors + (symmetryMatching[i2] - 1);
                        }
                        this.nCurrentColors += max;
                    } else {
                        for (i = 0; i < t.length; ++i) {
                            ++this.nCurrentColors;
                        }
                    }
                    this.mapOfRelationColors.put(key, t);
                }
                int v = this.nCurrentNodes;
                this.constraintNodes.add(new Node(this.nCurrentNodes, t[t.length - 1]));
                this.addColorNode(this.nCurrentNodes++, t[t.length - 1]);
                for (i = 0; i < t.length - 1; ++i) {
                    this.constraintNodes.add(new Node(this.nCurrentNodes, t[i], new int[]{scope[i].num, v}));
                    this.addColorNode(this.nCurrentNodes++, t[i]);
                }
            }
        }

        private void buildGAPEdges(PrintWriter out) {
            out.print('[');
            Iterator<Node> it = this.constraintNodes.iterator();
            while (it.hasNext()) {
                Node node = it.next();
                for (int i = 0; i < node.neighbors.length; ++i) {
                    out.print('[');
                    out.print(node.id + 1);
                    out.print(',');
                    out.print(node.neighbors[i] + 1);
                    out.print(']');
                    if (!it.hasNext() && i >= node.neighbors.length - 1) continue;
                    out.print(',');
                }
            }
            out.print(']');
        }

        private void buildGAPGroups(PrintWriter out) {
            out.print('[');
            Collection<List<Integer>> collection = this.groupsOfColors.values();
            Iterator<List<Integer>> it = collection.iterator();
            while (it.hasNext()) {
                List<Integer> list = it.next();
                out.print('[');
                for (int i = 0; i < list.size(); ++i) {
                    out.print(list.get(i) + 1);
                    if (i >= list.size() - 1) continue;
                    out.print(',');
                }
                out.print(']');
                if (!it.hasNext()) continue;
                out.print(',');
            }
            out.print(']');
        }

        private void saveInGAPFormat() {
            try {
                this.graphFileName = "graph" + new Random().nextInt() + ".gap";
                PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(this.graphFileName)));
                out.print("AutGroupGraph(UnderlyingGraph(EdgeOrbitsGraph( Group(()),");
                this.buildGAPEdges(out);
                out.print(',');
                out.print(this.nCurrentNodes);
                out.print(")),");
                this.buildGAPGroups(out);
                out.println(");");
                out.close();
            }
            catch (Exception e) {
                Kit.exit(e);
            }
        }

        private List<int[]> parseGenerator(String line) {
            int id;
            String cycle;
            StringTokenizer st2;
            ArrayList<int[]> list = new ArrayList<int[]>();
            StringTokenizer st1 = new StringTokenizer(line, "()");
            while (st1.hasMoreTokens() && (st2 = new StringTokenizer(cycle = st1.nextToken(), ",")).hasMoreTokens() && (id = Integer.parseInt(st2.nextToken()) - 1) < this.variableNodes.length) {
                int[] t = new int[st2.countTokens() + 1];
                t[0] = id;
                for (int i = 1; i < t.length; ++i) {
                    t[i] = Integer.parseInt(st2.nextToken()) - 1;
                }
                list.add(t);
            }
            return list;
        }

        private void runSaucy() {
            try {
                String command = System.getenv("HOME") + File.separator + "tools" + File.separator + "saucy-1.1" + File.separator + "saucy -t 20 -g " + this.graphFileName;
                Kit.log.info("Command for symmetry breaking is " + command);
                Process p = Runtime.getRuntime().exec(command);
                BufferedReader in = new BufferedReader(new InputStreamReader(p.getInputStream()));
                this.generators = new ArrayList<List<int[]>>();
                in.readLine();
                String line = in.readLine().trim();
                while (!line.equals("]")) {
                    List<int[]> generator = this.parseGenerator(line);
                    if (generator.size() > 0) {
                        this.generators.add(generator);
                    }
                    line = in.readLine();
                }
                this.displayGenerators();
                in.close();
                p.waitFor();
                p.destroy();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        private List<Constraint> buildConstraintsFor(Variable[] variables, Collection<Constraint> collectedConstraints) {
            ArrayList<Constraint> list = new ArrayList<Constraint>();
            for (List<int[]> generator : this.generators) {
                int[] cycle1 = generator.get(0);
                Variable x = variables[cycle1[0]];
                Variable y = variables[cycle1[1]];
                if (this.problem.head.control.problem.symmetryBreaking == Enums.ESymmetryBreaking.LE) {
                    list.add(new Intension(this.problem, (Variable[])this.problem.api.vars(x, new Object[]{y}), this.problem.api.le(x, y)));
                    continue;
                }
                ArrayList<Variable> list1 = new ArrayList<Variable>();
                ArrayList<Variable> list2 = new ArrayList<Variable>();
                for (int[] cycle : generator) {
                    if (cycle.length == 2) {
                        list1.add(variables[cycle[0]]);
                        list2.add(variables[cycle[1]]);
                        continue;
                    }
                    for (int i = 0; i < cycle.length; ++i) {
                        list1.add(variables[cycle[i]]);
                        list2.add(variables[cycle[(i + 1) % cycle.length]]);
                    }
                }
                Comparable[] t1 = list1.toArray(new Variable[list1.size()]);
                Variable[] t2 = list2.toArray(new Variable[list2.size()]);
                Kit.control(Kit.isStrictlyIncreasing((Comparable[])t1));
                list.add(new Lexicographic.LexicographicLE(this.problem, (Variable[])t1, t2));
            }
            return list;
        }

        public List<Constraint> buildVariableSymmetriesFor(Variable[] vars, Collection<Constraint> cons) {
            this.stopwatch = new Kit.Stopwatch();
            this.groupsOfColors = new HashMap<Integer, List<Integer>>();
            this.buildVariableNodes(vars);
            this.buildConstraintNodes(cons);
            this.saveInGAPFormat();
            this.runSaucy();
            this.clear();
            return this.buildConstraintsFor(vars, cons);
        }

        public void putInMap(Map<String, String> map) {
            map.put(N_GENERATORS, this.generators.size() + "");
            map.put("nbFusions", this.nFusions + "");
            map.put(SYMMETRY_WALL_CLOCK_TIME, this.stopwatch.wckTimeInSeconds() + "");
        }

        void displayGenerators() {
            if (this.problem.head.control.general.verbose > 0) {
                for (List<int[]> generator : this.generators) {
                    String s = "generator = ";
                    for (int[] t : generator) {
                        s = s + "[ " + Kit.join((Object)t, new String[0]) + " ]";
                    }
                    System.out.println(s);
                }
            }
        }

        void displayGraph() {
            int i;
            System.out.println("variableNodes");
            for (i = 0; i < this.variableNodes.length; ++i) {
                System.out.println(i + 1 + ":" + this.variableNodes[i] + " ");
            }
            System.out.println("constraintNodes");
            for (i = 0; i < this.constraintNodes.size(); ++i) {
                System.out.println(i + 1 + ":" + this.constraintNodes.get(i) + " ");
            }
        }

        private class Node {
            private int id;
            private int color;
            private int[] neighbors;

            private Node(int id, int color) {
                this.id = id;
                this.color = color;
                this.neighbors = new int[0];
            }

            private Node(int id, int color, int[] neighbors) {
                this.id = id;
                this.color = color;
                this.neighbors = neighbors;
            }

            public String toString() {
                String s = "node " + (this.id + 1) + " color=" + this.color + " neighbors=";
                for (int i = 0; i < this.neighbors.length; ++i) {
                    s = s + (this.neighbors[i] + 1) + " ";
                }
                return s;
            }
        }
    }

    public static final class DeducingAllDifferent {
        public static final String N_CLIQUES = "nCliques";
        private Problem problem;
        public int nBuiltCliques;

        private int[][] computeIrreflexivesNeigbours(Variable[] variables, List<Constraint> constraints) {
            Set[] neighbours = (Set[])Stream.of(variables).map(x -> new TreeSet()).toArray(TreeSet[]::new);
            for (Constraint c : constraints) {
                if (c.scp.length != 2 || !c.isIrreflexive()) continue;
                neighbours[c.scp[0].num].add(c.scp[1].num);
                neighbours[c.scp[1].num].add(c.scp[0].num);
            }
            return Kit.intArray2D(neighbours);
        }

        private int countNeighboursAtLevel(int[] neighbours, int level, int[] levels) {
            int cnt = 0;
            for (int j : neighbours) {
                if (levels[j] != level) continue;
                ++cnt;
            }
            return cnt;
        }

        private List<Variable.VariableInteger[]> buildCliques(Variable[] variables, List<Constraint> constraints, int nLimit, int sLimit) {
            int n = variables.length;
            int[][] allNeighbours = this.computeIrreflexivesNeigbours(variables, constraints);
            int[] degrees = Stream.of(allNeighbours).mapToInt(t -> ((int[])t).length).toArray();
            int[] levels = new int[n];
            int[] tmp = new int[n];
            SetSparse set = new SetSparse(n, true);
            ArrayList<Variable.VariableInteger[]> list = new ArrayList<Variable.VariableInteger[]>();
            for (int k = 1; k <= nLimit; ++k) {
                int i2;
                int level = 0;
                int cliqueSize = 0;
                int num = -1;
                for (i2 = 0; i2 <= set.limit; ++i2) {
                    if (num != -1 && degrees[set.dense[i2]] <= degrees[num]) continue;
                    num = set.dense[i2];
                }
                while (num != -1) {
                    int[] neighbours;
                    levels[num] = -k;
                    tmp[cliqueSize++] = num;
                    set.remove(num);
                    for (int j : neighbours = allNeighbours[num]) {
                        if (levels[j] != level) continue;
                        levels[j] = level + 1;
                    }
                    ++level;
                    for (int j : neighbours) {
                        if (levels[j] != level) continue;
                        degrees[j] = this.countNeighboursAtLevel(allNeighbours[j], level, levels);
                    }
                    num = -1;
                    for (int j : neighbours) {
                        if (levels[j] != level || num != -1 && degrees[j] <= degrees[num]) continue;
                        num = j;
                    }
                }
                for (i2 = 0; i2 <= set.limit; ++i2) {
                    levels[set.dense[i2]] = 0;
                }
                if (cliqueSize <= sLimit) break;
                Variable[] scp = (Variable.VariableInteger[])IntStream.range(0, cliqueSize).mapToObj(i -> this.problem.variables[tmp[i]]).sorted().toArray(Variable.VariableInteger[]::new);
                list.add((Variable.VariableInteger[])scp);
                this.display(k, (Variable.VariableInteger[])scp);
                assert (this.controlClique(scp, constraints));
                for (int i3 = 0; i3 <= set.limit; ++i3) {
                    degrees[set.dense[i3]] = this.countNeighboursAtLevel(allNeighbours[set.dense[i3]], 0, levels);
                }
            }
            return list;
        }

        public DeducingAllDifferent(Problem problem) {
            this.problem = problem;
            int nLimit = problem.head.control.constraints.inferAllDifferentNb;
            int sLimit = problem.head.control.constraints.inferAllDifferentSize;
            List<Variable.VariableInteger[]> list = this.buildCliques(problem.variables, problem.features.collectedCtrsAtInit, nLimit, sLimit);
            for (IVar.Var[] varArray : list) {
                problem.allDifferent(varArray);
            }
            this.nBuiltCliques = list.size();
        }

        private boolean controlClique(Variable[] scp, List<Constraint> constraints) {
            for (int i = 0; i < scp.length; ++i) {
                for (int j = i + 1; j < scp.length; ++j) {
                    Variable x = scp[i];
                    Variable y = scp[j];
                    Kit.control(constraints.stream().anyMatch(c -> c.scp.length == 2 && c.isIrreflexive() && c.involves(x, y)), () -> "not a clique with " + x + " " + y);
                }
            }
            return true;
        }

        private void display(int cliqueId, Variable.VariableInteger[] scp) {
            System.out.println(" clique " + cliqueId + " of size " + scp.length + " {" + Kit.join((Object)scp, new String[0]) + "}");
        }
    }
}

