/*
 * Decompiled with CFR 0.152.
 */
package org.xcsp.parser.loaders;

import java.lang.reflect.Array;
import java.util.Set;
import java.util.stream.Stream;
import org.xcsp.common.Types;
import org.xcsp.common.predicates.XNodeParent;
import org.xcsp.parser.callbacks.XCallbacks;
import org.xcsp.parser.entries.XConstraints;
import org.xcsp.parser.entries.XVariables;

public class CtrLoaderSymbolic {
    private XCallbacks xc;

    public CtrLoaderSymbolic(XCallbacks xc) {
        this.xc = xc;
    }

    public void load(XConstraints.XCtr c) {
        switch (c.getType()) {
            case intension: {
                this.intension(c);
                break;
            }
            case extension: {
                this.extension(c);
                break;
            }
            case allDifferent: {
                this.allDifferent(c);
                break;
            }
            default: {
                this.xc.unimplementedCase(c);
            }
        }
    }

    private void intension(XConstraints.XCtr c) {
        this.xc.buildCtrIntension(c.id, (XVariables.XVarSymbolic[])Stream.of(c.vars()).toArray(XVariables.XVarSymbolic[]::new), (XNodeParent)c.childs[0].value);
    }

    private void extension(XConstraints.XCtr c) {
        boolean positive;
        XConstraints.CChild c1 = c.childs[1];
        boolean bl = positive = c1.type == Types.TypeChild.supports;
        if (c1.value == null || Array.getLength(c1.value) == 0) {
            if (positive) {
                this.xc.buildCtrFalse(c.id, c.vars());
            } else {
                this.xc.buildCtrTrue(c.id, c.vars());
            }
        } else {
            XVariables.XVarSymbolic[] list = (XVariables.XVarSymbolic[])c.childs[0].value;
            if (list.length == 1) {
                this.xc.buildCtrExtension(c.id, list[0], (String[])c1.value, positive, (Set<Types.TypeFlag>)c1.flags);
            } else {
                this.xc.buildCtrExtension(c.id, list, (String[][])c1.value, positive, (Set<Types.TypeFlag>)c1.flags);
            }
        }
    }

    private void allDifferent(XConstraints.XCtr c) {
        if (c.childs.length == 1 && c.childs[0].type == Types.TypeChild.list) {
            this.xc.buildCtrAllDifferent(c.id, (XVariables.XVarSymbolic[])c.childs[0].value);
        } else {
            this.xc.unimplementedCase(c);
        }
    }
}

