/*
 * Decompiled with CFR 0.152.
 */
package org.xcsp.parser.loaders;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.xcsp.common.Condition;
import org.xcsp.common.IVar;
import org.xcsp.common.Types;
import org.xcsp.common.Utilities;
import org.xcsp.common.predicates.MatcherInterface;
import org.xcsp.common.predicates.XNode;
import org.xcsp.common.predicates.XNodeParent;
import org.xcsp.parser.callbacks.XCallbacks;
import org.xcsp.parser.entries.XVariables;
import org.xcsp.parser.loaders.CtrLoaderInteger;

public class ConstraintRecognizer {
    private XCallbacks xc;
    private MatcherInterface.Matcher x_relop_k = new MatcherInterface.Matcher(XNode.node(MatcherInterface.AbstractOperation.relop, MatcherInterface.var, MatcherInterface.val));
    private MatcherInterface.Matcher k_relop_x = new MatcherInterface.Matcher(XNode.node(MatcherInterface.AbstractOperation.relop, MatcherInterface.val, MatcherInterface.var));
    private MatcherInterface.Matcher x_ariop_k__relop_l = new MatcherInterface.Matcher(XNode.node(MatcherInterface.AbstractOperation.relop, XNode.node(MatcherInterface.AbstractOperation.ariop, MatcherInterface.var, MatcherInterface.val), MatcherInterface.val));
    private MatcherInterface.Matcher l_relop__x_ariop_k = new MatcherInterface.Matcher(XNode.node(MatcherInterface.AbstractOperation.relop, MatcherInterface.val, XNode.node(MatcherInterface.AbstractOperation.ariop, MatcherInterface.var, MatcherInterface.val)));
    private MatcherInterface.Matcher x_setop_S = new MatcherInterface.Matcher(XNode.node(MatcherInterface.AbstractOperation.setop, MatcherInterface.var, MatcherInterface.set_vals));
    private MatcherInterface.Matcher x_in_intvl = new MatcherInterface.Matcher(XNode.node(Types.TypeExpr.AND, XNode.node(Types.TypeExpr.LE, MatcherInterface.var, MatcherInterface.val), XNode.node(Types.TypeExpr.LE, MatcherInterface.val, MatcherInterface.var)));
    private MatcherInterface.Matcher x_notin_intvl = new MatcherInterface.Matcher(XNode.node(Types.TypeExpr.OR, XNode.node(Types.TypeExpr.LE, MatcherInterface.var, MatcherInterface.val), XNode.node(Types.TypeExpr.LE, MatcherInterface.val, MatcherInterface.var)));
    private MatcherInterface.Matcher x_relop_y = new MatcherInterface.Matcher(XNode.node(MatcherInterface.AbstractOperation.relop, MatcherInterface.var, MatcherInterface.var));
    private MatcherInterface.Matcher x_ariop_y__relop_k = new MatcherInterface.Matcher(XNode.node(MatcherInterface.AbstractOperation.relop, XNode.node(MatcherInterface.AbstractOperation.ariop, MatcherInterface.var, MatcherInterface.var), MatcherInterface.val));
    private MatcherInterface.Matcher k_relop__x_ariop_y = new MatcherInterface.Matcher(XNode.node(MatcherInterface.AbstractOperation.relop, MatcherInterface.val, XNode.node(MatcherInterface.AbstractOperation.ariop, MatcherInterface.var, MatcherInterface.var)));
    private MatcherInterface.Matcher x_relop__y_ariop_k = new MatcherInterface.Matcher(XNode.node(MatcherInterface.AbstractOperation.relop, MatcherInterface.var, XNode.node(MatcherInterface.AbstractOperation.ariop, MatcherInterface.var, MatcherInterface.val)));
    private MatcherInterface.Matcher y_ariop_k__relop_x = new MatcherInterface.Matcher(XNode.node(MatcherInterface.AbstractOperation.relop, XNode.node(MatcherInterface.AbstractOperation.ariop, MatcherInterface.var, MatcherInterface.val), MatcherInterface.var));
    private MatcherInterface.Matcher logic_y_relop_k__eq_x = new MatcherInterface.Matcher(XNode.node(Types.TypeExpr.EQ, XNode.node(MatcherInterface.AbstractOperation.relop, MatcherInterface.var, MatcherInterface.val), MatcherInterface.var));
    private MatcherInterface.Matcher logic_k_relop_y__eq_x = new MatcherInterface.Matcher(XNode.node(Types.TypeExpr.EQ, XNode.node(MatcherInterface.AbstractOperation.relop, MatcherInterface.val, MatcherInterface.var), MatcherInterface.var));
    private MatcherInterface.Matcher unalop_x__eq_y = new MatcherInterface.Matcher(XNode.node(Types.TypeExpr.EQ, XNode.node(MatcherInterface.AbstractOperation.unalop, MatcherInterface.var), MatcherInterface.var));
    private MatcherInterface.Matcher x_ariop_y__relop_z = new MatcherInterface.Matcher(XNode.node(MatcherInterface.AbstractOperation.relop, XNode.node(MatcherInterface.AbstractOperation.ariop, MatcherInterface.var, MatcherInterface.var), MatcherInterface.var));
    private MatcherInterface.Matcher z_relop__x_ariop_y = new MatcherInterface.Matcher(XNode.node(MatcherInterface.AbstractOperation.relop, MatcherInterface.var, XNode.node(MatcherInterface.AbstractOperation.ariop, MatcherInterface.var, MatcherInterface.var)));
    private MatcherInterface.Matcher logic_y_relop_z__eq_x = new MatcherInterface.Matcher(XNode.node(Types.TypeExpr.EQ, XNode.node(MatcherInterface.AbstractOperation.relop, MatcherInterface.var, MatcherInterface.var), MatcherInterface.var));
    private MatcherInterface.Matcher logic_X = new MatcherInterface.Matcher(MatcherInterface.logic_vars);
    private MatcherInterface.Matcher logic_X__eq_x = new MatcherInterface.Matcher(XNode.node(Types.TypeExpr.EQ, MatcherInterface.logic_vars, MatcherInterface.var));
    private MatcherInterface.Matcher logic_X__ne_x = new MatcherInterface.Matcher(XNode.node(Types.TypeExpr.NE, MatcherInterface.logic_vars, MatcherInterface.var));
    private MatcherInterface.Matcher min_relop = new MatcherInterface.Matcher(XNode.node(MatcherInterface.AbstractOperation.relop, MatcherInterface.min_vars, MatcherInterface.varOrVal));
    private MatcherInterface.Matcher max_relop = new MatcherInterface.Matcher(XNode.node(MatcherInterface.AbstractOperation.relop, MatcherInterface.max_vars, MatcherInterface.varOrVal));
    private MatcherInterface.Matcher add_vars__relop = new MatcherInterface.Matcher(XNode.node(MatcherInterface.AbstractOperation.relop, MatcherInterface.add_vars, MatcherInterface.varOrVal));
    private MatcherInterface.Matcher add_mul_vals__relop = new MatcherInterface.Matcher(XNode.node(MatcherInterface.AbstractOperation.relop, MatcherInterface.add_mul_vals, MatcherInterface.varOrVal));
    private MatcherInterface.Matcher add_mul_vars__relop = new MatcherInterface.Matcher(XNode.node(MatcherInterface.AbstractOperation.relop, MatcherInterface.add_mul_vars, MatcherInterface.varOrVal));
    private Map<MatcherInterface.Matcher, BiConsumer<String, XNodeParent<XVariables.XVarInteger>>> unaryRules = new LinkedHashMap<MatcherInterface.Matcher, BiConsumer<String, XNodeParent<XVariables.XVarInteger>>>();
    private Map<MatcherInterface.Matcher, BiConsumer<String, XNodeParent<XVariables.XVarInteger>>> binaryRules = new LinkedHashMap<MatcherInterface.Matcher, BiConsumer<String, XNodeParent<XVariables.XVarInteger>>>();
    private Map<MatcherInterface.Matcher, BiConsumer<String, XNodeParent<XVariables.XVarInteger>>> ternaryRules = new LinkedHashMap<MatcherInterface.Matcher, BiConsumer<String, XNodeParent<XVariables.XVarInteger>>>();
    private Map<MatcherInterface.Matcher, BiConsumer<String, XNodeParent<XVariables.XVarInteger>>> logicRules = new LinkedHashMap<MatcherInterface.Matcher, BiConsumer<String, XNodeParent<XVariables.XVarInteger>>>();
    private Map<MatcherInterface.Matcher, BiConsumer<String, XNodeParent<XVariables.XVarInteger>>> sumRules = new LinkedHashMap<MatcherInterface.Matcher, BiConsumer<String, XNodeParent<XVariables.XVarInteger>>>();
    private Map<MatcherInterface.Matcher, BiConsumer<String, XNodeParent<XVariables.XVarInteger>>> extremumRules = new LinkedHashMap<MatcherInterface.Matcher, BiConsumer<String, XNodeParent<XVariables.XVarInteger>>>();

    private Condition basicCondition(XNodeParent<XVariables.XVarInteger> r) {
        if (r.type.isRelationalOperator() && r.sons.length == 2 && r.sons[1].type.oneOf(Types.TypeExpr.VAR, Types.TypeExpr.LONG)) {
            return r.sons[1].type == Types.TypeExpr.VAR ? new Condition.ConditionVar(r.relop(0), (IVar)r.sons[1].var(0)) : new Condition.ConditionVal(r.relop(0), r.sons[1].val(0).intValue());
        }
        return null;
    }

    ConstraintRecognizer(XCallbacks xc) {
        this.xc = xc;
        this.unaryRules.put(this.x_relop_k, (id, r) -> xc.buildCtrPrimitive((String)id, (XVariables.XVarInteger)r.var(0), r.relop(0), r.val(0)));
        this.unaryRules.put(this.k_relop_x, (id, r) -> xc.buildCtrPrimitive((String)id, (XVariables.XVarInteger)r.var(0), r.relop(0).arithmeticInversion(), r.val(0)));
        this.unaryRules.put(this.x_ariop_k__relop_l, (id, r) -> xc.buildCtrPrimitive((String)id, (XVariables.XVarInteger)r.var(0), r.ariop(0), (int)r.val(0), r.relop(0), (int)r.val(1)));
        this.unaryRules.put(this.l_relop__x_ariop_k, (id, r) -> xc.buildCtrPrimitive((String)id, (XVariables.XVarInteger)r.var(0), r.ariop(0), (int)r.val(1), r.relop(0).arithmeticInversion(), (int)r.val(0)));
        this.unaryRules.put(this.x_setop_S, (id, r) -> xc.buildCtrPrimitive((String)id, (XVariables.XVarInteger)r.var(0), r.type.toSetop(), r.arrayOfVals()));
        this.unaryRules.put(this.x_in_intvl, (id, r) -> xc.buildCtrPrimitive((String)id, (XVariables.XVarInteger)r.var(0), Types.TypeConditionOperatorSet.IN, r.val(1), r.val(0)));
        this.unaryRules.put(this.x_notin_intvl, (id, r) -> xc.buildCtrPrimitive((String)id, (XVariables.XVarInteger)r.var(0), Types.TypeConditionOperatorSet.NOTIN, r.val(0) + 1, r.val(1) - 1));
        this.binaryRules.put(this.x_relop_y, (id, r) -> xc.buildCtrPrimitive((String)id, (XVariables.XVarInteger)r.var(0), Types.TypeArithmeticOperator.SUB, (XVariables.XVarInteger)r.var(1), r.relop(0), 0));
        this.binaryRules.put(this.x_ariop_y__relop_k, (id, r) -> xc.buildCtrPrimitive((String)id, (XVariables.XVarInteger)r.var(0), r.ariop(0), (XVariables.XVarInteger)r.var(1), r.relop(0), (int)r.val(0)));
        this.binaryRules.put(this.k_relop__x_ariop_y, (id, r) -> xc.buildCtrPrimitive((String)id, (XVariables.XVarInteger)r.var(0), r.ariop(0), (XVariables.XVarInteger)r.var(1), r.relop(0).arithmeticInversion(), (int)r.val(0)));
        this.binaryRules.put(this.x_relop__y_ariop_k, (id, r) -> xc.buildCtrPrimitive((String)id, (XVariables.XVarInteger)r.var(1), r.ariop(0), (int)r.val(0), r.relop(0).arithmeticInversion(), (XVariables.XVarInteger)r.var(0)));
        this.binaryRules.put(this.y_ariop_k__relop_x, (id, r) -> xc.buildCtrPrimitive((String)id, (XVariables.XVarInteger)r.var(0), r.ariop(0), (int)r.val(0), r.relop(0), (XVariables.XVarInteger)r.var(1)));
        this.binaryRules.put(this.logic_y_relop_k__eq_x, (id, r) -> xc.buildCtrLogic((String)id, (XVariables.XVarInteger)r.var(1), (XVariables.XVarInteger)r.var(0), r.relop(1), r.val(0)));
        this.binaryRules.put(this.logic_k_relop_y__eq_x, (id, r) -> xc.buildCtrLogic((String)id, (XVariables.XVarInteger)r.var(1), (XVariables.XVarInteger)r.var(0), r.relop(1).arithmeticInversion(), r.val(0)));
        this.binaryRules.put(this.unalop_x__eq_y, (id, r) -> xc.buildCtrPrimitive((String)id, (XVariables.XVarInteger)r.var(1), r.sons[0].type.toUnalop(), (XVariables.XVarInteger)r.var(0)));
        this.ternaryRules.put(this.x_ariop_y__relop_z, (id, r) -> xc.buildCtrPrimitive((String)id, (XVariables.XVarInteger)r.var(0), r.ariop(0), (XVariables.XVarInteger)r.var(1), r.relop(0), (XVariables.XVarInteger)r.var(2)));
        this.ternaryRules.put(this.z_relop__x_ariop_y, (id, r) -> xc.buildCtrPrimitive((String)id, (XVariables.XVarInteger)r.var(1), r.ariop(0), (XVariables.XVarInteger)r.var(2), r.relop(0).arithmeticInversion(), (XVariables.XVarInteger)r.var(0)));
        this.logicRules.put(this.logic_X, (id, r) -> xc.buildCtrLogic((String)id, r.type.toLogop(), (XVariables.XVarInteger[])r.arrayOfVars()));
        this.logicRules.put(this.logic_X__eq_x, (id, r) -> xc.buildCtrLogic((String)id, (XVariables.XVarInteger)r.sons[1].var(0), Types.TypeEqNeOperator.EQ, r.sons[0].type.toLogop(), (XVariables.XVarInteger[])r.sons[0].arrayOfVars()));
        this.logicRules.put(this.logic_X__ne_x, (id, r) -> xc.buildCtrLogic((String)id, (XVariables.XVarInteger)r.sons[1].var(0), Types.TypeEqNeOperator.NE, r.sons[0].type.toLogop(), (XVariables.XVarInteger[])r.sons[0].arrayOfVars()));
        this.logicRules.put(this.logic_y_relop_z__eq_x, (id, r) -> xc.buildCtrLogic((String)id, (XVariables.XVarInteger)r.var(2), (XVariables.XVarInteger)r.var(0), r.relop(1), (XVariables.XVarInteger)r.var(1)));
        this.sumRules.put(this.add_vars__relop, (id, r) -> xc.buildCtrSum((String)id, (XVariables.XVarInteger[])r.sons[0].arrayOfVars(), this.basicCondition((XNodeParent<XVariables.XVarInteger>)r)));
        this.sumRules.put(this.add_mul_vals__relop, (id, r) -> {
            int[] coeffs = Stream.of(r.sons[0].sons).mapToInt(s -> s.type == Types.TypeExpr.VAR ? 1 : s.val(0)).toArray();
            if (IntStream.of(coeffs).allMatch(v -> v == 1)) {
                xc.buildCtrSum((String)id, (XVariables.XVarInteger[])r.sons[0].arrayOfVars(), this.basicCondition((XNodeParent<XVariables.XVarInteger>)r));
            } else {
                xc.buildCtrSum((String)id, (XVariables.XVarInteger[])r.sons[0].arrayOfVars(), coeffs, this.basicCondition((XNodeParent<XVariables.XVarInteger>)r));
            }
        });
        this.sumRules.put(this.add_mul_vars__relop, (id, r) -> {
            XVariables.XVarInteger[] list = (XVariables.XVarInteger[])Stream.of(r.sons[0].sons).map(s -> (XVariables.XVarInteger)s.var(0)).toArray(XVariables.XVarInteger[]::new);
            XVariables.XVarInteger[] coeffs = (XVariables.XVarInteger[])Stream.of(r.sons[0].sons).map(s -> (XVariables.XVarInteger)s.var(1)).toArray(XVariables.XVarInteger[]::new);
            xc.buildCtrSum((String)id, list, coeffs, this.basicCondition((XNodeParent<XVariables.XVarInteger>)r));
        });
        this.extremumRules.put(this.min_relop, (id, r) -> xc.buildCtrMinimum((String)id, (XVariables.XVarInteger[])r.sons[0].vars(), this.basicCondition((XNodeParent<XVariables.XVarInteger>)r)));
        this.extremumRules.put(this.max_relop, (id, r) -> xc.buildCtrMaximum((String)id, (XVariables.XVarInteger[])r.sons[0].vars(), this.basicCondition((XNodeParent<XVariables.XVarInteger>)r)));
    }

    private void posted(String id) {
        Utilities.control(!this.xc.implem().postedRecognizedCtrs.contains(id), "Pb with the same constraint posted twice");
        this.xc.implem().postedRecognizedCtrs.add(id);
    }

    private boolean recognizeIntensionIn(String id, XNodeParent<XVariables.XVarInteger> tree, Map<MatcherInterface.Matcher, BiConsumer<String, XNodeParent<XVariables.XVarInteger>>> rules, boolean condition) {
        return condition && rules.entrySet().stream().anyMatch(rule -> {
            if (!((MatcherInterface.Matcher)rule.getKey()).matches(tree)) {
                return false;
            }
            this.posted(id);
            ((BiConsumer)rule.getValue()).accept(id, tree);
            return true;
        });
    }

    private boolean recognizeIntension(String id, XNodeParent<XVariables.XVarInteger> tree, int arity) {
        Map<XCallbacks.XCallbacksParameters, Object> map = this.xc.implem().currParameters;
        if (this.recognizeIntensionIn(id, tree, this.unaryRules, arity == 1 && map.containsKey((Object)XCallbacks.XCallbacksParameters.RECOGNIZE_UNARY_PRIMITIVES))) {
            return true;
        }
        if (this.recognizeIntensionIn(id, tree, this.binaryRules, arity == 2 && map.containsKey((Object)XCallbacks.XCallbacksParameters.RECOGNIZE_BINARY_PRIMITIVES))) {
            return true;
        }
        if (this.recognizeIntensionIn(id, tree, this.ternaryRules, arity == 3 && map.containsKey((Object)XCallbacks.XCallbacksParameters.RECOGNIZE_TERNARY_PRIMITIVES))) {
            return true;
        }
        if (this.recognizeIntensionIn(id, tree, this.logicRules, map.containsKey((Object)XCallbacks.XCallbacksParameters.RECOGNIZE_LOGIC_CASES))) {
            return true;
        }
        if (this.recognizeIntensionIn(id, tree, this.sumRules, map.containsKey((Object)XCallbacks.XCallbacksParameters.RECOGNIZE_SUM_CASES))) {
            return true;
        }
        return this.recognizeIntensionIn(id, tree, this.extremumRules, map.containsKey((Object)XCallbacks.XCallbacksParameters.RECOGNIZE_EXTREMUM_CASES));
    }

    public boolean specificIntensionCases(String id, XNodeParent<XVariables.XVarInteger> tree, int arity) {
        this.recognizeIntension(id, tree, arity);
        return this.xc.implem().postedRecognizedCtrs.contains(id);
    }

    private Runnable recognizeCount(String id, XVariables.XVarInteger[] list, Long[] values, Types.TypeConditionOperatorRel op, Condition condition) {
        if (this.xc.implem().currParameters.containsKey((Object)XCallbacks.XCallbacksParameters.RECOGNIZE_COUNT_CASES)) {
            if (values.length == 1) {
                int value = CtrLoaderInteger.trInteger(values[0]);
                if (condition instanceof Condition.ConditionVal) {
                    int k = CtrLoaderInteger.trInteger(((Condition.ConditionVal)condition).k);
                    if (op == Types.TypeConditionOperatorRel.LT) {
                        return () -> this.xc.buildCtrAtMost(id, list, value, k - 1);
                    }
                    if (op == Types.TypeConditionOperatorRel.LE) {
                        return () -> this.xc.buildCtrAtMost(id, list, value, k);
                    }
                    if (op == Types.TypeConditionOperatorRel.GE) {
                        return () -> this.xc.buildCtrAtLeast(id, list, value, k);
                    }
                    if (op == Types.TypeConditionOperatorRel.GT) {
                        return () -> this.xc.buildCtrAtLeast(id, list, value, k + 1);
                    }
                    if (op == Types.TypeConditionOperatorRel.EQ) {
                        return () -> this.xc.buildCtrExactly(id, list, value, k);
                    }
                } else if (condition instanceof Condition.ConditionVar && op == Types.TypeConditionOperatorRel.EQ) {
                    return () -> this.xc.buildCtrExactly(id, list, value, (XVariables.XVarInteger)((Condition.ConditionVar)condition).x);
                }
            } else if (op == Types.TypeConditionOperatorRel.EQ) {
                if (condition instanceof Condition.ConditionVal) {
                    return () -> this.xc.buildCtrAmong(id, list, CtrLoaderInteger.trIntegers(values), CtrLoaderInteger.trInteger(((Condition.ConditionVal)condition).k));
                }
                if (condition instanceof Condition.ConditionVar) {
                    return () -> this.xc.buildCtrAmong(id, list, CtrLoaderInteger.trIntegers(values), (XVariables.XVarInteger)((Condition.ConditionVar)condition).x);
                }
            }
        }
        return null;
    }

    public boolean specificCountCases(String id, XVariables.XVarInteger[] list, Long[] values, Types.TypeConditionOperatorRel op, Condition condition) {
        Runnable recognized = this.recognizeCount(id, list, values, op, condition);
        if (recognized == null) {
            return false;
        }
        recognized.run();
        this.posted(id);
        return true;
    }

    private Runnable recognizeNvalues(String id, XVariables.XVarInteger[] list, Condition condition) {
        if (this.xc.implem().currParameters.containsKey((Object)XCallbacks.XCallbacksParameters.RECOGNIZE_NVALUES_CASES) && condition instanceof Condition.ConditionVal) {
            Types.TypeConditionOperatorRel op = ((Condition.ConditionVal)condition).operator;
            int k = CtrLoaderInteger.trInteger(((Condition.ConditionVal)condition).k);
            if (op == Types.TypeConditionOperatorRel.EQ && k == list.length) {
                return () -> this.xc.buildCtrAllDifferent(id, list);
            }
            if (op == Types.TypeConditionOperatorRel.EQ && k == 1) {
                return () -> this.xc.buildCtrAllEqual(id, list);
            }
            if (op == Types.TypeConditionOperatorRel.GE && k == 2 || op == Types.TypeConditionOperatorRel.GT && k == 1) {
                return () -> this.xc.buildCtrNotAllEqual(id, list);
            }
        }
        return null;
    }

    public boolean specificNvaluesCases(String id, XVariables.XVarInteger[] list, Condition condition) {
        Runnable recognized = this.recognizeNvalues(id, list, condition);
        if (recognized == null) {
            return false;
        }
        recognized.run();
        this.posted(id);
        return true;
    }
}

