/*
 * Decompiled with CFR 0.152.
 */
package org.xcsp.parser.entries;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.IntStream;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.xcsp.common.Types;
import org.xcsp.common.Utilities;
import org.xcsp.parser.entries.XConstraints;
import org.xcsp.parser.entries.XVariables;

public abstract class ParsingEntry {
    public String id;
    public Types.TypeClass[] classes;
    public String note;
    public final Map<Types.TypeAtt, String> attributes = new HashMap<Types.TypeAtt, String>();
    public final Set<Types.TypeFlag> flags = new HashSet<Types.TypeFlag>();

    public final boolean getAttributeValue(Types.TypeAtt att, boolean defaultValue) {
        return this.attributes.get((Object)att) == null ? defaultValue : this.attributes.get((Object)att).toLowerCase().equals("true");
    }

    public final int getAttributeValue(Types.TypeAtt att, int defaultValue) {
        return this.attributes.get((Object)att) == null ? defaultValue : Utilities.safeInt(Utilities.safeLong(this.attributes.get((Object)att)));
    }

    public final <T extends Enum<T>> T getAttributeValue(Types.TypeAtt att, Class<T> clazz, T defaultValue) {
        return this.attributes.get((Object)att) == null ? defaultValue : Types.valueOf(clazz, this.attributes.get((Object)att));
    }

    public void copyAttributesOf(Element elt) {
        NamedNodeMap al = elt.getAttributes();
        IntStream.range(0, al.getLength()).forEach(i -> {
            String string = this.attributes.put(Types.TypeAtt.valOf(al.item(i).getNodeName()), al.item(i).getNodeValue());
        });
        if (this.id == null && this.attributes.containsKey((Object)Types.TypeAtt.id)) {
            this.id = this.attributes.get((Object)Types.TypeAtt.id);
        }
        if (this.attributes.containsKey((Object)Types.TypeAtt.CLASS)) {
            this.classes = Types.TypeClass.classesFor(this.attributes.get((Object)Types.TypeAtt.CLASS).split("\\s+"));
        }
        if (this.attributes.containsKey((Object)Types.TypeAtt.note)) {
            this.note = this.attributes.get((Object)Types.TypeAtt.note);
        }
    }

    protected ParsingEntry() {
    }

    protected ParsingEntry(String id) {
        this.id = id;
        Utilities.control(id.matches("[a-zA-Z][_a-zA-Z0-9\\[\\]]*"), "Badly formed id : " + id + ". This does not match [a-zA-Z][_a-zA-Z0-9\\\\[\\\\]]* \n");
    }

    public static abstract class CEntry
    extends ParsingEntry {
        private XVariables.XVar[] vars;

        public XVariables.XVar[] vars() {
            XVariables.XVar[] xVarArray;
            if (this instanceof XConstraints.XCtr && ((XConstraints.XCtr)this).abstraction != null) {
                return this.collectVars(new LinkedHashSet<XVariables.XVar>()).toArray(new XVariables.XVar[0]);
            }
            if (this.vars != null) {
                xVarArray = this.vars;
            } else {
                this.vars = this.collectVars(new LinkedHashSet<XVariables.XVar>()).toArray(new XVariables.XVar[0]);
                xVarArray = this.vars;
            }
            return xVarArray;
        }

        public abstract LinkedHashSet<XVariables.XVar> collectVars(LinkedHashSet<XVariables.XVar> var1);

        public abstract boolean subjectToAbstraction();

        public String toString() {
            return "(" + (this.attributes == null ? "" : Utilities.join(this.attributes, ":", " ")) + ")";
        }
    }

    public static abstract class OEntry
    extends ParsingEntry {
        public final boolean minimize;
        public final Types.TypeObjective type;

        public abstract XVariables.XVar[] vars();

        public final Types.TypeObjective getType() {
            return this.type;
        }

        public OEntry(boolean minimize, Types.TypeObjective type) {
            this.minimize = minimize;
            this.type = type;
        }

        public String toString() {
            return String.valueOf(this.id) + " " + (this.minimize ? "minimize" : "maximize") + " " + (Object)((Object)this.type);
        }
    }

    public static abstract class VEntry
    extends ParsingEntry {
        public final Types.TypeVar type;

        public final Types.TypeVar getType() {
            return this.type;
        }

        protected VEntry(String id, Types.TypeVar type) {
            super(id);
            this.type = type;
        }

        public String toString() {
            return String.valueOf(this.id) + ":" + (Object)((Object)this.type);
        }
    }
}

