/*
 * Decompiled with CFR 0.152.
 */
package org.xcsp.modeler.implementation;

import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.PrintWriter;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonReader;
import javax.json.JsonString;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import javax.json.JsonWriter;
import org.xcsp.common.Utilities;
import org.xcsp.modeler.api.ProblemAPI;
import org.xcsp.modeler.implementation.ProblemIMP;

public final class ProblemDataHandler {
    private Object handleField(Field field, JsonObject jsonObject, ProblemAPI api) {
        if (ProblemIMP.mustBeIgnored(field)) {
            return null;
        }
        field.setAccessible(true);
        String key = field.getName();
        try {
            if (jsonObject.isNull(key)) {
                return null;
            }
        }
        catch (NullPointerException e) {
            ProblemIMP.control(false, "The field " + key + " has not been found");
        }
        return this.load((JsonValue)jsonObject.get(key), field.getType(), field.getGenericType(), api);
    }

    private Object load(JsonValue json, Class<?> type, Type genericType, ProblemAPI api) {
        block24: {
            if (json instanceof JsonString && ((JsonString)json).getString().equals("null") && type != String.class) {
                return null;
            }
            if (type == Boolean.TYPE || type == Boolean.class) {
                if (json == JsonValue.TRUE) {
                    return true;
                }
                return false;
            }
            if (type == Integer.TYPE || type == Integer.class || type == Byte.TYPE || type == Byte.class || type == Short.TYPE || type == Short.class) {
                return ((JsonNumber)json).intValue();
            }
            if (type == Long.TYPE || type == Long.class) {
                return ((JsonNumber)json).longValue();
            }
            if (type == Double.TYPE || type == Double.class || type == Float.TYPE || type == Float.class) {
                return ((JsonNumber)json).doubleValue();
            }
            if (type == String.class) {
                return ((JsonString)json).getString();
            }
            if (json.toString().equals("\"null\"") || json.toString().equals("null")) {
                return null;
            }
            if (type.isArray()) {
                JsonArray jsonArray = (JsonArray)json;
                List list = jsonArray.stream().map(v -> this.load((JsonValue)v, type.getComponentType(), null, api)).collect(Collectors.toList());
                Object array = Array.newInstance(type.getComponentType(), jsonArray.size());
                IntStream.range(0, jsonArray.size()).forEach(i -> Array.set(array, i, list.get(i)));
                return array;
            }
            if (type == List.class) {
                Class c2 = (Class)((ParameterizedType)genericType).getActualTypeArguments()[0];
                return ((JsonArray)json).stream().map(v -> this.load((JsonValue)v, c2, null, api)).collect(Collectors.toList());
            }
            if (type == Map.class) {
                Class c1 = (Class)((ParameterizedType)genericType).getActualTypeArguments()[0];
                Class c2 = (Class)((ParameterizedType)genericType).getActualTypeArguments()[1];
                Utilities.control(c1 == Integer.class || c1 == String.class, "Managing other types of keys ?");
                return ((JsonObject)json).entrySet().stream().collect(Collectors.toMap(e -> Integer.parseInt((String)e.getKey()), e -> this.load((JsonValue)e.getValue(), c2, null, api)));
            }
            if (type.isEnum()) {
                Utilities.control(Stream.of(type.getEnumConstants()).anyMatch(c -> json.toString().equals("\"" + c.toString() + "\"")), "");
                return Stream.of(type.getEnumConstants()).filter(c -> json.toString().equals("\"" + c.toString() + "\"")).findFirst().get();
            }
            if (!(json instanceof JsonString)) break block24;
            Utilities.control(json.toString().equals("\"null\""), "Pb with a JSON element");
            return null;
        }
        try {
            boolean defaultConstructor;
            JsonObject jsonObject = (JsonObject)json;
            if (type == api.getClass()) {
                Field[] fieldArray = type.getDeclaredFields();
                int n = fieldArray.length;
                int array = 0;
                while (array < n) {
                    Field field = fieldArray[array];
                    Object value = this.handleField(field, jsonObject, api);
                    if (value != null) {
                        field.set(api, value);
                    }
                    ++array;
                }
                return api;
            }
            Utilities.control(type.getDeclaredConstructors().length == 1, "Only one constructor is allowed");
            Constructor<?> c3 = type.getDeclaredConstructors()[0];
            c3.setAccessible(true);
            boolean additionnalArgument = !Modifier.isStatic(type.getModifiers()) && type.getEnclosingClass() != null;
            boolean bl = defaultConstructor = c3.getParameterTypes().length == (additionnalArgument ? 1 : 0);
            if (defaultConstructor) {
                Object obj = additionnalArgument ? c3.newInstance(api) : c3.newInstance(new Object[0]);
                Field[] fieldArray = type.getDeclaredFields();
                int n = fieldArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Field field = fieldArray[n2];
                    Object value = this.handleField(field, jsonObject, api);
                    if (value != null) {
                        field.set(obj, value);
                    }
                    ++n2;
                }
                return obj;
            }
            ArrayList<Object> list = new ArrayList<Object>();
            if (additionnalArgument) {
                list.add(api);
            }
            Field[] fieldArray = type.getDeclaredFields();
            int n = fieldArray.length;
            int n3 = 0;
            while (n3 < n) {
                Field field = fieldArray[n3];
                Object value = this.handleField(field, jsonObject, api);
                if (value != null) {
                    list.add(value);
                }
                ++n3;
            }
            return c3.newInstance(list.toArray());
        }
        catch (Exception e2) {
            e2.printStackTrace();
            Utilities.exit("Pb when loading ");
            return null;
        }
    }

    public void load(ProblemAPI api, String fileName) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (JsonReader jsonReader = Json.createReader(new BufferedReader(new FileReader(fileName)));){
                this.load(jsonReader.readObject(), api.getClass(), null, api);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Utilities.exit("Pb when loading " + e);
        }
    }

    private JsonStructure save(Object object) throws Exception {
        if (object.getClass().isArray() || object instanceof List) {
            JsonArrayBuilder builder = Json.createArrayBuilder();
            for (Object item : object instanceof List ? (List)object : IntStream.range(0, Array.getLength(object)).mapToObj(i -> Array.get(object, i)).collect(Collectors.toList())) {
                if (item == null) {
                    builder.addNull();
                    continue;
                }
                if (item.getClass() == Boolean.class) {
                    builder.add((Boolean)item);
                    continue;
                }
                if (item.getClass() == Integer.class || item.getClass() == Byte.class || item.getClass() == Short.class) {
                    builder.add(((Number)item).intValue());
                    continue;
                }
                if (item.getClass() == Long.class) {
                    builder.add((Long)item);
                    continue;
                }
                if (item.getClass() == Double.class || item.getClass() == Float.class) {
                    builder.add(((Number)item).doubleValue());
                    continue;
                }
                if (item.getClass() == String.class) {
                    builder.add((String)item);
                    continue;
                }
                builder.add(this.save(item));
            }
            return builder.build();
        }
        JsonObjectBuilder builder = Json.createObjectBuilder();
        Map map = null;
        if (object instanceof Map) {
            map = (Map)object;
        } else if (object instanceof ProblemAPI) {
            List<Field> list = ProblemIMP.problemDataFields(new ArrayList<Field>(), object.getClass());
            map = list.stream().collect(Collectors.toMap(Field::getName, f -> {
                try {
                    f.setAccessible(true);
                    return f.get(object) == null ? "null" : f.get(object);
                }
                catch (Exception e) {
                    return "null";
                }
            }, (v1, v2) -> v1, LinkedHashMap::new));
        } else {
            map = Stream.of(object.getClass().getDeclaredFields()).filter(f -> !ProblemIMP.mustBeIgnored(f)).peek(f -> f.setAccessible(true)).collect(Collectors.toMap(Field::getName, f -> {
                try {
                    f.setAccessible(true);
                    return f.get(object) == null ? "null" : f.get(object);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }, (v1, v2) -> v1, LinkedHashMap::new));
        }
        for (Object k : map.keySet()) {
            map.replace(k, "null", null);
        }
        for (Map.Entry entry : map.entrySet()) {
            String key = entry.getKey().toString();
            Object value = entry.getValue();
            if (value == null) {
                builder.addNull(key);
                continue;
            }
            if (value.getClass().isArray()) {
                builder.add(key, this.save(value));
                continue;
            }
            if (value.getClass() == Boolean.class) {
                builder.add(key, (Boolean)value);
                continue;
            }
            if (value.getClass() == Integer.class || value.getClass() == Byte.class || value.getClass() == Short.class) {
                builder.add(key, ((Number)value).intValue());
                continue;
            }
            if (value.getClass() == Long.class) {
                builder.add(key, (Long)value);
                continue;
            }
            if (value.getClass() == Double.class || value.getClass() == Float.class) {
                builder.add(key, ((Number)value).doubleValue());
                continue;
            }
            if (value.getClass() == String.class) {
                builder.add(key, (String)value);
                continue;
            }
            if (value instanceof Enum) {
                builder.add(key, value.toString());
                continue;
            }
            builder.add(key, this.save(value));
        }
        return builder.build();
    }

    public void save(ProblemAPI api, String fileName) {
        fileName = String.valueOf(fileName) + ".json";
        System.out.print("\n  Saving Data File " + fileName + " ... ");
        HashMap properties = new HashMap(1);
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (JsonWriter jsonWriter = Json.createWriterFactory(properties).createWriter(new PrintWriter(new FileOutputStream(fileName)));){
                JsonStructure js = this.save(api);
                jsonWriter.write(js);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            e.getCause().getStackTrace();
        }
        System.out.println("Finished.");
    }
}

