/*
 * Decompiled with CFR 0.152.
 */
package org.xcsp.modeler.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.xcsp.common.FunctionalInterfaces;
import org.xcsp.common.IVar;
import org.xcsp.common.Range;
import org.xcsp.common.Utilities;
import org.xcsp.modeler.api.ProblemAPIBase;

public interface ProblemAPIOnVars
extends ProblemAPIBase {
    default public <T extends IVar> T[] vars(Object first, Object ... others) {
        return this.imp().vars(new Object[]{IntStream.range(0, others.length + 1).mapToObj(i -> i == 0 ? first : others[i - 1])});
    }

    default public <T extends IVar> T[] vars(T x, T ... others) {
        return this.vars(x, (IVar[])others);
    }

    default public <T extends IVar> T[] vars(T[][] vars) {
        return this.vars(vars, new Object[0]);
    }

    default public <T extends IVar> T[] vars(T[][][] vars) {
        return this.vars(vars, new Object[0]);
    }

    default public <T extends IVar> T[] vars(Object first, T x) {
        return this.vars(first, new Object[]{x});
    }

    default public <T extends IVar> T[] vars(Object first, T[] x) {
        return this.vars(first, new Object[]{x});
    }

    default public <T extends IVar> T[] vars(Object first, T[][] x) {
        return this.vars(first, new Object[]{x});
    }

    default public <T extends IVar> T[] vars(Stream<T> stream) {
        return this.vars(stream, new Object[0]);
    }

    default public <T extends IVar> T[] clean(T[] vars) {
        return this.imp().clean((IVar[])vars);
    }

    default public <T extends IVar> T[] variablesIn(Object object, Object ... otherObjects) {
        return this.vars(object, otherObjects);
    }

    default public <T extends IVar, U> T[] variablesFrom(Stream<U> stream, Function<U, Object> f) {
        return this.variablesIn(stream.filter(o -> o != null).map(o -> f.apply(o)), new Object[0]);
    }

    default public <T extends IVar, U> T[] variablesFrom(IntStream stream, Function<Integer, Object> f) {
        return this.variablesFrom(stream.boxed(), f);
    }

    default public <T extends IVar, U> T[] variablesFrom(U[] t, Function<U, Object> f) {
        return this.variablesFrom(Stream.of(t), f);
    }

    default public <T extends IVar, U> T[] variablesFrom(Collection<U> c, Function<U, Object> f) {
        return this.variablesFrom(c.stream(), f);
    }

    default public <T extends IVar> T[] variablesFrom(int[] t, Function<Integer, Object> f) {
        return this.variablesFrom(IntStream.of(t).boxed(), f);
    }

    default public <T extends IVar> T[] variablesFrom(Range r, Function<Integer, Object> f) {
        return this.variablesFrom(r.stream(), f);
    }

    default public <T extends IVar> T[] singleVariablesIn(Object ... objects) {
        return this.vars(Stream.of(this.variablesIn(objects, new Object[0])).sorted().distinct(), new Object[0]);
    }

    default public <T extends IVar, U> T[] singleVariablesFrom(Stream<U> stream, Function<U, Object> f) {
        return this.singleVariablesIn(new Object[]{stream.filter(o -> o != null).map(o -> f.apply(o))});
    }

    default public <T extends IVar, U> T[] singleVariablesFrom(Collection<U> c, Function<U, Object> f) {
        return this.singleVariablesFrom(c.stream(), f);
    }

    default public <T> T[] select(T[] vars, int[] indexes) {
        this.control(Utilities.firstNonNull(vars) != null, "The specified array must contain at least one non-null object.");
        this.control(IntStream.of(indexes).allMatch(i -> i >= 0 && i < vars.length), "The indexes in the specified array are not correct.");
        T[] t = Utilities.convert(Arrays.stream(indexes).mapToObj(i -> vars[i]).filter(x -> x != null).collect(Collectors.toList()));
        return t != null ? t : Utilities.buildArray(Utilities.firstNonNull(vars).getClass(), 0);
    }

    default public <T> T[] select(T[] vars, int fromIndex, int toIndex) {
        this.control(fromIndex >= 0 && fromIndex < toIndex && toIndex <= vars.length, "The specified indexes are not correct.");
        return this.select(vars, IntStream.range(fromIndex, toIndex).toArray());
    }

    default public <T> T[] select(T[] vars, Collection<Integer> indexes) {
        return this.select(vars, indexes.stream().mapToInt(i -> i).toArray());
    }

    default public <T> T[] select(T[] vars, FunctionalInterfaces.Intx1Predicate p) {
        this.control(Utilities.firstNonNull(vars) != null, "The specified array must contain at least one non-null object.");
        T[] t = Utilities.convert(FunctionalInterfaces.Intx1Predicate.select(vars, p, new ArrayList()));
        return t != null ? t : Utilities.buildArray(Utilities.firstNonNull(vars).getClass(), 0);
    }

    default public <T> T[] select(T[][] vars, FunctionalInterfaces.Intx2Predicate p) {
        this.control(Utilities.firstNonNull(vars) != null, "The specified array must contain at least one non-null object.");
        T[] t = Utilities.convert(FunctionalInterfaces.Intx2Predicate.select(vars, p, new ArrayList()));
        return t != null ? t : Utilities.buildArray(Utilities.firstNonNull(vars).getClass(), 0);
    }

    default public <T> T[] select(T[][][] vars, FunctionalInterfaces.Intx3Predicate p) {
        this.control(Utilities.firstNonNull(vars) != null, "The specified array must contain at least one non-null object.");
        T[] t = Utilities.convert(FunctionalInterfaces.Intx3Predicate.select(vars, p, new ArrayList()));
        return t != null ? t : Utilities.buildArray(Utilities.firstNonNull(vars).getClass(), 0);
    }

    default public <T> T[] select(T[][][][] vars, FunctionalInterfaces.Intx4Predicate p) {
        this.control(Utilities.firstNonNull(vars) != null, "The specified array must contain at least one non-null object.");
        T[] t = Utilities.convert(FunctionalInterfaces.Intx4Predicate.select(vars, p, new ArrayList()));
        return t != null ? t : Utilities.buildArray(Utilities.firstNonNull(vars).getClass(), 0);
    }

    default public <T> T[] select(T[][][][][] vars, FunctionalInterfaces.Intx5Predicate p) {
        this.control(Utilities.firstNonNull(vars) != null, "The specified array must contain at least one non-null object.");
        T[] t = Utilities.convert(FunctionalInterfaces.Intx5Predicate.select(vars, p, new ArrayList()));
        return t != null ? t : Utilities.buildArray(Utilities.firstNonNull(vars).getClass(), 0);
    }

    default public <T> T[] select(T[] vars, Range range) {
        return this.select(vars, (int i) -> range.contains(i));
    }

    default public <T> T[] select(T[][] vars, Range.Rangesx2 rangesx2) {
        return this.select(vars, (int i, int j) -> rangesx2.contains(i, j));
    }

    default public <T> T[] select(T[][][] vars, Range.Rangesx3 rangesx3) {
        return this.select(vars, (int i, int j, int k) -> rangesx3.contains(i, j, k));
    }

    default public <T> T[] select(T[][][][] vars, Range.Rangesx4 rangesx4) {
        return this.select(vars, (int i, int j, int k, int l) -> rangesx4.contains(i, j));
    }

    default public <T> T[] select(T[][][][][] vars, Range.Rangesx5 rangesx5) {
        return this.select(vars, (int i, int j, int k, int l, int m) -> rangesx5.contains(i, j, k, l, m));
    }

    default public <T> T[] columnOf(T[][] vars, int idColumn) {
        this.control(Utilities.firstNonNull(vars) != null, "The specified array must contain at least one non-null object.");
        this.control(idColumn >= 0 && Stream.of(vars).allMatch(t -> t != null && idColumn < ((Object[])t).length), "The specified index is not valid.");
        T[] t2 = Utilities.convert(Stream.of(vars).map(p -> p[idColumn]).collect(Collectors.toList()));
        return t2 != null ? t2 : Utilities.buildArray(Utilities.firstNonNull(vars).getClass(), vars.length);
    }

    default public <T> T[] diagonalDown(T[][] vars, int idDiagonal) {
        this.control(Utilities.isRegular(vars), "The specified array must have the same number of rows and columns");
        this.control(idDiagonal >= 0 && idDiagonal < vars.length, "The specified index is not valid.");
        T[] t = Utilities.convert(IntStream.range(0, vars.length).mapToObj(i -> vars[i][i < idDiagonal ? vars.length - (idDiagonal - i) : i - idDiagonal]).collect(Collectors.toList()));
        return t != null ? t : Utilities.buildArray(Utilities.firstNonNull(vars).getClass(), vars.length);
    }

    default public <T> T[] diagonalUp(T[][] vars, int idDiagonal) {
        this.control(Utilities.isRegular(vars), "The specified array must have the same number of rows and columns");
        this.control(idDiagonal >= 0 && idDiagonal < vars.length, "The specified index is not valid.");
        T[] t = Utilities.convert(IntStream.range(0, vars.length).map(i -> vars.length - 1 - i).mapToObj(i -> vars[i][i < vars.length - idDiagonal ? vars.length - idDiagonal - i - 1 : 2 * vars.length - idDiagonal - i - 1]).collect(Collectors.toList()));
        return t != null ? t : Utilities.buildArray(Utilities.firstNonNull(vars).getClass(), vars.length);
    }

    default public <T> T[] diagonalDown(T[][] vars) {
        return this.diagonalDown(vars, 0);
    }

    default public <T> T[] diagonalUp(T[][] vars) {
        return this.diagonalUp(vars, 0);
    }

    default public <T> T[] diagonalDown(T[][] vars, int i, int j) {
        this.control(Utilities.isRegular(vars) && vars.length == vars[0].length, "Not a regular matrix (square)");
        this.control(i == 0 && j >= 0 && j < vars.length - 1 || j == 0 && i >= 0 && i < vars.length - 1, "Bad values for specified integers " + i + " and " + j);
        return Utilities.convert(IntStream.range(0, vars.length - Math.max(i, j)).mapToObj(k -> vars[i + k][j + k]).collect(Collectors.toList()));
    }

    default public <T> T[][] diagonalsDown(T[][] vars) {
        this.control(Utilities.isRegular(vars) && vars.length == vars[0].length, "Not a regular matrix (square)");
        ArrayList<T[]> list = new ArrayList<T[]>();
        int i = vars.length - 2;
        while (i >= 0) {
            list.add(this.diagonalDown(vars, i, 0));
            --i;
        }
        int j = 1;
        while (j < vars.length - 1) {
            list.add(this.diagonalDown(vars, 0, j));
            ++j;
        }
        return (Object[][])Utilities.convert(list);
    }

    default public <T> T[] diagonalUp(T[][] vars, int i, int j) {
        this.control(Utilities.isRegular(vars) && vars.length == vars[0].length, "Not a regular matrix (square)");
        this.control(j == 0 && i > 0 && i < vars.length || i == vars.length - 1 && j >= 0 && j < vars.length - 1, "Bad values for specified integers " + i + " and " + j);
        return Utilities.convert(IntStream.range(0, Math.min(i + 1, vars.length - j)).mapToObj(k -> vars[i - k][j + k]).collect(Collectors.toList()));
    }

    default public <T> T[][] diagonalsUp(T[][] vars) {
        this.control(Utilities.isRegular(vars) && vars.length == vars[0].length, "Not a regular matrix (square)");
        ArrayList<T[]> list = new ArrayList<T[]>();
        int i = 1;
        while (i < vars.length) {
            list.add(this.diagonalUp(vars, i, 0));
            ++i;
        }
        int j = 1;
        while (j < vars.length - 1) {
            list.add(this.diagonalUp(vars, vars.length - 1, j));
            ++j;
        }
        return (Object[][])Utilities.convert(list);
    }

    default public <T> T[][] transpose(T[] ... vars) {
        this.control(Utilities.isRegular(vars), "The specified array must have the same number of rows and columns");
        this.control(Utilities.firstNonNull(vars) != null, "The specified array must contain at least one non-null object.");
        Object[][] t = Utilities.buildArray(Utilities.firstNonNull(vars).getClass(), vars[0].length, vars.length);
        IntStream.range(0, t.length).forEach(i -> IntStream.range(0, t[0].length).forEach(j -> {
            Object object = objectArray[n][j] = vars[j][i];
        }));
        return t;
    }

    default public <T> T[][] eliminateDim2(T[][][] vars, int idx) {
        this.control(Utilities.isRegular(vars), "The specified array must be regular");
        this.control(Utilities.firstNonNull(vars) != null, "The specified array must contain at least one non-null object.");
        Object[][] m = Utilities.buildArray(vars[0][0][0].getClass(), vars.length, vars[0][0].length);
        IntStream.range(0, m.length).forEach(i -> IntStream.range(0, m[0].length).forEach(j -> {
            Object object = objectArray[n][j] = vars[i][idx][j];
        }));
        return m;
    }

    default public <T> T[][] eliminateDim3(T[][][] vars, int idx) {
        this.control(Utilities.isRegular(vars), "The specified array must be regular");
        this.control(Utilities.firstNonNull(vars) != null, "The specified array must contain at least one non-null object.");
        Object[][] m = Utilities.buildArray(vars[0][0][0].getClass(), vars.length, vars[0].length);
        IntStream.range(0, m.length).forEach(i -> IntStream.range(0, m[0].length).forEach(j -> {
            Object object = objectArray[n][j] = vars[i][j][idx];
        }));
        return m;
    }

    default public <T> T[] addObject(T[] t, T object, int index) {
        this.control(t != null && object != null, "The two first parameters must be different from null");
        this.control(index >= 0 && index <= t.length, "The specified index is not valid");
        T[] tt = Utilities.buildArray(object.getClass(), t.length + 1);
        int i = 0;
        while (i < tt.length) {
            tt[i] = i < index ? t[i] : (i == index ? object : t[i - 1]);
            ++i;
        }
        return tt;
    }

    default public <T> T[] addObject(T[] t, T object) {
        this.control(t != null && object != null, "The two first parameters must be different from null");
        return this.addObject(t, object, t.length);
    }

    default public boolean contains(Object[] t, Object object) {
        this.control(t != null && object != null, "The two first parameters must be different from null");
        return Stream.of(t).anyMatch(o -> o == object);
    }

    default public <T> T firstFrom(T[] t, Predicate<T> p) {
        return t == null ? null : Stream.of(t).filter(v -> p.test(v)).findFirst().orElse(null);
    }
}

