/*
 * Decompiled with CFR 0.152.
 */
package org.xcsp.modeler.api;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.IntConsumer;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.xcsp.common.Condition;
import org.xcsp.common.FunctionalInterfaces;
import org.xcsp.common.IVar;
import org.xcsp.common.Range;
import org.xcsp.common.Types;
import org.xcsp.common.Utilities;
import org.xcsp.common.structures.Automaton;
import org.xcsp.common.structures.Table;
import org.xcsp.common.structures.Transition;
import org.xcsp.common.structures.Transitions;
import org.xcsp.modeler.api.ProblemAPI;
import org.xcsp.modeler.entities.CtrEntities;
import org.xcsp.modeler.implementation.ProblemIMP;

public interface ProblemAPIBase {
    public static final Types.TypeConditionOperatorRel LT = Types.TypeConditionOperatorRel.LT;
    public static final Types.TypeConditionOperatorRel LE = Types.TypeConditionOperatorRel.LE;
    public static final Types.TypeConditionOperatorRel GE = Types.TypeConditionOperatorRel.GE;
    public static final Types.TypeConditionOperatorRel GT = Types.TypeConditionOperatorRel.GT;
    public static final Types.TypeConditionOperatorRel NE = Types.TypeConditionOperatorRel.NE;
    public static final Types.TypeConditionOperatorRel EQ = Types.TypeConditionOperatorRel.EQ;
    public static final Types.TypeConditionOperatorSet IN = Types.TypeConditionOperatorSet.IN;
    public static final Types.TypeConditionOperatorSet NOTIN = Types.TypeConditionOperatorSet.NOTIN;
    public static final Types.TypeOperatorRel STRICTLY_INCREASING = Types.TypeOperatorRel.LT;
    public static final Types.TypeOperatorRel INCREASING = Types.TypeOperatorRel.LE;
    public static final Types.TypeOperatorRel DECREASING = Types.TypeOperatorRel.GE;
    public static final Types.TypeOperatorRel STRICTLY_DECREASING = Types.TypeOperatorRel.GT;
    public static final Types.TypeObjective EXPRESSION = Types.TypeObjective.EXPRESSION;
    public static final Types.TypeObjective SUM = Types.TypeObjective.SUM;
    public static final Types.TypeObjective PRODUCT = Types.TypeObjective.PRODUCT;
    public static final Types.TypeObjective MINIMUM = Types.TypeObjective.MINIMUM;
    public static final Types.TypeObjective MAXIMUM = Types.TypeObjective.MAXIMUM;
    public static final Types.TypeObjective NVALUES = Types.TypeObjective.NVALUES;
    public static final Types.TypeObjective LEX = Types.TypeObjective.LEX;
    public static final Types.TypeClass CHANNELING = Types.StandardClass.CHANNELING;
    public static final Types.TypeClass CLUES = Types.StandardClass.CLUES;
    public static final Types.TypeClass ROWS = Types.StandardClass.ROWS;
    public static final Types.TypeClass COLUMNS = Types.StandardClass.COLUMNS;
    public static final Types.TypeClass BLOCKS = Types.StandardClass.BLOCKS;
    public static final Types.TypeClass DIAGONALS = Types.StandardClass.DIAGONALS;
    public static final Types.TypeClass SYMMETRY_BREAKING = Types.StandardClass.SYMMETRY_BREAKING;
    public static final Types.TypeClass REDUNDANT_CONSTRAINTS = Types.StandardClass.REDUNDANT_CONSTRAINTS;
    public static final Types.TypeClass NOGOODS = Types.StandardClass.NOGOODS;
    public static final Types.TypeRank FIRST = Types.TypeRank.FIRST;
    public static final Types.TypeRank LAST = Types.TypeRank.LAST;
    public static final Types.TypeRank ANY = Types.TypeRank.ANY;
    public static final Boolean POSITIVE = Boolean.TRUE;
    public static final Boolean NEGATIVE = Boolean.FALSE;
    public static final Boolean CLOSED = Boolean.TRUE;
    public static final int STAR = 0x7FFFFFFE;
    public static final int STAR_INT = 0x7FFFFFFE;
    public static final String STAR_SYMBOL = "*";
    public static final Map<ProblemAPI, ProblemIMP> api2imp = new HashMap<ProblemAPI, ProblemIMP>();

    default public ProblemIMP imp() {
        this.control(api2imp.get(this) != null, "The method has been called before the associated problem implementation object was created.");
        return api2imp.get(this);
    }

    default public void control(boolean b, Object ... objects) {
        ProblemIMP.control(b, objects);
    }

    default public String name() {
        return this.imp().name();
    }

    default public String modelVariant() {
        return this.imp().modelVariant;
    }

    default public boolean modelVariant(String s) {
        return s.equals(this.modelVariant());
    }

    @Deprecated
    default public boolean isModel(String s) {
        return this.modelVariant(s);
    }

    default public <T> Stream<T> readFileLines(String filename, Function<String, T> f) {
        try {
            return Files.lines(Paths.get(filename, new String[0])).map(s -> s.trim()).filter(s -> s.length() > 0).map(s -> f.apply((String)s));
        }
        catch (IOException e) {
            System.out.println("Problem with file " + filename + " (or the specified function)");
            System.exit(1);
            return null;
        }
    }

    default public Stream<String> readFileLines(String filename) {
        return this.readFileLines(filename, s -> s);
    }

    default public int[] tuple(int value, int ... otherValues) {
        return IntStream.range(0, otherValues.length + 1).map(i -> i == 0 ? value : otherValues[i - 1]).toArray();
    }

    @Deprecated
    default public int[][] number(int ... t) {
        return this.indexing(t);
    }

    default public int[][] indexing(int ... t) {
        return (int[][])IntStream.range(0, t.length).mapToObj(i -> this.tuple(i, t[i])).toArray(n -> new int[n][]);
    }

    default public int[][] indexing(IntStream t) {
        return this.indexing(t.toArray());
    }

    default public int[][] indexing(int[] ... m) {
        return (int[][])IntStream.range(0, m.length).mapToObj(i -> IntStream.range(0, m[i].length).mapToObj(j -> this.tuple(i, j, m[i][j]))).flatMap(s -> s).toArray(n -> new int[n][]);
    }

    default public int[][] indexingTuples(int[] ... tuples) {
        return (int[][])IntStream.range(0, tuples.length).mapToObj(i -> this.tuple(i, tuples[i])).toArray(n -> new int[n][]);
    }

    default public int[][] indexingTuples(Stream<int[]> tuples) {
        return this.indexingTuples((int[][])tuples.toArray(n -> new int[n][]));
    }

    default public Table table() {
        return new Table();
    }

    default public Table table(boolean positive) {
        return new Table().positive(positive);
    }

    default public Table table(int value, int ... otherValues) {
        return new Table().add(value, otherValues);
    }

    default public Table table(int[] ... tuples) {
        return new Table().add(tuples);
    }

    default public Table table(Stream<int[]> stream) {
        return new Table().add(stream);
    }

    default public Table table(Collection<int[]> collection) {
        return new Table().add(collection.stream());
    }

    default public Table table(Table table) {
        return new Table().add(table);
    }

    default public Table tableIntersection(Table table1, Table table2) {
        return table1.intersectionWith(table2);
    }

    default public Table tableWithNewColumn(Table table, int position, int value) {
        return table.addColumnWithValue(position, value);
    }

    default public Table table(String tuples) {
        return new Table().add(tuples);
    }

    default public Transitions transitions() {
        return new Transitions();
    }

    default public Transitions transitions(String transitions) {
        return Transitions.parse(transitions);
    }

    default public String[] finalStates(String ... finalStates) {
        return finalStates;
    }

    default public String[] finalState(String finalState) {
        return this.finalStates(finalState);
    }

    default public Automaton automaton(String startState, Transition[] transitions, String ... finalStates) {
        return new Automaton(startState, transitions, finalStates);
    }

    default public Automaton automaton(String startState, Transitions transitions, String ... finalStates) {
        return this.automaton(startState, transitions.toArray(), finalStates);
    }

    default public Automaton automaton(String startState, String transitions, String ... finalStates) {
        return this.automaton(startState, this.transitions(transitions), finalStates);
    }

    default public Occurrences occursEachExactly(int occurs) {
        return new Occurrences.OccurrencesInt(occurs);
    }

    default public Occurrences occursEachBetween(int occursMin, int occursMax) {
        return new Occurrences.OccurrencesIntRange(occursMin, occursMax);
    }

    default public Occurrences occurExactly(int ... occurs) {
        return new Occurrences.OccurrencesInt1D(occurs);
    }

    @Deprecated
    default public Occurrences occurrences(int ... occurs) {
        return this.occurExactly(occurs);
    }

    default public Occurrences occurBetween(int[] occursMin, int[] occursMax) {
        return new Occurrences.OccurrencesIntRange1D(occursMin, occursMax);
    }

    @Deprecated
    default public Occurrences occursBetween(int[] occursMin, int[] occursMax) {
        return this.occurBetween(occursMin, occursMax);
    }

    default public Occurrences occurExactly(IVar.Var ... occurs) {
        return new Occurrences.OccurrencesVar1D(occurs);
    }

    @Deprecated
    default public Occurrences occurrences(IVar.Var ... occurs) {
        return this.occurExactly(occurs);
    }

    default public Condition condition(Types.TypeConditionOperatorRel op, long limit) {
        return new Condition.ConditionVal(op, limit);
    }

    default public Condition condition(Types.TypeConditionOperatorRel op, IVar.Var limit) {
        return new Condition.ConditionVar(op, limit);
    }

    default public Condition condition(Types.TypeConditionOperatorSet op, Range range) {
        this.control(range.step == 1 && range.length() >= 1, "Bad form of range");
        return new Condition.ConditionIntvl(op, range.start, range.stop - 1);
    }

    default public Condition condition(Types.TypeConditionOperatorSet op, int[] values) {
        return new Condition.ConditionIntset(op, IntStream.of(Utilities.collectInt(new Object[]{values})).sorted().distinct().toArray());
    }

    default public Index index(IVar.Var variable) {
        return new Index(variable);
    }

    default public Index index(IVar.Var variable, Types.TypeRank rank) {
        return new Index(variable, rank);
    }

    default public int startIndex(int value) {
        return value;
    }

    default public FunctionalInterfaces.Intx2Predicate onlyOn(FunctionalInterfaces.Intx2Predicate p) {
        return p;
    }

    default public int[] weightedBy(int ... coeffs) {
        return coeffs;
    }

    default public IVar.Var[] weightedBy(IVar.Var ... coeffs) {
        return coeffs;
    }

    default public int[][] weightedBy(int[] ... coeffs) {
        return coeffs;
    }

    default public IVar.Var[][] weightedBy(IVar.Var[] ... coeffs) {
        return coeffs;
    }

    default public int takingValue(int value) {
        return value;
    }

    default public IVar.Var takingValue(IVar.Var value) {
        return value;
    }

    default public int exceptValue(int value) {
        return value;
    }

    default public int[] exceptValues(int ... values) {
        this.control(values.length >= 1, new Object[0]);
        return values;
    }

    default public int[] takingValues(int ... values) {
        return values;
    }

    default public int[] takingValues(Range values) {
        return values.toArray();
    }

    default public int[][] takingValues(int[] ... values) {
        return values;
    }

    default public IVar.Var at(IVar.Var index) {
        return index;
    }

    default public CtrEntities.CtrArray block(Runnable r) {
        return this.imp().manageLoop(r);
    }

    default public CtrEntities.CtrArray forall(Range range, IntConsumer c) {
        return this.imp().forall(range, c);
    }

    default public CtrEntities.CtrArray forall(Range.Rangesx2 rangesx2, FunctionalInterfaces.Intx2Consumer c2) {
        return this.imp().forall(rangesx2, c2);
    }

    default public CtrEntities.CtrArray forall(Range.Rangesx3 rangesx3, FunctionalInterfaces.Intx3Consumer c3) {
        return this.imp().forall(rangesx3, c3);
    }

    default public CtrEntities.CtrArray forall(Range.Rangesx4 rangesx4, FunctionalInterfaces.Intx4Consumer c4) {
        return this.imp().forall(rangesx4, c4);
    }

    default public CtrEntities.CtrArray forall(Range.Rangesx5 rangesx5, FunctionalInterfaces.Intx5Consumer c5) {
        return this.imp().forall(rangesx5, c5);
    }

    default public CtrEntities.CtrArray forall(Range.Rangesx6 rangesx6, FunctionalInterfaces.Intx6Consumer c6) {
        return this.imp().forall(rangesx6, c6);
    }

    public static class Index {
        public IVar.Var var;
        public Types.TypeRank rank;

        public Index(IVar.Var var, Types.TypeRank rank) {
            this.var = var;
            this.rank = rank;
        }

        public Index(IVar.Var var) {
            this(var, Types.TypeRank.ANY);
        }
    }

    public static interface Occurrences {

        public static class OccurrencesInt
        implements Occurrences {
            public int occurs;

            public OccurrencesInt(int occurs) {
                this.occurs = occurs;
            }
        }

        public static class OccurrencesInt1D
        implements Occurrences {
            public int[] occurs;

            public OccurrencesInt1D(int[] occurs) {
                this.occurs = occurs;
            }
        }

        public static class OccurrencesIntRange
        implements Occurrences {
            public int occursMin;
            public int occursMax;

            public OccurrencesIntRange(int occursMin, int occursMax) {
                this.occursMin = occursMin;
                this.occursMax = occursMax;
            }
        }

        public static class OccurrencesIntRange1D
        implements Occurrences {
            public int[] occursMin;
            public int[] occursMax;

            public OccurrencesIntRange1D(int[] occursMin, int[] occursMax) {
                this.occursMin = occursMin;
                this.occursMax = occursMax;
            }
        }

        public static class OccurrencesVar1D
        implements Occurrences {
            public IVar.Var[] occurs;

            public OccurrencesVar1D(IVar.Var[] occurs) {
                this.occurs = occurs;
            }
        }
    }
}

