/*
 * Decompiled with CFR 0.152.
 */
package org.xcsp.common.enumerations;

import java.util.Arrays;
import java.util.stream.IntStream;
import org.xcsp.common.Utilities;
import org.xcsp.common.enumerations.EnumerationAbstract;

public class EnumerationOfPermutations
extends EnumerationAbstract {
    private final int[] values;
    private final boolean[] currDirectionOfIndexes;

    public EnumerationOfPermutations(int ... values) {
        super(values.length, IntStream.range(0, values.length).allMatch(i -> i == values[i]));
        this.values = values;
        this.currDirectionOfIndexes = new boolean[values.length];
        Utilities.control(IntStream.of(values).distinct().count() == (long)values.length, "Values should all be different");
        this.reset();
    }

    public EnumerationOfPermutations(int nValues) {
        this(IntStream.range(0, nValues).toArray());
    }

    @Override
    protected int valAt(int i) {
        return this.values[this.currTupleOfIdxs[i]];
    }

    @Override
    protected void computeFirstTuple() {
        int i = 0;
        while (i < this.currTupleOfIdxs.length) {
            this.currTupleOfIdxs[i] = i;
            ++i;
        }
        Arrays.fill(this.currDirectionOfIndexes, false);
    }

    private int findLargestMobileIndexPosition() {
        int best = -1;
        int p = 0;
        while (p < this.currTupleOfIdxs.length) {
            int q;
            int n = q = this.currDirectionOfIndexes[p] ? p + 1 : p - 1;
            if (q >= 0 && q <= this.currTupleOfIdxs.length - 1 && this.currTupleOfIdxs[p] > this.currTupleOfIdxs[q] && (best == -1 || this.currTupleOfIdxs[p] > this.currTupleOfIdxs[best])) {
                best = p;
            }
            ++p;
        }
        return best;
    }

    @Override
    public boolean hasNext() {
        if (this.nextTuple != null) {
            return this.nextTuple == Boolean.TRUE;
        }
        int p = this.findLargestMobileIndexPosition();
        if (p == -1) {
            this.nextTuple = Boolean.FALSE;
            return false;
        }
        int q = this.currDirectionOfIndexes[p] ? p + 1 : p - 1;
        int tmp = this.currTupleOfIdxs[p];
        boolean tmpD = this.currDirectionOfIndexes[p];
        this.currTupleOfIdxs[p] = this.currTupleOfIdxs[q];
        this.currDirectionOfIndexes[p] = this.currDirectionOfIndexes[q];
        this.currTupleOfIdxs[q] = tmp;
        this.currDirectionOfIndexes[q] = tmpD;
        int i = 0;
        while (i < this.currDirectionOfIndexes.length) {
            if (this.currTupleOfIdxs[i] > tmp) {
                this.currDirectionOfIndexes[i] = !this.currDirectionOfIndexes[i];
            }
            ++i;
        }
        this.nextTuple = Boolean.TRUE;
        return true;
    }

    public static void main(String[] args) {
        new EnumerationOfPermutations(1, 2, 3, 4, 5).displayAllTuples();
        new EnumerationOfPermutations(3).displayAllTuples();
    }
}

