/*
 * Decompiled with CFR 0.152.
 */
package optimization;

import constraints.Constraint;
import interfaces.Tags;
import optimization.Optimizable;
import problem.Problem;
import variables.Variable;

public abstract class ObjectiveVariable
extends Constraint.CtrGlobal
implements Optimizable,
Tags.TagAC,
Tags.TagFilteringCompleteAtEachCall,
Tags.TagSymmetric {
    protected Variable x;
    protected long limit;

    @Override
    public long minComputableObjectiveValue() {
        return this.x.dom.toVal(0);
    }

    @Override
    public long maxComputableObjectiveValue() {
        return this.x.dom.toVal(this.x.dom.initSize() - 1);
    }

    @Override
    public long minCurrentObjectiveValue() {
        return this.x.dom.firstValue();
    }

    @Override
    public long maxCurrentObjectiveValue() {
        return this.x.dom.lastValue();
    }

    @Override
    public long limit() {
        return this.limit;
    }

    @Override
    public final void limit(long newLimit) {
        this.limit = newLimit;
        this.control(this.minComputableObjectiveValue() - 1L <= this.limit && this.limit <= this.maxComputableObjectiveValue() + 1L);
    }

    @Override
    public long objectiveValue() {
        return this.x.dom.uniqueValue();
    }

    public ObjectiveVariable(Problem pb, Variable x, long limit) {
        super(pb, new Variable[]{x});
        this.x = x;
        this.limit(limit);
    }

    public static final class ObjVarGE
    extends ObjectiveVariable {
        @Override
        public boolean checkValues(int[] vals) {
            return (long)vals[0] >= this.limit;
        }

        public ObjVarGE(Problem pb, Variable x, long limit) {
            super(pb, x, Math.max(limit, (long)x.dom.firstValue()));
        }

        @Override
        public boolean runPropagator(Variable dummy) {
            this.control(this.problem.solver.depth() == 0, () -> "depth: " + this.problem.solver.depth());
            if (!this.x.dom.removeValuesLT(this.limit)) {
                return false;
            }
            assert (this.x.dom.size() > 0);
            return this.entailed();
        }
    }

    public static final class ObjVarLE
    extends ObjectiveVariable {
        @Override
        public boolean checkValues(int[] vals) {
            return (long)vals[0] <= this.limit;
        }

        public ObjVarLE(Problem pb, Variable x, long limit) {
            super(pb, x, Math.min(limit, (long)x.dom.lastValue()));
        }

        @Override
        public boolean runPropagator(Variable dummy) {
            this.control(this.problem.solver.depth() == 0, () -> "depth: " + this.problem.solver.depth());
            if (!this.x.dom.removeValuesGT(this.limit)) {
                return false;
            }
            assert (this.x.dom.size() > 0);
            return this.entailed();
        }
    }
}

