/*
 * Decompiled with CFR 0.152.
 */
package main;

import constraints.Constraint;
import dashboard.Input;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import main.Head;
import problem.Problem;
import solver.Solver;
import utility.Enums;
import utility.Kit;
import variables.Variable;

public class HeadExtraction
extends Head {
    public List<List<Constraint>> cores = new ArrayList<List<Constraint>>();
    private boolean[] presentVars;
    private boolean[] presentCtrs;
    private boolean[] localVars;
    private boolean[] localCtrs;
    private boolean[] activeCtrs;
    private boolean[] tmpVars;
    private boolean[] tmpCtrs;
    private VarComparator varComparator = new VarComparator();
    private CtrComparator ctrComparator = new CtrComparator();
    private int nRuns;
    private int nCalls;

    private Variable[] arrayOfPossiblyPresentVars() {
        return (Variable[])IntStream.range(0, this.presentVars.length).filter(i -> this.presentVars[i]).mapToObj(i -> this.problem.variables[i]).toArray(Variable[]::new);
    }

    private Constraint[] arrayOfPossiblyPresentCtrs() {
        return (Constraint[])IntStream.range(0, this.presentCtrs.length).filter(i -> this.presentCtrs[i]).mapToObj(i -> this.problem.constraints[i]).toArray(Constraint[]::new);
    }

    private boolean[] updatePresentVariablesFrom(boolean[] presentVars, boolean[] presentCtrs) {
        for (int i = 0; i < presentVars.length; ++i) {
            presentVars[i] = presentVars[i] && Variable.isInducedBy(this.problem.variables[i], presentCtrs);
        }
        return presentVars;
    }

    private boolean[] updatePresentConstraintsFrom(boolean[] presentVars, boolean[] presentCtrs) {
        for (int i = 0; i < presentCtrs.length; ++i) {
            presentCtrs[i] = presentCtrs[i] && Constraint.isPresentScope(this.problem.constraints[i], presentVars);
        }
        return presentCtrs;
    }

    private void updatePossiblyArrays(Variable[] currVars, int min) {
        int i;
        for (i = min; i < currVars.length; ++i) {
            this.presentVars[currVars[i].num] = false;
        }
        for (i = 0; i < this.presentCtrs.length; ++i) {
            if (!this.presentCtrs[i]) continue;
            this.presentCtrs[i] = Constraint.isPresentScope(this.problem.constraints[i], this.presentVars);
        }
    }

    private void updatePossiblyArrays(Constraint[] currCtrs, int min) {
        int i;
        for (i = min; i < currCtrs.length; ++i) {
            this.presentCtrs[currCtrs[i].num] = false;
        }
        for (i = 0; i < this.presentVars.length; ++i) {
            if (!this.presentVars[i]) continue;
            this.presentVars[i] = Variable.isInducedBy(this.problem.variables[i], this.presentCtrs);
        }
    }

    private boolean solveCurrentNetwork(boolean[] presentVars, boolean[] presentCtrs, boolean preserveWeightedDegrees) {
        ++this.nRuns;
        this.problem.reduceTo(presentVars, presentCtrs);
        this.solver.reset();
        this.solver.solve();
        return this.solver.solRecorder.found > 0L;
    }

    private boolean solveFor(boolean[] presentVars, Variable[] currVars, int min, int max, int center) {
        int i;
        for (i = min; i <= center; ++i) {
            presentVars[currVars[i].num] = true;
        }
        for (i = center + 1; i <= max; ++i) {
            presentVars[currVars[i].num] = false;
        }
        return this.solveCurrentNetwork(presentVars, this.updatePresentConstraintsFrom(presentVars, this.tmpCtrs), true);
    }

    private boolean solveFor(boolean[] presentCtrs, Constraint[] currCtrs, int min, int max, int center) {
        int i;
        for (i = min; i <= center; ++i) {
            presentCtrs[currCtrs[i].num] = true;
        }
        for (i = center + 1; i <= max; ++i) {
            presentCtrs[currCtrs[i].num] = false;
        }
        return this.solveCurrentNetwork(this.updatePresentVariablesFrom(this.tmpVars, presentCtrs), presentCtrs, true);
    }

    private List<Variable> minimalCoreOfVars() {
        Kit.log.info("Start Finding Minimal Core of variables ...");
        ArrayList<Variable> core = new ArrayList<Variable>();
        boolean finished = false;
        while (!finished) {
            boolean transitionVariable;
            Variable[] currVars = Kit.sort(this.arrayOfPossiblyPresentVars(), this.varComparator.core(core));
            Arrays.fill(this.localVars, false);
            int min = core.size();
            int max = currVars.length - 1;
            for (int i = 0; i < min; ++i) {
                this.localVars[currVars[i].num] = true;
            }
            while (min != max) {
                int center = min + (max - min) / 2;
                if (!this.solveFor(this.localVars, currVars, min, max, center)) {
                    max = center;
                    continue;
                }
                min = center + 1;
            }
            if (min == core.size()) {
                finished = true;
            }
            boolean bl = transitionVariable = !finished || this.solveFor(this.localVars, currVars, min, currVars.length - 1, min - 1);
            if (transitionVariable) {
                core.add(currVars[min]);
                Kit.log.info("Last transition variable : " + currVars[min] + " coreSize=" + core.size());
            }
            this.updatePossiblyArrays(currVars, min + (transitionVariable ? 1 : 0));
        }
        assert (!this.solveCurrentNetwork(this.presentVars, this.presentCtrs, true));
        Kit.log.info("End Finding Minimal Core of variables.");
        return core;
    }

    private List<Constraint> minimalCoreOfCtrs() {
        Kit.log.info("Start Finding Minimal Core of constraints (dichotomic) ...");
        ArrayList<Constraint> core = new ArrayList<Constraint>();
        boolean finished = false;
        while (!finished) {
            boolean transitionConstraint;
            Constraint[] currCtrs = Kit.sort(this.arrayOfPossiblyPresentCtrs(), this.ctrComparator.coreAndMode(core, this.solver.stats.nPreproInconsistencies == 0L));
            Arrays.fill(this.localCtrs, false);
            int min = core.size();
            int max = currCtrs.length - 1;
            for (int i = 0; i < min; ++i) {
                this.localCtrs[currCtrs[i].num] = true;
            }
            while (min != max) {
                int center = min + (max - min) / 2;
                if (!this.solveFor(this.localCtrs, currCtrs, min, max, center)) {
                    max = center;
                    continue;
                }
                min = center + 1;
            }
            if (min == core.size()) {
                finished = true;
            }
            boolean bl = transitionConstraint = !finished || this.solveFor(this.localCtrs, currCtrs, min, currCtrs.length - 1, min - 1);
            if (transitionConstraint) {
                core.add(currCtrs[min]);
                Kit.log.info("Last transition constraint : " + currCtrs[min] + " coreSize=" + core.size());
            }
            this.updatePossiblyArrays(currCtrs, min + (transitionConstraint ? 1 : 0));
        }
        assert (!this.solveCurrentNetwork(this.presentVars, this.presentCtrs, true));
        Kit.log.info("End Finding Minimal Core of constraints.");
        return core;
    }

    private boolean wcore() {
        if (this.solveCurrentNetwork(this.presentVars, this.presentCtrs, true)) {
            return false;
        }
        Kit.log.info("Start wcore ...");
        int nPreviousActiveConstraints = Integer.MAX_VALUE;
        while (true) {
            int nActiveConstraints = 0;
            Arrays.fill(this.activeCtrs, false);
            for (Constraint c : this.problem.constraints) {
                if (c.ignored || c.nEffectiveFilterings <= 0) continue;
                this.activeCtrs[c.num] = true;
                ++nActiveConstraints;
            }
            Kit.log.info("nEffectiveFilteringConstraints= " + nActiveConstraints + "\n");
            if (nActiveConstraints >= nPreviousActiveConstraints) break;
            nPreviousActiveConstraints = nActiveConstraints;
            Kit.control(Kit.isSubsumed(this.activeCtrs, this.presentCtrs));
            Kit.and(this.presentCtrs, this.activeCtrs);
            boolean sat = this.solveCurrentNetwork(this.updatePresentVariablesFrom(this.presentVars, this.presentCtrs), this.presentCtrs, true);
            Kit.control(!sat);
        }
        Kit.log.info("End wcore.");
        return true;
    }

    private void buildOrInitializeStructures(List<List<Constraint>> cores) {
        if (cores.size() == 0) {
            this.presentVars = Kit.repeat(true, this.problem.variables.length);
            this.presentCtrs = Kit.repeat(true, this.problem.constraints.length);
            this.localVars = new boolean[this.problem.variables.length];
            this.localCtrs = new boolean[this.problem.constraints.length];
            this.activeCtrs = new boolean[this.problem.constraints.length];
            this.tmpVars = new boolean[this.problem.variables.length];
            this.tmpCtrs = new boolean[this.problem.constraints.length];
        } else {
            Arrays.fill(this.presentVars, true);
            Arrays.fill(this.presentCtrs, true);
            cores.stream().forEach(core -> core.stream().forEach(c -> {
                this.presentCtrs[c.num] = false;
            }));
            this.updatePresentVariablesFrom(this.presentVars, this.presentCtrs);
        }
    }

    @Override
    protected void solveInstance(int instanceNumber) {
        this.problem = this.buildProblem(instanceNumber);
        this.solver = this.buildSolver(this.problem);
        Kit.Stopwatch stopwatch = new Kit.Stopwatch();
        this.cores.clear();
        for (int i = 0; i < this.control.extraction.nCores; ++i) {
            stopwatch.start();
            this.buildOrInitializeStructures(this.cores);
            if (!this.wcore()) {
                Kit.log.info("No more cores");
                break;
            }
            if (this.control.extraction.method == Enums.EExtraction.VAR) {
                this.minimalCoreOfVars();
            }
            List<Constraint> core = this.minimalCoreOfCtrs();
            this.cores.add(core);
            Kit.log.config("New Core " + this.nCalls++ + " with #C=" + core.size() + ",#V=" + core.stream().collect(Collectors.toCollection(HashSet::new)).size() + " => { " + Kit.join(core, new String[0]) + " }");
            Kit.log.config("in wck = " + stopwatch.wckTimeInSeconds() + " and nRuns = " + this.nRuns);
        }
    }

    @Override
    public Problem buildProblem(int instanceNumber) {
        if (this.problem == null) {
            this.problem = super.buildProblem(instanceNumber);
        } else {
            this.problem.reset();
        }
        return this.problem;
    }

    public List<Constraint> lastCore() {
        return this.cores.size() == 0 ? null : this.cores.get(this.cores.size() - 1);
    }

    public HeadExtraction() {
    }

    public HeadExtraction(String configurationFileName) {
        super(configurationFileName);
    }

    public HeadExtraction(Problem pb) {
        this.problem = pb;
    }

    public static void main(String[] args) {
        Input.loadArguments(args);
        HeadExtraction extraction = new HeadExtraction();
        Kit.control(!extraction.control.problem.isSymmetryBreaking(), () -> "Do not use symmetry breaking method when extracting unsatisfiable cores.");
        Kit.control(extraction.control.learning.state == Enums.ELearningIps.NO, () -> "Do not use partial state learning when extracting unsatisfiable cores.");
        Kit.control(extraction.control.solving.clazz.equals(Solver.class.getSimpleName()), () -> extraction.control.solving.clazz);
        extraction.start();
    }

    private class CtrComparator
    implements Comparator<Constraint> {
        private List<Constraint> core;
        private boolean wmode;

        private CtrComparator() {
        }

        private CtrComparator coreAndMode(List<Constraint> core, boolean wmode) {
            this.core = core;
            this.wmode = wmode;
            return this;
        }

        @Override
        public int compare(Constraint c1, Constraint c2) {
            boolean b1 = this.core.contains(c1);
            boolean b2 = this.core.contains(c2);
            return b1 && !b2 ? -1 : (!b1 && b2 ? 1 : (this.wmode ? Double.compare(c2.wdeg(), c1.wdeg()) : Integer.compare(c2.nEffectiveFilterings, c1.nEffectiveFilterings)));
        }
    }

    private class VarComparator
    implements Comparator<Variable> {
        private List<Variable> core;

        private VarComparator() {
        }

        private VarComparator core(List<Variable> core) {
            this.core = core;
            return this;
        }

        @Override
        public int compare(Variable x, Variable y) {
            boolean b1 = this.core.contains(x);
            boolean b2 = this.core.contains(y);
            return b1 && !b2 ? -1 : (!b1 && b2 ? 1 : Double.compare(y.wdegOnDom(), x.wdegOnDom()));
        }
    }
}

