/*
 * Decompiled with CFR 0.152.
 */
package main;

import constraints.extension.Extension;
import constraints.extension.structures.Bits;
import constraints.extension.structures.ExtensionStructure;
import constraints.extension.structures.MDD;
import constraints.intension.Intension;
import dashboard.Control;
import dashboard.Input;
import dashboard.Output;
import heuristics.HeuristicRevisions;
import heuristics.HeuristicValues;
import heuristics.HeuristicVariables;
import interfaces.Observers;
import java.io.File;
import java.io.FileInputStream;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import main.HeadExtraction;
import main.ResolutionVariants;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xcsp.common.Types;
import org.xcsp.common.Utilities;
import org.xcsp.modeler.api.ProblemAPI;
import problem.Problem;
import propagation.Propagation;
import solver.Solver;
import utility.Enums;
import utility.Kit;
import utility.Reflector;

public class Head
extends Thread {
    private static Head[] heads;
    public HandlerClasses handlerClasses = new HandlerClasses();
    public StructureSharing structureSharing = new StructureSharing();
    public final Kit.Stopwatch stopwatch = new Kit.Stopwatch();
    public final Kit.Stopwatch instanceStopwatch = new Kit.Stopwatch();
    public Problem problem;
    public Solver solver;
    public final Control control;
    public final Output output;
    public final List<Observers.ObserverConstruction> observersConstruction = new ArrayList<Observers.ObserverConstruction>();
    public final Random random = new Random();
    public int instanceNumber;

    public static synchronized void saveMultithreadResultsFiles(Head resolution) {
        String fileName = resolution.output.save(resolution.stopwatch.wckTime());
        if (fileName != null) {
            String variantParallelName = Kit.attValueFor(Input.lastArgument(), "variantParallel", "name");
            String resultsFileName = resolution.control.xml.dirForCampaign;
            if (resultsFileName != "") {
                resultsFileName = resultsFileName + File.separator;
            }
            resultsFileName = resultsFileName + "results" + File.separator + resolution.output.outputFileNameFrom(resolution.problem.name(), variantParallelName);
            Kit.copy(fileName, resultsFileName);
            Document document = Kit.load(resultsFileName);
            Kit.modify(document, Enums.TypeOutput.RESOLUTIONS.toString(), "configurationFileName", variantParallelName);
            long totalWCKTime = 0L;
            long totalVisitedNodes = 0L;
            for (Head h : heads) {
                totalWCKTime += h.instanceStopwatch.wckTime();
                totalVisitedNodes += h.solver.stats.nNodes;
            }
            Element root = document.getDocumentElement();
            Element multiThreadedResults = document.createElement("multithreadResults");
            multiThreadedResults.setAttribute("wck", Double.toString((double)totalWCKTime / 1000.0));
            multiThreadedResults.setAttribute("nNodes", Long.toString(totalVisitedNodes));
            root.appendChild(multiThreadedResults);
            Utilities.save(document, resultsFileName);
        }
    }

    public static boolean isAvailableIn() {
        try {
            return System.in.available() > 0;
        }
        catch (Throwable e) {
            return (Boolean)Kit.exit(e);
        }
    }

    public static final String[] loadVariantNames() {
        if (Input.multiThreads) {
            File file;
            String prefix = Kit.attValueFor(Input.userSettingsFilename, "xml", "exportMode");
            if (prefix.equals("NO")) {
                prefix = ".";
            }
            if (prefix != "") {
                prefix = prefix + File.separator;
            }
            if (!(file = new File(prefix = prefix + "configurations" + File.separator)).exists()) {
                file.mkdirs();
            } else {
                Kit.control(file.isDirectory());
            }
            return ResolutionVariants.loadSequentialVariants(Input.userSettingsFilename, Input.lastArgument(), prefix);
        }
        return new String[]{Input.userSettingsFilename};
    }

    public static void main(String[] args) {
        if (args.length == 0 && !Head.isAvailableIn()) {
            new Head().control.settings.display();
        } else {
            Input.loadArguments(args);
            heads = (Head[])Stream.of(Head.loadVariantNames()).map(v -> new Head((String)v)).peek(h -> h.start()).toArray(Head[]::new);
        }
    }

    public boolean mustPreserveUnaryConstraints() {
        return this.control.constraints.preserveUnaryCtrs || this instanceof HeadExtraction || this.control.problem.isSymmetryBreaking() || this.control.general.framework == Types.TypeFramework.MAXCSP;
    }

    public boolean isTimeExpiredForCurrentInstance() {
        return this.control.general.timeout <= this.instanceStopwatch.wckTime();
    }

    public Head(String configurationFileName) {
        this.control = Control.buildControlPanelFor(configurationFileName);
        this.output = new Output(this, configurationFileName);
        this.observersConstruction.add(this.output);
    }

    public Head() {
        this((String)null);
    }

    public Problem buildProblem(int instanceNumber) {
        this.instanceNumber = instanceNumber;
        this.random.setSeed(this.control.general.seed + (long)instanceNumber);
        ProblemAPI api = null;
        try {
            try {
                api = (ProblemAPI)Reflector.buildObject(Input.problemPackageName);
            }
            catch (Exception e) {
                api = (ProblemAPI)Reflector.buildObject("problems." + Input.problemPackageName);
            }
        }
        catch (Exception e) {
            return (Problem)Kit.exit("The class " + Input.problemPackageName + " cannot be found.", e);
        }
        Control.SettingProblem settings = this.control.problem;
        this.problem = new Problem(api, settings.variant, settings.data, settings.dataFormat, settings.dataexport, Input.argsForPb, this);
        for (Observers.ObserverConstruction obs : this.observersConstruction) {
            obs.afterProblemConstruction();
        }
        this.problem.display();
        return this.problem;
    }

    protected final Solver buildSolver(Problem problem) {
        Kit.log.config("\n  Building solver... ");
        this.solver = Reflector.buildObject(this.control.solving.clazz, Solver.class, this);
        for (Observers.ObserverConstruction obs : this.observersConstruction) {
            obs.afterSolverConstruction();
        }
        return this.solver;
    }

    protected void solveInstance(int instanceNumber) {
        this.observersConstruction.clear();
        this.observersConstruction.add(this.output);
        this.structureSharing.clear();
        this.problem = this.buildProblem(instanceNumber);
        this.structureSharing.clear();
        if (this.control.solving.enablePrepro || this.control.solving.enableSearch) {
            this.solver = this.buildSolver(this.problem);
            this.solver.solve();
            this.solver.solRecorder.displayFinalResults();
        }
    }

    @Override
    public void run() {
        this.stopwatch.start();
        Kit.log.config("\n" + Kit.preprint("ACE (AbsCon Essence)", "\u001b[93m") + " v21.05 " + Kit.dateOf(Head.class));
        boolean crashed = false;
        for (int i = 0; i < Input.nInstancesToSolve; ++i) {
            try {
                crashed = false;
                this.solveInstance(i);
                continue;
            }
            catch (Throwable e) {
                crashed = true;
                System.out.println(Kit.preprint("\n! ERROR (use -ev for more details)", "\u001b[91m"));
                if (!this.control.general.makeExceptionsVisible) continue;
                e.printStackTrace();
            }
        }
        if (Input.multiThreads) {
            if (!crashed) {
                Head.saveMultithreadResultsFiles(this);
                System.exit(0);
            }
        } else {
            this.output.save(this.stopwatch.wckTime());
        }
    }

    public static class StructureSharing {
        public Map<String, ExtensionStructure> mapOfExtensionStructures = new HashMap<String, ExtensionStructure>();
        public Map<String, MDD> mapOfMDDStructures = new HashMap<String, MDD>();
        public Map<String, Intension.SharedTreeEvaluator> mapOfTreeEvaluators = new HashMap<String, Intension.SharedTreeEvaluator>();

        public void clear() {
            this.mapOfExtensionStructures.clear();
            this.mapOfMDDStructures.clear();
            this.mapOfTreeEvaluators.clear();
            Bits.globalMap.clear();
        }
    }

    public static class HandlerClasses {
        private static final String DOT_CLASS = ".class";
        private static final String DOT_JAR = ".jar";
        public Map<Class<?>, Set<Class<?>>> map = new HashMap();

        private HandlerClasses() {
            this.loadClasses();
        }

        private boolean dealWith(Class<?> clazz, Class<?> rootClass) {
            if (rootClass.isAssignableFrom(clazz)) {
                this.map.computeIfAbsent(rootClass, r -> new HashSet()).add(clazz);
                return true;
            }
            return false;
        }

        private boolean dealWith(Class<?> clazz) {
            if (Modifier.isAbstract(clazz.getModifiers())) {
                return false;
            }
            return this.dealWith(clazz, HeuristicVariables.class) || this.dealWith(clazz, HeuristicValues.class) || this.dealWith(clazz, HeuristicRevisions.class) || this.dealWith(clazz, Extension.class) || this.dealWith(clazz, Propagation.class);
        }

        private void loadRecursively(File directory, String packageName) throws ClassNotFoundException {
            packageName = packageName.startsWith(".") ? packageName.substring(1) : packageName;
            for (File file : directory.listFiles()) {
                if (file.isDirectory()) {
                    Kit.control(!file.getName().contains("."));
                    this.loadRecursively(file, packageName + "." + file.getName());
                    continue;
                }
                if (!file.getName().endsWith(DOT_CLASS) || file.getName().charAt(0) == '/') continue;
                this.dealWith(Class.forName(packageName + '.' + file.getName().substring(0, file.getName().length() - DOT_CLASS.length())));
            }
        }

        private void loadClasses() {
            try {
                block11: for (String classPathToken : System.getProperty("java.class.path", ".").split(File.pathSeparator)) {
                    if (!classPathToken.endsWith(DOT_JAR)) continue;
                    try {
                        JarInputStream jarFile = new JarInputStream(new FileInputStream(classPathToken));
                        block12: while (true) {
                            while (true) {
                                JarEntry jarEntry;
                                if ((jarEntry = jarFile.getNextJarEntry()) == null) {
                                    continue block11;
                                }
                                if (!jarEntry.getName().endsWith(DOT_CLASS)) continue;
                                try {
                                    String s = jarEntry.getName().replaceAll("/", "\\.");
                                    this.dealWith(Class.forName(s.substring(0, s.lastIndexOf("."))));
                                    continue block12;
                                }
                                catch (Throwable e) {
                                    Kit.log.fine("Impossible to load" + jarEntry.getName());
                                    continue;
                                }
                                break;
                            }
                        }
                        finally {
                            jarFile.close();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                for (Package p : Package.getPackages()) {
                    String name = p.getName();
                    if (!name.startsWith("constraints") && !name.startsWith("heuristics") && !name.startsWith("propagation")) continue;
                    for (URL url : Collections.list(classLoader.getResources(p.getName().replace('.', '/')))) {
                        if (!url.getProtocol().equals("file") || !new File(url.getFile()).exists()) continue;
                        this.loadRecursively(new File(url.getFile()), p.getName());
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public String toString() {
            String s = "";
            for (Map.Entry<Class<?>, Set<Class<?>>> entry : this.map.entrySet()) {
                s = s + entry.getKey() + " : " + entry.getValue().stream().map(c -> c.getName()).collect(Collectors.joining(" ")) + "\n";
            }
            return s;
        }
    }
}

