/*
 * Decompiled with CFR 0.152.
 */
package learning;

import propagation.GAC;
import propagation.Propagation;
import solver.DecisionRecorder;
import solver.Solver;
import utility.Enums;
import variables.Variable;

public class NogoodMinimizer {
    private Solver solver;
    private Propagation propagation;
    private DecisionRecorder dr;
    private int arityLimit;

    public NogoodMinimizer(Solver solver) {
        this.solver = solver;
        this.propagation = solver.propagation;
        this.dr = solver.decRecorder;
        this.arityLimit = solver.head.control.learning.nogoodArityLimit;
    }

    private boolean addPositiveTransitionDecision(int positiveDecision, int[] tmp, int nTransitions) {
        tmp[nTransitions] = positiveDecision;
        Variable x = this.dr.varIn(positiveDecision);
        int a = this.dr.idxIn(positiveDecision);
        if (!x.dom.present(a)) {
            return false;
        }
        this.solver.assign(x, a);
        return this.propagation.runAfterAssignment(x);
    }

    private int searchPositiveTransitionDecision(int right, int[] decs, int limitDepth) {
        int left;
        boolean consistent = true;
        for (left = 0; consistent && left < right; ++left) {
            Variable x = this.dr.varIn(decs[left]);
            int a = this.dr.idxIn(decs[left]);
            if (!x.dom.present(a)) {
                consistent = false;
            } else {
                this.solver.assign(x, a);
                consistent = this.propagation.runAfterAssignment(x);
            }
            assert (!consistent || !(this.propagation instanceof GAC) || ((GAC)this.propagation).controlArcConsistency());
        }
        if (consistent) {
            return -1;
        }
        while (this.solver.futVars.size() > 0 && this.solver.depth() != limitDepth - 1) {
            this.solver.backtrack();
        }
        return left - 1;
    }

    public int[] extractMinimalNogoodFrom(int[] decs) {
        boolean consistent;
        int[] tmp = new int[decs.length];
        int positionOfLastFoundTransitionDecision = decs.length - 1;
        int nTransitions = 0;
        if (!(consistent = this.addPositiveTransitionDecision(decs[positionOfLastFoundTransitionDecision], tmp, nTransitions++))) {
            Variable x = this.solver.futVars.lastPast();
            int a = x.dom.unique();
            this.solver.backtrack(x);
            x.dom.removeElementary(a);
            boolean bl = consistent = x.dom.size() > 0 && this.propagation.runAfterRefutation(x);
            if (!consistent) {
                this.solver.stopping = Enums.EStopping.FULL_EXPLORATION;
                return new int[0];
            }
            return null;
        }
        while (consistent && 0 < positionOfLastFoundTransitionDecision && nTransitions < this.arityLimit) {
            if (positionOfLastFoundTransitionDecision == 1) {
                tmp[nTransitions++] = decs[0];
                break;
            }
            if ((positionOfLastFoundTransitionDecision = this.searchPositiveTransitionDecision(positionOfLastFoundTransitionDecision, decs, this.solver.depth())) == -1) continue;
            consistent = this.addPositiveTransitionDecision(decs[positionOfLastFoundTransitionDecision], tmp, nTransitions++);
        }
        this.solver.backtrackToTheRoot();
        if (positionOfLastFoundTransitionDecision == -1) {
            int[] t = new int[decs.length];
            for (int i = 0; i < t.length; ++i) {
                t[i] = -decs[i];
            }
            return t;
        }
        int[] t = new int[nTransitions];
        for (int i = 0; i < t.length; ++i) {
            t[i] = -tmp[i];
        }
        return t;
    }
}

