/*
 * Decompiled with CFR 0.152.
 */
package learning;

import java.util.HashMap;
import java.util.Map;
import java.util.zip.Deflater;
import learning.IpsRecorder;
import solver.Solver;
import utility.Bit;
import utility.Enums;
import utility.Kit;
import variables.Domain;
import variables.Variable;

public final class IpsRecorderForEquivalence
extends IpsRecorder {
    private static final Integer zero = new Integer(0);
    private Map<Kit.ByteArrayHashKey, Integer> mapOfHashKeys = new HashMap<Kit.ByteArrayHashKey, Integer>(2000);
    private Kit.ByteArrayHashKey[] currentOpenNodesKeys;
    private int[] currentOpenNodesNbFoundSolutions;
    private Kit.ByteArrayHashKey currentHashKey;
    private boolean moreThanOneSolution;
    private int nBytesPerVariableId;
    private Deflater compressor;
    private byte[] tmpInput = new byte[50000];
    private byte[] tmpOutput = new byte[20000];
    public int nTooLargeKeys;
    public int nInferredSolutions;

    public int getMapSize() {
        return this.mapOfHashKeys.size();
    }

    public IpsRecorderForEquivalence(Solver solver) {
        super(solver);
        if (this.variables.length > 1500) {
            this.stopped = true;
        }
        this.currentOpenNodesKeys = new Kit.ByteArrayHashKey[this.variables.length];
        this.currentOpenNodesNbFoundSolutions = new int[this.variables.length];
        boolean bl = this.moreThanOneSolution = solver.solRecorder.limit > 1L;
        int n = (double)this.variables.length <= Math.pow(2.0, 8.0) ? 1 : ((double)this.variables.length <= Math.pow(2.0, 16.0) ? 2 : (this.nBytesPerVariableId = (double)this.variables.length <= Math.pow(2.0, 24.0) ? 3 : 4));
        if (this.settings.compressionLevelForStateEquivalence != 0) {
            this.compressor = new Deflater(this.settings.compressionLevelForStateEquivalence);
        }
    }

    @Override
    protected boolean mustStop() {
        if (super.mustStop()) {
            return true;
        }
        int nGlobalKeys = this.mapOfHashKeys.size() + this.nTooLargeKeys;
        return nGlobalKeys > 1000 && nGlobalKeys > 1000 * this.nInferences;
    }

    private byte[] compress(int limit) {
        assert (limit >= this.settings.compressionLimitForStateEquivalence);
        this.compressor.reset();
        this.compressor.setInput(this.tmpInput, 0, limit);
        this.compressor.finish();
        int count = this.compressor.deflate(this.tmpOutput);
        if (!this.compressor.finished()) {
            byte[] t = new byte[limit];
            System.arraycopy(this.tmpInput, 0, t, 0, limit);
            return t;
        }
        byte[] t = new byte[count];
        System.arraycopy(this.tmpOutput, 0, t, 0, count);
        return t;
    }

    private void buildHashKey() {
        int[] ids = this.moreThanOneSolution ? this.reductionOperator.extractForAllSolutions() : this.reductionOperator.extract();
        int keySize = 0;
        for (int i = 0; i < ids.length; ++i) {
            Variable var = this.solver.problem.variables[ids[i]];
            Domain dom = var.dom;
            if (keySize + this.nBytesPerVariableId + dom.initSize() / 8 >= this.tmpInput.length) {
                keySize = -1;
                break;
            }
            keySize = Bit.convert(var.num, this.nBytesPerVariableId, this.tmpInput, keySize);
            keySize = Bit.convert(dom.binary(), dom.initSize(), this.tmpInput, keySize);
        }
        if (this.currentHashKey == null) {
            this.currentHashKey = new Kit.ByteArrayHashKey();
        }
        if (keySize == -1) {
            this.currentHashKey.t = null;
            ++this.nTooLargeKeys;
        } else {
            byte[] t = null;
            if (this.compressor == null || keySize < this.settings.compressionLimitForStateEquivalence) {
                t = new byte[keySize];
                System.arraycopy(this.tmpInput, 0, t, 0, keySize);
            } else {
                t = this.compress(keySize);
            }
            this.currentHashKey.t = t;
        }
    }

    @Override
    public boolean dealWhenOpeningNode() {
        if (this.stopped) {
            return true;
        }
        int level = this.solver.depth();
        if (level == this.variables.length) {
            return true;
        }
        this.buildHashKey();
        if (this.currentHashKey.t == null) {
            this.currentOpenNodesKeys[level] = null;
            return true;
        }
        Integer value = this.mapOfHashKeys.get(this.currentHashKey);
        if (value != null) {
            ++this.nInferences;
            if (value > 0) {
                this.nInferredSolutions += value.intValue();
                this.solver.solRecorder.found += (long)value.intValue();
            }
            return false;
        }
        this.currentOpenNodesKeys[level] = this.currentHashKey;
        this.currentHashKey = null;
        this.currentOpenNodesNbFoundSolutions[level] = (int)this.solver.solRecorder.found;
        return true;
    }

    @Override
    public void dealWhenClosingNode() {
        int nSolutions;
        if (this.stopped) {
            return;
        }
        if (this.mustStop()) {
            Kit.log.info("Stopping use of transposition table (mapSize=" + this.mapOfHashKeys.size() + ", nbTooLargekeys=" + this.nTooLargeKeys + ", mem=" + Kit.memoryInMb() + ")");
            this.mapOfHashKeys.clear();
            this.stopped = true;
            return;
        }
        Kit.ByteArrayHashKey hashKey = this.currentOpenNodesKeys[this.solver.depth()];
        if (hashKey == null) {
            return;
        }
        if (hashKey.t.length == 0) {
            this.solver.stopping = Enums.EStopping.FULL_EXPLORATION;
        }
        this.mapOfHashKeys.put(hashKey, (nSolutions = (int)this.solver.solRecorder.found - this.currentOpenNodesNbFoundSolutions[this.solver.depth()]) == 0 ? zero : nSolutions);
    }

    @Override
    public void displayStats() {
        if (!this.stopped) {
            Kit.log.finer("  mapSize=" + this.mapOfHashKeys.size() + "  nbInferences=" + this.nInferences + "  nbInferredSolutions=" + this.nInferredSolutions + "  usedMem=" + Kit.memoryInMb() + "  nbTooLargeKeys=" + this.nTooLargeKeys);
        }
    }
}

