/*
 * Decompiled with CFR 0.152.
 */
package learning;

import learning.Ips;
import learning.IpsRecorder;
import solver.Solver;
import utility.Bit;
import utility.Enums;
import utility.Kit;
import variables.Domain;
import variables.Variable;

public final class IpsRecorderForDominance
extends IpsRecorder {
    protected Ips[] waitingNogoods;
    protected WatchCell[] watches;
    protected WatchCell free;
    protected int nTotalRemovals;
    protected int nWipeouts;
    protected int nIps;
    public int nGeneratedIps;
    private int[] offsets;
    private Ips[] quarantine = new Ips[100];
    private int quarantineSize;
    private int[] topBeforeRefutations;

    public IpsRecorderForDominance(Solver solver) {
        super(solver);
        Kit.control(solver.propagation != null);
        int capacity = 0;
        this.offsets = new int[this.variables.length];
        for (int i = 0; i < this.offsets.length; ++i) {
            this.offsets[i] = capacity;
            capacity += this.variables[i].dom.initSize();
        }
        this.watches = new WatchCell[capacity];
        if (this.reductionOperator.enablePElimination()) {
            this.topBeforeRefutations = new int[this.offsets.length + 1];
        } else {
            this.waitingNogoods = new Ips[this.offsets.length + 1];
        }
        solver.propagation.queue.setStateDominanceManager(this);
    }

    private void insertIps(Ips ips, int accessKey) {
        if (this.free == null) {
            this.watches[accessKey] = new WatchCell(ips, this.watches[accessKey]);
        } else {
            WatchCell cell = this.free;
            this.free = this.free.nextCell;
            cell.state = ips;
            cell.nextCell = this.watches[accessKey];
            this.watches[accessKey] = cell;
        }
    }

    private boolean canFindAnotherWatch(Ips ips, int watchPosition) {
        int x = ips.varNumFor(watchPosition);
        long[] binDom = this.variables[x].dom.binary();
        int a = Bit.firstPositionOfNonInclusion(binDom, ips.binDomFor(watchPosition));
        if (a != -1) {
            this.insertIps(ips, this.offsets[x] + a);
            ips.setIndex(watchPosition, a);
            return true;
        }
        for (int i = 0; i < ips.nums.length; ++i) {
            int y = ips.nums[i];
            if (ips.isWatched(y) || (a = Bit.firstPositionOfNonInclusion(binDom = this.variables[y].dom.binary(), ips.binDoms[i])) == -1) continue;
            this.insertIps(ips, this.offsets[y] + a);
            ips.setWatch(watchPosition, i, a);
            return true;
        }
        return false;
    }

    public boolean checkWatchesOf(int x, int a) {
        int lit = this.offsets[x] + a;
        WatchCell previous = null;
        WatchCell current = this.watches[lit];
        while (current != null) {
            Ips ips = current.state;
            int watch = ips.watchFor(x);
            if (this.canFindAnotherWatch(ips, watch)) {
                WatchCell tmp = current.nextCell;
                if (previous == null) {
                    this.watches[lit] = current.nextCell;
                } else {
                    previous.nextCell = current.nextCell;
                }
                current.nextCell = this.free;
                this.free = current;
                current = tmp;
                continue;
            }
            previous = current;
            current = current.nextCell;
            if (this.dealWithInference(ips, ips.watchVarFor(watch == 0 ? 1 : 0))) continue;
            return false;
        }
        return true;
    }

    private boolean canFindAWatch(Ips ips, int pos) {
        int[] nums = ips.nums;
        for (int i = 0; i < nums.length; ++i) {
            long[] binDom;
            int a;
            if (i == pos || (a = Bit.firstPositionOfNonInclusion(binDom = this.variables[nums[i]].dom.binary(), ips.binDoms[i])) == -1) continue;
            ips.setWatch(pos == -1 ? 0 : 1, i, a);
            return true;
        }
        return false;
    }

    protected boolean dealWithInference(Ips ips, int pos) {
        Variable x = this.variables[ips.nums[pos]];
        long[] domainRepresentation = ips.binDoms[pos];
        Domain dom = x.dom;
        if (x.assigned() && Bit.isPresent(domainRepresentation, dom.first())) {
            this.solver.proofer.updateProof(ips.nums);
            ++this.nWipeouts;
            return false;
        }
        int sizeBefore = dom.size();
        int a = dom.first();
        while (a != -1) {
            if (Bit.isPresent(domainRepresentation, a)) {
                dom.removeElementary(a);
            }
            a = dom.next(a);
        }
        int nRemovals = sizeBefore - dom.size();
        if (nRemovals > 0) {
            this.solver.proofer.updateProof(ips.nums);
            if (dom.size() == 0) {
                ++this.nWipeouts;
            } else {
                this.nTotalRemovals += nRemovals;
            }
            if (!dom.afterElementaryCalls(sizeBefore)) {
                return false;
            }
        }
        return true;
    }

    private boolean manageQuarantine() {
        for (int i = 0; i < this.quarantineSize; ++i) {
            Ips ips = this.quarantine[i];
            int[] nums = ips.nums;
            if (nums.length == 1) {
                if (this.dealWithInference(ips, 0)) continue;
                return false;
            }
            if (!this.canFindAWatch(ips, -1)) {
                this.solver.proofer.updateProof(ips.nums);
                ++this.nWipeouts;
                return false;
            }
            int pos = ips.watchVarFor(0);
            if (this.canFindAWatch(ips, pos)) {
                this.insertIps(ips, this.offsets[ips.varNumFor(0)] + ips.watchIdxFor(0));
                this.insertIps(ips, this.offsets[ips.varNumFor(1)] + ips.watchIdxFor(1));
                --this.quarantineSize;
                this.quarantine[i--] = this.quarantine[this.quarantineSize];
                ++this.nIps;
                continue;
            }
            if (this.dealWithInference(ips, pos)) continue;
            return false;
        }
        return true;
    }

    private void preparePartialBacktrack(int level) {
        int top = this.solver.stackedVariables.top;
        Variable[] stack = this.solver.stackedVariables.stack;
        this.topBeforeRefutations[level] = top;
        if (top == -1 || stack[top].dom.lastRemovedLevel() < level) {
            return;
        }
        int i = top;
        while (stack[i] != null) {
            stack[i].dom.setMark(level);
            --i;
        }
    }

    @Override
    public boolean dealWhenOpeningNode() {
        if (this.reductionOperator.enablePElimination()) {
            this.topBeforeRefutations[this.solver.depth()] = -2;
        }
        if (!this.manageQuarantine() || !this.solver.propagation.propagate()) {
            return false;
        }
        if (this.reductionOperator.enablePElimination()) {
            this.preparePartialBacktrack(this.solver.depth());
        } else {
            this.waitingNogoods[this.solver.depth()] = new Ips(this, this.reductionOperator.extract());
        }
        return true;
    }

    private void performPartialBacktrack(int topBefore, int depth) {
        int i;
        int top = this.solver.stackedVariables.top;
        Variable[] stack = this.solver.stackedVariables.stack;
        if (top == -1 || stack[top].dom.lastRemovedLevel() < depth) {
            return;
        }
        this.solver.stackedVariables.top = topBefore;
        for (i = top; i > topBefore; --i) {
            if (stack[i] == null) {
                assert (i == topBefore + 1);
                return;
            }
            stack[i].dom.restoreBefore(depth);
        }
        i = topBefore;
        while (stack[i] != null) {
            stack[i].dom.restoreAtMark(depth);
            --i;
        }
    }

    @Override
    public void dealWhenClosingNode() {
        int level = this.solver.depth();
        if (level == 0) {
            return;
        }
        Ips ips = null;
        if (this.reductionOperator.enablePElimination()) {
            int topBefore = this.topBeforeRefutations[level];
            if (topBefore == -2) {
                return;
            }
            this.performPartialBacktrack(topBefore, level);
            ips = new Ips(this, this.reductionOperator.extract());
        } else {
            ips = this.waitingNogoods[level];
        }
        assert (ips != null);
        if (ips.nums.length == 0) {
            Kit.log.info("empty nogood");
            this.solver.stopping = Enums.EStopping.FULL_EXPLORATION;
        } else {
            if (this.quarantineSize + 1 > this.quarantine.length) {
                Ips[] t = new Ips[this.quarantine.length * 2];
                System.arraycopy(this.quarantine, 0, t, 0, this.quarantine.length);
                this.quarantine = t;
            }
            this.quarantine[this.quarantineSize++] = ips;
        }
    }

    @Override
    public void displayStats() {
        Kit.log.info("nIps=" + this.nGeneratedIps + " nTotalRemovals=" + this.nTotalRemovals + " nWipeouts=" + this.nWipeouts);
    }

    public void display() {
        Kit.log.fine("nIps = " + this.nIps);
        for (int i = 0; i < this.watches.length; ++i) {
            String s = "Watches for " + this.solver.problem.variables[i] + " ";
            WatchCell cell = this.watches[i];
            while (cell != null) {
                s = s + cell.state.toString();
                cell = cell.nextCell;
            }
            Kit.log.fine(s);
        }
    }

    class WatchCell {
        Ips state;
        WatchCell nextCell;

        WatchCell(Ips state, WatchCell nextCell) {
            this.state = state;
            this.nextCell = nextCell;
        }
    }
}

