/*
 * Decompiled with CFR 0.152.
 */
package learning;

import constraints.Constraint;
import dashboard.Control;
import interfaces.Observers;
import learning.IpsRecorderForDominance;
import learning.IpsRecorderForEquivalence;
import learning.ReductionOperator;
import solver.Solver;
import utility.Enums;
import utility.Kit;
import variables.Domain;
import variables.Variable;

public abstract class IpsRecorder
implements Observers.ObserverRuns {
    protected final Solver solver;
    protected final Variable[] variables;
    public final ReductionOperator reductionOperator;
    protected final Justifier justifier;
    protected final Control.SettingLearning settings;
    public boolean stopped = false;
    public int nInferences;

    public static IpsRecorder buildFor(Solver solver) {
        if (solver.head.control.learning.state == Enums.ELearningIps.EQUIVALENCE) {
            return new IpsRecorderForEquivalence(solver);
        }
        if (solver.head.control.learning.state == Enums.ELearningIps.DOMINANCE) {
            return new IpsRecorderForDominance(solver);
        }
        return null;
    }

    @Override
    public void afterRun() {
        this.displayStats();
    }

    public IpsRecorder(Solver solver) {
        this.solver = solver;
        this.variables = solver.problem.variables;
        this.reductionOperator = new ReductionOperator(this);
        this.justifier = new Justifier(this);
        this.settings = solver.head.control.learning;
    }

    protected boolean mustStop() {
        return Kit.memory() > 600000000L;
    }

    public abstract boolean dealWhenOpeningNode();

    public abstract void dealWhenClosingNode();

    public void displayStats() {
    }

    public static final class Justifier
    implements Observers.ObserverDomainReduction {
        public final Constraint[][] justifications;
        private final Solver solver;

        public Justifier(IpsRecorder recorder) {
            this.solver = recorder.solver;
            if (this.solver.head.control.learning.state != Enums.ELearningIps.NO) {
                Variable[] vars = recorder.solver.problem.variables;
                this.justifications = new Constraint[vars.length][];
                for (int i = 0; i < this.justifications.length; ++i) {
                    Domain dom = vars[i].dom;
                    this.justifications[i] = new Constraint[dom.initSize()];
                    for (int a = 0; a < this.justifications[i].length; ++a) {
                        if (dom.present(a)) continue;
                        this.justifications[i][a] = Constraint.TAG;
                    }
                }
                this.solver.problem.observersDomainReduction.add(this);
            } else {
                this.justifications = null;
            }
        }

        @Override
        public void afterRemoval(Variable x, int a) {
            this.justifications[x.num][a] = this.solver.depth() == 0 ? Constraint.TAG : this.solver.propagation.currFilteringCtr;
        }

        @Override
        public void afterRemovals(Variable x, int nRemovals) {
            Constraint c = this.solver.depth() == 0 ? Constraint.TAG : this.solver.propagation.currFilteringCtr;
            int a = x.dom.lastRemoved();
            for (int cnt = 0; cnt < nRemovals; ++cnt) {
                this.justifications[x.num][a] = c;
                a = x.dom.prevRemoved(a);
            }
        }
    }
}

