/*
 * Decompiled with CFR 0.152.
 */
package learning;

import java.util.stream.IntStream;
import learning.IpsRecorderForDominance;
import utility.Bit;
import utility.Kit;
import variables.Variable;

public final class Ips {
    public static boolean FIRST_WATCH = true;
    public static boolean SECOND_WATCH = false;
    public final int[] nums;
    public final long[][] binDoms;
    private int watchVar0 = -1;
    private int watchVar1 = -1;
    private int watchIdx0 = -1;
    private int watchIdx1 = -1;

    public int varNumFor(int watch) {
        return this.nums[watch == 0 ? this.watchVar0 : this.watchVar1];
    }

    public long[] binDomFor(int watch) {
        return this.binDoms[watch == 0 ? this.watchVar0 : this.watchVar1];
    }

    public int watchVarFor(int watch) {
        return watch == 0 ? this.watchVar0 : this.watchVar1;
    }

    public int watchIdxFor(int watch) {
        return watch == 0 ? this.watchIdx0 : this.watchIdx1;
    }

    public boolean isWatched(int x) {
        return this.nums[this.watchVar0] == x || this.nums[this.watchVar1] == x;
    }

    public int watchFor(int x) {
        return this.nums[this.watchVar0] == x ? 0 : 1;
    }

    public void setIndex(int watchPosition, int a) {
        if (watchPosition == 0) {
            this.watchIdx0 = a;
        } else {
            this.watchIdx1 = a;
        }
    }

    public void setWatch(int watch, int pos, int a) {
        if (watch == 0) {
            this.watchVar0 = pos;
            this.watchIdx0 = a;
        } else {
            this.watchVar1 = pos;
            this.watchIdx1 = a;
        }
    }

    public Ips(IpsRecorderForDominance recorder, int[] nums) {
        this.nums = nums;
        Variable[] variables = recorder.solver.problem.variables;
        this.binDoms = (long[][])IntStream.of(nums).mapToObj(x -> (long[])variables[x].dom.binary().clone()).toArray(x$0 -> new long[x$0][]);
        ++recorder.nGeneratedIps;
    }

    public Ips(IpsRecorderForDominance recorder, Ips ips, boolean[] proof) {
        int cnt = Kit.countIn(true, proof);
        this.nums = new int[cnt];
        this.binDoms = new long[cnt][];
        int j = 0;
        for (int i = 0; i < proof.length; ++i) {
            if (!proof[i]) continue;
            this.nums[j] = i;
            this.binDoms[j] = (long[])recorder.solver.problem.variables[i].dom.binary().clone();
            ++j;
        }
        ++recorder.nGeneratedIps;
    }

    public boolean equals(Object o) {
        int i;
        Ips ips = (Ips)o;
        if (this.nums.length != ips.nums.length) {
            return false;
        }
        for (i = 0; i < this.nums.length; ++i) {
            if (this.nums[i] == ips.nums[i]) continue;
            return false;
        }
        for (i = 0; i < this.binDoms.length; ++i) {
            for (int j = 0; j < this.binDoms[i].length; ++j) {
                if (this.binDoms[i][j] == ips.binDoms[i][j]) continue;
                return false;
            }
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder().append("IPS of size " + this.nums.length + " with watch1 = " + this.watchVar0 + " and watch2 = " + this.watchVar1 + "\n");
        for (int i = 0; i < this.nums.length; ++i) {
            sb.append(this.nums[i] + " : " + Bit.decrypt(this.binDoms[i]) + " \n");
        }
        return sb.append("end\n").toString();
    }
}

