/*
 * Decompiled with CFR 0.152.
 */
package heuristics;

import constraints.Constraint;
import constraints.global.Sum;
import heuristics.HeuristicVariables;
import interfaces.Observers;
import interfaces.Tags;
import java.util.Arrays;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import sets.SetDense;
import solver.Solver;
import utility.Enums;
import utility.Kit;
import variables.Domain;
import variables.Variable;

public abstract class HeuristicVariablesDynamic
extends HeuristicVariables {
    private int lastDepthWithOnlySingletons = Integer.MAX_VALUE;

    public HeuristicVariablesDynamic(Solver solver, boolean antiHeuristic) {
        super(solver, antiHeuristic);
    }

    @Override
    protected final Variable bestUnpriorityVar() {
        Variable x;
        assert (this.solver.futVars.size() > 0);
        if (this.solver.head.control.solving.branching != Enums.EBranching.BIN && (x = this.solver.decRecorder.varOfLastDecisionIf(false)) != null) {
            return x;
        }
        if (this.settings.lc > 0 && (x = this.solver.lastConflict.lastConflictPriorityVar()) != null) {
            return x;
        }
        this.bestScoredVariable.reset(false);
        if (this.settings.singleton == Enums.ESingleton.LAST) {
            if (this.solver.depth() <= this.lastDepthWithOnlySingletons) {
                this.lastDepthWithOnlySingletons = Integer.MAX_VALUE;
                x = this.solver.futVars.first();
                while (x != null) {
                    if (x.dom.size() != 1) {
                        this.bestScoredVariable.update(x, this.scoreOptimizedOf(x));
                    }
                    x = this.solver.futVars.next(x);
                }
            }
            if (this.bestScoredVariable.variable == null) {
                this.lastDepthWithOnlySingletons = this.solver.depth();
                return this.solver.futVars.first();
            }
        } else {
            boolean first = this.settings.singleton == Enums.ESingleton.FIRST;
            Variable x2 = this.solver.futVars.first();
            while (x2 != null) {
                if (first && x2.dom.size() == 1) {
                    return x2;
                }
                this.bestScoredVariable.update(x2, this.scoreOptimizedOf(x2));
                x2 = this.solver.futVars.next(x2);
            }
            if (this.bestScoredVariable.variable == null) {
                return this.solver.futVars.first();
            }
        }
        return this.bestScoredVariable.variable;
    }

    public static final class Impact
    extends ActivityImpactAbstract {
        private double[] impacts;

        @Override
        public void beforeRun() {
            super.beforeRun();
            if (this.solver.restarter.runMultipleOf(this.solver.head.control.restarts.varhResetPeriod)) {
                Kit.log.info("Reset of impacts");
                Arrays.fill(this.impacts, 0.0);
            }
        }

        public Impact(Solver solver, boolean antiHeuristic) {
            super(solver, antiHeuristic);
            this.alpha = 0.1;
            this.impacts = new double[solver.problem.variables.length];
        }

        @Override
        protected void update() {
            double impact = 1.0;
            if (this.solver.depth() > this.lastDepth) {
                for (Variable x : this.solver.futVars) {
                    impact *= (double)x.dom.size() / (double)this.lastSizes[x.num];
                }
            } else {
                impact = 0.0;
            }
            this.impacts[this.lastVar.num] = (1.0 - this.alpha) * this.impacts[this.lastVar.num] + this.alpha * impact;
            assert (0.0 <= impact && impact <= 1.0 && 0.0 <= this.impacts[this.lastVar.num] && this.impacts[this.lastVar.num] <= 1.0);
        }

        @Override
        public double scoreOf(Variable x) {
            return this.impacts[x.num];
        }
    }

    public static final class Activity
    extends ActivityImpactAbstract {
        private double[] activities;

        @Override
        public void beforeRun() {
            super.beforeRun();
            if (this.solver.restarter.runMultipleOf(this.solver.head.control.restarts.varhResetPeriod)) {
                Kit.log.info("Reset of activities");
                Arrays.fill(this.activities, 0.0);
            }
        }

        public Activity(Solver solver, boolean antiHeuristic) {
            super(solver, antiHeuristic);
            this.alpha = 0.99;
            this.activities = new double[solver.problem.variables.length];
        }

        @Override
        protected void update() {
            if (this.solver.depth() > this.lastDepth) {
                this.solver.futVars.execute(x -> {
                    this.activities[x.num] = x.dom.size() != this.lastSizes[x.num] ? this.activities[x.num] + 1.0 : this.activities[x.num] * this.alpha;
                });
            } else {
                int n = this.lastVar.num;
                this.activities[n] = this.activities[n] + 2.0;
            }
        }

        @Override
        public double scoreOf(Variable x) {
            return -this.activities[x.num] / (double)x.dom.size();
        }
    }

    public static abstract class ActivityImpactAbstract
    extends HeuristicVariables
    implements Observers.ObserverRuns {
        protected Variable lastVar;
        protected int lastDepth = -1;
        protected int[] lastSizes;
        protected double alpha;

        @Override
        public void beforeRun() {
            this.lastVar = null;
            this.lastDepth = -1;
            for (int i = 0; i < this.solver.problem.variables.length; ++i) {
                this.lastSizes[i] = this.solver.problem.variables[i].dom.size();
            }
        }

        public ActivityImpactAbstract(Solver solver, boolean antiHeuristic) {
            super(solver, antiHeuristic);
            this.lastSizes = Stream.of(solver.problem.variables).mapToInt(x -> x.dom.size()).toArray();
            Kit.control(solver.head.control.solving.branching == Enums.EBranching.BIN);
            Kit.control(solver.head.control.restarts.varhResetPeriod != 0);
        }

        protected abstract void update();

        @Override
        protected Variable bestUnpriorityVar() {
            assert (this.lastVar != null || this.solver.depth() > this.lastDepth) : this.lastVar + " " + this.solver.depth() + " " + this.lastDepth;
            if (this.lastVar != null) {
                this.update();
            }
            this.bestScoredVariable.reset(true);
            this.solver.futVars.execute(x -> {
                if (x.dom.size() > 1 || this.settings.singleton != Enums.ESingleton.LAST) {
                    this.lastSizes[x.num] = x.dom.size();
                    this.bestScoredVariable.update((Variable)x, this.scoreOptimizedOf((Variable)x));
                }
            });
            if (this.bestScoredVariable.variable == null) {
                assert (this.settings.singleton == Enums.ESingleton.LAST || this.solver.head.control.varh.discardAux);
                return this.solver.futVars.first();
            }
            this.lastVar = this.bestScoredVariable.variable.dom.size() == 1 ? null : this.bestScoredVariable.variable;
            this.lastDepth = this.solver.depth();
            return this.bestScoredVariable.variable;
        }
    }

    public static class WdegOnDom
    extends WdegVariant {
        public WdegOnDom(Solver solver, boolean antiHeuristic) {
            super(solver, antiHeuristic);
        }

        @Override
        public double scoreOf(Variable x) {
            if (this.settings.weighting == Enums.EWeighting.CHS) {
                double d = 0.0;
                for (Constraint c : x.ctrs) {
                    if (c.futvars.size() <= 1) continue;
                    d += this.cscores[c.num];
                }
                return d / (double)x.dom.size();
            }
            return this.vscores[x.num] / (double)x.dom.size();
        }
    }

    public static class Wdeg
    extends WdegVariant {
        public Wdeg(Solver solver, boolean antiHeuristic) {
            super(solver, antiHeuristic);
        }

        @Override
        public double scoreOf(Variable x) {
            if (this.settings.weighting == Enums.EWeighting.CHS) {
                double d = 0.0;
                for (Constraint c : x.ctrs) {
                    if (c.futvars.size() <= 1) continue;
                    d += this.cscores[c.num];
                }
                return d;
            }
            return this.vscores[x.num];
        }
    }

    public static abstract class WdegVariant
    extends HeuristicVariablesDynamic
    implements Observers.ObserverRuns,
    Observers.ObserverAssignment,
    Observers.ObserverConflicts,
    Tags.TagMaximize {
        private int time;
        private int[] ctime;
        public double[] vscores;
        public double[] cscores;
        double[][] cvscores;
        final double SMOOTHING = 0.995;
        final double ALPHA0 = 0.1;
        final double ALPHA_LIMIT = 0.06;
        final double ALPHA_DECREMENT = 1.0E-6;
        double alpha;

        @Override
        public void reset() {
            this.time = 0;
            Arrays.fill(this.ctime, 0);
            Arrays.fill(this.vscores, 0.0);
            Arrays.fill(this.cscores, 0.0);
            for (double[] t : this.cvscores) {
                Arrays.fill(t, 0.0);
            }
        }

        @Override
        public void beforeRun() {
            if (this.solver.restarter.runMultipleOf(this.solver.head.control.restarts.varhResetPeriod) || (this.solver.restarter.numRun - this.solver.solRecorder.lastSolutionRun) % this.solver.head.control.restarts.varhSolResetPeriod == 0) {
                System.out.println("    ...resetting weights (nValues: " + Variable.nValidValuesFor(this.solver.problem.variables) + ")");
                this.reset();
            }
            this.alpha = 0.1;
            if (this.settings.weighting == Enums.EWeighting.CHS) {
                for (int i = 0; i < this.cscores.length; ++i) {
                    int n = i;
                    this.cscores[n] = this.cscores[n] * Math.pow(0.995, this.time - this.ctime[i]);
                }
            }
        }

        @Override
        public void afterAssignment(Variable x, int a) {
            if (this.settings.weighting != Enums.EWeighting.VAR && this.settings.weighting != Enums.EWeighting.CHS) {
                for (Constraint c : x.ctrs) {
                    if (c.futvars.size() != 1) continue;
                    int y = c.futvars.dense[0];
                    int n = c.scp[y].num;
                    this.vscores[n] = this.vscores[n] - this.cvscores[c.num][y];
                }
            }
        }

        @Override
        public void afterUnassignment(Variable x) {
            if (this.settings.weighting != Enums.EWeighting.VAR && this.settings.weighting != Enums.EWeighting.CHS) {
                for (Constraint c : x.ctrs) {
                    if (c.futvars.size() != 2) continue;
                    int y = c.futvars.dense[0];
                    int n = c.scp[y].num;
                    this.vscores[n] = this.vscores[n] + this.cvscores[c.num][y];
                }
            }
        }

        @Override
        public void whenWipeout(Constraint c, Variable x) {
            ++this.time;
            if (this.settings.weighting == Enums.EWeighting.VAR) {
                int n = x.num;
                this.vscores[n] = this.vscores[n] + 1.0;
            } else if (c != null) {
                if (this.settings.weighting == Enums.EWeighting.CHS) {
                    double r = 1.0 / (double)(this.time - this.ctime[c.num]);
                    double increment = this.alpha * (r - this.cscores[c.num]);
                    int n = c.num;
                    this.cscores[n] = this.cscores[n] + increment;
                    this.alpha = Double.max(0.06, this.alpha - 1.0E-6);
                } else {
                    double increment = 1.0;
                    int n = c.num;
                    this.cscores[n] = this.cscores[n] + increment;
                    SetDense futvars = c.futvars;
                    for (int i = futvars.limit; i >= 0; --i) {
                        Variable y = c.scp[futvars.dense[i]];
                        if (this.settings.weighting == Enums.EWeighting.CACD) {
                            Domain dom = y.dom;
                            boolean test = false;
                            if (test) {
                                int depth = this.solver.depth();
                                int nRemoved = 0;
                                int a = dom.lastRemoved();
                                while (a != -1 && dom.removedLevelOf(a) == depth) {
                                    ++nRemoved;
                                    a = dom.prevRemoved(a);
                                }
                                increment = 1.0 / (double)(futvars.size() * (dom.size() + nRemoved));
                            } else {
                                increment = 1.0 / ((double)futvars.size() * (dom.size() == 0 ? 0.5 : (double)dom.size()));
                            }
                        }
                        int n2 = y.num;
                        this.vscores[n2] = this.vscores[n2] + increment;
                        double[] dArray = this.cvscores[c.num];
                        int n3 = futvars.dense[i];
                        dArray[n3] = dArray[n3] + increment;
                    }
                }
                this.ctime[c.num] = this.time;
            }
        }

        public WdegVariant(Solver solver, boolean antiHeuristic) {
            super(solver, antiHeuristic);
            this.ctime = new int[solver.problem.constraints.length];
            this.vscores = new double[solver.problem.variables.length];
            this.cscores = new double[solver.problem.constraints.length];
            this.cvscores = (double[][])Stream.of(solver.problem.constraints).map(c -> new double[c.scp.length]).toArray(x$0 -> new double[x$0][]);
            boolean b = false;
            if (b && solver.problem.optimizer != null && solver.problem.optimizer.ctr instanceof Sum) {
                Sum c2 = (Sum)((Object)solver.problem.optimizer.ctr);
                int[] coeffs = c2 instanceof Sum.SumSimple ? null : ((Sum.SumWeighted)c2).coeffs;
                long[] gaps = IntStream.range(0, c2.scp.length).mapToLong(i -> Math.abs((coeffs == null ? 1 : coeffs[i]) * c.scp[i].dom.intervalValue())).toArray();
                long minGap = LongStream.of(gaps).min().getAsLong();
                for (int i2 = 0; i2 < c2.scp.length; ++i2) {
                    int n = c2.scp[i2].num;
                    this.vscores[n] = this.vscores[n] + (double)(1L + gaps[i2] - minGap);
                }
            }
        }
    }

    public static final class DomThenDeg
    extends HeuristicVariablesDynamic {
        private Kit.CombinatorOfTwoInts combinator;

        public DomThenDeg(Solver solver, boolean antiHeuristic) {
            super(solver, antiHeuristic);
            this.combinator = new Kit.CombinatorOfTwoInts(solver.problem.features.maxVarDegree());
        }

        @Override
        public double scoreOf(Variable x) {
            return this.combinator.combinedMaxMinLongValueFor(x.dom.size(), x.deg());
        }
    }

    public static final class Dom
    extends HeuristicVariablesDynamic {
        public Dom(Solver solver, boolean antiHeuristic) {
            super(solver, antiHeuristic);
        }

        @Override
        public double scoreOf(Variable x) {
            return x.dom.size();
        }
    }

    public static final class DdegOnDom
    extends HeuristicVariablesDynamic
    implements Tags.TagMaximize {
        public DdegOnDom(Solver solver, boolean antiHeuristic) {
            super(solver, antiHeuristic);
        }

        @Override
        public double scoreOf(Variable x) {
            return x.ddegOnDom();
        }
    }

    public static final class Ddeg
    extends HeuristicVariablesDynamic
    implements Tags.TagMaximize {
        public Ddeg(Solver solver, boolean antiHeuristic) {
            super(solver, antiHeuristic);
        }

        @Override
        public double scoreOf(Variable x) {
            return x.ddeg();
        }
    }
}

