/*
 * Decompiled with CFR 0.152.
 */
package heuristics;

import heuristics.HeuristicValues;
import interfaces.Tags;
import variables.Variable;

public abstract class HeuristicValuesDirect
extends HeuristicValues {
    public HeuristicValuesDirect(Variable x, boolean dummy) {
        super(x, dummy);
    }

    @Override
    protected double scoreOf(int a) {
        throw new AssertionError((Object)"The value must be directly selected without any iteration");
    }

    public static final class Values
    extends HeuristicValuesDirect {
        private boolean min;
        private Variable[] others;

        public Values(Variable x, boolean antiHeuristic, Variable[] others) {
            super(x, antiHeuristic);
            this.min = !antiHeuristic;
            this.others = others;
        }

        @Override
        public int identifyBestValueIndex() {
            if (this.dx.size() == 1) {
                return this.dx.first();
            }
            if (this.min) {
                for (Variable y : this.others) {
                    int a;
                    if (y == this.x || y.dom.size() != 1 || (a = this.dx.toPresentIdx(y.dom.firstValue())) < 0) continue;
                    return a;
                }
                return this.dx.first();
            }
            throw new UnsupportedOperationException();
        }
    }

    public static final class Robin
    extends HeuristicValuesDirect {
        int cnt = -1;

        public Robin(Variable x, boolean dummy) {
            super(x, dummy);
        }

        @Override
        public int identifyBestValueIndex() {
            ++this.cnt;
            if (this.cnt % 3 == 0) {
                return this.dx.first();
            }
            if (this.cnt % 3 == 1) {
                return this.dx.last();
            }
            return this.dx.random();
        }
    }

    public static final class RunRobin
    extends HeuristicValuesDirect {
        public RunRobin(Variable x, boolean dummy) {
            super(x, dummy);
        }

        @Override
        public int identifyBestValueIndex() {
            int run = this.x.problem.solver.restarter.numRun;
            if (run % 3 == 0) {
                return this.dx.first();
            }
            if (run % 3 == 1) {
                return this.dx.last();
            }
            return this.dx.random();
        }
    }

    public static final class Rand
    extends HeuristicValuesDirect {
        public Rand(Variable x, boolean dummy) {
            super(x, dummy);
        }

        @Override
        public int identifyBestValueIndex() {
            return this.dx.random();
        }
    }

    public static class ProgressSaving
    extends HeuristicValuesDirect
    implements Tags.TagExperimental {
        private int[] progressSaving;

        public ProgressSaving(Variable x, boolean dummy) {
            super(x, dummy);
        }

        @Override
        public int identifyBestValueIndex() {
            int a = this.progressSaving[this.x.num];
            return a != -1 && this.dx.present(a) ? a : this.dx.first();
        }
    }

    public static final class Median
    extends HeuristicValuesDirect {
        public Median(Variable x, boolean dummy) {
            super(x, dummy);
        }

        @Override
        public int identifyBestValueIndex() {
            int a = this.dx.first();
            for (int cnt = this.dx.size() / 2; cnt > 0; --cnt) {
                a = this.dx.next(a);
            }
            return a;
        }
    }

    public static final class Last
    extends HeuristicValuesDirect {
        public Last(Variable x, boolean dummy) {
            super(x, dummy);
        }

        @Override
        public int identifyBestValueIndex() {
            return this.dx.last();
        }
    }

    public static final class First
    extends HeuristicValuesDirect {
        public First(Variable x, boolean dummy) {
            super(x, dummy);
        }

        @Override
        public int identifyBestValueIndex() {
            return this.dx.first();
        }
    }
}

