/*
 * Decompiled with CFR 0.152.
 */
package heuristics;

import dashboard.Control;
import heuristics.Heuristic;
import heuristics.HeuristicValuesDynamic;
import interfaces.Tags;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import solver.Solver;
import utility.Kit;
import variables.Domain;
import variables.Variable;

public abstract class HeuristicValues
extends Heuristic {
    protected final Variable x;
    protected final Domain dx;
    protected Control.SettingValh settings;

    public HeuristicValues(Variable x, boolean antiHeuristic) {
        super(antiHeuristic);
        this.x = x;
        this.dx = x.dom;
        this.settings = x.problem.head.control.valh;
    }

    protected abstract double scoreOf(int var1);

    protected abstract int identifyBestValueIndex();

    public int bestIndex() {
        int a;
        Solver solver = this.x.problem.solver;
        if (solver.solRecorder.found == 0L) {
            int a2;
            if (this.settings.warmStart.length() > 0) {
                int a3 = solver.warmStarter.valueOf(this.x);
                if (a3 != -1 && this.dx.present(a3)) {
                    return a3;
                }
            } else if (this.settings.runProgressSaving && (a2 = solver.runProgressSaver.valueOf(this.x)) != -1 && this.dx.present(a2)) {
                return a2;
            }
        } else if (this.settings.solutionSaving && !(this instanceof HeuristicValuesDynamic.Bivs2) && solver.restarter.numRun % this.settings.solutionSavingGap != 0 && this.dx.present(a = solver.solRecorder.lastSolution[this.x.num])) {
            return a;
        }
        return this.identifyBestValueIndex();
    }

    public static abstract class HeuristicValuesFixed
    extends HeuristicValues {
        private final int[] fixed;

        public HeuristicValuesFixed(Variable x, boolean antiHeuristic) {
            super(x, antiHeuristic);
            Map<Integer, Double> map = IntStream.range(0, this.dx.initSize()).filter(a -> this.dx.present(a)).boxed().collect(Collectors.toMap(a -> a, a -> this.scoreOf((int)a) * (double)this.scoreCoeff));
            map = Kit.sort(map, (e1, e2) -> (Double)e1.getValue() > (Double)e2.getValue() ? -1 : ((Double)e1.getValue() < (Double)e2.getValue() ? 1 : (Integer)e1.getKey() - (Integer)e2.getKey()));
            this.fixed = map.entrySet().stream().mapToInt(e -> (Integer)e.getKey()).toArray();
        }

        @Override
        protected final int identifyBestValueIndex() {
            assert (this.dx.size() > 0) : "The domain is empty";
            for (int a : this.fixed) {
                if (!this.dx.present(a)) continue;
                return a;
            }
            throw new AssertionError();
        }

        public static final class Srand
        extends HeuristicValuesFixed {
            public Srand(Variable x, boolean antiHeuristic) {
                super(x, antiHeuristic);
            }

            @Override
            public double scoreOf(int a) {
                return this.x.problem.head.random.nextDouble();
            }
        }

        public static class LetterFrequency
        extends HeuristicValuesFixed
        implements Tags.TagExperimental {
            private static int[] letterPositionsFr = new int[]{2, 17, 11, 10, 0, 16, 18, 19, 3, 20, 25, 8, 13, 5, 9, 12, 15, 6, 1, 4, 7, 14, 24, 21, 22, 23};

            public LetterFrequency(Variable x, boolean antiHeuristic) {
                super(x, antiHeuristic);
            }

            @Override
            public double scoreOf(int a) {
                return letterPositionsFr[a];
            }
        }
    }
}

