/*
 * Decompiled with CFR 0.152.
 */
package dashboard;

import interfaces.Observers;
import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Map;
import main.Head;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xcsp.common.Utilities;
import problem.Features;
import utility.Enums;
import utility.Kit;

public class Output
implements Observers.ObserverConstruction,
Observers.ObserverSearch,
Observers.ObserverRuns {
    public static final String RESULTS_DIRECTORY = "results";
    public static final String SETTINGS_DIRECTORY = "configurations";
    public static final String CONTEXT_DIRECTORY = "context";
    public static final String MULTITHREAD_RESULTS = "multithreadResults";
    public static final String CONFIGURATION_FILE_NAME = "configurationFileName";
    public static final String TOTAL_WCK_TIME = "totalWckTime";
    public static final String INSTANCE = "Instance";
    public static final String DOMAINS = "Domains";
    public static final String VARIABLES = "Variables";
    public static final String CONSTRAINTS = "Constraints";
    public static final String OBJECTIVE = "Objective";
    public static final String RUN = "Run";
    public static final String NUMBER = "number";
    public static final String NAME = "name";
    public static final String NTYPES = "nTypes";
    public static final String NVALUES = "nValues";
    public static final String COUNT = "count";
    public static final String DEGREES = "degrees";
    public static final String ARITIES = "arities";
    public static final String SIZES = "sizes";
    public static final String TYPES = "types";
    public static final String TABLES = "tables";
    public static final String BOUNDS = "bounds";
    public static final String WCK = "wck";
    public static final String CPU = "cpu";
    public static final String MEM = "mem";
    public static final String N_NODES = "nNodes";
    public static final String COMMENT_PREFIX = "  ";
    private final Head head;
    private Document document;
    private Element root;
    private Element resolElt;
    private Element solverElt;
    private String outputFileName;

    public static String getOutputFileNamePrefixFrom(String fullInstanceName, String fullConfigurationName) {
        return Kit.getRawInstanceName(fullInstanceName) + (fullConfigurationName != null ? "_" + Kit.getXMLBaseNameOf(fullConfigurationName) + "_" : "");
    }

    public Output(Head head, String configFileName) {
        this.head = head;
        if (!head.control.xml.dirForCampaign.equals("")) {
            this.document = Kit.createNewDocument();
            this.root = this.document.createElement(Enums.TypeOutput.RESOLUTIONS.toString());
            this.root.setAttribute(CONFIGURATION_FILE_NAME, configFileName);
            this.document.appendChild(this.root);
            this.document.normalize();
        }
    }

    public String outputFileNameFrom(String fullInstanceName, String configurationFileName) {
        String hostName = "unknown";
        try {
            hostName = InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        return Output.getOutputFileNamePrefixFrom(fullInstanceName, configurationFileName) + hostName + "_" + Kit.date() + ".xml";
    }

    public Element record(Enums.TypeOutput output, Collection<Map.Entry<String, Object>> entries, Element parent) {
        if (this.document == null) {
            return null;
        }
        Element child = Utilities.element(this.document, output.toString(), entries);
        if (parent == null) {
            this.root.appendChild(child);
        } else {
            parent.appendChild(child);
        }
        return child;
    }

    public void beforeData() {
        this.resolElt = this.record(Enums.TypeOutput.RESOLUTION, null, this.root);
        this.save(this.head.instanceStopwatch.wckTime());
    }

    public void afterData() {
        Features.MapAtt ia = this.head.problem.features.instanceAttributes(this.head.instanceNumber);
        String name = ia.entries().stream().filter(e -> ((String)e.getKey()).equals(NAME)).map(e -> e.getValue().toString()).findFirst().get();
        this.outputFileName = this.outputFileNameFrom(name, this.head.control.settingsFilename);
        Kit.log.config(COMMENT_PREFIX + Kit.preprint("Instance ", "\u001b[94m") + name + "\n");
        this.record(Enums.TypeOutput.INSTANCE, ia.entries(), this.resolElt);
    }

    @Override
    public void afterProblemConstruction() {
        Kit.control(this.head.problem.variables.length > 0, () -> "No variable in your model");
        Features.MapAtt da = this.head.problem.features.domainsAttributes();
        Features.MapAtt va = this.head.problem.features.variablesAttributes();
        Features.MapAtt ca = this.head.problem.features.ctrsAttributes();
        Features.MapAtt oa = this.head.problem.optimizer != null ? this.head.problem.features.objsAttributes() : null;
        this.record(Enums.TypeOutput.DOMAINS, da.entries(), this.resolElt);
        this.record(Enums.TypeOutput.VARIABLES, va.entries(), this.resolElt);
        this.record(Enums.TypeOutput.CONSTRAINTS, ca.entries(), this.resolElt);
        if (oa != null) {
            this.record(Enums.TypeOutput.OBJECTIVE, oa.entries(), this.resolElt);
        }
        Kit.log.config("\n" + da.toString());
        Kit.log.config(va.toString());
        Kit.log.config(ca.toString());
        if (oa != null) {
            Kit.log.config(oa.toString());
        }
    }

    @Override
    public void afterSolverConstruction() {
        Features.MapAtt sa = this.head.solver.stats.solverConstructionAttributes();
        this.solverElt = this.record(Enums.TypeOutput.SOLVER, sa.entries(), this.resolElt);
        Kit.log.config("\n" + sa.toString());
    }

    @Override
    public final void afterPreprocessing() {
        Features.MapAtt pa = this.head.solver.stats.preproAttributes();
        this.record(Enums.TypeOutput.PREPROCESSING, pa.entries(), this.solverElt);
        Kit.log.config("\n" + pa.toString() + "\n");
    }

    @Override
    public final void afterRun() {
        Features.MapAtt ra = this.head.solver.stats.runAttributes();
        this.record(Enums.TypeOutput.RUN, ra.entries(), this.solverElt);
        Kit.log.config(ra.toString());
    }

    @Override
    public final void afterSolving() {
        Features.MapAtt ga = this.head.solver.stats.globalAttributes();
        this.record(Enums.TypeOutput.GLOBAL, ga.entries(), this.solverElt);
        Kit.log.config("\n" + ga.toString());
    }

    public String save(long totalWck) {
        if (this.document == null) {
            return null;
        }
        this.root.setAttribute(TOTAL_WCK_TIME, totalWck + "");
        String dirName = this.head.control.xml.dirForCampaign + File.separator + RESULTS_DIRECTORY;
        File file = new File(dirName);
        if (!file.exists()) {
            file.mkdirs();
        }
        return Utilities.save(this.document, dirName + File.separator + this.outputFileName);
    }
}

