/*
 * Decompiled with CFR 0.152.
 */
package constraints.intension;

import constraints.Constraint;
import constraints.global.Sum;
import constraints.intension.Primitive;
import constraints.intension.PrimitiveBinary;
import interfaces.Tags;
import java.math.BigInteger;
import org.xcsp.common.Types;
import org.xcsp.common.Utilities;
import problem.Problem;
import utility.Kit;
import variables.Domain;
import variables.Variable;

public abstract class PrimitiveTernary
extends Primitive
implements Tags.TagAC,
Tags.TagFilteringCompleteAtEachCall,
Tags.TagNotSymmetric {
    Variable x;
    Variable y;
    Variable z;
    Domain dx;
    Domain dy;
    Domain dz;
    int[] rx;
    int[] ry;
    int[] rzx;
    int[] rzy;

    public static Constraint buildFrom(Problem pb, Variable x, Types.TypeArithmeticOperator aop, Variable y, Types.TypeConditionOperatorRel op, Variable z) {
        switch (aop) {
            case ADD: {
                return PrimitiveTernaryAdd.buildFrom(pb, x, y, op, z);
            }
            case SUB: {
                return PrimitiveTernarySub.buildFrom(pb, x, y, op, z);
            }
            case MUL: {
                return PrimitiveTernaryMul.buildFrom(pb, x, y, op, z);
            }
            case DIV: {
                return PrimitiveTernaryDiv.buildFrom(pb, x, y, op, z);
            }
            case MOD: {
                return PrimitiveTernaryMod.buildFrom(pb, x, y, op, z);
            }
            case DIST: {
                return PrimitiveTernaryDist.buildFrom(pb, x, y, op, z);
            }
        }
        return null;
    }

    public PrimitiveTernary(Problem pb, Variable x, Variable y, Variable z) {
        super(pb, (Variable[])pb.api.vars(x, new Variable[]{y, z}));
        this.x = x;
        this.y = y;
        this.z = z;
        this.dx = x.dom;
        this.dy = y.dom;
        this.dz = z.dom;
    }

    protected void buildThreeResidueStructure() {
        this.rx = new int[this.dx.initSize()];
        this.ry = new int[this.dy.initSize()];
        this.rzx = new int[this.dz.initSize()];
    }

    protected void buildFourResidueStructure() {
        this.rx = new int[this.dx.initSize()];
        this.ry = new int[this.dy.initSize()];
        this.rzx = Kit.repeat(-1, this.dz.initSize());
        this.rzy = Kit.repeat(-1, this.dz.initSize());
    }

    public static abstract class PrimitiveTernaryLog
    extends PrimitiveTernary {
        public static Constraint buildFrom(Problem pb, Variable x, Variable y, Types.TypeConditionOperatorRel op, Variable z) {
            switch (op) {
                case LT: {
                    return new LogLT3(pb, x, y, z);
                }
                case LE: {
                    return new LogLE3(pb, x, y, z);
                }
                case GE: {
                    return new LogGE3(pb, x, y, z);
                }
                case GT: {
                    return new LogGT3(pb, x, y, z);
                }
                case EQ: {
                    return new LogEQ3(pb, x, y, z);
                }
                case NE: {
                    return new LogNE3(pb, x, y, z);
                }
            }
            throw new AssertionError();
        }

        public PrimitiveTernaryLog(Problem pb, Variable x, Variable y, Variable z) {
            super(pb, x, y, z);
            this.control(this.dx.is01(), "The first variable should be of type 01");
        }

        public static final class LogNE3
        extends PrimitiveTernaryLog {
            int residue;

            @Override
            public final boolean checkValues(int[] t) {
                return t[0] == 1 == (t[1] != t[2]);
            }

            public LogNE3(Problem pb, Variable x, Variable y, Variable z) {
                super(pb, x, y, z);
            }

            @Override
            public boolean runPropagator(Variable dummy) {
                int v;
                if (this.dy.size() == 1 && this.dz.size() == 1) {
                    return this.dx.removeIfPresent(this.dy.firstValue() != this.dz.firstValue() ? 0 : 1);
                }
                if (this.dx.last() == 0) {
                    return PrimitiveBinary.enforceEQ(this.dy, this.dz);
                }
                if (this.dx.first() == 1) {
                    return this.dy.size() > 1 && this.dz.size() > 1 || PrimitiveBinary.enforceNE(this.dy, this.dz) && this.entailed();
                }
                assert (this.dx.size() == 2);
                if (this.dy.presentValue(this.residue) && this.dz.presentValue(this.residue)) {
                    return true;
                }
                int n = v = this.dy.size() <= this.dz.size() ? this.dy.firstCommonValueWith(this.dz) : this.dz.firstCommonValueWith(this.dy);
                if (v == Integer.MAX_VALUE) {
                    this.dx.removeSafely(0);
                    return this.entailed();
                }
                this.residue = v;
                return true;
            }
        }

        public static final class LogEQ3
        extends PrimitiveTernaryLog {
            private int residue;

            @Override
            public final boolean checkValues(int[] t) {
                return t[0] == 1 == (t[1] == t[2]);
            }

            public LogEQ3(Problem pb, Variable x, Variable y, Variable z) {
                super(pb, x, y, z);
            }

            @Override
            public boolean runPropagator(Variable dummy) {
                int v;
                if (this.dy.size() == 1 && this.dz.size() == 1) {
                    return this.dx.removeIfPresent(this.dy.firstValue() == this.dz.firstValue() ? 0 : 1);
                }
                if (this.dx.last() == 0) {
                    return this.dy.size() > 1 && this.dz.size() > 1 || PrimitiveBinary.enforceNE(this.dy, this.dz) && this.entailed();
                }
                if (this.dx.first() == 1) {
                    return PrimitiveBinary.enforceEQ(this.dy, this.dz);
                }
                assert (this.dx.size() == 2);
                if (this.dy.presentValue(this.residue) && this.dz.presentValue(this.residue)) {
                    return true;
                }
                int n = v = this.dy.size() <= this.dz.size() ? this.dy.firstCommonValueWith(this.dz) : this.dz.firstCommonValueWith(this.dy);
                if (v == Integer.MAX_VALUE) {
                    this.dx.removeSafely(1);
                    return this.entailed();
                }
                this.residue = v;
                return true;
            }
        }

        public static final class LogGT3
        extends PrimitiveTernaryLog {
            @Override
            public final boolean checkValues(int[] t) {
                return t[0] == 1 == t[1] > t[2];
            }

            public LogGT3(Problem pb, Variable x, Variable y, Variable z) {
                super(pb, x, y, z);
            }

            @Override
            public boolean runPropagator(Variable dummy) {
                if (this.dx.last() == 0) {
                    return PrimitiveBinary.enforceLE(this.dy, this.dz);
                }
                if (this.dx.first() == 1) {
                    return PrimitiveBinary.enforceGT(this.dy, this.dz);
                }
                if (this.dy.firstValue() > this.dz.lastValue()) {
                    return this.dx.removeIfPresent(0);
                }
                if (this.dy.lastValue() <= this.dz.firstValue()) {
                    return this.dx.removeIfPresent(1);
                }
                return true;
            }
        }

        public static final class LogGE3
        extends PrimitiveTernaryLog {
            @Override
            public final boolean checkValues(int[] t) {
                return t[0] == 1 == t[1] >= t[2];
            }

            public LogGE3(Problem pb, Variable x, Variable y, Variable z) {
                super(pb, x, y, z);
            }

            @Override
            public boolean runPropagator(Variable dummy) {
                if (this.dx.last() == 0) {
                    return PrimitiveBinary.enforceLT(this.dy, this.dz);
                }
                if (this.dx.first() == 1) {
                    return PrimitiveBinary.enforceGE(this.dy, this.dz);
                }
                if (this.dy.firstValue() >= this.dz.lastValue()) {
                    return this.dx.removeIfPresent(0);
                }
                if (this.dy.lastValue() < this.dz.firstValue()) {
                    return this.dx.removeIfPresent(1);
                }
                return true;
            }
        }

        public static final class LogLE3
        extends PrimitiveTernaryLog {
            @Override
            public final boolean checkValues(int[] t) {
                return t[0] == 1 == t[1] <= t[2];
            }

            public LogLE3(Problem pb, Variable x, Variable y, Variable z) {
                super(pb, x, y, z);
            }

            @Override
            public boolean runPropagator(Variable dummy) {
                if (this.dx.last() == 0) {
                    return PrimitiveBinary.enforceGT(this.dy, this.dz);
                }
                if (this.dx.first() == 1) {
                    return PrimitiveBinary.enforceLE(this.dy, this.dz);
                }
                if (this.dy.lastValue() <= this.dz.firstValue()) {
                    return this.dx.removeIfPresent(0);
                }
                if (this.dy.firstValue() > this.dz.lastValue()) {
                    return this.dx.removeIfPresent(1);
                }
                return true;
            }
        }

        public static final class LogLT3
        extends PrimitiveTernaryLog {
            @Override
            public final boolean checkValues(int[] t) {
                return t[0] == 1 == t[1] < t[2];
            }

            public LogLT3(Problem pb, Variable x, Variable y, Variable z) {
                super(pb, x, y, z);
            }

            @Override
            public boolean runPropagator(Variable dummy) {
                if (this.dx.last() == 0) {
                    return PrimitiveBinary.enforceGE(this.dy, this.dz);
                }
                if (this.dx.first() == 1) {
                    return PrimitiveBinary.enforceLT(this.dy, this.dz);
                }
                if (this.dy.lastValue() < this.dz.firstValue()) {
                    return this.dx.removeIfPresent(0);
                }
                if (this.dy.firstValue() >= this.dz.lastValue()) {
                    return this.dx.removeIfPresent(1);
                }
                return true;
            }
        }
    }

    public static abstract class PrimitiveTernaryDist
    extends PrimitiveTernary {
        public static Constraint buildFrom(Problem pb, Variable x, Variable y, Types.TypeConditionOperatorRel op, Variable z) {
            switch (op) {
                case EQ: {
                    return new DistEQ3(pb, x, y, z);
                }
            }
            return null;
        }

        public PrimitiveTernaryDist(Problem pb, Variable x, Variable y, Variable z) {
            super(pb, x, y, z);
        }

        public static final class DistEQ3
        extends PrimitiveTernaryDist {
            boolean multidirectional = true;

            @Override
            public final boolean checkValues(int[] t) {
                return Math.abs(t[0] - t[1]) == t[2];
            }

            public DistEQ3(Problem pb, Variable x, Variable y, Variable z) {
                super(pb, x, y, z);
                this.buildFourResidueStructure();
            }

            private boolean supportx(Domain d, int v, int a, int b, int c) {
                if (d.presentValue(v)) {
                    this.rx[a] = b;
                    if (this.multidirectional) {
                        this.ry[b] = a;
                        this.rzx[c] = a;
                        this.rzy[c] = b;
                    }
                    return true;
                }
                return false;
            }

            private boolean supporty(Domain d, int v, int a, int b, int c) {
                if (d.presentValue(v)) {
                    this.ry[b] = a;
                    if (this.multidirectional) {
                        this.rzx[c] = a;
                        this.rzy[c] = b;
                    }
                    return true;
                }
                return false;
            }

            private boolean supportz(Domain d, int v, int a, int b, int c) {
                if (d.presentValue(v)) {
                    this.rzx[c] = a;
                    this.rzy[c] = b;
                    return true;
                }
                return false;
            }

            @Override
            public boolean runPropagator(Variable dummy) {
                int va;
                int a;
                int vb;
                int c;
                int vc;
                int b;
                int a2 = this.dx.first();
                while (a2 != -1) {
                    block27: {
                        int va2 = this.dx.toVal(a2);
                        if (!this.dy.present(this.rx[a2]) || !this.dz.presentValue(Math.abs(va2 - this.dy.toVal(this.rx[a2])))) {
                            if (this.dy.size() <= this.dz.size()) {
                                b = this.dy.first();
                                while (b != -1) {
                                    vc = Math.abs(va2 - this.dy.toVal(b));
                                    if (!this.supportx(this.dz, vc, a2, b, this.dz.toIdx(vc))) {
                                        b = this.dy.next(b);
                                        continue;
                                    }
                                    break block27;
                                }
                            } else {
                                c = this.dz.first();
                                while (c != -1) {
                                    vb = va2 - this.dz.toVal(c);
                                    if (!this.supportx(this.dy, vb, a2, this.dy.toIdx(vb), c) && !this.supportx(this.dy, vb = va2 + this.dz.toVal(c), a2, this.dy.toIdx(vb), c)) {
                                        c = this.dz.next(c);
                                        continue;
                                    }
                                    break block27;
                                }
                            }
                            if (!this.dx.remove(a2)) {
                                return false;
                            }
                        }
                    }
                    a2 = this.dx.next(a2);
                }
                int b2 = this.dy.first();
                while (b2 != -1) {
                    block28: {
                        int vb2 = this.dy.toVal(b2);
                        if (!this.dx.present(this.ry[b2]) || !this.dz.presentValue(Math.abs(vb2 - this.dx.toVal(this.ry[b2])))) {
                            if (this.dx.size() <= this.dz.size()) {
                                a = this.dx.first();
                                while (a != -1) {
                                    vc = Math.abs(vb2 - this.dx.toVal(a));
                                    if (!this.supporty(this.dz, vc, a, b2, this.dz.toIdx(vc))) {
                                        a = this.dx.next(a);
                                        continue;
                                    }
                                    break block28;
                                }
                            } else {
                                c = this.dz.first();
                                while (c != -1) {
                                    va = vb2 - this.dz.toVal(c);
                                    if (!this.supporty(this.dx, va, this.dx.toIdx(va), b2, c) && !this.supporty(this.dx, va = vb2 + this.dz.toVal(c), this.dx.toIdx(va), b2, c)) {
                                        c = this.dz.next(c);
                                        continue;
                                    }
                                    break block28;
                                }
                            }
                            if (!this.dy.remove(b2)) {
                                return false;
                            }
                        }
                    }
                    b2 = this.dy.next(b2);
                }
                int c2 = this.dz.first();
                while (c2 != -1) {
                    block29: {
                        int vc2 = this.dz.toVal(c2);
                        if (this.rzx[c2] == -1 || !this.dx.present(this.rzx[c2]) || !this.dy.present(this.rzy[c2])) {
                            if (this.dx.size() <= this.dy.size()) {
                                a = this.dx.first();
                                while (a != -1) {
                                    vb = this.dx.toVal(a) - vc2;
                                    if (!this.supportz(this.dy, vb, a, this.dy.toIdx(vb), c2) && !this.supportz(this.dy, vb = this.dx.toVal(a) + vc2, a, this.dy.toIdx(vb), c2)) {
                                        a = this.dx.next(a);
                                        continue;
                                    }
                                    break block29;
                                }
                            } else {
                                b = this.dy.first();
                                while (b != -1) {
                                    va = this.dy.toVal(b) - vc2;
                                    if (!this.supportz(this.dx, va, this.dx.toIdx(va), b, c2) && !this.supportz(this.dx, va = this.dy.toVal(b) + vc2, this.dx.toIdx(va), b, c2)) {
                                        b = this.dy.next(b);
                                        continue;
                                    }
                                    break block29;
                                }
                            }
                            if (!this.dz.remove(c2)) {
                                return false;
                            }
                        }
                    }
                    c2 = this.dz.next(c2);
                }
                return true;
            }
        }
    }

    public static abstract class PrimitiveTernaryMod
    extends PrimitiveTernary {
        public static Constraint buildFrom(Problem pb, Variable x, Variable y, Types.TypeConditionOperatorRel op, Variable z) {
            switch (op) {
                case EQ: {
                    return new ModEQ3(pb, x, y, z);
                }
            }
            return null;
        }

        public PrimitiveTernaryMod(Problem pb, Variable x, Variable y, Variable z) {
            super(pb, x, y, z);
        }

        public static final class ModEQ3
        extends PrimitiveTernaryMod {
            @Override
            public final boolean checkValues(int[] t) {
                return t[0] % t[1] == t[2];
            }

            public ModEQ3(Problem pb, Variable x, Variable y, Variable z) {
                super(pb, x, y, z);
                this.buildFourResidueStructure();
                this.control(x.dom.firstValue() >= 0 && y.dom.firstValue() > 0 && z.dom.firstValue() >= 0);
            }

            @Override
            public boolean runPropagator(Variable dummy) {
                int vb;
                int b;
                int a = this.dx.first();
                while (a != -1) {
                    block23: {
                        int va = this.dx.toVal(a);
                        if (!(va < this.dy.lastValue() && this.dz.presentValue(va) || this.dy.present(this.rx[a]) && this.dz.presentValue(va % this.dy.toVal(this.rx[a])))) {
                            b = this.dy.first();
                            while (b != -1 && va >= (vb = this.dy.toVal(b))) {
                                if (this.dz.presentValue(va % vb)) {
                                    this.rx[a] = b;
                                    break block23;
                                }
                                b = this.dy.next(b);
                            }
                            if (!this.dx.remove(a)) {
                                return false;
                            }
                        }
                    }
                    a = this.dx.next(a);
                }
                int b2 = this.dy.first();
                while (b2 != -1) {
                    block24: {
                        int vb2 = this.dy.toVal(b2);
                        if (vb2 <= this.dz.firstValue()) {
                            if (!this.dy.remove(b2)) {
                                return false;
                            }
                        } else if (!this.dx.present(this.ry[b2]) || !this.dz.presentValue(this.dx.toVal(this.ry[b2]) % vb2)) {
                            int a2 = this.dx.first();
                            while (a2 != -1) {
                                int vc = this.dx.toVal(a2) % vb2;
                                if (this.dz.presentValue(vc)) {
                                    this.ry[b2] = a2;
                                    break block24;
                                }
                                a2 = this.dx.next(a2);
                            }
                            if (!this.dy.remove(b2)) {
                                return false;
                            }
                        }
                    }
                    b2 = this.dy.next(b2);
                }
                if (!this.dz.removeValuesGE(this.dy.lastValue())) {
                    return false;
                }
                int c = this.dz.first();
                while (c != -1) {
                    block25: {
                        int vc = this.dz.toVal(c);
                        if (this.rzx[c] == -1 || !this.dx.present(this.rzx[c]) || !this.dy.present(this.rzy[c])) {
                            b = this.dy.last();
                            while (b != -1 && (vb = this.dy.toVal(b)) > vc) {
                                int nMultiples = this.dx.lastValue() / vb;
                                if (this.dx.size() <= nMultiples) {
                                    int a3 = this.dx.first();
                                    while (a3 != -1) {
                                        if (this.dx.toVal(a3) % vb == vc) {
                                            this.rzx[c] = a3;
                                            this.rzy[c] = b;
                                            break block25;
                                        }
                                        a3 = this.dx.next(a3);
                                    }
                                } else {
                                    for (int multiple = vc; multiple <= this.dx.lastValue(); multiple += vb) {
                                        if (!this.dx.presentValue(multiple)) continue;
                                        this.rzx[c] = this.dx.toIdx(multiple);
                                        this.rzy[c] = b;
                                        break block25;
                                    }
                                }
                                b = this.dy.prev(b);
                            }
                            if (!this.dz.remove(c)) {
                                return false;
                            }
                        }
                    }
                    c = this.dz.next(c);
                }
                return true;
            }
        }
    }

    public static abstract class PrimitiveTernaryDiv
    extends PrimitiveTernary {
        public static Constraint buildFrom(Problem pb, Variable x, Variable y, Types.TypeConditionOperatorRel op, Variable z) {
            switch (op) {
                case EQ: {
                    return new DivEQ3(pb, x, y, z);
                }
            }
            return null;
        }

        public PrimitiveTernaryDiv(Problem pb, Variable x, Variable y, Variable z) {
            super(pb, x, y, z);
        }

        public static final class DivEQ3
        extends PrimitiveTernaryDiv {
            @Override
            public final boolean checkValues(int[] t) {
                return t[0] / t[1] == t[2];
            }

            public DivEQ3(Problem pb, Variable x, Variable y, Variable z) {
                super(pb, x, y, z);
                this.buildFourResidueStructure();
                this.control(x.dom.firstValue() >= 0 && y.dom.firstValue() > 0 && z.dom.firstValue() >= 0);
            }

            @Override
            public boolean runPropagator(Variable dummy) {
                int va;
                int a;
                if (this.dx.size() * this.dy.size() > 200) {
                    if (!this.dz.removeValuesLT(this.dx.firstValue() / this.dy.lastValue()) || !this.dz.removeValuesGT(this.dx.lastValue() / this.dy.firstValue())) {
                        return false;
                    }
                    return PrimitiveBinary.enforceDivGE(this.dx, this.dy, this.dz.firstValue()) && PrimitiveBinary.enforceDivLE(this.dx, this.dy, this.dz.lastValue());
                }
                if (this.dx.firstValue() >= this.dy.lastValue() && !this.dz.removeValueIfPresent(0)) {
                    return false;
                }
                boolean zero = this.dz.presentValue(0);
                if (!zero || this.dx.lastValue() >= this.dy.lastValue()) {
                    int a2 = this.dx.first();
                    while (a2 != -1) {
                        block30: {
                            int va2 = this.dx.toVal(a2);
                            if (va2 == 0) {
                                if (!zero && !this.dx.remove(a2)) {
                                    return false;
                                }
                            } else if (!(zero && va2 < this.dy.lastValue() || this.dy.present(this.rx[a2]) && this.dz.presentValue(va2 / this.dy.toVal(this.rx[a2])))) {
                                int vc;
                                int b = this.dy.first();
                                while (b != -1 && (vc = va2 / this.dy.toVal(b)) >= this.dz.firstValue()) {
                                    if (this.dz.presentValue(vc)) {
                                        this.rx[a2] = b;
                                        break block30;
                                    }
                                    b = this.dy.next(b);
                                }
                                if (!this.dx.remove(a2)) {
                                    return false;
                                }
                            }
                        }
                        a2 = this.dx.next(a2);
                    }
                }
                if (!zero || !this.dx.presentValue(0)) {
                    int b = this.dy.first();
                    while (b != -1) {
                        block31: {
                            int vb = this.dy.toVal(b);
                            if (zero && this.dx.firstValue() < vb) break;
                            if (!this.dx.present(this.ry[b]) || !this.dz.presentValue(this.dx.toVal(this.ry[b]) / vb)) {
                                a = this.dx.last();
                                while (a != -1) {
                                    va = this.dx.toVal(a);
                                    if (va < vb) {
                                        assert (!zero);
                                        break;
                                    }
                                    if (this.dz.presentValue(va / vb)) {
                                        this.ry[b] = a;
                                        break block31;
                                    }
                                    a = this.dx.prev(a);
                                }
                                if (!this.dy.remove(b)) {
                                    return false;
                                }
                            }
                        }
                        b = this.dy.next(b);
                    }
                }
                int c = this.dz.first();
                while (c != -1) {
                    block32: {
                        int vc = this.dz.toVal(c);
                        if (vc == 0) {
                            assert (this.dx.firstValue() < this.dy.lastValue());
                        } else if (this.rzx[c] == -1 || !this.dx.present(this.rzx[c]) || !this.dy.present(this.rzy[c])) {
                            a = this.dx.first();
                            while (a != -1 && (va = this.dx.toVal(a)) / this.dy.lastValue() <= vc) {
                                if (va / this.dy.firstValue() >= vc) {
                                    int res;
                                    int b = this.dy.first();
                                    while (b != -1 && (res = va / this.dy.toVal(b)) >= vc) {
                                        if (res == vc) {
                                            this.rzx[c] = a;
                                            this.rzy[c] = b;
                                            break block32;
                                        }
                                        b = this.dy.next(b);
                                    }
                                }
                                a = this.dx.next(a);
                            }
                            if (!this.dz.remove(c)) {
                                return false;
                            }
                        }
                    }
                    c = this.dz.next(c);
                }
                return true;
            }
        }
    }

    public static abstract class PrimitiveTernaryMul
    extends PrimitiveTernary {
        public static Constraint buildFrom(Problem pb, Variable x, Variable y, Types.TypeConditionOperatorRel op, Variable z) {
            switch (op) {
                case EQ: {
                    return x.dom.is01() ? new MulEQ3b(pb, x, y, z) : (y.dom.is01() ? new MulEQ3b(pb, y, x, z) : new MulEQ3(pb, y, x, z));
                }
            }
            return null;
        }

        public PrimitiveTernaryMul(Problem pb, Variable x, Variable y, Variable z) {
            super(pb, x, y, z);
        }

        public static final class MulEQ3
        extends PrimitiveTernaryMul {
            @Override
            public final boolean checkValues(int[] t) {
                return t[0] * t[1] == t[2];
            }

            public MulEQ3(Problem pb, Variable x, Variable y, Variable z) {
                super(pb, x, y, z);
                this.buildFourResidueStructure();
                this.control(Utilities.isSafeInt(BigInteger.valueOf(this.dx.firstValue()).multiply(BigInteger.valueOf(this.dy.firstValue())).longValueExact()));
                this.control(Utilities.isSafeInt(BigInteger.valueOf(this.dx.lastValue()).multiply(BigInteger.valueOf(this.dy.lastValue())).longValueExact()));
            }

            @Override
            public boolean runPropagator(Variable dummy) {
                int a;
                int vc;
                if (this.dx.size() * this.dy.size() > 200) {
                    int v1 = this.dx.firstValue() * this.dy.firstValue();
                    int v2 = this.dx.firstValue() * this.dy.lastValue();
                    int v3 = this.dx.lastValue() * this.dy.firstValue();
                    int v4 = this.dx.lastValue() * this.dy.lastValue();
                    int min1 = Math.min(v1, v2);
                    int max1 = Math.max(v1, v2);
                    int min2 = Math.min(v3, v4);
                    int max2 = Math.max(v3, v4);
                    if (!this.dz.removeValuesLT(Math.min(min1, min2)) || !this.dz.removeValuesGT(Math.max(max1, max2))) {
                        return false;
                    }
                    return PrimitiveBinary.enforceMulGE(this.dx, this.dy, this.dz.firstValue()) && PrimitiveBinary.enforceMulLE(this.dx, this.dy, this.dz.lastValue());
                }
                if (!this.dy.presentValue(0) || !this.dz.presentValue(0)) {
                    int a2 = this.dx.first();
                    while (a2 != -1) {
                        block29: {
                            int va = this.dx.toVal(a2);
                            if (va == 0) {
                                if (!this.dz.presentValue(0) && !this.dx.remove(a2)) {
                                    return false;
                                }
                            } else if (!this.dy.present(this.rx[a2]) || !this.dz.presentValue(va * this.dy.toVal(this.rx[a2]))) {
                                int b = this.dy.first();
                                while (b != -1) {
                                    vc = va * this.dy.toVal(b);
                                    if (va > 0 && vc > this.dz.lastValue() || va < 0 && vc < this.dz.firstValue()) break;
                                    if (this.dz.presentValue(vc)) {
                                        this.rx[a2] = b;
                                        break block29;
                                    }
                                    b = this.dy.next(b);
                                }
                                if (!this.dx.remove(a2)) {
                                    return false;
                                }
                            }
                        }
                        a2 = this.dx.next(a2);
                    }
                }
                if (!this.dx.presentValue(0) || !this.dz.presentValue(0)) {
                    int b = this.dy.first();
                    while (b != -1) {
                        block30: {
                            int vb = this.dy.toVal(b);
                            if (vb == 0) {
                                if (!this.dz.presentValue(0) && !this.dy.remove(b)) {
                                    return false;
                                }
                            } else if (!this.dx.present(this.ry[b]) || !this.dz.presentValue(vb * this.dx.toVal(this.ry[b]))) {
                                a = this.dx.first();
                                while (a != -1) {
                                    vc = vb * this.dx.toVal(a);
                                    if (vb > 0 && vc > this.dz.lastValue() || vb < 0 && vc < this.dz.firstValue()) break;
                                    if (this.dz.presentValue(vc)) {
                                        this.ry[b] = a;
                                        break block30;
                                    }
                                    a = this.dx.next(a);
                                }
                                if (!this.dy.remove(b)) {
                                    return false;
                                }
                            }
                        }
                        b = this.dy.next(b);
                    }
                }
                int c = this.dz.first();
                while (c != -1) {
                    block31: {
                        int vc2 = this.dz.toVal(c);
                        if (vc2 == 0) {
                            if (!(this.dx.presentValue(0) || this.dy.presentValue(0) || this.dz.remove(c))) {
                                return false;
                            }
                        } else if (this.rzx[c] == -1 || !this.dx.present(this.rzx[c]) || !this.dy.present(this.rzy[c])) {
                            a = this.dx.first();
                            while (a != -1) {
                                int va = this.dx.toVal(a);
                                if (va != 0) {
                                    int vb = vc2 / va;
                                    if (va > 0 && vc2 > 0 && va * this.dy.firstValue() > vc2) break;
                                    if (vc2 % va == 0 && this.dy.presentValue(vb)) {
                                        this.rzx[c] = a;
                                        this.rzy[c] = this.dy.toIdx(vb);
                                        break block31;
                                    }
                                }
                                a = this.dx.next(a);
                            }
                            if (!this.dz.remove(c)) {
                                return false;
                            }
                        }
                    }
                    c = this.dz.next(c);
                }
                return true;
            }
        }

        public static final class MulEQ3b
        extends PrimitiveTernaryMul {
            @Override
            public final boolean checkValues(int[] t) {
                return t[0] * t[1] == t[2];
            }

            public MulEQ3b(Problem pb, Variable x, Variable y, Variable z) {
                super(pb, x, y, z);
                this.control(this.dx.is01(), "The first variable should be of type 01");
            }

            @Override
            public boolean runPropagator(Variable dummy) {
                if (this.dx.last() == 0 || this.dy.onlyContainsValue(0)) {
                    return this.dz.reduceToValue(0);
                }
                if (this.dz.onlyContainsValue(0)) {
                    if (this.dx.first() == 0 && this.dy.presentValue(0)) {
                        return true;
                    }
                    return this.dx.first() == 0 ? this.dx.reduceTo(0) : this.dy.reduceToValue(0);
                }
                if (this.dz.presentValue(0) ? this.dx.first() == 1 && !this.dy.presentValue(0) && !this.dz.removeValue(0) : !this.dx.removeIfPresent(0) || !this.dy.removeValueIfPresent(0)) {
                    return false;
                }
                if (this.dx.first() == 1) {
                    return PrimitiveBinary.enforceEQ(this.dy, this.dz);
                }
                assert (this.dx.size() == 2 && this.dz.presentValue(0) && this.dz.size() > 1);
                int sizeBefore = this.dz.size();
                int c = this.dz.first();
                while (c != -1) {
                    int vc = this.dz.toVal(c);
                    if (vc != 0 && !this.dy.presentValue(vc)) {
                        this.dz.removeElementary(c);
                    }
                    c = this.dz.next(c);
                }
                this.dz.afterElementaryCalls(sizeBefore);
                if (this.dz.size() == 1) {
                    assert (this.dz.onlyContainsValue(0));
                    this.dx.removeSafely(1);
                }
                return true;
            }
        }
    }

    public static abstract class PrimitiveTernarySub
    extends PrimitiveTernary {
        public static Constraint buildFrom(Problem pb, Variable x, Variable y, Types.TypeConditionOperatorRel op, Variable z) {
            return PrimitiveTernaryAdd.buildFrom(pb, y, z, op, x);
        }

        public PrimitiveTernarySub(Problem pb, Variable x, Variable y, Variable z) {
            super(pb, x, y, z);
        }
    }

    public static abstract class PrimitiveTernaryAdd
    extends PrimitiveTernary {
        public static Constraint buildFrom(Problem pb, Variable x, Variable y, Types.TypeOperatorRel op, Variable z) {
            return PrimitiveTernaryAdd.buildFrom(pb, x, y, op.toConditionOperator(), z);
        }

        public static Constraint buildFrom(Problem pb, Variable x, Variable y, Types.TypeConditionOperatorRel op, Variable z) {
            switch (op) {
                case EQ: {
                    return new AddEQ3(pb, x, y, z);
                }
            }
            return Sum.SumWeighted.buildFrom(pb, (Variable[])pb.api.vars(z, new Variable[]{x, y}), pb.api.vals(-1, 1, 1), op, 0L);
        }

        public PrimitiveTernaryAdd(Problem pb, Variable x, Variable y, Variable z) {
            super(pb, x, y, z);
        }

        public static final class AddEQ3
        extends PrimitiveTernaryAdd {
            boolean multidirectional = false;

            @Override
            public final boolean checkValues(int[] t) {
                return t[0] + t[1] == t[2];
            }

            public AddEQ3(Problem pb, Variable x, Variable y, Variable z) {
                super(pb, x, y, z);
                this.buildThreeResidueStructure();
            }

            @Override
            public boolean runPropagator(Variable dummy) {
                int va;
                int a;
                int vb;
                int c;
                int vc;
                int b;
                if (this.dx.size() * this.dy.size() > 200) {
                    if (!this.dz.removeValuesLT(this.dx.firstValue() + this.dy.firstValue()) || !this.dz.removeValuesGT(this.dx.lastValue() + this.dy.lastValue())) {
                        return false;
                    }
                    return PrimitiveBinary.enforceAddGE(this.dx, this.dy, this.dz.firstValue()) && PrimitiveBinary.enforceAddLE(this.dx, this.dy, this.dz.lastValue());
                }
                int a2 = this.dx.first();
                while (a2 != -1) {
                    block33: {
                        int va2 = this.dx.toVal(a2);
                        if (!this.dy.present(this.rx[a2]) || !this.dz.presentValue(va2 + this.dy.toVal(this.rx[a2]))) {
                            if (this.dy.size() <= this.dz.size()) {
                                b = this.dy.first();
                                while (b != -1 && (vc = va2 + this.dy.toVal(b)) <= this.dz.lastValue()) {
                                    if (this.dz.presentValue(vc)) {
                                        this.rx[a2] = b;
                                        if (this.multidirectional) {
                                            this.ry[b] = a2;
                                            this.rzx[this.dz.toIdx((int)vc)] = a2;
                                        }
                                        break block33;
                                    }
                                    b = this.dy.next(b);
                                }
                            } else {
                                c = this.dz.first();
                                while (c != -1 && (vb = this.dz.toVal(c) - va2) <= this.dy.lastValue()) {
                                    if (this.dy.presentValue(vb)) {
                                        this.rx[a2] = this.dy.toIdx(vb);
                                        if (this.multidirectional) {
                                            this.ry[this.dy.toIdx((int)vb)] = a2;
                                            this.rzx[c] = a2;
                                        }
                                        break block33;
                                    }
                                    c = this.dz.next(c);
                                }
                            }
                            if (!this.dx.remove(a2)) {
                                return false;
                            }
                        }
                    }
                    a2 = this.dx.next(a2);
                }
                int b2 = this.dy.first();
                while (b2 != -1) {
                    block34: {
                        int vb2 = this.dy.toVal(b2);
                        if (!this.dx.present(this.ry[b2]) || !this.dz.presentValue(vb2 + this.dx.toVal(this.ry[b2]))) {
                            if (this.dx.size() <= this.dz.size()) {
                                a = this.dx.first();
                                while (a != -1 && (vc = vb2 + this.dx.toVal(a)) <= this.dz.lastValue()) {
                                    if (this.dz.presentValue(vc)) {
                                        this.ry[b2] = a;
                                        if (this.multidirectional) {
                                            this.rzx[this.dz.toIdx((int)vc)] = a;
                                        }
                                        break block34;
                                    }
                                    a = this.dx.next(a);
                                }
                            } else {
                                c = this.dz.first();
                                while (c != -1 && (va = this.dz.toVal(c) - vb2) <= this.dx.lastValue()) {
                                    if (this.dx.presentValue(va)) {
                                        this.ry[b2] = this.dx.toIdx(va);
                                        if (this.multidirectional) {
                                            this.rzx[c] = this.dx.toIdx(va);
                                        }
                                        break block34;
                                    }
                                    c = this.dz.next(c);
                                }
                            }
                            if (!this.dy.remove(b2)) {
                                return false;
                            }
                        }
                    }
                    b2 = this.dy.next(b2);
                }
                int c2 = this.dz.first();
                while (c2 != -1) {
                    block35: {
                        int vc2 = this.dz.toVal(c2);
                        if (!this.dx.present(this.rzx[c2]) || !this.dy.presentValue(vc2 - this.dx.toVal(this.rzx[c2]))) {
                            if (this.dx.size() <= this.dy.size()) {
                                a = this.dx.last();
                                while (a != -1 && (vb = vc2 - this.dx.toVal(a)) <= this.dy.lastValue()) {
                                    if (this.dy.presentValue(vb)) {
                                        this.rzx[c2] = a;
                                        break block35;
                                    }
                                    a = this.dx.prev(a);
                                }
                            } else {
                                b = this.dy.last();
                                while (b != -1 && (va = vc2 - this.dy.toVal(b)) <= this.dx.lastValue()) {
                                    if (this.dx.presentValue(va)) {
                                        this.rzx[c2] = this.dx.toIdx(va);
                                        break block35;
                                    }
                                    b = this.dy.prev(b);
                                }
                            }
                            if (!this.dz.remove(c2)) {
                                return false;
                            }
                        }
                    }
                    c2 = this.dz.next(c2);
                }
                return true;
            }
        }
    }
}

