/*
 * Decompiled with CFR 0.152.
 */
package constraints.intension;

import constraints.Constraint;
import constraints.global.Sum;
import constraints.intension.Primitive;
import interfaces.Tags;
import java.math.BigInteger;
import org.xcsp.common.Types;
import org.xcsp.common.Utilities;
import problem.Problem;
import utility.Kit;
import variables.Domain;
import variables.Variable;

public abstract class PrimitiveBinary
extends Primitive
implements Tags.TagAC,
Tags.TagFilteringCompleteAtEachCall {
    public static final int UNITIALIZED = -1;
    protected final Variable x;
    protected final Variable y;
    protected final Domain dx;
    protected final Domain dy;
    protected int[] rx;
    protected int[] ry;

    public static boolean enforceLT(Domain dx, Domain dy) {
        return dx.removeValuesGE(dy.lastValue()) && dy.removeValuesLE(dx.firstValue());
    }

    public static boolean enforceLT(Domain dx, Domain dy, int k) {
        return dx.removeValuesGE(dy.lastValue() + k) && dy.removeValuesLE(dx.firstValue() - k);
    }

    public static boolean enforceLE(Domain dx, Domain dy) {
        return dx.removeValuesGT(dy.lastValue()) && dy.removeValuesLT(dx.firstValue());
    }

    public static boolean enforceLE(Domain dx, Domain dy, int k) {
        return dx.removeValuesGT(dy.lastValue() + k) && dy.removeValuesLT(dx.firstValue() - k);
    }

    public static boolean enforceGE(Domain dx, Domain dy) {
        return dx.removeValuesLT(dy.firstValue()) && dy.removeValuesGT(dx.lastValue());
    }

    public static boolean enforceGE(Domain dx, Domain dy, int k) {
        return dx.removeValuesLT(dy.firstValue() + k) && dy.removeValuesGT(dx.lastValue() - k);
    }

    public static boolean enforceGT(Domain dx, Domain dy) {
        return dx.removeValuesLE(dy.firstValue()) && dy.removeValuesGE(dx.lastValue());
    }

    public static boolean enforceGT(Domain dx, Domain dy, int k) {
        return dx.removeValuesLE(dy.firstValue() + k) && dy.removeValuesGE(dx.lastValue() - k);
    }

    public static boolean enforceEQ(Domain dx, Domain dy) {
        if (!dx.removeValuesNotIn(dy)) {
            return false;
        }
        if (dx.size() == dy.size()) {
            return true;
        }
        assert (dx.size() < dy.size());
        boolean consistent = dy.removeValuesNotIn(dx);
        assert (consistent);
        return true;
    }

    public static boolean enforceNE(Domain dx, Domain dy) {
        if (dx.size() == 1) {
            return dy.removeValueIfPresent(dx.uniqueValue());
        }
        if (dy.size() == 1) {
            return dx.removeValueIfPresent(dy.uniqueValue());
        }
        return true;
    }

    public static boolean enforceAddLE(Domain dx, Domain dy, int k) {
        return dx.removeValuesGT(k - dy.firstValue()) && dy.removeValuesGT(k - dx.firstValue());
    }

    public static boolean enforceAddGE(Domain dx, Domain dy, int k) {
        return dx.removeValuesLT(k - dy.lastValue()) && dy.removeValuesLT(k - dx.lastValue());
    }

    public static boolean enforceMulLE(Domain dx, Domain dy, int k) {
        return PrimitiveBinaryMul.MulLE2.revise(dx, dy, k) && PrimitiveBinaryMul.MulLE2.revise(dy, dx, k);
    }

    public static boolean enforceMulGE(Domain dx, Domain dy, int k) {
        return PrimitiveBinaryMul.MulGE2.revise(dx, dy, k) && PrimitiveBinaryMul.MulGE2.revise(dy, dx, k);
    }

    public static boolean enforceDivLE(Domain dx, Domain dy, int k) {
        return dx.removeValuesNumeratorsGT(k, dy.lastValue()) && dy.removeValuesDenominatorsGT(k, dx.firstValue());
    }

    public static boolean enforceDivGE(Domain dx, Domain dy, int k) {
        return dx.removeValuesNumeratorsLT(k, dy.firstValue()) && dy.removeValuesDenominatorsLT(k, dx.lastValue());
    }

    protected void buildResiduesForFirstVariable() {
        this.rx = Kit.repeat(-1, this.dx.initSize());
    }

    protected void buildResiduesForBothVariables() {
        this.rx = Kit.repeat(-1, this.dx.initSize());
        this.ry = Kit.repeat(-1, this.dy.initSize());
    }

    public PrimitiveBinary(Problem pb, Variable x, Variable y) {
        super(pb, (Variable[])pb.api.vars(x, y));
        this.x = x;
        this.y = y;
        this.dx = x.dom;
        this.dy = y.dom;
    }

    public static abstract class PrimitiveBinaryLog
    extends PrimitiveBinaryWithCst
    implements Tags.TagNotSymmetric {
        public static PrimitiveBinary buildFrom(Problem pb, Variable x, Variable y, Types.TypeConditionOperatorRel op, int k) {
            switch (op) {
                case LT: {
                    return new LogLE2(pb, x, y, k - 1);
                }
                case LE: {
                    return new LogLE2(pb, x, y, k);
                }
                case GE: {
                    return new LogGE2(pb, x, y, k);
                }
                case GT: {
                    return new LogGE2(pb, x, y, k + 1);
                }
                case EQ: {
                    return new LogEQ2(pb, x, y, k);
                }
                case NE: {
                    return new LogNE2(pb, x, y, k);
                }
            }
            throw new AssertionError();
        }

        public PrimitiveBinaryLog(Problem pb, Variable x, Variable y, int k) {
            super(pb, x, y, k);
            this.control(this.dx.is01(), "The first variable should be of type 01");
        }

        public static final class LogNE2
        extends PrimitiveBinaryLog {
            @Override
            public final boolean checkValues(int[] t) {
                return t[0] == 1 == (t[1] != this.k);
            }

            public LogNE2(Problem pb, Variable x, Variable y, int k) {
                super(pb, x, y, k);
            }

            @Override
            public boolean runPropagator(Variable dummy) {
                if (this.dx.last() == 0) {
                    return this.dy.reduceToValue(this.k);
                }
                if (this.dx.first() == 1) {
                    return this.dy.removeValueIfPresent(this.k) && this.entailed();
                }
                if (!this.dy.presentValue(this.k)) {
                    return this.dx.removeIfPresent(0);
                }
                if (this.dy.size() == 1) {
                    return this.dx.removeIfPresent(1) && this.entailed();
                }
                return true;
            }
        }

        public static final class LogEQ2
        extends PrimitiveBinaryLog {
            @Override
            public final boolean checkValues(int[] t) {
                return t[0] == 1 == (t[1] == this.k);
            }

            public LogEQ2(Problem pb, Variable x, Variable y, int k) {
                super(pb, x, y, k);
            }

            @Override
            public boolean runPropagator(Variable dummy) {
                if (this.dx.last() == 0) {
                    return this.dy.removeValueIfPresent(this.k) && this.entailed();
                }
                if (this.dx.first() == 1) {
                    return this.dy.reduceToValue(this.k);
                }
                if (!this.dy.presentValue(this.k)) {
                    return this.dx.removeIfPresent(1) && this.entailed();
                }
                if (this.dy.size() == 1) {
                    return this.dx.removeIfPresent(0);
                }
                return true;
            }
        }

        public static final class LogGE2
        extends PrimitiveBinaryLog {
            @Override
            public final boolean checkValues(int[] t) {
                return t[0] == 1 == t[1] >= this.k;
            }

            public LogGE2(Problem pb, Variable x, Variable y, int k) {
                super(pb, x, y, k);
            }

            @Override
            public boolean runPropagator(Variable dummy) {
                if (this.dx.last() == 0) {
                    return this.dy.lastValue() < this.k || this.dy.removeValuesGE(this.k);
                }
                if (this.dx.first() == 1) {
                    return this.dy.firstValue() >= this.k || this.dy.removeValuesLT(this.k);
                }
                if (this.dy.firstValue() >= this.k) {
                    return this.dx.removeIfPresent(0);
                }
                if (this.dy.lastValue() < this.k) {
                    return this.dx.removeIfPresent(1);
                }
                return true;
            }
        }

        public static final class LogLE2
        extends PrimitiveBinaryLog {
            @Override
            public final boolean checkValues(int[] t) {
                return t[0] == 1 == t[1] <= this.k;
            }

            public LogLE2(Problem pb, Variable x, Variable y, int k) {
                super(pb, x, y, k);
            }

            @Override
            public boolean runPropagator(Variable dummy) {
                if (this.dx.last() == 0) {
                    return this.dy.firstValue() > this.k || this.dy.removeValuesLE(this.k);
                }
                if (this.dx.first() == 1) {
                    return this.dy.lastValue() <= this.k || this.dy.removeValuesGT(this.k);
                }
                if (this.dy.lastValue() <= this.k) {
                    return this.dx.removeIfPresent(0);
                }
                if (this.dy.firstValue() > this.k) {
                    return this.dx.removeIfPresent(1);
                }
                return true;
            }
        }
    }

    public static abstract class PrimitiveBinaryDistb
    extends PrimitiveBinaryWithCst
    implements Tags.TagNotSymmetric {
        public static PrimitiveBinary buildFrom(Problem pb, Variable x, Types.TypeConditionOperatorRel op, Variable y, int k) {
            switch (op) {
                case EQ: {
                    return new DistbEQ2(pb, x, y, k);
                }
                case NE: {
                    return new DistbNE2(pb, x, y, k);
                }
            }
            return null;
        }

        public PrimitiveBinaryDistb(Problem pb, Variable x, Variable y, int k) {
            super(pb, x, y, k);
            this.control(this.dx.firstValue() >= 0);
            this.control(k >= 0, "k should be positive or 0");
        }

        public static final class DistbNE2
        extends PrimitiveBinaryDistb {
            @Override
            public boolean checkValues(int[] t) {
                return t[0] != Math.abs(t[1] - this.k);
            }

            public DistbNE2(Problem pb, Variable x, Variable y, int k) {
                super(pb, x, y, k);
            }

            @Override
            public boolean runPropagator(Variable dummy) {
                if (this.dx.size() == 1) {
                    return this.dy.removeValuesIfPresent(this.k + this.dx.uniqueValue(), this.k - this.dx.uniqueValue());
                }
                int v = Math.abs(this.dy.firstValue() - this.k);
                if (this.dy.size() == 1) {
                    return this.dx.removeValueIfPresent(v);
                }
                if (this.dy.size() == 2 && Math.abs(this.dy.lastValue() - this.k) == v) {
                    return this.dx.removeValueIfPresent(v);
                }
                return true;
            }
        }

        public static final class DistbEQ2
        extends PrimitiveBinaryDistb {
            private final PropagatorEQ.SimplePropagatorEQ sp;

            @Override
            public boolean checkValues(int[] t) {
                return t[0] == Math.abs(t[1] - this.k);
            }

            public DistbEQ2(Problem pb, Variable x, Variable y, final int k) {
                super(pb, x, y, k);
                this.sp = new PropagatorEQ.SimplePropagatorEQ(this.dx, this.dy, false){

                    @Override
                    final int valxFor(int b) {
                        return Math.abs(this.dy.toVal(b) - k);
                    }
                };
            }

            @Override
            public boolean runPropagator(Variable evt) {
                if (this.dx.size() == 1 && !this.dy.presentValue(this.k + this.dx.uniqueValue()) && !this.dy.presentValue(this.k - this.dx.uniqueValue())) {
                    return evt.dom.fail();
                }
                return this.sp.runPropagator(evt);
            }
        }
    }

    public static abstract class PrimitiveBinaryModb
    extends PrimitiveBinaryWithCst
    implements Tags.TagNotSymmetric {
        public static PrimitiveBinary buildFrom(Problem pb, Variable x, Types.TypeConditionOperatorRel op, Variable y, int k) {
            switch (op) {
                case EQ: {
                    return new ModbEQ2(pb, x, y, k);
                }
                case NE: {
                    return new ModbNE2(pb, x, y, k);
                }
            }
            return null;
        }

        public PrimitiveBinaryModb(Problem pb, Variable x, Variable y, int k) {
            super(pb, x, y, k);
            this.control(this.dx.firstValue() >= 0 && this.dy.firstValue() >= 0 && k > 1);
        }

        public static final class ModbNE2
        extends PrimitiveBinaryModb {
            int watch1 = -1;
            int watch2 = -1;

            @Override
            public boolean checkValues(int[] t) {
                return t[0] != t[1] % this.k;
            }

            public ModbNE2(Problem pb, Variable x, Variable y, int k) {
                super(pb, x, y, k);
            }

            private int findWatch(int other) {
                if (other == -1) {
                    return this.dy.first();
                }
                int r = this.dy.toVal(other) % this.k;
                int b = this.dy.first();
                while (b != -1) {
                    if (this.dy.toVal(b) % this.k != r) {
                        return b;
                    }
                    b = this.dy.next(b);
                }
                return -1;
            }

            @Override
            public boolean runPropagator(Variable dummy) {
                if (this.dx.size() == 1) {
                    this.entailed();
                    return this.dy.removeValuesModIn(this.dx, this.k);
                }
                if (this.watch1 == -1 || !this.dy.present(this.watch1)) {
                    this.watch1 = this.findWatch(this.watch2);
                }
                if (this.watch1 == -1) {
                    assert (this.watch2 != -1 && this.dy.present(this.watch2));
                    this.entailed();
                    return this.dx.removeValueIfPresent(this.dy.toVal(this.watch2) % this.k);
                }
                if (this.watch2 == -1 || !this.dy.present(this.watch2)) {
                    this.watch2 = this.findWatch(this.watch1);
                }
                if (this.watch2 == -1) {
                    this.entailed();
                    return this.dx.removeValueIfPresent(this.dy.toVal(this.watch1) % this.k);
                }
                return true;
            }
        }

        public static final class ModbEQ2
        extends PrimitiveBinaryModb {
            private final PropagatorEQ.SimplePropagatorEQ sp;

            @Override
            public boolean checkValues(int[] t) {
                return t[0] == t[1] % this.k;
            }

            public ModbEQ2(Problem pb, Variable x, Variable y, final int k) {
                super(pb, x, y, k);
                this.dx.removeValuesAtConstructionTime(v -> v >= k);
                this.sp = new PropagatorEQ.SimplePropagatorEQ(this.dx, this.dy, false){

                    @Override
                    final int valxFor(int b) {
                        return this.dy.toVal(b) % k;
                    }
                };
            }

            @Override
            public boolean runPropagator(Variable dummy) {
                return this.sp.runPropagator(dummy);
            }
        }
    }

    public static abstract class PrimitiveBinaryDivb
    extends PrimitiveBinaryWithCst
    implements Tags.TagNotSymmetric {
        public static PrimitiveBinary buildFrom(Problem pb, Variable x, Types.TypeConditionOperatorRel op, Variable y, int k) {
            switch (op) {
                case EQ: {
                    return x.dom.firstValue() >= 0 && y.dom.firstValue() >= 0 && k > 1 ? new DivbEQ2(pb, x, y, k) : null;
                }
                case NE: {
                    return x.dom.firstValue() >= 0 && y.dom.firstValue() >= 0 && k > 1 ? new DivbNE2(pb, x, y, k) : null;
                }
            }
            return null;
        }

        public PrimitiveBinaryDivb(Problem pb, Variable x, Variable y, int k) {
            super(pb, x, y, k);
            this.control(this.dx.firstValue() >= 0 && this.dy.firstValue() >= 0 && k > 1, this.dx.firstValue() + " " + this.dy.firstValue() + " " + k);
        }

        public static final class DivbNE2
        extends PrimitiveBinaryDivb {
            @Override
            public boolean checkValues(int[] t) {
                return t[0] != t[1] / this.k;
            }

            public DivbNE2(Problem pb, Variable x, Variable y, int k) {
                super(pb, x, y, k);
            }

            @Override
            public boolean runPropagator(Variable dummy) {
                if (this.dx.size() == 1) {
                    return this.dy.removeValuesInRange(this.dx.uniqueValue() * this.k, this.dx.uniqueValue() * this.k + this.k);
                }
                if (this.dy.firstValue() / this.k == this.dy.lastValue() / this.k) {
                    return this.dx.removeValueIfPresent(this.dy.firstValue() / this.k);
                }
                return true;
            }
        }

        public static final class DivbEQ2
        extends PrimitiveBinaryDivb {
            private final PropagatorEQ.SimplePropagatorEQ sp;

            @Override
            public boolean checkValues(int[] t) {
                return t[0] == t[1] / this.k;
            }

            public DivbEQ2(Problem pb, Variable x, Variable y, final int k) {
                super(pb, x, y, k);
                this.sp = new PropagatorEQ.SimplePropagatorEQ(this.dx, this.dy, false){

                    @Override
                    final int valxFor(int b) {
                        return this.dy.toVal(b) / k;
                    }
                };
            }

            @Override
            public boolean runPropagator(Variable dummy) {
                return this.sp.runPropagator(dummy);
            }
        }
    }

    public static abstract class PrimitiveBinaryMulb
    extends PrimitiveBinaryWithCst
    implements Tags.TagNotSymmetric {
        public static Constraint buildFrom(Problem pb, Variable x, Types.TypeConditionOperatorRel op, Variable y, int k) {
            switch (op) {
                case LT: 
                case LE: 
                case GE: 
                case GT: {
                    return Sum.SumWeighted.buildFrom(pb, (Variable[])pb.api.vars(y, x), pb.api.vals(-k, 1), op, 0L);
                }
                case EQ: {
                    return new MulbEQ2(pb, x, y, k);
                }
                case NE: {
                    return new MulbNE2(pb, x, y, k);
                }
            }
            throw new AssertionError();
        }

        public PrimitiveBinaryMulb(Problem pb, Variable x, Variable y, int k) {
            super(pb, x, y, k);
            this.control(k != 0);
            this.control(Utilities.isSafeInt(BigInteger.valueOf(this.dy.firstValue()).multiply(BigInteger.valueOf(k)).longValueExact()));
            this.control(Utilities.isSafeInt(BigInteger.valueOf(this.dy.lastValue()).multiply(BigInteger.valueOf(k)).longValueExact()));
        }

        public static final class MulbNE2
        extends PrimitiveBinaryMulb {
            @Override
            public boolean checkValues(int[] t) {
                return t[0] != t[1] * this.k;
            }

            public MulbNE2(Problem pb, Variable x, Variable y, int k) {
                super(pb, x, y, k);
            }

            @Override
            public boolean runPropagator(Variable dummy) {
                if (this.dx.size() == 1) {
                    return this.dx.uniqueValue() % this.k != 0 || this.dy.removeValueIfPresent(this.dx.uniqueValue() / this.k);
                }
                if (this.dy.size() == 1) {
                    return this.dx.removeValueIfPresent(this.dy.uniqueValue() * this.k);
                }
                return true;
            }
        }

        public static final class MulbEQ2
        extends PrimitiveBinaryMulb {
            private final PropagatorEQ.SimplePropagatorEQ sp;

            @Override
            public boolean checkValues(int[] t) {
                return t[0] == t[1] * this.k;
            }

            public MulbEQ2(Problem pb, Variable x, Variable y, final int k) {
                super(pb, x, y, k);
                this.dx.removeValuesAtConstructionTime(v -> v != 0 && v % k != 0);
                this.sp = new PropagatorEQ.SimplePropagatorEQ(this.dx, this.dy, true){

                    @Override
                    final int valxFor(int b) {
                        return this.dy.toVal(b) * k;
                    }

                    @Override
                    final int valyFor(int a) {
                        return this.dx.toVal(a) / k;
                    }
                };
            }

            @Override
            public boolean runPropagator(Variable dummy) {
                return this.sp.runPropagator(dummy);
            }
        }
    }

    public static abstract class PrimitiveBinaryDist
    extends PrimitiveBinaryWithCst
    implements Tags.TagSymmetric {
        public static PrimitiveBinary buildFrom(Problem pb, Variable x, Variable y, Types.TypeConditionOperatorRel op, int k) {
            switch (op) {
                case LT: {
                    return new DistLE2(pb, x, y, k - 1);
                }
                case LE: {
                    return new DistLE2(pb, x, y, k);
                }
                case GE: {
                    return new DistGE2(pb, x, y, k);
                }
                case GT: {
                    return new DistGE2(pb, x, y, k + 1);
                }
                case EQ: {
                    return new DistEQ2(pb, x, y, k);
                }
                case NE: {
                    return new DistNE2(pb, x, y, k);
                }
            }
            throw new AssertionError();
        }

        public PrimitiveBinaryDist(Problem pb, Variable x, Variable y, int k) {
            super(pb, x, y, k);
            this.control(k > 0, "k should be strictly positive");
        }

        public static final class DistNE2
        extends PrimitiveBinaryDist {
            @Override
            public final boolean checkValues(int[] t) {
                return Math.abs(t[0] - t[1]) != this.k;
            }

            public DistNE2(Problem pb, Variable x, Variable y, int k) {
                super(pb, x, y, k);
            }

            private boolean revise(Domain d1, Domain d2) {
                if (d1.size() == 1) {
                    return d2.removeValuesIfPresent(d1.uniqueValue() - this.k, d1.uniqueValue() + this.k);
                }
                if (d1.size() == 2 && d1.lastValue() - this.k == d1.firstValue() + this.k) {
                    return d2.removeValueIfPresent(d1.lastValue() - this.k);
                }
                return true;
            }

            @Override
            public boolean runPropagator(Variable dummy) {
                return this.revise(this.dx, this.dy) && this.revise(this.dy, this.dx);
            }
        }

        public static final class DistEQ2
        extends PrimitiveBinaryDist {
            private final PropagatorEQ.MultiPropagatorEQ sp;

            @Override
            public final boolean checkValues(int[] t) {
                return Math.abs(t[0] - t[1]) == this.k;
            }

            public DistEQ2(Problem pb, Variable x, Variable y, final int k) {
                super(pb, x, y, k);
                final int[] tmp = new int[2];
                this.sp = new PropagatorEQ.MultiPropagatorEQ(this.dx, this.dy, true){

                    @Override
                    final int[] valsxFor(int b) {
                        tmp[0] = this.dy.toVal(b) + k;
                        tmp[1] = this.dy.toVal(b) - k;
                        return tmp;
                    }

                    @Override
                    final int[] valsyFor(int a) {
                        tmp[0] = this.dx.toVal(a) + k;
                        tmp[1] = this.dx.toVal(a) - k;
                        return tmp;
                    }
                };
            }

            @Override
            public boolean runPropagator(Variable dummy) {
                return this.sp.runPropagator(dummy);
            }
        }

        public static final class DistGE2
        extends PrimitiveBinaryDist {
            @Override
            public boolean checkValues(int[] t) {
                return Math.abs(t[0] - t[1]) >= this.k;
            }

            public DistGE2(Problem pb, Variable x, Variable y, int k) {
                super(pb, x, y, k);
            }

            @Override
            public boolean runPropagator(Variable dummy) {
                return this.dx.removeValuesInRange(this.dy.lastValue() - this.k + 1, this.dy.firstValue() + this.k) && this.dy.removeValuesInRange(this.dx.lastValue() - this.k + 1, this.dx.firstValue() + this.k);
            }
        }

        public static final class DistLE2
        extends PrimitiveBinaryDist {
            @Override
            public boolean checkValues(int[] t) {
                return Math.abs(t[0] - t[1]) <= this.k;
            }

            public DistLE2(Problem pb, Variable x, Variable y, int k) {
                super(pb, x, y, k);
            }

            @Override
            public boolean runPropagator(Variable dummy) {
                return this.dx.removeValuesAtDistanceGT(this.k, this.dy) && this.dy.removeValuesAtDistanceGT(this.k, this.dx);
            }
        }
    }

    public static abstract class PrimitiveBinaryMod
    extends PrimitiveBinaryWithCst
    implements Tags.TagNotSymmetric {
        public static PrimitiveBinary buildFrom(Problem pb, Variable x, Variable y, Types.TypeConditionOperatorRel op, int k) {
            switch (op) {
                case EQ: {
                    return new ModEQ2(pb, x, y, k);
                }
            }
            return null;
        }

        public PrimitiveBinaryMod(Problem pb, Variable x, Variable y, int k) {
            super(pb, x, y, k);
            this.control(this.dx.firstValue() >= 0 && this.dy.firstValue() > 0 && k >= 0);
        }

        public static final class ModEQ2
        extends PrimitiveBinaryMod {
            @Override
            public boolean checkValues(int[] t) {
                return t[0] % t[1] == this.k;
            }

            public ModEQ2(Problem pb, Variable x, Variable y, int k) {
                super(pb, x, y, k);
                this.buildResiduesForBothVariables();
                this.dx.removeValuesAtConstructionTime(v -> v < k);
                this.dy.removeValuesAtConstructionTime(v -> v <= k);
            }

            @Override
            public boolean runPropagator(Variable dummy) {
                int a = this.dx.first();
                while (a != -1) {
                    block16: {
                        int va;
                        if (!(this.rx[a] != -1 && this.dy.present(this.rx[a]) || (va = this.dx.toVal(a)) == this.k)) {
                            int b = this.dy.first();
                            while (b != -1) {
                                int vb = this.dy.toVal(b);
                                if (va % vb == this.k) {
                                    this.rx[a] = b;
                                    break block16;
                                }
                                if (va < vb) break;
                                if (va < 2 * vb) {
                                    assert (va / vb == 1);
                                    if (va - this.k <= vb || !this.dy.presentValue(va - this.k)) break;
                                    this.rx[a] = this.dy.toVal(va - this.k);
                                    break block16;
                                }
                                b = this.dy.next(b);
                            }
                            if (!this.dx.remove(a)) {
                                return false;
                            }
                        }
                    }
                    a = this.dx.next(a);
                }
                int b = this.dy.first();
                while (b != -1) {
                    block17: {
                        if (this.ry[b] == -1 || !this.dx.present(this.ry[b])) {
                            int vb = this.dy.toVal(b);
                            int nMultiples = this.dx.lastValue() / vb;
                            if (this.dx.size() <= nMultiples) {
                                int a2 = this.dx.first();
                                while (a2 != -1) {
                                    int va = this.dx.toVal(a2);
                                    if (va % vb == this.k) {
                                        this.ry[b] = a2;
                                        break block17;
                                    }
                                    a2 = this.dx.next(a2);
                                }
                            } else {
                                for (int va = vb + this.k; va <= this.dx.lastValue(); va += vb) {
                                    assert (va % vb == this.k);
                                    if (!this.dx.presentValue(va)) continue;
                                    this.ry[b] = this.dx.toIdx(va);
                                    break block17;
                                }
                            }
                            if (!this.dy.remove(b)) {
                                return false;
                            }
                        }
                    }
                    b = this.dy.next(b);
                }
                return true;
            }
        }
    }

    public static abstract class PrimitiveBinaryDiv
    extends PrimitiveBinaryWithCst
    implements Tags.TagNotSymmetric {
        public static PrimitiveBinary buildFrom(Problem pb, Variable x, Variable y, Types.TypeConditionOperatorRel op, int k) {
            switch (op) {
                case LT: {
                    return new DivLE2(pb, x, y, k - 1);
                }
                case LE: {
                    return new DivLE2(pb, x, y, k);
                }
                case GE: {
                    return new DivGE2(pb, x, y, k);
                }
                case GT: {
                    return new DivGE2(pb, x, y, k + 1);
                }
                case EQ: {
                    return new DivEQ2(pb, x, y, k);
                }
                case NE: {
                    return null;
                }
            }
            throw new AssertionError();
        }

        public PrimitiveBinaryDiv(Problem pb, Variable x, Variable y, int k) {
            super(pb, x, y, k);
            this.control(this.dx.firstValue() >= 0 && this.dy.firstValue() > 0 && k >= 0);
        }

        public static final class DivEQ2
        extends PrimitiveBinaryDiv {
            @Override
            public boolean checkValues(int[] t) {
                return t[0] / t[1] == this.k;
            }

            public DivEQ2(Problem pb, Variable x, Variable y, int k) {
                super(pb, x, y, k);
                this.buildResiduesForBothVariables();
            }

            @Override
            public boolean runPropagator(Variable dummy) {
                int res;
                if (this.dx.lastValue() / this.dy.firstValue() < this.k || this.dx.firstValue() / this.dy.lastValue() > this.k) {
                    return this.dx.fail();
                }
                int a = this.dx.first();
                while (a != -1) {
                    block11: {
                        int va = this.dx.toVal(a);
                        if (this.rx[a] == -1 || !this.dy.present(this.rx[a])) {
                            int b = this.dy.first();
                            while (b != -1 && (res = va / this.dy.toVal(b)) >= this.k) {
                                if (res == this.k) {
                                    this.rx[a] = b;
                                    break block11;
                                }
                                b = this.dy.next(b);
                            }
                            if (!this.dx.remove(a)) {
                                return false;
                            }
                        }
                    }
                    a = this.dx.next(a);
                }
                int b = this.dy.first();
                while (b != -1) {
                    block12: {
                        int vb = this.dy.toVal(b);
                        if (this.ry[b] == -1 || !this.dx.present(this.ry[b])) {
                            int a2 = this.dx.first();
                            while (a2 != -1 && (res = this.dx.toVal(a2) / vb) <= this.k) {
                                if (res == this.k) {
                                    this.ry[b] = a2;
                                    break block12;
                                }
                                a2 = this.dx.next(a2);
                            }
                            if (!this.dy.remove(b)) {
                                return false;
                            }
                        }
                    }
                    b = this.dy.next(b);
                }
                return true;
            }
        }

        public static final class DivGE2
        extends PrimitiveBinaryDiv {
            @Override
            public boolean checkValues(int[] t) {
                return t[0] / t[1] >= this.k;
            }

            public DivGE2(Problem pb, Variable x, Variable y, int k) {
                super(pb, x, y, k);
            }

            @Override
            public boolean runPropagator(Variable dummy) {
                return DivGE2.enforceDivGE(this.dx, this.dy, this.k);
            }
        }

        public static final class DivLE2
        extends PrimitiveBinaryDiv {
            @Override
            public boolean checkValues(int[] t) {
                return t[0] / t[1] <= this.k;
            }

            public DivLE2(Problem pb, Variable x, Variable y, int k) {
                super(pb, x, y, k);
            }

            @Override
            public boolean runPropagator(Variable dummy) {
                return DivLE2.enforceDivLE(this.dx, this.dy, this.k);
            }
        }
    }

    public static abstract class PrimitiveBinaryMul
    extends PrimitiveBinaryWithCst
    implements Tags.TagSymmetric {
        public static PrimitiveBinary buildFrom(Problem pb, Variable x, Variable y, Types.TypeConditionOperatorRel op, int k) {
            switch (op) {
                case LT: {
                    return new MulLE2(pb, x, y, k - 1);
                }
                case LE: {
                    return new MulLE2(pb, x, y, k);
                }
                case GE: {
                    return new MulGE2(pb, x, y, k);
                }
                case GT: {
                    return new MulGE2(pb, x, y, k + 1);
                }
                case EQ: {
                    return new MulEQ2(pb, x, y, k);
                }
                case NE: {
                    return new MulNE2(pb, x, y, k);
                }
            }
            throw new AssertionError();
        }

        public PrimitiveBinaryMul(Problem pb, Variable x, Variable y, int k) {
            super(pb, x, y, k);
            this.control(Utilities.isSafeInt(BigInteger.valueOf(this.dx.firstValue()).multiply(BigInteger.valueOf(this.dy.firstValue())).longValueExact()));
            this.control(Utilities.isSafeInt(BigInteger.valueOf(this.dx.lastValue()).multiply(BigInteger.valueOf(this.dy.lastValue())).longValueExact()));
        }

        public static final class MulNE2
        extends PrimitiveBinaryMul {
            @Override
            public boolean checkValues(int[] t) {
                return t[0] * t[1] != this.k;
            }

            public MulNE2(Problem pb, Variable x, Variable y, int k) {
                super(pb, x, y, k);
                this.control(k > 1, "if k is 0 or 1, other constraints should be posted");
            }

            @Override
            public boolean runPropagator(Variable dummy) {
                int vb;
                if (this.dx.size() == 1) {
                    int va = this.dx.uniqueValue();
                    if (va != 0 && this.k % va == 0) {
                        return this.dy.removeValueIfPresent(this.k / va);
                    }
                } else if (this.dy.size() == 1 && (vb = this.dy.uniqueValue()) != 0 && this.k % vb == 0) {
                    return this.dx.removeValueIfPresent(this.k / vb);
                }
                return true;
            }
        }

        public static final class MulEQ2
        extends PrimitiveBinaryMul {
            private final PropagatorEQ.SimplePropagatorEQ sp;

            @Override
            public boolean checkValues(int[] t) {
                return t[0] * t[1] == this.k;
            }

            public MulEQ2(Problem pb, Variable x, Variable y, final int k) {
                super(pb, x, y, k);
                this.control(k > 1, "if k is 0 or 1, other constraints should be posted");
                this.dx.removeValuesAtConstructionTime(v -> v == 0 || k % v != 0);
                this.dy.removeValuesAtConstructionTime(v -> v == 0 || k % v != 0);
                this.sp = new PropagatorEQ.SimplePropagatorEQ(this.dx, this.dy, true){

                    @Override
                    final int valxFor(int b) {
                        return k / this.dy.toVal(b);
                    }

                    @Override
                    final int valyFor(int a) {
                        return k / this.dx.toVal(a);
                    }
                };
            }

            @Override
            public boolean runPropagator(Variable dummy) {
                return this.sp.runPropagator(dummy);
            }
        }

        public static final class MulGE2
        extends PrimitiveBinaryMul {
            @Override
            public boolean checkValues(int[] t) {
                return t[0] * t[1] >= this.k;
            }

            public MulGE2(Problem pb, Variable x, Variable y, int k) {
                super(pb, x, y, k);
            }

            public static boolean revise(Domain d1, Domain d2, int k) {
                if (d2.presentValue(0)) {
                    if (0 >= k) {
                        return true;
                    }
                    if (!d2.removeValue(0)) {
                        return false;
                    }
                }
                assert (!d2.presentValue(0));
                if (d2.firstValue() > 0) {
                    return d1.removeValuesLT(k < 0 ? Kit.smallestIntegerGE(d2.firstValue(), k) : Kit.smallestIntegerGE(d2.lastValue(), k));
                }
                if (d2.lastValue() < 0) {
                    return d1.removeValuesGT(k > 0 ? Kit.greatestIntegerLE(-d2.firstValue(), -k) : Kit.greatestIntegerLE(-d2.lastValue(), -k));
                }
                return d1.removeValuesInRange(Kit.greatestIntegerLE(-d2.firstValue(), -k) + 1, Kit.smallestIntegerGE(d2.lastValue(), k));
            }

            @Override
            public boolean runPropagator(Variable dummy) {
                return MulGE2.revise(this.dx, this.dy, this.k) && MulGE2.revise(this.dy, this.dx, this.k);
            }
        }

        public static final class MulLE2
        extends PrimitiveBinaryMul {
            @Override
            public boolean checkValues(int[] t) {
                return t[0] * t[1] <= this.k;
            }

            public MulLE2(Problem pb, Variable x, Variable y, int k) {
                super(pb, x, y, k);
            }

            public static boolean revise(Domain d1, Domain d2, int k) {
                if (d2.presentValue(0)) {
                    if (0 <= k) {
                        return true;
                    }
                    if (!d2.removeValue(0)) {
                        return false;
                    }
                }
                assert (!d2.presentValue(0));
                if (d2.firstValue() > 0) {
                    return d1.removeValuesGT(k > 0 ? Kit.greatestIntegerLE(d2.firstValue(), k) : Kit.greatestIntegerLE(d2.lastValue(), k));
                }
                if (d2.lastValue() < 0) {
                    return d1.removeValuesLT(k < 0 ? Kit.smallestIntegerGE(-d2.firstValue(), -k) : Kit.smallestIntegerGE(-d2.lastValue(), -k));
                }
                return d1.removeValuesInRange(Kit.greatestIntegerLE(d2.lastValue(), k) + 1, Kit.smallestIntegerGE(-d2.firstValue(), -k));
            }

            @Override
            public boolean runPropagator(Variable dummy) {
                return MulLE2.revise(this.dx, this.dy, this.k) && MulLE2.revise(this.dy, this.dx, this.k);
            }
        }

        public static final class MulGE2Old
        extends PrimitiveBinaryMul {
            @Override
            public boolean checkValues(int[] t) {
                return t[0] * t[1] >= this.k;
            }

            public MulGE2Old(Problem pb, Variable x, Variable y, int k) {
                super(pb, x, y, k);
            }

            private boolean checkLimit(int c, int k, Domain dom) {
                if (c == 0) {
                    return k <= 0;
                }
                int limit = Kit.smallestIntegerGE(c, k);
                return c > 0 ? dom.lastValue() >= limit : dom.firstValue() <= limit;
            }

            private boolean revise(Domain d1, Domain d2) {
                int va;
                int sizeBefore = d1.size();
                int a = d1.first();
                while (!(a == -1 || (va = d1.toVal(a)) > 0 && d2.lastValue() >= 0 && va * d2.lastValue() >= this.k || va < 0 && d2.firstValue() >= 0 && va * d2.firstValue() >= this.k)) {
                    if (!this.checkLimit(va, this.k, d2)) {
                        d1.removeElementary(a);
                    }
                    a = d1.next(a);
                }
                return d1.afterElementaryCalls(sizeBefore);
            }

            @Override
            public boolean runPropagator(Variable dummy) {
                return this.revise(this.dx, this.dy) && this.revise(this.dy, this.dx);
            }
        }

        public static final class MulLE2Old
        extends PrimitiveBinaryMul {
            @Override
            public boolean checkValues(int[] t) {
                return t[0] * t[1] <= this.k;
            }

            public MulLE2Old(Problem pb, Variable x, Variable y, int k) {
                super(pb, x, y, k);
            }

            private boolean checkLimit(int c, int k, Domain dom) {
                if (c == 0) {
                    return k >= 0;
                }
                int limit = Kit.greatestIntegerLE(c, k);
                return c > 0 ? dom.firstValue() <= limit : dom.lastValue() >= limit;
            }

            private boolean revise(Domain d1, Domain d2) {
                int va;
                int sizeBefore = d1.size();
                int a = d1.last();
                while (!(a == -1 || (va = d1.toVal(a)) > 0 && d2.firstValue() >= 0 && va * d2.firstValue() <= this.k || va < 0 && d2.lastValue() >= 0 && va * d2.lastValue() <= this.k)) {
                    if (!this.checkLimit(va, this.k, d2)) {
                        d1.removeElementary(a);
                    }
                    a = d1.prev(a);
                }
                return d1.afterElementaryCalls(sizeBefore);
            }

            @Override
            public boolean runPropagator(Variable dummy) {
                return this.revise(this.dx, this.dy) && this.revise(this.dy, this.dx);
            }
        }
    }

    public static abstract class PrimitiveBinarySub
    extends PrimitiveBinaryWithCst {
        public static PrimitiveBinary buildFrom(Problem pb, Variable x, Variable y, Types.TypeOperatorRel op, int k) {
            return PrimitiveBinarySub.buildFrom(pb, x, y, op.toConditionOperator(), k);
        }

        public static PrimitiveBinary buildFrom(Problem pb, Variable x, Variable y, Types.TypeConditionOperatorRel op, int k) {
            switch (op) {
                case LT: {
                    return new SubLE2(pb, x, y, k - 1);
                }
                case LE: {
                    return new SubLE2(pb, x, y, k);
                }
                case GE: {
                    return new SubGE2(pb, x, y, k);
                }
                case GT: {
                    return new SubGE2(pb, x, y, k + 1);
                }
                case EQ: {
                    return new SubEQ2(pb, x, y, k);
                }
                case NE: {
                    return new SubNE2(pb, x, y, k);
                }
            }
            throw new AssertionError();
        }

        public PrimitiveBinarySub(Problem pb, Variable x, Variable y, int k) {
            super(pb, x, y, k);
        }

        public static final class SubNE2
        extends PrimitiveBinarySub {
            @Override
            public final boolean checkValues(int[] t) {
                return t[0] - t[1] != this.k;
            }

            public SubNE2(Problem pb, Variable x, Variable y, int k) {
                super(pb, x, y, k);
            }

            @Override
            public Boolean isSymmetric() {
                return this.k == 0;
            }

            @Override
            public boolean runPropagator(Variable dummy) {
                if (this.dx.size() == 1) {
                    return this.dy.removeValueIfPresent(this.dx.uniqueValue() - this.k);
                }
                if (this.dy.size() == 1) {
                    return this.dx.removeValueIfPresent(this.dy.uniqueValue() + this.k);
                }
                return true;
            }
        }

        public static final class SubEQ2
        extends PrimitiveBinarySub {
            private final PropagatorEQ.SimplePropagatorEQ sp;

            @Override
            public final boolean checkValues(int[] t) {
                return t[0] - t[1] == this.k;
            }

            @Override
            public Boolean isSymmetric() {
                return this.k == 0;
            }

            public SubEQ2(Problem pb, Variable x, Variable y, final int k) {
                super(pb, x, y, k);
                this.sp = new PropagatorEQ.SimplePropagatorEQ(this.dx, this.dy, true){

                    @Override
                    final int valxFor(int b) {
                        return k + this.dy.toVal(b);
                    }

                    @Override
                    final int valyFor(int a) {
                        return this.dx.toVal(a) - k;
                    }
                };
            }

            @Override
            public boolean runPropagator(Variable dummy) {
                return this.sp.runPropagator(dummy);
            }
        }

        public static final class SubGE2
        extends PrimitiveBinarySub
        implements Tags.TagNotSymmetric {
            @Override
            public final boolean checkValues(int[] t) {
                return t[0] - t[1] >= this.k;
            }

            public SubGE2(Problem pb, Variable x, Variable y, int k) {
                super(pb, x, y, k);
            }

            @Override
            public boolean runPropagator(Variable dummy) {
                return SubGE2.enforceGE(this.dx, this.dy, this.k);
            }
        }

        public static final class SubLE2
        extends PrimitiveBinarySub
        implements Tags.TagNotSymmetric {
            @Override
            public final boolean checkValues(int[] t) {
                return t[0] - t[1] <= this.k;
            }

            public SubLE2(Problem pb, Variable x, Variable y, int k) {
                super(pb, x, y, k);
            }

            @Override
            public boolean runPropagator(Variable dummy) {
                return SubLE2.enforceLE(this.dx, this.dy, this.k);
            }
        }
    }

    public static abstract class PrimitiveBinaryAdd
    extends PrimitiveBinaryWithCst
    implements Tags.TagSymmetric {
        public static PrimitiveBinary buildFrom(Problem pb, Variable x, Variable y, Types.TypeConditionOperatorRel op, int k) {
            switch (op) {
                case LT: {
                    return new AddLE2(pb, x, y, k - 1);
                }
                case LE: {
                    return new AddLE2(pb, x, y, k);
                }
                case GE: {
                    return new AddGE2(pb, x, y, k);
                }
                case GT: {
                    return new AddGE2(pb, x, y, k + 1);
                }
                case EQ: {
                    return new AddEQ2(pb, x, y, k);
                }
                case NE: {
                    return new AddNE2(pb, x, y, k);
                }
            }
            throw new AssertionError();
        }

        public PrimitiveBinaryAdd(Problem pb, Variable x, Variable y, int k) {
            super(pb, x, y, k);
        }

        public static final class AddNE2
        extends PrimitiveBinaryAdd {
            @Override
            public final boolean checkValues(int[] t) {
                return t[0] + t[1] != this.k;
            }

            public AddNE2(Problem pb, Variable x, Variable y, int k) {
                super(pb, x, y, k);
            }

            @Override
            public boolean runPropagator(Variable dummy) {
                if (this.dx.size() == 1) {
                    return this.dy.removeValueIfPresent(this.k - this.dx.uniqueValue());
                }
                if (this.dy.size() == 1) {
                    return this.dx.removeValueIfPresent(this.k - this.dy.uniqueValue());
                }
                return true;
            }
        }

        public static final class AddEQ2
        extends PrimitiveBinaryAdd {
            private final PropagatorEQ.SimplePropagatorEQ sp;

            @Override
            public final boolean checkValues(int[] t) {
                return t[0] + t[1] == this.k;
            }

            public AddEQ2(Problem pb, Variable x, Variable y, final int k) {
                super(pb, x, y, k);
                this.sp = new PropagatorEQ.SimplePropagatorEQ(this.dx, this.dy, true){

                    @Override
                    final int valxFor(int b) {
                        return k - this.dy.toVal(b);
                    }

                    @Override
                    final int valyFor(int a) {
                        return k - this.dx.toVal(a);
                    }
                };
            }

            @Override
            public boolean runPropagator(Variable dummy) {
                return this.sp.runPropagator(dummy);
            }
        }

        public static final class AddGE2
        extends PrimitiveBinaryAdd {
            @Override
            public final boolean checkValues(int[] t) {
                return t[0] + t[1] >= this.k;
            }

            public AddGE2(Problem pb, Variable x, Variable y, int k) {
                super(pb, x, y, k);
            }

            @Override
            public boolean runPropagator(Variable dummy) {
                return AddGE2.enforceAddGE(this.dx, this.dy, this.k);
            }
        }

        public static final class AddLE2
        extends PrimitiveBinaryAdd {
            @Override
            public final boolean checkValues(int[] t) {
                return t[0] + t[1] <= this.k;
            }

            public AddLE2(Problem pb, Variable x, Variable y, int k) {
                super(pb, x, y, k);
            }

            @Override
            public boolean runPropagator(Variable dummy) {
                return AddLE2.enforceAddLE(this.dx, this.dy, this.k);
            }
        }
    }

    public static abstract class PrimitiveBinaryWithCst
    extends PrimitiveBinary {
        protected final int k;

        public static PrimitiveBinary buildFrom(Problem pb, Variable x, Types.TypeArithmeticOperator aop, Variable y, Types.TypeConditionOperatorRel op, int k) {
            switch (aop) {
                case ADD: {
                    return PrimitiveBinaryAdd.buildFrom(pb, x, y, op, k);
                }
                case SUB: {
                    return PrimitiveBinarySub.buildFrom(pb, x, y, op, k);
                }
                case MUL: {
                    return PrimitiveBinaryMul.buildFrom(pb, x, y, op, k);
                }
                case DIV: {
                    return PrimitiveBinaryDiv.buildFrom(pb, x, y, op, k);
                }
                case MOD: {
                    return PrimitiveBinaryMod.buildFrom(pb, x, y, op, k);
                }
                case DIST: {
                    return PrimitiveBinaryDist.buildFrom(pb, x, y, op, k);
                }
            }
            return null;
        }

        public static Constraint buildFrom(Problem pb, Variable x, Types.TypeConditionOperatorRel op, Variable y, Types.TypeArithmeticOperator aop, int k) {
            switch (aop) {
                case ADD: {
                    return PrimitiveBinarySub.buildFrom(pb, x, y, op, k);
                }
                case SUB: {
                    return PrimitiveBinarySub.buildFrom(pb, x, y, op, -k);
                }
                case MUL: {
                    return PrimitiveBinaryMulb.buildFrom(pb, x, op, y, k);
                }
                case DIV: {
                    return PrimitiveBinaryDivb.buildFrom(pb, x, op, y, k);
                }
                case MOD: {
                    return PrimitiveBinaryModb.buildFrom(pb, x, op, y, k);
                }
                case DIST: {
                    return PrimitiveBinaryDistb.buildFrom(pb, x, op, y, k);
                }
            }
            return null;
        }

        public PrimitiveBinaryWithCst(Problem pb, Variable x, Variable y, int k) {
            super(pb, x, y);
            this.k = k;
            this.defineKey(k);
        }
    }

    public static abstract class PrimitiveBinaryEQWithUnaryOperator
    extends PrimitiveBinary
    implements Tags.TagNotSymmetric {
        public static PrimitiveBinary buildFrom(Problem pb, Variable x, Types.TypeUnaryArithmeticOperator aop, Variable y) {
            switch (aop) {
                case ABS: {
                    return new PrimitiveBinaryDistb.DistbEQ2(pb, x, y, 0);
                }
                case NEG: {
                    return new NegEQ2(pb, x, y);
                }
                case SQR: {
                    return null;
                }
            }
            return null;
        }

        public PrimitiveBinaryEQWithUnaryOperator(Problem pb, Variable x, Variable y) {
            super(pb, x, y);
        }

        public static final class NegEQ2
        extends PrimitiveBinaryEQWithUnaryOperator {
            private final PropagatorEQ.SimplePropagatorEQ sp;

            @Override
            public final boolean checkValues(int[] t) {
                return t[0] == -t[1];
            }

            public NegEQ2(Problem pb, Variable x, Variable y) {
                super(pb, x, y);
                this.sp = new PropagatorEQ.SimplePropagatorEQ(this.dx, this.dy, true){

                    @Override
                    final int valxFor(int b) {
                        return -this.dy.toVal(b);
                    }

                    @Override
                    final int valyFor(int a) {
                        return -this.dx.toVal(a);
                    }
                };
            }

            @Override
            public boolean runPropagator(Variable dummy) {
                return this.sp.runPropagator(dummy);
            }
        }
    }

    public static final class Disjonctive
    extends PrimitiveBinary {
        final int wx;
        final int wy;

        @Override
        public boolean checkValues(int[] t) {
            return t[0] + this.wx <= t[1] || t[1] + this.wy <= t[0];
        }

        @Override
        public Boolean isSymmetric() {
            return this.wx == this.wy;
        }

        public Disjonctive(Problem pb, Variable x, int wx, Variable y, int wy) {
            super(pb, x, y);
            this.wx = wx;
            this.wy = wy;
            this.defineKey(wx, wy);
        }

        @Override
        public boolean runPropagator(Variable dummy) {
            return this.dx.removeValuesInRange(this.dy.lastValue() - this.wx + 1, this.dy.firstValue() + this.wy) && this.dy.removeValuesInRange(this.dx.lastValue() - this.wy + 1, this.dx.firstValue() + this.wx);
        }
    }

    public static abstract class PropagatorEQ {
        protected Domain dx;
        protected Domain dy;
        protected int time;
        protected int[] times;
        protected boolean twoway;

        protected PropagatorEQ(Domain dx, Domain dy, boolean twoway) {
            this.dx = dx;
            this.dy = dy;
            this.times = new int[twoway ? Math.max(dx.initSize(), dy.initSize()) : dx.initSize()];
        }

        protected PropagatorEQ(Domain dx, Domain dy) {
            this(dx, dy, false);
        }

        protected abstract int nSupportsForWhenIteratingOver(Domain var1, Domain var2);

        public boolean runPropagator(Variable evt, Domain d1, Domain d2) {
            int sizeBefore = d2.size();
            int nSupports = this.nSupportsForWhenIteratingOver(d1, d2);
            if (nSupports == 0) {
                return evt.dom.fail();
            }
            d2.afterElementaryCalls(sizeBefore);
            int toremove = d1.size() - nSupports;
            if (toremove == 0) {
                return true;
            }
            sizeBefore = d1.size();
            int a = d1.first();
            while (a != -1 && toremove > 0) {
                if (this.times[a] != this.time) {
                    d1.removeElementary(a);
                    --toremove;
                }
                a = d1.next(a);
            }
            d1.afterElementaryCalls(sizeBefore);
            return true;
        }

        public boolean runPropagator(Variable evt) {
            ++this.time;
            if (this.twoway && this.dx.size() < this.dy.size()) {
                return this.runPropagator(evt, this.dy, this.dx);
            }
            return this.runPropagator(evt, this.dx, this.dy);
        }

        public static abstract class MultiPropagatorEQ
        extends PropagatorEQ {
            protected MultiPropagatorEQ(Domain dx, Domain dy, boolean twoway) {
                super(dx, dy, twoway);
            }

            abstract int[] valsxFor(int var1);

            int[] valsyFor(int a) {
                throw new AssertionError((Object)"Missing implementation");
            }

            @Override
            protected int nSupportsForWhenIteratingOver(Domain d1, Domain d2) {
                int cnt = 0;
                int b = d2.first();
                while (b != -1) {
                    boolean found = false;
                    for (int va : d1 == this.dx ? this.valsxFor(b) : this.valsyFor(b)) {
                        int a = d1.toPresentIdx(va);
                        if (a == -1) continue;
                        found = true;
                        if (this.times[a] == this.time) continue;
                        this.times[a] = this.time;
                        ++cnt;
                    }
                    if (!found) {
                        if (d2.var().assigned()) {
                            return 0;
                        }
                        d2.removeElementary(b);
                    }
                    b = d2.next(b);
                }
                return cnt;
            }
        }

        public static abstract class SimplePropagatorEQ
        extends PropagatorEQ {
            protected SimplePropagatorEQ(Domain dx, Domain dy, boolean twoway) {
                super(dx, dy, twoway);
            }

            abstract int valxFor(int var1);

            int valyFor(int a) {
                throw new AssertionError((Object)"Missing implementation");
            }

            @Override
            protected int nSupportsForWhenIteratingOver(Domain d1, Domain d2) {
                if (d2.size() == 1 && !d1.presentValue(d1 == this.dx ? this.valxFor(d2.unique()) : this.valyFor(d2.unique()))) {
                    return 0;
                }
                int cnt = 0;
                int b = d2.first();
                while (b != -1) {
                    int a = d1.toPresentIdx(d1 == this.dx ? this.valxFor(b) : this.valyFor(b));
                    if (a == -1) {
                        d2.removeElementary(b);
                    } else if (this.times[a] != this.time) {
                        this.times[a] = this.time;
                        ++cnt;
                    }
                    b = d2.next(b);
                }
                return cnt;
            }
        }
    }
}

