/*
 * Decompiled with CFR 0.152.
 */
package constraints.global;

import constraints.Constraint;
import interfaces.Tags;
import org.xcsp.common.Types;
import problem.Problem;
import sets.SetDense;
import variables.Domain;
import variables.Variable;

public abstract class SumScalarBoolean
extends Constraint.CtrGlobal
implements Tags.TagAC,
Tags.TagFilteringCompleteAtEachCall {
    protected final Variable[] list;
    protected final Variable[] coeffs;
    protected final int half;
    protected int min;
    protected int max;
    protected final SetDense set01vs1;

    public SumScalarBoolean(Problem pb, Variable[] list, Variable[] coeffs, Variable limit) {
        super(pb, (Variable[])pb.api.vars(list, new Object[]{coeffs, limit}));
        this.list = list;
        this.coeffs = coeffs;
        this.half = list.length;
        this.set01vs1 = new SetDense(this.half);
        assert (list.length == coeffs.length && Variable.areAllInitiallyBoolean((Variable[])pb.api.vars(list, coeffs)));
    }

    public SumScalarBoolean(Problem pb, Variable[] list, Variable[] coeffs) {
        this(pb, list, coeffs, null);
    }

    protected final int sumScalar(int[] t) {
        int sum = 0;
        for (int i = 0; i < this.half; ++i) {
            sum += t[i] * t[this.half + i];
        }
        return sum;
    }

    protected void recomputeBounds() {
        this.max = 0;
        this.min = 0;
        this.set01vs1.clear();
        for (int i = 0; i < this.half; ++i) {
            Domain dom1 = this.scp[i].dom;
            Domain dom2 = this.scp[i + this.half].dom;
            if (!dom1.present(1) || !dom2.present(1)) continue;
            ++this.max;
            if (!dom1.present(0) && !dom2.present(0)) {
                ++this.min;
                continue;
            }
            if (dom1.size() != 1 && dom2.size() != 1) continue;
            this.set01vs1.add(i);
        }
    }

    protected final void removeFrom01vs1(int value) {
        assert (value == 0 || value == 1);
        for (int i = this.set01vs1.limit; i >= 0; --i) {
            int j = this.set01vs1.dense[i];
            assert (this.scp[j].dom.size() == 2 && this.scp[this.half + j].dom.onlyContains(1) || this.scp[this.half + j].dom.size() == 2 && this.scp[j].dom.onlyContains(1));
            if (this.scp[j].dom.size() == 2) {
                this.scp[j].dom.remove(value);
                continue;
            }
            this.scp[this.half + j].dom.remove(value);
        }
    }

    public static abstract class SumScalarBooleanVar
    extends SumScalarBoolean {
        protected Variable limit;

        public static SumScalarBooleanVar buildFrom(Problem pb, Variable[] list, Variable[] coeffs, Types.TypeConditionOperatorRel op, Variable limit) {
            switch (op) {
                case LT: {
                    return new SumScalarBooleanVarLE(pb, list, coeffs, pb.replaceByVariable(pb.api.sub(limit, 1)));
                }
                case LE: {
                    return new SumScalarBooleanVarLE(pb, list, coeffs, limit);
                }
                case GE: {
                    return new SumScalarBooleanVarGE(pb, list, coeffs, limit);
                }
                case GT: {
                    return new SumScalarBooleanVarLE(pb, list, coeffs, pb.replaceByVariable(pb.api.add(limit, 1)));
                }
            }
            throw new UnsupportedOperationException("NE and EQ are not implemented");
        }

        public SumScalarBooleanVar(Problem pb, Variable[] list, Variable[] coeffs, Variable limit) {
            super(pb, list, coeffs, limit);
            this.limit = limit;
        }

        public static final class SumScalarBooleanVarGE
        extends SumScalarBooleanVar {
            @Override
            public boolean checkValues(int[] t) {
                return this.sumScalar(t) >= t[t.length - 1];
            }

            public SumScalarBooleanVarGE(Problem pb, Variable[] list, Variable[] coeffs, Variable limit) {
                super(pb, list, coeffs, limit);
            }

            @Override
            public boolean runPropagator(Variable x) {
                this.recomputeBounds();
                if (!this.limit.dom.removeValuesGT(this.max)) {
                    return false;
                }
                int vlimit = this.limit.dom.firstValue();
                if (this.min >= vlimit) {
                    return true;
                }
                if (this.max == vlimit) {
                    assert (this.limit.dom.size() == 1);
                    this.removeFrom01vs1(0);
                }
                return true;
            }
        }

        public static final class SumScalarBooleanVarLE
        extends SumScalarBooleanVar {
            @Override
            public boolean checkValues(int[] t) {
                return this.sumScalar(t) <= t[t.length - 1];
            }

            public SumScalarBooleanVarLE(Problem pb, Variable[] list, Variable[] coeffs, Variable limit) {
                super(pb, list, coeffs, limit);
            }

            @Override
            public boolean runPropagator(Variable x) {
                this.recomputeBounds();
                if (!this.limit.dom.removeValuesLT(this.min)) {
                    return false;
                }
                int vlimit = this.limit.dom.lastValue();
                if (this.max <= vlimit) {
                    return true;
                }
                if (this.min == vlimit) {
                    assert (this.limit.dom.size() == 1);
                    this.removeFrom01vs1(1);
                }
                return true;
            }
        }
    }

    public static abstract class SumScalarBooleanCst
    extends SumScalarBoolean {
        protected int limit;

        public static SumScalarBooleanCst buildFrom(Problem pb, Variable[] list, Variable[] coeffs, Types.TypeConditionOperatorRel op, int limit) {
            switch (op) {
                case LT: {
                    return new SumScalarBooleanLE(pb, list, coeffs, limit - 1);
                }
                case LE: {
                    return new SumScalarBooleanLE(pb, list, coeffs, limit);
                }
                case GE: {
                    return new SumScalarBooleanGE(pb, list, coeffs, limit);
                }
                case GT: {
                    return new SumScalarBooleanGE(pb, list, coeffs, limit + 1);
                }
                case EQ: {
                    return new SumScalarBooleanEQ(pb, list, coeffs, limit);
                }
            }
            throw new UnsupportedOperationException("NE is not implemented");
        }

        public SumScalarBooleanCst(Problem pb, Variable[] list, Variable[] coeffs, int limit) {
            super(pb, list, coeffs);
            this.limit = limit;
            this.control(0 < limit && limit < list.length);
        }

        public static final class SumScalarBooleanEQ
        extends SumScalarBooleanCst {
            private SetDense set01vs01;

            @Override
            public boolean checkValues(int[] t) {
                return this.sumScalar(t) == this.limit;
            }

            public SumScalarBooleanEQ(Problem pb, Variable[] list, Variable[] coeffs, int limit) {
                super(pb, list, coeffs, limit);
                this.set01vs01 = new SetDense(this.half);
            }

            @Override
            protected void recomputeBounds() {
                this.max = 0;
                this.min = 0;
                this.set01vs1.clear();
                this.set01vs01.clear();
                for (int i = 0; i < this.half; ++i) {
                    Domain dom1 = this.scp[i].dom;
                    Domain dom2 = this.scp[i + this.half].dom;
                    if (!dom1.present(1) || !dom2.present(1)) continue;
                    ++this.max;
                    if (!dom1.present(0) && !dom2.present(0)) {
                        ++this.min;
                        continue;
                    }
                    if (dom1.size() == 1 || dom2.size() == 1) {
                        this.set01vs1.add(i);
                        continue;
                    }
                    this.set01vs01.add(i);
                }
            }

            @Override
            public boolean runPropagator(Variable x) {
                this.recomputeBounds();
                if (this.min > this.limit || this.max < this.limit) {
                    return x.dom.fail();
                }
                if (this.min == this.max || this.min < this.limit && this.limit < this.max) {
                    return true;
                }
                if (this.min == this.limit) {
                    this.removeFrom01vs1(1);
                } else if (this.max == this.limit) {
                    this.removeFrom01vs1(0);
                    for (int i = this.set01vs01.limit; i >= 0; --i) {
                        int j = this.set01vs01.dense[i];
                        assert (this.scp[j].dom.size() == 2 && this.scp[this.half + j].dom.size() == 2);
                        this.scp[j].dom.remove(0);
                        this.scp[this.half + j].dom.remove(0);
                    }
                }
                return true;
            }
        }

        public static final class SumScalarBooleanGE
        extends SumScalarBooleanCst {
            @Override
            public boolean checkValues(int[] t) {
                return this.sumScalar(t) >= this.limit;
            }

            public SumScalarBooleanGE(Problem pb, Variable[] list, Variable[] coeffs, int limit) {
                super(pb, list, coeffs, limit);
            }

            @Override
            public boolean runPropagator(Variable x) {
                this.recomputeBounds();
                if (this.min >= this.limit) {
                    return this.entailed();
                }
                if (this.max < this.limit) {
                    return x.dom.fail();
                }
                if (this.max == this.limit) {
                    this.removeFrom01vs1(0);
                }
                return true;
            }
        }

        public static final class SumScalarBooleanLE
        extends SumScalarBooleanCst {
            @Override
            public boolean checkValues(int[] t) {
                return this.sumScalar(t) <= this.limit;
            }

            public SumScalarBooleanLE(Problem pb, Variable[] list, Variable[] coeffs, int limit) {
                super(pb, list, coeffs, limit);
            }

            @Override
            public boolean runPropagator(Variable x) {
                this.recomputeBounds();
                if (this.max <= this.limit) {
                    return this.entailed();
                }
                if (this.min > this.limit) {
                    return x.dom.fail();
                }
                if (this.min == this.limit) {
                    this.removeFrom01vs1(1);
                }
                return true;
            }
        }
    }
}

