/*
 * Decompiled with CFR 0.152.
 */
package constraints.global;

import constraints.Constraint;
import interfaces.Tags;
import java.math.BigInteger;
import java.util.stream.Stream;
import org.xcsp.common.Types;
import problem.Problem;
import variables.Domain;
import variables.Variable;

public abstract class Product
extends Constraint.CtrGlobal
implements Tags.TagFilteringCompleteAtEachCall {
    protected long limit;
    protected long min;
    protected long max;
    protected long minWithout0;

    public Product(Problem pb, Variable[] scp) {
        super(pb, scp);
        this.control(scp.length > 1);
    }

    public static abstract class ProductSimple
    extends Product
    implements Tags.TagSymmetric {
        public static ProductSimple buildFrom(Problem pb, Variable[] scp, Types.TypeConditionOperatorRel op, long limit) {
            switch (op) {
                case LT: {
                    return new ProductSimpleLE(pb, scp, limit - 1L);
                }
                case LE: {
                    return new ProductSimpleLE(pb, scp, limit);
                }
                case GE: {
                    return new ProductSimpleGE(pb, scp, limit);
                }
                case GT: {
                    return new ProductSimpleGE(pb, scp, limit + 1L);
                }
                case EQ: {
                    return new ProductSimpleEQ(pb, scp, limit);
                }
                case NE: {
                    throw new AssertionError();
                }
            }
            throw new AssertionError();
        }

        protected final long product(int[] t) {
            long l = 1L;
            for (int v : t) {
                l *= (long)v;
            }
            return l;
        }

        protected final long currProduct() {
            long sum = 0L;
            for (Variable x : this.scp) {
                sum *= (long)x.dom.uniqueValue();
            }
            return sum;
        }

        private long maxCurrentProduct(Variable[] scp) {
            assert (Stream.of(scp).allMatch(x -> x.dom.firstValue() >= 0));
            BigInteger product = BigInteger.valueOf(1L);
            for (int i = 0; i < scp.length; ++i) {
                product = product.multiply(BigInteger.valueOf(scp[i].dom.lastValue()));
            }
            return product.longValueExact();
        }

        public ProductSimple(Problem pb, Variable[] scp, long limit) {
            super(pb, scp);
            this.control(limit > 0L && Stream.of(scp).allMatch(x -> x.dom.firstValue() >= 0), " for the moment, only positive values");
            this.maxCurrentProduct(scp);
            this.limit = limit;
        }

        protected final int recomputeBounds() {
            int n0 = 0;
            this.minWithout0 = 1L;
            this.max = 1L;
            this.min = 1L;
            for (Domain dom : this.doms) {
                this.min *= (long)dom.firstValue();
                this.max *= (long)dom.lastValue();
                if (dom.firstValue() == 0) {
                    ++n0;
                    continue;
                }
                this.minWithout0 *= (long)dom.firstValue();
            }
            return n0;
        }

        public static final class ProductSimpleEQ
        extends ProductSimple {
            @Override
            public final boolean checkValues(int[] t) {
                return this.product(t) == this.limit;
            }

            public ProductSimpleEQ(Problem pb, Variable[] scp, long limit) {
                super(pb, scp, limit);
                for (Domain dom : this.doms) {
                    if (!dom.presentValue(0)) continue;
                    dom.removeValueAtConstructionTime(0);
                }
            }

            @Override
            public boolean isGuaranteedAC() {
                return false;
            }

            @Override
            public boolean runPropagator(Variable evt) {
                this.recomputeBounds();
                if (this.limit < this.min || this.limit > this.max) {
                    return evt.dom.fail();
                }
                if (this.futvars.size() > 0) {
                    int lastModified = this.futvars.limit;
                    int i = this.futvars.limit;
                    do {
                        Domain dom;
                        int sizeBefore;
                        if ((sizeBefore = (dom = this.scp[this.futvars.dense[i]].dom).size()) <= 1) continue;
                        this.min /= (long)dom.firstValue();
                        this.max /= (long)dom.lastValue();
                        if (!dom.removeValuesLT(this.limit / this.max) || !dom.removeValuesGT(this.limit / this.min)) {
                            return false;
                        }
                        if (sizeBefore != dom.size()) {
                            lastModified = i;
                        }
                        this.min *= (long)dom.firstValue();
                        this.max *= (long)dom.lastValue();
                    } while (lastModified != (i = i > 0 ? i - 1 : this.futvars.limit));
                }
                return true;
            }
        }

        public static class ProductSimpleGE
        extends ProductSimple
        implements Tags.TagAC {
            @Override
            public final boolean checkValues(int[] t) {
                return this.product(t) >= this.limit;
            }

            public ProductSimpleGE(Problem pb, Variable[] scp, long limit) {
                super(pb, scp, limit);
                for (Domain dom : this.doms) {
                    if (!dom.presentValue(0)) continue;
                    dom.removeValueAtConstructionTime(0);
                }
            }

            @Override
            public boolean runPropagator(Variable x) {
                this.recomputeBounds();
                if (this.min >= this.limit) {
                    return this.entailed();
                }
                if (this.max < this.limit) {
                    return x == null ? false : x.dom.fail();
                }
                for (int i = this.futvars.limit; i >= 0; --i) {
                    Domain dom = this.scp[this.futvars.dense[i]].dom;
                    if (dom.size() == 1) continue;
                    this.min /= (long)dom.firstValue();
                    dom.removeValuesLT(this.limit / (this.max / (long)dom.lastValue()));
                    assert (dom.size() > 0);
                    this.min *= (long)dom.firstValue();
                    if (this.min < this.limit) continue;
                    return this.entailed();
                }
                return true;
            }
        }

        public static class ProductSimpleLE
        extends ProductSimple
        implements Tags.TagAC {
            @Override
            public final boolean checkValues(int[] t) {
                return this.product(t) <= this.limit;
            }

            public ProductSimpleLE(Problem pb, Variable[] scp, long limit) {
                super(pb, scp, limit);
            }

            @Override
            public boolean runPropagator(Variable x) {
                int n0 = this.recomputeBounds();
                if (this.max <= this.limit) {
                    return this.entailed();
                }
                if (this.min > this.limit) {
                    return x == null ? false : x.dom.fail();
                }
                for (int i = this.futvars.limit; i >= 0; --i) {
                    Domain dom = this.scp[this.futvars.dense[i]].dom;
                    if (dom.size() == 1) continue;
                    assert (this.max != 0L);
                    this.max /= (long)dom.lastValue();
                    if (this.min != 0L) {
                        dom.removeValuesGT(this.limit / (this.min / (long)dom.firstValue()));
                    } else if (dom.firstValue() == 0 && n0 == 1) {
                        dom.removeValuesGT(this.limit / this.minWithout0);
                    }
                    assert (dom.size() > 0);
                    this.max *= (long)dom.lastValue();
                    if (this.max > this.limit) continue;
                    return this.entailed();
                }
                return true;
            }
        }
    }
}

