/*
 * Decompiled with CFR 0.152.
 */
package constraints.global;

import constraints.Constraint;
import interfaces.Tags;
import java.util.stream.IntStream;
import org.xcsp.common.Types;
import problem.Problem;
import variables.Variable;

public abstract class Ordered
extends Constraint.CtrGlobal
implements Tags.TagAC,
Tags.TagFilteringCompleteAtEachCall,
Tags.TagNotSymmetric {
    protected int[] lengths;

    public static Ordered build(Problem pb, Variable[] x, int[] lengths, Types.TypeOperatorRel op) {
        switch (op) {
            case LT: {
                return new OrderedLT(pb, x, lengths);
            }
            case LE: {
                return new OrderedLE(pb, x, lengths);
            }
            case GE: {
                return new OrderedGE(pb, x, lengths);
            }
        }
        return new OrderedGT(pb, x, lengths);
    }

    public Ordered(Problem pb, Variable[] scp, int[] lengths) {
        super(pb, scp);
        this.lengths = lengths;
        this.control(scp.length == lengths.length + 1);
    }

    public Ordered(Problem pb, Variable[] scp) {
        this(pb, scp, new int[scp.length - 1]);
    }

    public static final class OrderedGT
    extends Ordered {
        @Override
        public final boolean checkValues(int[] t) {
            return IntStream.range(0, t.length - 1).allMatch(i -> t[i] + this.lengths[i] > t[i + 1]);
        }

        public OrderedGT(Problem pb, Variable[] scp, int[] lengths) {
            super(pb, scp, lengths);
        }

        public OrderedGT(Problem pb, Variable[] scp) {
            super(pb, scp);
        }

        @Override
        public boolean runPropagator(Variable dummy) {
            int i;
            for (i = 0; i < this.scp.length - 1; ++i) {
                if (this.scp[i + 1].dom.removeValuesGE(this.scp[i].dom.lastValue() + this.lengths[i])) continue;
                return false;
            }
            for (i = this.scp.length - 2; i >= 0; --i) {
                if (this.scp[i].dom.removeValuesLE(this.scp[i + 1].dom.firstValue() - this.lengths[i])) continue;
                return false;
            }
            return true;
        }
    }

    public static final class OrderedGE
    extends Ordered {
        @Override
        public final boolean checkValues(int[] t) {
            return IntStream.range(0, t.length - 1).allMatch(i -> t[i] + this.lengths[i] >= t[i + 1]);
        }

        public OrderedGE(Problem pb, Variable[] scp, int[] lengths) {
            super(pb, scp, lengths);
        }

        public OrderedGE(Problem pb, Variable[] scp) {
            super(pb, scp);
        }

        @Override
        public boolean runPropagator(Variable dummy) {
            int i;
            for (i = 0; i < this.scp.length - 1; ++i) {
                if (this.scp[i + 1].dom.removeValuesGT(this.scp[i].dom.lastValue() + this.lengths[i])) continue;
                return false;
            }
            for (i = this.scp.length - 2; i >= 0; --i) {
                if (this.scp[i].dom.removeValuesLT(this.scp[i + 1].dom.firstValue() - this.lengths[i])) continue;
                return false;
            }
            return true;
        }
    }

    public static final class OrderedLE
    extends Ordered {
        @Override
        public final boolean checkValues(int[] t) {
            return IntStream.range(0, t.length - 1).allMatch(i -> t[i] + this.lengths[i] <= t[i + 1]);
        }

        public OrderedLE(Problem pb, Variable[] scp, int[] lengths) {
            super(pb, scp, lengths);
        }

        public OrderedLE(Problem pb, Variable[] scp) {
            super(pb, scp);
        }

        @Override
        public boolean runPropagator(Variable dummy) {
            int i;
            for (i = this.scp.length - 2; i >= 0; --i) {
                if (this.scp[i].dom.removeValuesGT(this.scp[i + 1].dom.lastValue() - this.lengths[i])) continue;
                return false;
            }
            for (i = 0; i < this.scp.length - 1; ++i) {
                if (this.scp[i + 1].dom.removeValuesLT(this.scp[i].dom.firstValue() + this.lengths[i])) continue;
                return false;
            }
            return true;
        }
    }

    public static final class OrderedLT
    extends Ordered {
        @Override
        public final boolean checkValues(int[] t) {
            return IntStream.range(0, t.length - 1).allMatch(i -> t[i] + this.lengths[i] < t[i + 1]);
        }

        public OrderedLT(Problem pb, Variable[] scp, int[] lengths) {
            super(pb, scp, lengths);
        }

        public OrderedLT(Problem pb, Variable[] scp) {
            super(pb, scp);
        }

        @Override
        public boolean runPropagator(Variable dummy) {
            int i;
            for (i = this.scp.length - 2; i >= 0; --i) {
                if (this.scp[i].dom.removeValuesGE(this.scp[i + 1].dom.lastValue() - this.lengths[i])) continue;
                return false;
            }
            for (i = 0; i < this.scp.length - 1; ++i) {
                if (this.scp[i + 1].dom.removeValuesLE(this.scp[i].dom.firstValue() + this.lengths[i])) continue;
                return false;
            }
            return true;
        }
    }
}

