/*
 * Decompiled with CFR 0.152.
 */
package constraints.global;

import constraints.Constraint;
import constraints.intension.PrimitiveBinary;
import interfaces.Tags;
import org.xcsp.common.Types;
import problem.Problem;
import variables.Domain;
import variables.Variable;

public abstract class Lexicographic
extends Constraint.CtrGlobal
implements Tags.TagNotSymmetric,
Tags.TagFilteringCompleteAtEachCall,
Tags.TagAC {
    private final Variable[] list1;
    private final Variable[] list2;
    private final boolean strictOrdering;
    private final int half;
    private int lex_time;
    private final int[] lex_times;
    private final int[] vals;

    public static Lexicographic buildFrom(Problem pb, Variable[] list1, Variable[] list2, Types.TypeOperatorRel op) {
        switch (op) {
            case LT: {
                return new LexicographicLT(pb, list1, list2);
            }
            case LE: {
                return new LexicographicLE(pb, list1, list2);
            }
            case GE: {
                return new LexicographicLE(pb, list2, list1);
            }
        }
        return new LexicographicLT(pb, list2, list1);
    }

    @Override
    public boolean checkValues(int[] t) {
        for (int i = 0; i < this.half; ++i) {
            int w;
            int v = t[this.positionOf(this.list1[i])];
            if (v < (w = t[this.positionOf(this.list2[i])])) {
                return true;
            }
            if (v <= w) continue;
            return false;
        }
        return !this.strictOrdering;
    }

    public Lexicographic(Problem pb, Variable[] list1, Variable[] list2, boolean strictOrdering) {
        super(pb, (Variable[])pb.vars(new Object[]{list1, list2}));
        assert (list1.length == list2.length);
        this.list1 = list1;
        this.list2 = list2;
        this.strictOrdering = strictOrdering;
        this.half = list1.length;
        this.lex_times = new int[this.scp.length];
        this.vals = new int[this.scp.length];
        this.defineKey(strictOrdering);
    }

    private void set(int p, int v) {
        this.lex_times[p] = this.lex_time;
        this.vals[p] = v;
    }

    private boolean isConsistentPair(int alpha, int v) {
        ++this.lex_time;
        this.set(this.positionOf(this.list1[alpha]), v);
        this.set(this.positionOf(this.list2[alpha]), v);
        for (int i = alpha + 1; i < this.half; ++i) {
            int max2;
            int p1 = this.positionOf(this.list1[i]);
            int p2 = this.positionOf(this.list2[i]);
            int min1 = this.lex_times[p1] == this.lex_time ? this.vals[p1] : this.list1[i].dom.firstValue();
            int n = max2 = this.lex_times[p2] == this.lex_time ? this.vals[p2] : this.list2[i].dom.lastValue();
            if (min1 < max2) {
                return true;
            }
            if (min1 > max2) {
                return false;
            }
            this.set(p1, min1);
            this.set(p2, max2);
        }
        return !this.strictOrdering;
    }

    @Override
    public boolean runPropagator(Variable dummy) {
        int alpha;
        for (alpha = 0; alpha < this.half; ++alpha) {
            Domain dom1 = this.list1[alpha].dom;
            Domain dom2 = this.list2[alpha].dom;
            if (!PrimitiveBinary.enforceLE(dom1, dom2)) {
                return false;
            }
            if (dom1.size() == 1 && dom2.size() == 1) {
                if (dom1.uniqueValue() < dom2.uniqueValue()) {
                    return this.entailed();
                }
                assert (dom1.uniqueValue() == dom2.uniqueValue());
                continue;
            }
            int min1 = dom1.firstValue();
            int min2 = dom2.firstValue();
            assert (min1 <= min2);
            if (min1 == min2 && !this.isConsistentPair(alpha, min1) && !dom2.removeValue(min2)) {
                return false;
            }
            int max1 = dom1.lastValue();
            int max2 = dom2.lastValue();
            assert (max1 <= max2);
            if (max1 == max2 && !this.isConsistentPair(alpha, max1) && !dom1.removeValue(max1)) {
                return false;
            }
            assert (dom1.firstValue() < dom2.lastValue());
            return true;
        }
        assert (alpha == this.half);
        return !this.strictOrdering;
    }

    public static final class LexicographicLE
    extends Lexicographic {
        public LexicographicLE(Problem pb, Variable[] list1, Variable[] list2) {
            super(pb, list1, list2, false);
        }
    }

    public static final class LexicographicLT
    extends Lexicographic {
        public LexicographicLT(Problem pb, Variable[] list1, Variable[] list2) {
            super(pb, list1, list2, true);
        }
    }
}

