/*
 * Decompiled with CFR 0.152.
 */
package constraints.global;

import constraints.Constraint;
import interfaces.Tags;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import optimization.Optimizable;
import org.xcsp.common.Types;
import org.xcsp.common.Utilities;
import problem.Problem;
import variables.Domain;
import variables.Variable;

public abstract class Extremum
extends Constraint.CtrGlobal
implements Tags.TagFilteringCompleteAtEachCall,
Tags.TagAC {
    protected final Variable[] list;

    public Extremum(Problem pb, Variable[] list, Variable ext) {
        super(pb, (Variable[])pb.api.vars(ext, list));
        this.list = list;
    }

    public Extremum(Problem pb, Variable[] list) {
        this(pb, list, null);
    }

    public static abstract class ExtremumCst
    extends Extremum
    implements Optimizable,
    Tags.TagSymmetric {
        protected long limit;

        public static ExtremumCst buildFrom(Problem pb, Variable[] list, Types.TypeConditionOperatorRel op, long limit, boolean minimum) {
            switch (op) {
                case LT: {
                    return minimum ? new MinimumCst.MinimumCstLE(pb, list, limit - 1L) : new MaximumCst.MaximumCstLE(pb, list, limit - 1L);
                }
                case LE: {
                    return minimum ? new MinimumCst.MinimumCstLE(pb, list, limit) : new MaximumCst.MaximumCstLE(pb, list, limit);
                }
                case GE: {
                    return minimum ? new MinimumCst.MinimumCstGE(pb, list, limit) : new MaximumCst.MaximumCstGE(pb, list, limit);
                }
                case GT: {
                    return minimum ? new MinimumCst.MinimumCstGE(pb, list, limit + 1L) : new MaximumCst.MaximumCstGE(pb, list, limit + 1L);
                }
                case EQ: {
                    return minimum ? new MinimumCst.MinimumCstEQ(pb, list, limit) : new MaximumCst.MaximumCstEQ(pb, list, limit);
                }
            }
            throw new AssertionError((Object)"NE is not implemented");
        }

        @Override
        public long limit() {
            return this.limit;
        }

        @Override
        public final void limit(long newLimit) {
            this.limit = newLimit;
            this.control(this.minComputableObjectiveValue() - 1L <= this.limit && this.limit <= this.maxComputableObjectiveValue() + 1L);
        }

        public ExtremumCst(Problem pb, Variable[] list, long limit) {
            super(pb, list);
            this.limit(limit);
        }

        public static abstract class MinimumCst
        extends ExtremumCst {
            static long minFirstInitialValues(Variable[] scp) {
                long min = Long.MAX_VALUE;
                for (Variable x : scp) {
                    if ((long)x.dom.toVal(0) >= min) continue;
                    min = x.dom.toVal(0);
                }
                return min;
            }

            static long minLastInitialValues(Variable[] scp) {
                long min = Long.MAX_VALUE;
                for (Variable x : scp) {
                    if ((long)x.dom.toVal(x.dom.initSize() - 1) >= min) continue;
                    min = x.dom.toVal(x.dom.initSize() - 1);
                }
                return min;
            }

            @Override
            public long minComputableObjectiveValue() {
                return MinimumCst.minFirstInitialValues(this.scp);
            }

            @Override
            public long maxComputableObjectiveValue() {
                return MinimumCst.minLastInitialValues(this.scp);
            }

            @Override
            public long minCurrentObjectiveValue() {
                long min = Long.MAX_VALUE;
                for (Variable x : this.scp) {
                    if ((long)x.dom.firstValue() >= min) continue;
                    min = x.dom.firstValue();
                }
                return min;
            }

            @Override
            public long maxCurrentObjectiveValue() {
                long min = Long.MAX_VALUE;
                for (Variable x : this.scp) {
                    if ((long)x.dom.lastValue() >= min) continue;
                    min = x.dom.lastValue();
                }
                return min;
            }

            @Override
            public long objectiveValue() {
                return Stream.of(this.doms).mapToInt(dom -> dom.uniqueValue()).min().getAsInt();
            }

            public MinimumCst(Problem pb, Variable[] scp, long limit) {
                super(pb, scp, limit);
            }

            public static final class MinimumCstEQ
            extends MinimumCst {
                private int value;
                private Variable sentinel1;
                private Variable sentinel2;

                @Override
                public boolean checkValues(int[] vals) {
                    return (long)IntStream.of(vals).min().getAsInt() == this.limit;
                }

                public MinimumCstEQ(Problem pb, Variable[] scp, long limit) {
                    super(pb, scp, limit);
                    this.value = Utilities.safeInt(limit, true);
                    for (Variable x : scp) {
                        x.dom.removeValuesAtConstructionTime(v -> v < this.value);
                    }
                    this.sentinel1 = scp[0];
                    this.sentinel2 = scp[1];
                }

                private Variable findAnotherSentinel() {
                    for (Variable x : this.scp) {
                        if (x == this.sentinel1 || x == this.sentinel2 || !x.dom.presentValue(this.value)) continue;
                        return x;
                    }
                    return null;
                }

                @Override
                public boolean runPropagator(Variable x) {
                    Variable sentinel;
                    if (!this.sentinel1.dom.presentValue(this.value)) {
                        sentinel = this.findAnotherSentinel();
                        if (sentinel != null) {
                            this.sentinel1 = sentinel;
                        } else {
                            return this.sentinel2.dom.reduceToValue(this.value) && this.entailed();
                        }
                    }
                    if (!this.sentinel2.dom.presentValue(this.value)) {
                        sentinel = this.findAnotherSentinel();
                        if (sentinel != null) {
                            this.sentinel2 = sentinel;
                        } else {
                            return this.sentinel1.dom.reduceToValue(this.value) && this.entailed();
                        }
                    }
                    return true;
                }
            }

            public static final class MinimumCstGE
            extends MinimumCst {
                @Override
                public boolean checkValues(int[] vals) {
                    return (long)IntStream.of(vals).min().getAsInt() >= this.limit;
                }

                public MinimumCstGE(Problem pb, Variable[] scp, long limit) {
                    super(pb, scp, Math.max(limit, MinimumCstGE.minFirstInitialValues(scp)));
                }

                @Override
                public boolean runPropagator(Variable dummy) {
                    this.control(this.problem.solver.depth() == 0);
                    for (Variable y : this.scp) {
                        if (y.dom.removeValuesLT(this.limit)) continue;
                        return false;
                    }
                    return this.entailed();
                }
            }

            public static final class MinimumCstLE
            extends MinimumCst {
                private int sentinel1 = 0;
                private int sentinel2;

                @Override
                public boolean checkValues(int[] vals) {
                    return (long)IntStream.of(vals).min().getAsInt() <= this.limit;
                }

                public MinimumCstLE(Problem pb, Variable[] scp, long limit) {
                    super(pb, scp, Math.min(limit, MinimumCstLE.minLastInitialValues(scp)));
                    this.sentinel2 = scp.length - 1;
                    this.control((long)scp[this.sentinel1].dom.firstValue() <= limit && (long)scp[this.sentinel2].dom.firstValue() <= limit, "unsound sentinels");
                }

                @Override
                public boolean runPropagator(Variable x) {
                    int i;
                    if ((long)this.scp[this.sentinel1].dom.firstValue() > this.limit) {
                        for (i = 0; i < this.scp.length && (i == this.sentinel2 || (long)this.scp[i].dom.firstValue() > this.limit); ++i) {
                        }
                        if (i < this.scp.length) {
                            this.sentinel1 = i;
                        } else {
                            if ((long)this.scp[this.sentinel2].dom.firstValue() > this.limit) {
                                return x == null ? false : x.dom.fail();
                            }
                            this.scp[this.sentinel2].dom.removeValuesGT(this.limit);
                            return this.entailed();
                        }
                    }
                    if ((long)this.scp[this.sentinel2].dom.firstValue() > this.limit) {
                        for (i = 0; i < this.scp.length && (i == this.sentinel1 || (long)this.scp[i].dom.firstValue() > this.limit); ++i) {
                        }
                        if (i < this.scp.length) {
                            this.sentinel2 = i;
                        } else {
                            assert ((long)this.scp[this.sentinel1].dom.firstValue() <= this.limit);
                            this.scp[this.sentinel1].dom.removeValuesGT(this.limit);
                            return this.entailed();
                        }
                    }
                    return true;
                }
            }
        }

        public static abstract class MaximumCst
        extends ExtremumCst {
            static long maxFirstInitialValues(Variable[] scp) {
                long max = Long.MIN_VALUE;
                for (Variable x : scp) {
                    if ((long)x.dom.toVal(0) <= max) continue;
                    max = x.dom.toVal(0);
                }
                return max;
            }

            static long maxLastInitialValues(Variable[] scp) {
                long max = Long.MIN_VALUE;
                for (Variable x : scp) {
                    if ((long)x.dom.toVal(x.dom.initSize() - 1) <= max) continue;
                    max = x.dom.toVal(x.dom.initSize() - 1);
                }
                return max;
            }

            @Override
            public long minComputableObjectiveValue() {
                return MaximumCst.maxFirstInitialValues(this.scp);
            }

            @Override
            public long maxComputableObjectiveValue() {
                return MaximumCst.maxLastInitialValues(this.scp);
            }

            @Override
            public long minCurrentObjectiveValue() {
                long max = Long.MIN_VALUE;
                for (Variable x : this.scp) {
                    if ((long)x.dom.firstValue() <= max) continue;
                    max = x.dom.firstValue();
                }
                return max;
            }

            @Override
            public long maxCurrentObjectiveValue() {
                long max = Long.MIN_VALUE;
                for (Variable x : this.scp) {
                    if ((long)x.dom.lastValue() <= max) continue;
                    max = x.dom.lastValue();
                }
                return max;
            }

            @Override
            public long objectiveValue() {
                return Stream.of(this.doms).mapToInt(dom -> dom.uniqueValue()).max().getAsInt();
            }

            public MaximumCst(Problem pb, Variable[] scp, long limit) {
                super(pb, scp, limit);
            }

            public static final class MaximumCstEQ
            extends MaximumCst {
                private int value;
                private Variable sentinel1;
                private Variable sentinel2;

                @Override
                public boolean checkValues(int[] vals) {
                    return (long)IntStream.of(vals).max().getAsInt() == this.limit;
                }

                public MaximumCstEQ(Problem pb, Variable[] scp, long limit) {
                    super(pb, scp, limit);
                    this.value = Utilities.safeInt(limit, true);
                    for (Variable x : scp) {
                        x.dom.removeValuesAtConstructionTime(v -> v > this.value);
                    }
                    this.sentinel1 = scp[0];
                    this.sentinel2 = scp[1];
                }

                private Variable findAnotherSentinel() {
                    for (Variable x : this.scp) {
                        if (x == this.sentinel1 || x == this.sentinel2 || !x.dom.presentValue(this.value)) continue;
                        return x;
                    }
                    return null;
                }

                @Override
                public boolean runPropagator(Variable x) {
                    Variable sentinel;
                    if (!this.sentinel1.dom.presentValue(this.value)) {
                        sentinel = this.findAnotherSentinel();
                        if (sentinel != null) {
                            this.sentinel1 = sentinel;
                        } else {
                            return this.sentinel2.dom.reduceToValue(this.value) && this.entailed();
                        }
                    }
                    if (!this.sentinel2.dom.presentValue(this.value)) {
                        sentinel = this.findAnotherSentinel();
                        if (sentinel != null) {
                            this.sentinel2 = sentinel;
                        } else {
                            return this.sentinel1.dom.reduceToValue(this.value) && this.entailed();
                        }
                    }
                    return true;
                }
            }

            public static final class MaximumCstGE
            extends MaximumCst {
                private int sentinel1 = 0;
                private int sentinel2;

                @Override
                public boolean checkValues(int[] vals) {
                    return (long)IntStream.of(vals).max().getAsInt() >= this.limit;
                }

                public MaximumCstGE(Problem pb, Variable[] scp, long limit) {
                    super(pb, scp, Math.max(limit, MaximumCstGE.maxFirstInitialValues(scp)));
                    this.sentinel2 = scp.length - 1;
                    this.control((long)scp[this.sentinel1].dom.lastValue() >= limit && (long)scp[this.sentinel2].dom.lastValue() >= limit, "unsound sentinels");
                }

                @Override
                public boolean runPropagator(Variable x) {
                    int i;
                    if ((long)this.scp[this.sentinel1].dom.lastValue() < this.limit) {
                        for (i = 0; i < this.scp.length && (i == this.sentinel2 || (long)this.scp[i].dom.lastValue() < this.limit); ++i) {
                        }
                        if (i < this.scp.length) {
                            this.sentinel1 = i;
                        } else {
                            if ((long)this.scp[this.sentinel2].dom.lastValue() < this.limit) {
                                return x == null ? false : x.dom.fail();
                            }
                            this.scp[this.sentinel2].dom.removeValuesLT(this.limit);
                            return this.entailed();
                        }
                    }
                    if ((long)this.scp[this.sentinel2].dom.lastValue() < this.limit) {
                        for (i = 0; i < this.scp.length && (i == this.sentinel1 || (long)this.scp[i].dom.lastValue() < this.limit); ++i) {
                        }
                        if (i < this.scp.length) {
                            this.sentinel2 = i;
                        } else {
                            assert ((long)this.scp[this.sentinel1].dom.lastValue() >= this.limit);
                            this.scp[this.sentinel1].dom.removeValuesLT(this.limit);
                            return this.entailed();
                        }
                    }
                    return true;
                }
            }

            public static final class MaximumCstLE
            extends MaximumCst {
                @Override
                public boolean checkValues(int[] vals) {
                    return (long)IntStream.of(vals).max().getAsInt() <= this.limit;
                }

                public MaximumCstLE(Problem pb, Variable[] scp, long limit) {
                    super(pb, scp, Math.min(limit, MaximumCstLE.maxLastInitialValues(scp)));
                }

                @Override
                public boolean runPropagator(Variable dummy) {
                    this.control(this.problem.solver.depth() == 0);
                    for (Variable y : this.scp) {
                        if (y.dom.removeValuesGT(this.limit)) continue;
                        return false;
                    }
                    return this.entailed();
                }
            }
        }
    }

    public static abstract class ExtremumVar
    extends Extremum {
        protected final Domain domExt;
        protected final Variable[] sentinels;

        protected Variable findSentinelFor(int v, Variable except) {
            for (Variable x : this.list) {
                if (x == except || !x.dom.presentValue(v)) continue;
                return x;
            }
            return null;
        }

        protected Variable findSentinelFor(int v) {
            for (Variable x : this.list) {
                if (!x.dom.presentValue(v)) continue;
                return x;
            }
            return null;
        }

        @Override
        public int[] symmetryMatching() {
            return IntStream.range(0, this.scp.length).map(i -> i == 0 ? 1 : 2).toArray();
        }

        public ExtremumVar(Problem pb, Variable[] list, Variable ext) {
            super(pb, list, ext);
            this.domExt = ext.dom;
            this.sentinels = (Variable[])IntStream.range(0, this.domExt.initSize()).mapToObj(a -> this.findSentinelFor(this.domExt.toVal(a))).toArray(Variable[]::new);
            this.domExt.removeAtConstructionTime(a -> this.sentinels[a] == null);
            this.control(list.length > 1 && Stream.of(list).noneMatch(x -> x == ext), "vector length = " + list.length);
        }

        public static final class Minimum
        extends ExtremumVar {
            @Override
            public boolean checkValues(int[] t) {
                return t[0] == IntStream.range(1, t.length).map(i -> t[i]).min().getAsInt();
            }

            private int computeLimitForSentinel(Variable sentinel) {
                int a = this.domExt.first();
                while (a != -1) {
                    int v = this.domExt.toVal(a);
                    if (this.sentinels[a] != sentinel || this.findSentinelFor(v, sentinel) != null) {
                        return v;
                    }
                    a = this.domExt.next(a);
                }
                return Integer.MAX_VALUE;
            }

            public Minimum(Problem pb, Variable[] list, Variable min) {
                super(pb, list, min);
            }

            @Override
            public boolean runPropagator(Variable dummy) {
                int v;
                int minFirst = Integer.MAX_VALUE;
                int minLast = Integer.MAX_VALUE;
                for (Variable x : this.list) {
                    if (x.dom.firstValue() < minFirst) {
                        minFirst = x.dom.firstValue();
                    }
                    if (x.dom.lastValue() >= minLast) continue;
                    minLast = x.dom.lastValue();
                }
                if (!this.domExt.removeValuesGT(minLast) || !this.domExt.removeValuesLT(minFirst)) {
                    return false;
                }
                int sizeBefore = this.domExt.size();
                int a = this.domExt.first();
                while (a != -1) {
                    int v2 = this.domExt.toVal(a);
                    if (!this.sentinels[a].dom.presentValue(v2)) {
                        Variable s = this.findSentinelFor(v2);
                        if (s != null) {
                            this.sentinels[a] = s;
                        } else {
                            if (this.domExt.size() == 1) {
                                return this.domExt.fail();
                            }
                            this.domExt.removeElementary(a);
                        }
                    }
                    a = this.domExt.next(a);
                }
                if (!this.domExt.afterElementaryCalls(sizeBefore)) {
                    return false;
                }
                int firstMin = this.domExt.firstValue();
                for (Variable x : this.list) {
                    if (x.dom.removeValuesLT(firstMin)) continue;
                    return false;
                }
                Variable sentinel = this.sentinels[this.domExt.first()];
                int valLimit = this.computeLimitForSentinel(sentinel);
                if (valLimit == firstMin) {
                    return true;
                }
                Domain domSentinel = sentinel.dom;
                sizeBefore = domSentinel.size();
                int a2 = domSentinel.next(domSentinel.first());
                while (a2 != -1 && (v = domSentinel.toVal(a2)) < valLimit) {
                    if (!this.domExt.presentValue(v)) {
                        domSentinel.removeElementary(a2);
                    }
                    a2 = domSentinel.next(a2);
                }
                return domSentinel.afterElementaryCalls(sizeBefore);
            }
        }

        public static final class Maximum
        extends ExtremumVar {
            @Override
            public boolean checkValues(int[] t) {
                return t[0] == IntStream.range(1, t.length).map(i -> t[i]).max().getAsInt();
            }

            private int computeLimitForSentinel(Variable sentinel) {
                int a = this.domExt.last();
                while (a != -1) {
                    int v = this.domExt.toVal(a);
                    if (this.sentinels[a] != sentinel || this.findSentinelFor(v, sentinel) != null) {
                        return v;
                    }
                    a = this.domExt.prev(a);
                }
                return Integer.MIN_VALUE;
            }

            public Maximum(Problem pb, Variable[] list, Variable max) {
                super(pb, list, max);
            }

            @Override
            public boolean runPropagator(Variable dummy) {
                int v;
                int maxFirst = Integer.MIN_VALUE;
                int maxLast = Integer.MIN_VALUE;
                for (Variable x : this.list) {
                    if (x.dom.firstValue() > maxFirst) {
                        maxFirst = x.dom.firstValue();
                    }
                    if (x.dom.lastValue() <= maxLast) continue;
                    maxLast = x.dom.lastValue();
                }
                if (!this.domExt.removeValuesLT(maxFirst) || !this.domExt.removeValuesGT(maxLast)) {
                    return false;
                }
                int sizeBefore = this.domExt.size();
                if (!this.domExt.removeIndexesChecking(a -> {
                    int v = this.domExt.toVal((int)a);
                    if (!this.sentinels[a.intValue()].dom.presentValue(v)) {
                        Variable s = this.findSentinelFor(v);
                        if (s == null) {
                            return true;
                        }
                        this.sentinels[a.intValue()] = s;
                    }
                    return false;
                })) {
                    return false;
                }
                int lastMax = this.domExt.lastValue();
                for (Variable x : this.list) {
                    if (x.dom.removeValuesGT(lastMax)) continue;
                    return false;
                }
                Variable sentinel = this.sentinels[this.domExt.last()];
                int valLimit = this.computeLimitForSentinel(sentinel);
                if (valLimit == lastMax) {
                    return true;
                }
                Domain domSentinel = sentinel.dom;
                sizeBefore = domSentinel.size();
                int a2 = domSentinel.prev(domSentinel.last());
                while (a2 != -1 && (v = domSentinel.toVal(a2)) > valLimit) {
                    if (!this.domExt.presentValue(v)) {
                        domSentinel.removeElementary(a2);
                    }
                    a2 = domSentinel.prev(a2);
                }
                return domSentinel.afterElementaryCalls(sizeBefore);
            }
        }
    }
}

