/*
 * Decompiled with CFR 0.152.
 */
package constraints.global;

import constraints.Constraint;
import interfaces.Tags;
import java.util.stream.IntStream;
import org.xcsp.common.Utilities;
import problem.Problem;
import utility.Kit;
import variables.Domain;
import variables.Variable;

public abstract class Element
extends Constraint.CtrGlobal
implements Tags.TagNotSymmetric,
Tags.TagAC {
    protected final Variable[] list;
    protected final Variable ivar;
    protected final Domain idom;
    protected final int ipos;

    public Element(Problem pb, Variable[] list, int startAt, Variable index, Object value) {
        super(pb, Utilities.collect(Variable.class, list, index, value));
        this.list = list;
        this.ivar = index;
        this.idom = index.dom;
        this.ipos = IntStream.range(0, this.scp.length).filter(i -> this.scp[i] == index).findFirst().getAsInt();
        this.control(startAt == 0, "Starting at a value different from 0 not implemented");
        this.control(Variable.areAllDistinct(list) && index != value, "i=" + index + " x=" + Kit.join((Object)list, new String[0]) + " v=" + value);
        this.control(list.length == this.idom.initSize(), " pb with " + this + " " + index);
    }

    protected Domain domAt(int i) {
        return this.list[i].dom;
    }

    public static class ElementVariable
    extends Element
    implements Tags.TagFilteringCompleteAtEachCall {
        private final Variable vvar;
        private final Domain vdom;
        private final int vpos;
        private final int[] valueSentinels;
        private final int[] listSentinels;

        @Override
        public boolean checkValues(int[] t) {
            throw new AssertionError();
        }

        @Override
        public boolean checkIndexes(int[] t) {
            int i = t[this.ipos];
            return this.list[i].dom.toVal(t[i]) == this.vdom.toVal(t[this.vpos]);
        }

        public ElementVariable(Problem pb, Variable[] list, int startAt, Variable index, Variable value) {
            super(pb, list, startAt, index, value);
            this.vvar = value;
            this.vdom = value.dom;
            this.vpos = IntStream.range(0, this.scp.length).filter(i -> this.scp[i] == value).findFirst().getAsInt();
            this.valueSentinels = Kit.repeat(-1, value.dom.initSize());
            this.listSentinels = Kit.repeat(-1, list.length);
            this.defineKey(new Object[0]);
        }

        public ElementVariable(Problem pb, Variable[] list, Variable index, Variable value) {
            this(pb, list, 0, index, value);
        }

        private boolean validSentinelForListAt(int i) {
            int sentinel = this.listSentinels[i];
            if (sentinel != -1 && this.list[i].dom.presentValue(sentinel) && this.vdom.presentValue(sentinel)) {
                return true;
            }
            Domain dom = this.list[i].dom;
            int a = dom.first();
            while (a != -1) {
                int va = dom.toVal(a);
                if (this.vdom.presentValue(va)) {
                    this.listSentinels[i] = va;
                    return true;
                }
                a = dom.next(a);
            }
            return false;
        }

        private boolean validSentinelForValue(int a) {
            int va = this.vdom.toVal(a);
            int sentinel = this.valueSentinels[a];
            if (sentinel != -1 && this.idom.present(sentinel) && this.list[sentinel].dom.presentValue(va)) {
                return true;
            }
            int i = this.idom.first();
            while (i != -1) {
                if (this.list[i].dom.presentValue(va)) {
                    this.valueSentinels[a] = i;
                    return true;
                }
                i = this.idom.next(i);
            }
            return false;
        }

        private boolean reduceDomainOfValue() {
            return this.vdom.removeIndexesChecking(a -> !this.validSentinelForValue((int)a));
        }

        private boolean reduceDomainOfIndex() {
            return this.idom.removeIndexesChecking(i -> !this.validSentinelForListAt((int)i));
        }

        @Override
        public boolean runPropagator(Variable dummy) {
            if (this.idom.size() > 1) {
                int sizeBefore;
                if (!this.reduceDomainOfValue()) {
                    return false;
                }
                do {
                    sizeBefore = this.idom.size();
                    if (!this.reduceDomainOfIndex()) {
                        return false;
                    }
                    if (sizeBefore == this.idom.size()) break;
                    sizeBefore = this.vdom.size();
                    if (this.reduceDomainOfValue()) continue;
                    return false;
                } while (sizeBefore != this.vdom.size());
            }
            if (this.idom.size() == 1) {
                Domain dom = this.list[this.idom.unique()].dom;
                if (!dom.removeValuesNotIn(this.vdom) || !this.vdom.removeValuesNotIn(dom)) {
                    return false;
                }
                if (dom.size() == 1) {
                    assert (this.vdom.size() == 1);
                    return this.entailed();
                }
            }
            return true;
        }

        private boolean controlGAC() {
            this.control(this.idom.size() != 1 || this.list[this.idom.unique()].dom.subsetOf(this.vdom), () -> "index is singleton and dom(index) is not included in dom(result).");
            int a = this.idom.first();
            while (a != -1) {
                this.control(this.list[a].dom.overlapWith(this.vdom), () -> "One var has no value in dom(result).");
                a = this.idom.next(a);
            }
            a = this.vdom.first();
            while (a != -1) {
                block4: {
                    int v = this.vdom.toVal(a);
                    int b = this.idom.first();
                    while (b != -1) {
                        if (!this.list[b].dom.presentValue(v)) {
                            b = this.idom.next(b);
                            continue;
                        }
                        break block4;
                    }
                    this.control(false, () -> "value " + v + " is in dom(value) but in no list variable whose index is still in dom(index).");
                }
                a = this.vdom.next(a);
            }
            return true;
        }
    }

    public static class ElementConstant
    extends Element
    implements Tags.TagFilteringCompleteAtEachCall {
        private final int k;

        @Override
        public boolean checkValues(int[] t) {
            throw new AssertionError();
        }

        @Override
        public boolean checkIndexes(int[] t) {
            int i = t[this.ipos];
            return this.list[i].dom.toVal(t[i]) == this.k;
        }

        public ElementConstant(Problem pb, Variable[] list, int startAt, Variable index, int value) {
            super(pb, list, startAt, index, value);
            this.k = value;
            this.defineKey(value, startAt);
            this.control(Variable.areAllDomainsContainingValue(list, this.k));
            if (this.ipos < list.length && list[this.ipos].dom.toVal(this.ipos) != this.k) {
                this.idom.removeValueAtConstructionTime(this.k);
            }
        }

        public ElementConstant(Problem pb, Variable[] list, Variable index, int value) {
            this(pb, list, 0, index, value);
        }

        @Override
        public boolean runPropagator(Variable dummy) {
            if (this.idom.size() > 1) {
                int sizeBefore = this.idom.size();
                int a = this.idom.first();
                while (a != -1) {
                    if (!this.list[a].dom.presentValue(this.k)) {
                        this.idom.removeElementary(a);
                    }
                    a = this.idom.next(a);
                }
                if (!this.idom.afterElementaryCalls(sizeBefore)) {
                    return false;
                }
            }
            if (this.idom.size() > 1) {
                return true;
            }
            return this.list[this.idom.unique()].dom.reduceToValue(this.k) && this.entailed();
        }
    }
}

