/*
 * Decompiled with CFR 0.152.
 */
package constraints.global;

import constraints.Constraint;
import interfaces.Observers;
import interfaces.Tags;
import java.util.stream.IntStream;
import org.xcsp.common.Utilities;
import problem.Problem;
import utility.Kit;
import variables.Domain;
import variables.Variable;

public final class DistinctVectors
extends Constraint.CtrGlobal
implements Observers.ObserverBacktracking.ObserverBacktrackingSystematic,
Tags.TagFilteringCompleteAtEachCall,
Tags.TagNotSymmetric {
    private Variable[] list1;
    private Variable[] list2;
    private int[] pos1;
    private int[] pos2;
    private int half;
    private int sentinel1 = -1;
    private int sentinel2 = -1;
    private int uniqueSentinel;
    private int uniqueSentinelLevel = -1;

    @Override
    public void restoreBefore(int depth) {
        if (this.uniqueSentinelLevel == depth) {
            this.uniqueSentinelLevel = -1;
        }
    }

    @Override
    public boolean checkValues(int[] t) {
        for (int i = 0; i < this.half; ++i) {
            if (t[this.pos1[i]] == t[this.pos2[i]]) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isGuaranteedAC() {
        return this.scp.length == 2 * this.half;
    }

    public DistinctVectors(Problem pb, Variable[] list1, Variable[] list2) {
        super(pb, (Variable[])pb.vars(new Object[]{list1, list2}));
        this.half = list1.length;
        this.list1 = list1;
        this.list2 = list2;
        this.control(this.half > 1 && this.half == list2.length && IntStream.range(0, this.half).allMatch(i -> list1[i] != list2[i]), " " + this.half + " " + Kit.join((Object)list1, new String[0]) + " " + Kit.join((Object)list2, new String[0]));
        this.pos1 = IntStream.range(0, this.half).map(i -> Utilities.indexOf(list1[i], this.scp)).toArray();
        this.pos2 = IntStream.range(0, this.half).map(i -> Utilities.indexOf(list2[i], this.scp)).toArray();
        this.sentinel1 = 0;
        this.sentinel2 = this.half - 1;
    }

    private boolean handleUniqueSentinel(Domain dom1, Domain dom2) {
        if (dom1.size() > 1 && dom2.size() > 1) {
            return true;
        }
        if (dom1.size() == 1) {
            return dom2.removeValueIfPresent(dom1.uniqueValue()) && this.entailed();
        }
        return dom1.removeValueIfPresent(dom2.uniqueValue()) && this.entailed();
    }

    private boolean isGoodSentinel(Domain dom1, Domain dom2) {
        return dom1.size() > 1 || dom2.size() > 1 || dom1.uniqueValue() != dom2.uniqueValue();
    }

    private int findAnotherSentinel() {
        for (int i = 0; i < this.half; ++i) {
            if (i == this.sentinel1 || i == this.sentinel2 || !this.isGoodSentinel(this.list1[i].dom, this.list2[i].dom)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean runPropagator(Variable event) {
        int sentinel;
        if (this.uniqueSentinelLevel != -1) {
            return this.handleUniqueSentinel(this.list1[this.uniqueSentinel].dom, this.list2[this.uniqueSentinel].dom);
        }
        Domain dx1 = this.list1[this.sentinel1].dom;
        Domain dx2 = this.list2[this.sentinel1].dom;
        Domain dy1 = this.list1[this.sentinel2].dom;
        Domain dy2 = this.list2[this.sentinel2].dom;
        if (dx1.size() == 1 && dx2.size() == 1) {
            if (dx1.uniqueValue() != dx2.uniqueValue()) {
                return this.entailed();
            }
            sentinel = this.findAnotherSentinel();
            if (sentinel != -1) {
                this.sentinel1 = sentinel;
                dx1 = this.list1[this.sentinel1].dom;
                dx2 = this.list2[this.sentinel1].dom;
            } else {
                this.uniqueSentinel = this.sentinel2;
                this.uniqueSentinelLevel = this.problem.solver.depth();
                return this.handleUniqueSentinel(dy1, dy2);
            }
        }
        if (dy1.size() == 1 && dy2.size() == 1) {
            if (dy1.uniqueValue() != dy2.uniqueValue()) {
                return this.entailed();
            }
            sentinel = this.findAnotherSentinel();
            if (sentinel != -1) {
                this.sentinel2 = sentinel;
            } else {
                this.uniqueSentinel = this.sentinel1;
                this.uniqueSentinelLevel = this.problem.solver.depth();
                return this.handleUniqueSentinel(dx1, dx2);
            }
        }
        return true;
    }
}

