/*
 * Decompiled with CFR 0.152.
 */
package constraints.global;

import constraints.Constraint;
import interfaces.Observers;
import interfaces.Tags;
import java.util.Arrays;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import problem.Problem;
import sets.SetSparse;
import sets.SetSparseReversible;
import utility.Kit;
import variables.Variable;

public abstract class Cumulative
extends Constraint.CtrGlobal
implements Tags.TagFilteringCompleteAtEachCall,
Tags.TagNotAC,
Observers.ObserverBacktracking.ObserverBacktrackingSystematic {
    protected final int nTasks;
    protected final Variable[] starts;
    protected int[] wwidths;
    protected int[] wheights;
    protected int limit;
    protected TimetableReasoner timetableReasoner;
    protected EnergeticReasoner energeticReasoner;
    protected long margin;
    protected boolean movableWidths;
    protected boolean movableHeights;

    @Override
    public void restoreBefore(int depth) {
        this.timetableReasoner.relevantTasks.restoreLimitAtLevel(depth);
    }

    @Override
    public void afterProblemConstruction() {
        super.afterProblemConstruction();
        this.timetableReasoner.relevantTasks = new SetSparseReversible(this.nTasks, this.problem.variables.length + 1);
    }

    @Override
    public boolean checkValues(int[] tuple) {
        int wgap;
        int n = wgap = !this.movableWidths ? -1 : this.nTasks;
        int hgap = !this.movableHeights ? -1 : (this instanceof CumulativeVarH ? this.nTasks : this.nTasks * 2);
        int min = Integer.MAX_VALUE;
        int max = Integer.MIN_VALUE;
        for (int i = 0; i < this.nTasks; ++i) {
            min = Math.min(min, tuple[i]);
            max = Math.max(max, tuple[i] + (wgap == -1 ? this.wwidths[i] : tuple[wgap + i]));
        }
        for (int t = min; t <= max; ++t) {
            int sum = 0;
            for (int i = 0; i < this.nTasks; ++i) {
                if (tuple[i] > t || t >= tuple[i] + (wgap == -1 ? this.wwidths[i] : tuple[wgap + i])) continue;
                sum += hgap == -1 ? this.wheights[i] : tuple[hgap + i];
            }
            if (sum <= this.limit) continue;
            return false;
        }
        return true;
    }

    protected int maxWidth(int i) {
        return this.wwidths[i];
    }

    protected int maxHeight(int i) {
        return this.wheights[i];
    }

    protected long tasksVolume() {
        long sum = 0L;
        for (int i = 0; i < this.nTasks; ++i) {
            sum += (long)(this.wwidths[i] * this.wheights[i]);
        }
        return sum;
    }

    private int horizon() {
        int min = Integer.MAX_VALUE;
        int max = Integer.MIN_VALUE;
        for (int i = 0; i < this.nTasks; ++i) {
            min = Math.min(min, this.starts[i].dom.firstValue());
            max = Math.max(max, this.starts[i].dom.lastValue() + this.maxWidth(i));
        }
        return max - min;
    }

    public Cumulative(Problem pb, Variable[] scp, Variable[] starts, int[] widths, int[] heights, int limit) {
        super(pb, scp);
        this.control(starts.length > 1 && Stream.of(starts).allMatch(x -> x.dom.firstValue() >= 0));
        this.nTasks = starts.length;
        this.starts = starts;
        this.movableWidths = widths == null;
        this.wwidths = this.movableWidths ? new int[this.nTasks] : widths;
        this.movableHeights = heights == null;
        this.wheights = this.movableHeights ? new int[this.nTasks] : heights;
        this.limit = limit;
        this.timetableReasoner = new TimetableReasoner();
        this.energeticReasoner = new EnergeticReasoner();
        System.out.println(this);
    }

    @Override
    public boolean runPropagator(Variable dummy) {
        long volume = this instanceof CumulativeCst ? ((CumulativeCst)this).volume : this.tasksVolume();
        this.margin = (long)(this.horizon() * this.limit) - volume;
        if (this.margin < 0L) {
            System.out.println("margin " + this.margin + " " + this.horizon() + " " + this.limit);
            return false;
        }
        Boolean b = this.timetableReasoner.buildSlots();
        if (b == Boolean.FALSE) {
            return false;
        }
        if (b == Boolean.TRUE) {
            return true;
        }
        b = this.energeticReasoner.filter();
        if (b == Boolean.FALSE) {
            return false;
        }
        if (b == Boolean.TRUE) {
            return true;
        }
        return this.timetableReasoner.filter();
    }

    @Override
    public String toString() {
        return "constraint cumulative: " + Kit.join((Object)this.starts, new String[0]) + " lengths=" + Kit.join((Object)this.wwidths, new String[0]) + " heights=" + Kit.join((Object)this.wheights, new String[0]) + " limit=" + this.limit;
    }

    public static final class CumulativeVarWH
    extends Cumulative {
        Variable[] widths;
        Variable[] heights;

        @Override
        protected int maxWidth(int i) {
            return this.widths[i].dom.lastValue();
        }

        @Override
        protected int maxHeight(int i) {
            return this.heights[i].dom.lastValue();
        }

        public CumulativeVarWH(Problem pb, Variable[] starts, Variable[] widths, Variable[] heights, int limit) {
            super(pb, (Variable[])pb.vars(new Object[]{starts, widths, heights}), starts, null, null, limit);
            this.widths = widths;
            this.heights = heights;
            this.control(this.scp.length == 3 * this.nTasks);
            this.control(widths.length == this.nTasks && heights.length == this.nTasks);
            this.control(Stream.of(widths).allMatch(x -> x.dom.firstValue() >= 0) && Stream.of(heights).allMatch(x -> x.dom.firstValue() >= 0));
        }
    }

    public static final class CumulativeVarH
    extends Cumulative {
        Variable[] heights;

        @Override
        protected int maxHeight(int i) {
            return this.heights[i].dom.lastValue();
        }

        public CumulativeVarH(Problem pb, Variable[] starts, int[] widths, Variable[] heights, int limit) {
            super(pb, (Variable[])pb.vars(new Object[]{starts, heights}), starts, widths, null, limit);
            this.heights = heights;
            this.control(this.scp.length == 2 * this.nTasks);
            this.control(widths.length == this.nTasks && heights.length == this.nTasks);
            this.control(IntStream.of(widths).allMatch(h -> h >= 0) && Stream.of(heights).allMatch(x -> x.dom.firstValue() >= 0));
        }

        @Override
        public boolean runPropagator(Variable dummy) {
            int i;
            for (i = 0; i < this.nTasks; ++i) {
                this.wheights[i] = this.heights[i].dom.firstValue();
            }
            if (!super.runPropagator(dummy)) {
                return false;
            }
            block1: for (i = 0; i < this.nTasks; ++i) {
                if (this.starts[i].dom.size() != 1 || this.heights[i].dom.size() <= 1) continue;
                int start = this.starts[i].dom.uniqueValue();
                int increase = this.heights[i].dom.lastValue() - this.heights[i].dom.firstValue();
                for (int k = 0; k < this.timetableReasoner.nSlots; ++k) {
                    TimetableReasoner.Slot slot = this.timetableReasoner.slots[k];
                    int surplus = slot.height + increase - this.limit;
                    if (surplus <= 0) continue block1;
                    if (start + this.wwidths[i] <= slot.start || slot.end <= start) continue;
                    this.heights[i].dom.removeValuesGT(this.heights[i].dom.lastValue() - surplus);
                }
            }
            return true;
        }
    }

    public static final class CumulativeVarW
    extends Cumulative {
        Variable[] widths;

        @Override
        protected int maxWidth(int i) {
            return this.widths[i].dom.lastValue();
        }

        public CumulativeVarW(Problem pb, Variable[] starts, Variable[] widths, int[] heights, int limit) {
            super(pb, (Variable[])pb.vars(new Object[]{starts, widths}), starts, null, heights, limit);
            this.widths = widths;
            this.control(this.scp.length == 2 * this.nTasks);
            this.control(widths.length == this.nTasks && heights.length == this.nTasks);
            this.control(Stream.of(widths).allMatch(x -> x.dom.firstValue() >= 0) && IntStream.of(heights).allMatch(h -> h >= 0));
        }
    }

    public static final class CumulativeCst
    extends Cumulative {
        long volume;

        public CumulativeCst(Problem pb, Variable[] starts, int[] widths, int[] heights, int limit) {
            super(pb, starts, starts, widths, heights, limit);
            this.control(widths.length == this.nTasks && heights.length == this.nTasks);
            this.control(IntStream.of(widths).allMatch(w -> w >= 0) && IntStream.of(heights).allMatch(h -> h >= 0));
            this.volume = this.tasksVolume();
        }
    }

    class EnergeticReasoner {
        private Integer[] sortedTasks;
        private int[] smallestHeights;

        private EnergeticReasoner() {
            this.sortedTasks = (Integer[])IntStream.range(0, Cumulative.this.nTasks).boxed().toArray(Integer[]::new);
            if (!Cumulative.this.movableHeights) {
                Arrays.sort(this.sortedTasks, (i1, i2) -> Cumulative.this.wheights[i1] > Cumulative.this.wheights[i2] ? -1 : (Cumulative.this.wheights[i1] < Cumulative.this.wheights[i2] ? 1 : 0));
                int highest = Cumulative.this.wheights[this.sortedTasks[0]];
                int lowest = Cumulative.this.wheights[this.sortedTasks[Cumulative.this.nTasks - 1]];
                this.smallestHeights = new int[1];
            } else {
                this.smallestHeights = new int[2];
            }
        }

        private int largestHeightIndex() {
            for (int k = 0; k < this.sortedTasks.length; ++k) {
                int i = this.sortedTasks[k];
                if (Cumulative.this.starts[i].dom.size() <= 1) continue;
                return i;
            }
            return -1;
        }

        private void findSmallestHeights() {
            int k;
            int cnt = 0;
            for (k = this.sortedTasks.length - 1; k >= 0; --k) {
                int i = this.sortedTasks[k];
                if (Cumulative.this.starts[i].dom.size() <= 1) continue;
                this.smallestHeights[cnt++] = Cumulative.this.wheights[i];
                if (cnt == this.smallestHeights.length) break;
            }
            for (k = cnt; k < this.smallestHeights.length; ++k) {
                this.smallestHeights[k] = this.smallestHeights[cnt - 1];
            }
        }

        private Boolean filter() {
            int largest;
            if (Cumulative.this.movableHeights) {
                Arrays.sort(this.sortedTasks, (i1, i2) -> Cumulative.this.wheights[i1] > Cumulative.this.wheights[i2] ? -1 : (Cumulative.this.wheights[i1] < Cumulative.this.wheights[i2] ? 1 : 0));
            }
            if ((largest = this.largestHeightIndex()) == -1) {
                return Boolean.TRUE;
            }
            this.findSmallestHeights();
            int nSlots = Cumulative.this.timetableReasoner.nSlots;
            int largestHeight = Cumulative.this.wheights[largest];
            for (int k = nSlots - 1; k >= 0; --k) {
                TimetableReasoner.Slot slot = Cumulative.this.timetableReasoner.slots[k];
                int gap = Cumulative.this.limit - slot.height;
                if (gap <= largestHeight) break;
                int diff = gap - largestHeight;
                if (this.smallestHeights[0] <= diff || Cumulative.this.margin - (long)(diff * slot.width()) >= 0L || Cumulative.this.starts[largest].dom.removeValuesInRange(slot.start - Cumulative.this.wwidths[largest] + 1, slot.end)) continue;
                return Boolean.FALSE;
            }
            int s1 = this.smallestHeights[0];
            int s2 = this.smallestHeights.length <= 1 ? s1 : this.smallestHeights[1];
            int s3 = this.smallestHeights.length <= 2 ? s2 : this.smallestHeights[2];
            long currMargin = Cumulative.this.margin;
            boolean s1Used = false;
            for (int k = 0; k < nSlots; ++k) {
                TimetableReasoner.Slot slot = Cumulative.this.timetableReasoner.slots[k];
                int gap = Cumulative.this.limit - slot.height;
                if (gap == 0) continue;
                if (gap >= s3) break;
                int lost = gap < s1 ? gap : (gap < s2 ? (s1Used ? gap : gap - s1) : (gap < s1 + s2 ? gap - s2 : gap - s1 - s2));
                boolean bl = s1Used = s1 <= gap && gap < s2;
                assert (lost >= 0);
                if ((currMargin -= (long)(slot.width() * lost)) >= 0L) continue;
                return Boolean.FALSE;
            }
            return null;
        }
    }

    class TimetableReasoner {
        private SetSparseReversible relevantTasks;
        private Slot[] slots;
        private int nSlots;
        private SetSparse ticks;
        private int[] offsets;

        private TimetableReasoner() {
            int timeline = IntStream.range(0, Cumulative.this.nTasks).map(i -> Cumulative.this.starts[i].dom.lastValue() + Cumulative.this.maxWidth(i)).max().getAsInt() + 1;
            this.slots = (Slot[])IntStream.range(0, timeline).mapToObj(i -> new Slot()).toArray(Slot[]::new);
            this.ticks = new SetSparse(timeline);
            this.offsets = new int[timeline];
        }

        private int mandatoryStart(int i) {
            return Cumulative.this.starts[i].dom.lastValue();
        }

        private int mandatoryEnd(int i) {
            return Cumulative.this.starts[i].dom.firstValue() + Cumulative.this.wwidths[i];
        }

        private Boolean buildSlots() {
            this.ticks.clear();
            for (int j = this.relevantTasks.limit; j >= 0; --j) {
                int i = this.relevantTasks.dense[j];
                int ms = this.mandatoryStart(i);
                int me = this.mandatoryEnd(i);
                if (me <= ms) continue;
                if (!this.ticks.isPresent(ms)) {
                    this.ticks.add(ms);
                    this.offsets[ms] = 0;
                }
                int n = ms;
                this.offsets[n] = this.offsets[n] + Cumulative.this.wheights[i];
                if (!this.ticks.isPresent(me)) {
                    this.ticks.add(me);
                    this.offsets[me] = 0;
                }
                int n2 = me;
                this.offsets[n2] = this.offsets[n2] - Cumulative.this.wheights[i];
            }
            if (this.ticks.size() == 0) {
                return Boolean.TRUE;
            }
            int nRelevantTicks = 0;
            for (int j = 0; j <= this.ticks.limit; ++j) {
                if (this.offsets[this.ticks.dense[j]] == 0) continue;
                this.slots[nRelevantTicks++].start = this.ticks.dense[j];
            }
            Arrays.sort(this.slots, 0, nRelevantTicks, (t1, t2) -> t1.start < t2.start ? -1 : (t1.start > t2.start ? 1 : 0));
            int height = 0;
            for (int k = 0; k < nRelevantTicks - 1; ++k) {
                if ((height += this.offsets[this.slots[k].start]) > Cumulative.this.limit) {
                    return Boolean.FALSE;
                }
                this.slots[k].end = this.slots[k + 1].start;
                this.slots[k].height = height;
            }
            Arrays.sort(this.slots, 0, nRelevantTicks - 1, (t1, t2) -> t1.height > t2.height ? -1 : (t1.height < t2.height ? 1 : 0));
            this.nSlots = nRelevantTicks - 1;
            while (this.slots[this.nSlots - 1].height == 0) {
                --this.nSlots;
            }
            return null;
        }

        private void updateRelevantTasks() {
            int i;
            int j;
            int depth = Cumulative.this.problem.solver.depth();
            int smin = Integer.MAX_VALUE;
            int emax = Integer.MIN_VALUE;
            for (j = Cumulative.this.futvars.limit; j >= 0; --j) {
                i = Cumulative.this.futvars.dense[j];
                smin = Math.min(smin, Cumulative.this.starts[i].dom.firstValue());
                emax = Math.max(emax, Cumulative.this.starts[i].dom.lastValue() + Cumulative.this.maxWidth(i));
            }
            for (j = this.relevantTasks.limit; j >= 0; --j) {
                i = this.relevantTasks.dense[j];
                if (Cumulative.this.starts[i].dom.size() != 1 || Cumulative.this.starts[i].dom.lastValue() + Cumulative.this.maxWidth(i) > smin && emax > Cumulative.this.starts[i].dom.firstValue()) continue;
                this.relevantTasks.removeAtPosition(j, depth);
            }
        }

        private boolean filter() {
            int i;
            Variable lastPast = Cumulative.this.problem.solver.futVars.lastPast();
            for (int j = 0; j < Cumulative.this.nTasks && this.slots[0].height + Cumulative.this.wheights[i = Cumulative.this.energeticReasoner.sortedTasks[j].intValue()] > Cumulative.this.limit; ++j) {
                if (Cumulative.this.starts[i].assigned() && Cumulative.this.starts[i] != lastPast) continue;
                int ms = this.mandatoryStart(i);
                int me = this.mandatoryEnd(i);
                for (int k = 0; k < this.nSlots && this.slots[k].height + Cumulative.this.wheights[i] > Cumulative.this.limit; ++k) {
                    assert (this.slots[k].height != 0);
                    int rs = this.slots[k].start;
                    int re = this.slots[k].end;
                    if (me > ms && me > rs && re > ms || Cumulative.this.starts[i].dom.removeValuesInRange(rs - Cumulative.this.wwidths[i] + 1, re)) continue;
                    return false;
                }
            }
            this.updateRelevantTasks();
            return true;
        }

        class Slot {
            int start;
            int end;
            int height;

            Slot() {
            }

            int width() {
                return this.end - this.start + 1;
            }

            public String toString() {
                return "(" + this.start + "-" + this.end + ":" + this.height + ")";
            }
        }
    }
}

