/*
 * Decompiled with CFR 0.152.
 */
package constraints.global;

import constraints.Constraint;
import constraints.global.Matcher;
import interfaces.Observers;
import interfaces.Tags;
import java.util.stream.IntStream;
import org.xcsp.common.Utilities;
import problem.Problem;
import utility.Kit;
import variables.Variable;

public abstract class Cardinality
extends Constraint.CtrGlobal
implements Observers.ObserverBacktracking.ObserverBacktrackingSystematic {
    protected Matcher matcher;

    @Override
    public void restoreBefore(int depth) {
        this.matcher.restoreAtDepthBefore(depth);
    }

    @Override
    public int[] symmetryMatching() {
        return Kit.range(1, this.scp.length);
    }

    public Cardinality(Problem problem, Variable[] scope) {
        super(problem, scope);
    }

    @Override
    public boolean runPropagator(Variable x) {
        if (!this.matcher.findMaximumMatching()) {
            return x.dom.fail();
        }
        this.matcher.removeInconsistentValues();
        return true;
    }

    public static class CardinalityConstant
    extends Cardinality
    implements Tags.TagFilteringCompleteAtEachCall,
    Tags.TagAC {
        private int[] values;
        private int[] minOccs;
        private int[] maxOccs;

        @Override
        public boolean checkValues(int[] t) {
            for (int i = 0; i < this.values.length; ++i) {
                int nOccurrences = 0;
                for (int j = 0; j < t.length; ++j) {
                    if (t[j] != this.values[i]) continue;
                    ++nOccurrences;
                }
                if (nOccurrences >= this.minOccs[i] && nOccurrences <= this.maxOccs[i]) continue;
                return false;
            }
            return true;
        }

        public CardinalityConstant(Problem pb, Variable[] scp, int[] values, int[] minOccs, int[] maxOccs) {
            super(pb, scp);
            this.control(values.length == minOccs.length && values.length == maxOccs.length);
            this.values = values;
            this.minOccs = minOccs;
            this.maxOccs = maxOccs;
            this.defineKey(new Object[0]);
            this.matcher = new Matcher.MatcherCardinality(this, scp, values, minOccs, maxOccs);
        }

        public CardinalityConstant(Problem problem, Variable[] scope, int[] values, int[] nOccs) {
            this(problem, scope, values, nOccs, nOccs);
        }

        public CardinalityConstant(Problem problem, Variable[] scope, int zeroValue) {
            super(problem, scope);
            this.values = Kit.sort(Kit.intArray(Variable.setOfvaluesIn(scope)));
            this.minOccs = Kit.repeat(0, this.values.length);
            int position = Utilities.indexOf(zeroValue, this.values);
            this.control(position >= 0);
            this.maxOccs = IntStream.range(0, this.values.length).map(i -> i == position ? Integer.MAX_VALUE : 1).toArray();
            this.matcher = new Matcher.MatcherCardinality(this, scope, this.values, this.minOccs, this.maxOccs);
            this.defineKey(new Object[0]);
        }
    }
}

