/*
 * Decompiled with CFR 0.152.
 */
package constraints.global;

import constraints.Constraint;
import interfaces.Observers;
import interfaces.Tags;
import java.util.Arrays;
import java.util.stream.IntStream;
import problem.Problem;
import sets.SetDense;
import sets.SetSparseReversible;
import utility.Kit;
import variables.Domain;
import variables.Variable;

public abstract class BinPacking
extends Constraint.CtrGlobal
implements Tags.TagNotAC {
    protected final int[] sizes;
    protected final int[] limits;
    protected final long[] sums;

    @Override
    public final boolean checkValues(int[] t) {
        int i;
        Arrays.fill(this.sums, 0L);
        for (i = 0; i < t.length; ++i) {
            int n = this.scp[i].dom.toIdx(t[i]);
            this.sums[n] = this.sums[n] + (long)this.sizes[i];
        }
        for (i = 0; i < this.sums.length; ++i) {
            if (this.sums[i] <= (long)this.limits[i]) continue;
            return false;
        }
        return true;
    }

    public BinPacking(Problem pb, Variable[] scp, int[] sizes, int[] limits) {
        super(pb, scp);
        this.control(scp.length >= 2 && Variable.haveSameDomainType(scp));
        this.defineKey(Kit.join((Object)sizes, new String[0]) + " " + Kit.join((Object)limits, new String[0]));
        this.sizes = sizes;
        this.limits = limits;
        int nBins = scp[0].dom.initSize();
        this.sums = new long[nBins];
    }

    public BinPacking(Problem pb, Variable[] scp, int[] sizes, int limit) {
        this(pb, scp, sizes, Kit.repeat(limit, scp[0].dom.initSize()));
    }

    public static final class BinPacking2
    extends BinPacking
    implements Observers.ObserverConstruction,
    Observers.ObserverBacktracking.ObserverBacktrackingSystematic {
        private Bin[] bins;
        private Bin[] sortedBins;
        private SetDense[] fronts;
        private SetSparseReversible usableBins;

        @Override
        public void afterProblemConstruction() {
            super.afterProblemConstruction();
            this.usableBins = new SetSparseReversible(this.bins.length, true, this.problem.variables.length + 1);
        }

        @Override
        public void restoreBefore(int depth) {
            this.usableBins.restoreLimitAtLevel(depth);
        }

        public BinPacking2(Problem pb, Variable[] scp, int[] sizes, int[] limits) {
            super(pb, scp, sizes, limits);
            int nBins = scp[0].dom.initSize();
            this.bins = (Bin[])IntStream.range(0, nBins).mapToObj(i -> new Bin()).toArray(Bin[]::new);
            this.sortedBins = (Bin[])this.bins.clone();
            this.fronts = (SetDense[])IntStream.range(0, nBins).mapToObj(i -> new SetDense(scp.length)).toArray(SetDense[]::new);
        }

        public BinPacking2(Problem pb, Variable[] scp, int[] sizes, int limit) {
            this(pb, scp, sizes, Kit.repeat(limit, scp[0].dom.initSize()));
        }

        @Override
        public boolean runPropagator(Variable x) {
            for (int j = 0; j <= this.usableBins.limit; ++j) {
                int i = this.usableBins.dense[j];
                this.bins[i].set(i, this.limits[i]);
                this.sortedBins[j] = this.bins[i];
            }
            for (int i = 0; i < this.scp.length; ++i) {
                if (this.scp[i].dom.size() != 1) continue;
                this.bins[this.scp[i].dom.unique()].capacity -= this.sizes[i];
            }
            int maxSize = -1;
            int sortLimit = this.usableBins.limit + 1;
            block2: while (true) {
                maxSize = -1;
                Arrays.sort(this.sortedBins, 0, sortLimit, (b1, b2) -> Integer.compare(b1.capacity, b2.capacity));
                if (this.sortedBins[0].capacity < 0) {
                    return x.dom.fail();
                }
                for (SetDense set : this.fronts) {
                    set.clear();
                }
                for (int p = 0; p < this.scp.length; ++p) {
                    Domain dom = this.scp[p].dom;
                    if (dom.size() == 1) continue;
                    int position = -1;
                    for (int j = 0; position == -1 && j <= this.usableBins.limit; ++j) {
                        int i = this.sortedBins[j].index;
                        if (this.sizes[p] > this.sortedBins[j].capacity) {
                            if (dom.removeValueIfPresent(i)) continue;
                            return false;
                        }
                        if (!dom.present(i)) continue;
                        position = j;
                        this.fronts[j].add(p);
                    }
                    if (position == -1) {
                        return x.dom.fail();
                    }
                    if (dom.size() == 1) {
                        this.bins[dom.unique()].capacity -= this.sizes[p];
                        if (this.bins[dom.unique()].capacity < 0) {
                            return x.dom.fail();
                        }
                        sortLimit = position + 1;
                        continue block2;
                    }
                    if (this.sizes[p] <= maxSize) continue;
                    maxSize = this.sizes[p];
                }
                break;
            }
            int cumulatedCapacities = 0;
            int cumulatedSizes = 0;
            for (int j = this.usableBins.limit; j >= 0; --j) {
                int capacity = this.sortedBins[j].capacity;
                cumulatedCapacities += capacity;
                if (this.fronts[j].size() == 0) continue;
                int min = Integer.MAX_VALUE;
                int max = -1;
                for (int k = 0; k <= this.fronts[j].limit; ++k) {
                    int size = this.sizes[this.fronts[j].dense[k]];
                    min = Math.min(min, size);
                    max = Math.max(max, size);
                    cumulatedSizes += size;
                }
                boolean onyOnePossibleInTheBin = min > capacity / 2;
                this.sortedBins[j].lost = onyOnePossibleInTheBin ? capacity - max : 0;
                int lost = this.sortedBins[j].lost;
                for (int jj = this.usableBins.limit; jj > j; --jj) {
                    if (min <= this.sortedBins[jj].lost) {
                        this.sortedBins[jj].lost = 0;
                        continue;
                    }
                    lost += this.sortedBins[jj].lost;
                }
                int margin = cumulatedCapacities - lost - cumulatedSizes;
                if (margin < 0) {
                    return x.dom.fail();
                }
                if (onyOnePossibleInTheBin && margin - (max - min) < 0) {
                    for (int k = 0; k <= this.fronts[j].limit; ++k) {
                        int i = this.fronts[j].dense[k];
                        if (margin - (max - this.sizes[i]) >= 0 || this.scp[i].dom.removeValueIfPresent(this.sortedBins[j].index)) continue;
                        return false;
                    }
                }
                if (maxSize <= margin) continue;
                for (int left = 0; left < j; ++left) {
                    if (this.fronts[left].size() == 0) continue;
                    for (int k = 0; k <= this.fronts[left].limit; ++k) {
                        int p = this.fronts[left].dense[k];
                        int size = this.sizes[p];
                        if (size <= margin) continue;
                        for (int right = this.usableBins.limit; right >= j; --right) {
                            if (this.scp[p].dom.removeValueIfPresent(this.sortedBins[right].index)) continue;
                            return false;
                        }
                    }
                }
            }
            int smallestFreeItem = -1;
            int minUsableBin = Integer.MAX_VALUE;
            int maxUsableBin = -1;
            for (int i = 0; i < this.scp.length; ++i) {
                if (this.scp[i].dom.size() <= 1) continue;
                if (smallestFreeItem == -1) {
                    smallestFreeItem = i;
                }
                minUsableBin = Math.min(minUsableBin, this.scp[i].dom.first());
                maxUsableBin = Math.max(maxUsableBin, this.scp[i].dom.last());
            }
            if (smallestFreeItem == -1) {
                return true;
            }
            for (int j = this.usableBins.limit; j >= 0; --j) {
                int i = this.sortedBins[j].index;
                assert (this.usableBins.isPresent(i));
                if (this.sortedBins[j].capacity >= this.sizes[smallestFreeItem] && i <= maxUsableBin && i >= minUsableBin) continue;
                this.usableBins.remove(i, this.problem.solver.depth());
            }
            return true;
        }

        private static class Bin {
            int index;
            int capacity;
            int lost;

            private Bin() {
            }

            void set(int i, int c) {
                this.index = i;
                this.capacity = c;
            }

            public String toString() {
                return "(" + this.index + ":cap=" + this.capacity + ")";
            }
        }
    }

    public static final class BinPackingBasic
    extends BinPacking {
        private final SetDense set;

        public BinPackingBasic(Problem pb, Variable[] scp, int[] sizes, int[] limits) {
            super(pb, scp, sizes, limits);
            this.set = new SetDense(scp.length);
        }

        public BinPackingBasic(Problem pb, Variable[] scp, int[] sizes, int limit) {
            this(pb, scp, sizes, Kit.repeat(limit, scp[0].dom.initSize()));
        }

        @Override
        public boolean runPropagator(Variable x) {
            int i;
            Arrays.fill(this.sums, 0L);
            this.set.clear();
            for (i = 0; i < this.scp.length; ++i) {
                int a;
                int n = a = this.scp[i].dom.size() > 1 ? -1 : this.scp[i].dom.unique();
                if (a != -1) {
                    int n2 = a;
                    this.sums[n2] = this.sums[n2] + (long)this.sizes[i];
                    continue;
                }
                this.set.add(i);
            }
            for (i = 0; i < this.sums.length; ++i) {
                if (this.sums[i] <= (long)this.limits[i]) continue;
                return x.dom.fail();
            }
            for (i = this.set.limit; i >= 0; --i) {
                int p = this.set.dense[i];
                Domain dom = this.scp[p].dom;
                int sizeBefore = dom.size();
                int a = dom.first();
                while (a != -1) {
                    if (this.sums[a] + (long)this.sizes[p] > (long)this.limits[a]) {
                        dom.removeElementary(a);
                    }
                    a = dom.next(a);
                }
                if (dom.afterElementaryCalls(sizeBefore)) continue;
                return false;
            }
            return true;
        }
    }
}

