/*
 * Decompiled with CFR 0.152.
 */
package constraints.global;

import constraints.Constraint;
import interfaces.Tags;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import problem.Problem;
import sets.SetSparse;
import utility.Kit;
import variables.Domain;
import variables.Variable;

public final class Among
extends Constraint.CtrGlobal
implements Tags.TagSymmetric,
Tags.TagAC,
Tags.TagFilteringCompleteAtEachCall {
    private final Set<Integer> values;
    private final int k;
    private final SetSparse mixedVariables;

    @Override
    public boolean checkValues(int[] t) {
        return IntStream.of(t).filter(v -> this.values.contains(v)).count() == (long)this.k;
    }

    public Among(Problem pb, Variable[] list, int[] values, int k) {
        super(pb, list);
        this.values = new TreeSet<Integer>(IntStream.of(values).boxed().collect(Collectors.toList()));
        this.k = k;
        this.mixedVariables = new SetSparse(list.length);
        this.defineKey(Kit.join((Object)values, new String[0]), k);
        this.control(Kit.isStrictlyIncreasing(values), "Values must be given in increasing order");
        this.control(0 < k && k < list.length, "Bad value of k=" + k);
        this.control(Stream.of(list).allMatch(x -> x.dom.size() > 1 && IntStream.of(values).anyMatch(v -> x.dom.presentValue(v))), "Badly formed scope.");
    }

    @Override
    public boolean runPropagator(Variable x) {
        int i;
        int nGuaranteedVars = 0;
        int nPossibleVars = 0;
        this.mixedVariables.clear();
        for (i = 0; i < this.scp.length; ++i) {
            Domain dom = this.scp[i].dom;
            boolean atLeastOnePresentValue = false;
            boolean atLeastOneAbsentValue = false;
            int a = dom.first();
            while (!(a == -1 || atLeastOnePresentValue && atLeastOneAbsentValue)) {
                boolean b = this.values.contains(dom.toVal(a));
                atLeastOnePresentValue = atLeastOnePresentValue || b;
                atLeastOneAbsentValue = atLeastOneAbsentValue || !b;
                a = dom.next(a);
            }
            if (!atLeastOnePresentValue) continue;
            ++nPossibleVars;
            if (!atLeastOneAbsentValue && ++nGuaranteedVars > this.k) {
                return dom.fail();
            }
            if (!atLeastOneAbsentValue) continue;
            this.mixedVariables.add(i);
        }
        if (nGuaranteedVars == this.k) {
            for (i = this.mixedVariables.limit; i >= 0; --i) {
                this.scp[this.mixedVariables.dense[i]].dom.removeValuesIn(this.values);
            }
            return this.entailed();
        }
        if (nPossibleVars < this.k) {
            return x.dom.fail();
        }
        if (nPossibleVars == this.k) {
            for (i = this.mixedVariables.limit; i >= 0; --i) {
                this.scp[this.mixedVariables.dense[i]].dom.removeValuesNotIn(this.values);
            }
            return this.entailed();
        }
        return true;
    }
}

