/*
 * Decompiled with CFR 0.152.
 */
package constraints.global;

import constraints.Constraint;
import interfaces.Observers;
import interfaces.Tags;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import problem.Problem;
import sets.SetDense;
import sets.SetSparseReversible;
import variables.Domain;
import variables.Variable;

public final class AllEqual
extends Constraint.CtrGlobal
implements Observers.ObserverBacktracking.ObserverBacktrackingSystematic,
Tags.TagAC,
Tags.TagFilteringCompleteAtEachCall,
Tags.TagSymmetric {
    private final Map<Integer, Integer> map;
    private SetSparseReversible remainingValues;
    private SetDense lastRemovedValues;

    @Override
    public final boolean checkValues(int[] t) {
        for (int v : t) {
            if (v == t[0]) continue;
            return false;
        }
        return true;
    }

    @Override
    public void restoreBefore(int depth) {
        this.remainingValues.restoreLimitAtLevel(depth);
    }

    @Override
    public void afterProblemConstruction() {
        super.afterProblemConstruction();
        this.remainingValues = new SetSparseReversible(this.map.size(), this.problem.variables.length + 1);
        this.lastRemovedValues = new SetDense(this.map.size());
    }

    public AllEqual(Problem pb, Variable[] list) {
        super(pb, list);
        int[] allValues = Variable.setOfvaluesIn(list).stream().mapToInt(v -> v).sorted().toArray();
        this.map = IntStream.range(0, allValues.length).boxed().collect(Collectors.toMap(i -> allValues[i], i -> i, (v1, v2) -> v1 + v2, TreeMap::new));
        this.control(list.length > 1 && allValues.length > 1);
        this.defineKey(new Object[0]);
    }

    @Override
    public boolean runPropagator(Variable x) {
        Variable y;
        if (this.remainingValues.size() == 1) {
            return true;
        }
        Variable variable = y = x.dom.size() == 1 ? x : Variable.firstSingletonVariableIn(this.scp);
        if (y != null) {
            int v = y.dom.uniqueValue();
            for (Variable z : this.scp) {
                if (z == y || z.dom.reduceToValue(v)) continue;
                return false;
            }
            this.remainingValues.reduceTo(this.map.get(v), this.problem.solver.depth());
            return true;
        }
        this.lastRemovedValues.clear();
        for (Domain dom : this.doms) {
            int v;
            int a = dom.lastRemoved();
            while (a != -1 && this.remainingValues.isPresent(this.map.get(v = dom.toVal(a)))) {
                if (!this.lastRemovedValues.isPresent(v)) {
                    this.lastRemovedValues.add(v);
                }
                a = dom.prevRemoved(a);
            }
        }
        if (this.lastRemovedValues.size() == this.remainingValues.size()) {
            return x.dom.fail();
        }
        for (int i = this.scp.length - 1; i >= 0; --i) {
            this.scp[i].dom.removeValuesIn(this.lastRemovedValues);
        }
        int depth = this.problem.solver.depth();
        for (int i = this.lastRemovedValues.limit; i >= 0; --i) {
            this.remainingValues.remove(this.map.get(this.lastRemovedValues.dense[i]), depth);
        }
        return true;
    }
}

