/*
 * Decompiled with CFR 0.152.
 */
package constraints.extension.structures;

import constraints.Constraint;
import constraints.extension.structures.ExtensionStructure;
import utility.Kit;

public abstract class Matrix
extends ExtensionStructure {
    public Matrix(Constraint c) {
        super(c);
    }

    public static class Matrix3D
    extends Matrix {
        protected boolean[][][] supports;

        @Override
        public void storeTuples(int[][] tuples, boolean positive) {
            Constraint c = this.firstRegisteredCtr();
            this.supports = new boolean[c.doms[0].initSize()][c.doms[1].initSize()][c.doms[2].initSize()];
            if (!positive) {
                for (int i = 0; i < this.supports.length; ++i) {
                    for (int j = 0; j < this.supports[i].length; ++j) {
                        for (int k = 0; k < this.supports[i][j].length; ++k) {
                            this.supports[i][j][k] = true;
                        }
                    }
                }
            }
            if (c.indexesMatchValues) {
                for (int[] tuple : tuples) {
                    this.supports[tuple[0]][tuple[1]][tuple[2]] = positive;
                }
            } else {
                for (int[] tuple : tuples) {
                    this.supports[c.doms[0].toIdx((int)tuple[0])][c.doms[1].toIdx((int)tuple[1])][c.doms[2].toIdx((int)tuple[2])] = positive;
                }
            }
        }

        public Matrix3D(Constraint c) {
            super(c);
            assert (c.scp.length == 3);
        }

        public Matrix3D(Constraint c, Matrix3D matrix3D) {
            this(c);
            this.supports = Kit.cloneDeeply(matrix3D.supports);
        }

        @Override
        public final boolean checkIdxs(int[] t) {
            return this.supports[t[0]][t[1]][t[2]];
        }

        @Override
        public boolean removeTuple(int[] tuple) {
            assert (this.registeredCtrs().size() == 1);
            int a = tuple[0];
            int b = tuple[1];
            int c = tuple[2];
            if (!this.supports[a][b][c]) {
                return false;
            }
            this.supports[a][b][c] = false;
            this.incrementNbTuplesRemoved();
            return true;
        }
    }

    public static class Matrix2D
    extends Matrix {
        protected boolean[][] supports;

        @Override
        public void storeTuples(int[][] tuples, boolean positive) {
            Constraint c = this.firstRegisteredCtr();
            this.supports = new boolean[c.doms[0].initSize()][c.doms[1].initSize()];
            if (!positive) {
                Kit.fill(this.supports, true);
            }
            if (c.indexesMatchValues) {
                for (int[] tuple : tuples) {
                    this.supports[tuple[0]][tuple[1]] = positive;
                }
            } else {
                for (int[] tuple : tuples) {
                    this.supports[c.doms[0].toIdx((int)tuple[0])][c.doms[1].toIdx((int)tuple[1])] = positive;
                }
            }
        }

        public Matrix2D(Constraint c) {
            super(c);
            Kit.control(c.scp.length == 2);
        }

        public Matrix2D(Constraint c, Matrix2D matrix2D) {
            this(c);
            this.supports = Kit.cloneDeeply(matrix2D.supports);
        }

        @Override
        public final boolean checkIdxs(int[] t) {
            return this.supports[t[0]][t[1]];
        }

        @Override
        public boolean removeTuple(int[] tuple) {
            assert (this.registeredCtrs().size() == 1);
            int a = tuple[0];
            int b = tuple[1];
            if (!this.supports[a][b]) {
                return false;
            }
            this.supports[a][b] = false;
            this.incrementNbTuplesRemoved();
            return true;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("Matrix2D of " + this.firstRegisteredCtr() + "\n");
            boolean[][] blArray = this.supports;
            int n = blArray.length;
            for (int i = 0; i < n; ++i) {
                boolean[] t;
                for (boolean b : t = blArray[i]) {
                    sb.append(b ? "1" : "0");
                }
                sb.append("\n");
            }
            return sb.toString();
        }
    }
}

