/*
 * Decompiled with CFR 0.152.
 */
package constraints.extension.structures;

import constraints.Constraint;
import constraints.extension.CMDDShort;
import constraints.extension.structures.ExtensionStructure;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import utility.Kit;
import variables.Domain;
import variables.Variable;

public final class MDDShort
extends ExtensionStructure {
    public MDDNodeShort root;
    private Integer nNodes;
    private boolean reductionWhileProcessingTuples = false;
    private int nCreatedNodes = 2;

    public Integer nNodes() {
        return this.nNodes != null ? this.nNodes : (this.nNodes = Integer.valueOf(2 + this.root.nInternalNodes(new HashSet<Integer>())));
    }

    public int nextNodeId() {
        return this.nCreatedNodes++;
    }

    public MDDShort(CMDDShort c) {
        super(c);
    }

    public MDDShort(CMDDShort c, MDDNodeShort root) {
        this(c);
        this.root = root;
    }

    private MDDNodeShort recursiveReduction(MDDNodeShort node, Map<Kit.IntArrayHashKey, MDDNodeShort> reductionMap) {
        if (node.isLeaf()) {
            return node;
        }
        for (int i = 0; i < node.sons.length; ++i) {
            node.sons[i] = this.recursiveReduction(node.sons[i], reductionMap);
        }
        Kit.IntArrayHashKey hk = new Kit.IntArrayHashKey(Stream.of(node.sons).mapToInt(c -> c.id).toArray());
        return reductionMap.computeIfAbsent(hk, k -> node);
    }

    private void reduce(int[] prevTuple, int[] currTuple, Map<Kit.IntArrayHashKey, MDDNodeShort> reductionMap) {
        int v;
        int i = 0;
        MDDNodeShort node = this.root;
        while (prevTuple[i] == currTuple[i]) {
            v = prevTuple[i] == 0x7FFFFFFE ? node.sons.length - 1 : prevTuple[i];
            node = node.sons[v];
            ++i;
        }
        v = prevTuple[i] == 0x7FFFFFFE ? node.sons.length - 1 : prevTuple[i];
        node.sons[v] = this.recursiveReduction(node.sons[v], reductionMap);
    }

    private void finalizeStoreTuples() {
        this.root.buildSonsClasses();
        this.nNodes = this.root.renameNodes(1, new HashMap<Integer, MDDNodeShort>()) + 1;
        Kit.log.info("MDDShort : nNodes=" + this.nNodes + " nBuiltNodes=" + this.nCreatedNodes);
        assert (this.root.controlUniqueNodes(new HashMap<Integer, MDDNodeShort>()));
    }

    @Override
    public void storeTuples(int[][] tuples, boolean positive) {
        Kit.control(positive && tuples.length > 0);
        Constraint ctr = this.firstRegisteredCtr();
        int[] domainSizes = Variable.domSizeArrayOf(ctr.scp, true);
        HashMap<Kit.IntArrayHashKey, MDDNodeShort> reductionMap = new HashMap<Kit.IntArrayHashKey, MDDNodeShort>(2000);
        this.root = new MDDNodeShort(this, 0, domainSizes[0], positive);
        if (ctr.indexesMatchValues) {
            for (int i = 0; i < tuples.length; ++i) {
                this.root.addTuple(tuples[i], positive, domainSizes);
                if (!this.reductionWhileProcessingTuples || i <= 0) continue;
                this.reduce(tuples[i - 1], tuples[i], reductionMap);
            }
        } else {
            int[] previousTuple = null;
            int[] currentTuple = new int[tuples[0].length];
            for (int[] tuple : tuples) {
                for (int i = 0; i < currentTuple.length; ++i) {
                    currentTuple[i] = tuple[i] == 0x7FFFFFFE ? 0x7FFFFFFE : ctr.scp[i].dom.toIdx(tuple[i]);
                }
                this.root.addTuple(currentTuple, positive, domainSizes);
                if (!this.reductionWhileProcessingTuples) continue;
                if (previousTuple == null) {
                    previousTuple = (int[])currentTuple.clone();
                    continue;
                }
                this.reduce(previousTuple, currentTuple, reductionMap);
                int[] tmp = previousTuple;
                previousTuple = currentTuple;
                currentTuple = tmp;
            }
        }
        if (!this.reductionWhileProcessingTuples) {
            this.recursiveReduction(this.root, reductionMap);
        }
        this.finalizeStoreTuples();
    }

    private boolean checkIdxs(int[] t, int level, MDDNodeShort node) {
        if (node == MDDNodeShort.nodeT) {
            return true;
        }
        if (node == MDDNodeShort.nodeF) {
            return false;
        }
        return this.checkIdxs(t, level + 1, node.sons[t[level]]) || this.checkIdxs(t, level + 1, node.sons[node.sons.length - 1]);
    }

    @Override
    public boolean checkIdxs(int[] t) {
        return this.checkIdxs(t, 0, this.root);
    }

    public void displayTuples() {
        int cnt = this.root.displayTuples(Variable.buildDomainsArrayFor(this.firstRegisteredCtr().scp), new int[this.firstRegisteredCtr().scp.length], 0, 0);
        Kit.log.info(" => " + cnt + " tuples");
    }

    public static final class MDDNodeShort {
        public static final MDDNodeShort nodeF = new MDDNodeShort(null, 0);
        public static final MDDNodeShort nodeT = new MDDNodeShort(null, 1);
        public static int nBuiltNodes;
        private static boolean discardClassForNodeF;
        private final MDDShort mdd;
        public int id;
        public final int level;
        public MDDNodeShort[] sons;
        public int[][] sonsClasses;
        private Integer nSonsDifferentFromNodeF;
        public Object state;

        public String name() {
            return this == nodeF ? "nodeF" : (this == nodeT ? "nodeT" : (this.level == 0 ? "root" : "n" + this.id));
        }

        public int nSonsDifferentFromNodeF() {
            return this.nSonsDifferentFromNodeF != null ? this.nSonsDifferentFromNodeF : (this.nSonsDifferentFromNodeF = Integer.valueOf((int)Stream.of(this.sons).filter(c -> c != nodeF).count()));
        }

        public final boolean isLeaf() {
            return this == nodeF || this == nodeT;
        }

        private MDDNodeShort(MDDShort mdd, int level) {
            this.mdd = mdd;
            if (mdd == null) {
                this.id = level;
                this.level = -1;
            } else {
                this.id = mdd.nextNodeId();
                this.level = level;
            }
        }

        public MDDNodeShort(MDDShort mdd, int level, int nSons, boolean defaultNodeF) {
            this(mdd, level);
            this.sons = (MDDNodeShort[])IntStream.range(0, nSons + 1).mapToObj(i -> defaultNodeF ? nodeF : nodeT).toArray(MDDNodeShort[]::new);
        }

        public MDDNodeShort(MDDShort mdd, int level, int nSons, boolean defaultNodeF, Object state) {
            this(mdd, level, nSons, defaultNodeF);
            this.state = state;
        }

        private void addTuple(int level, int value, int[] tuple, boolean positive, int[] domSizes) {
            MDDNodeShort son = this.sons[value];
            if (!son.isLeaf()) {
                son.addTuple(level + 1, tuple, positive, domSizes);
            } else if (level == tuple.length - 1) {
                this.sons[value] = positive ? nodeT : nodeF;
            } else {
                this.sons[value] = new MDDNodeShort(this.mdd, level + 1, domSizes[level + 1], positive);
                this.sons[value].addTuple(level + 1, tuple, positive, domSizes);
            }
        }

        private void addTuple(int level, int[] tuple, boolean positive, int[] domSizes) {
            this.addTuple(level, tuple[level] == 0x7FFFFFFE ? this.sons.length - 1 : tuple[level], tuple, positive, domSizes);
        }

        public void addTuple(int[] tuple, boolean positive, int[] domSizes) {
            this.addTuple(0, tuple, positive, domSizes);
        }

        public void buildSonsClasses() {
            if (this.isLeaf() || this.sonsClasses != null) {
                return;
            }
            Map<MDDNodeShort, List<Integer>> map = IntStream.range(0, this.sons.length).filter(i -> !discardClassForNodeF || this.sons[i] != nodeF).boxed().collect(Collectors.groupingBy(i -> this.sons[i]));
            this.sonsClasses = (int[][])map.values().stream().map(list -> Kit.intArray(list)).toArray(x$0 -> new int[x$0][]);
            Stream.of(this.sons).forEach(s -> s.buildSonsClasses());
        }

        public int nInternalNodes(Set<Integer> set) {
            if (this.isLeaf() || set.contains(this.id)) {
                return 0;
            }
            set.add(this.id);
            return 1 + Stream.of(this.sons).mapToInt(c -> c.nInternalNodes(set)).sum();
        }

        private boolean canReachNodeT(Set<Integer> reachingNodes, Set<Integer> unreachingNodes) {
            if (this == nodeT || reachingNodes.contains(this.id)) {
                return true;
            }
            if (this == nodeF || unreachingNodes.contains(this.id)) {
                return false;
            }
            boolean found = false;
            for (int i = 0; i < this.sons.length; ++i) {
                if (!this.sons[i].canReachNodeT(reachingNodes, unreachingNodes)) {
                    this.sons[i] = nodeF;
                    continue;
                }
                found = true;
            }
            if (found) {
                reachingNodes.add(this.id);
            } else {
                unreachingNodes.add(this.id);
            }
            return found;
        }

        public boolean canReachNodeT() {
            return this.canReachNodeT(new HashSet<Integer>(), new HashSet<Integer>());
        }

        public int renameNodes(int lastId, Map<Integer, MDDNodeShort> map) {
            if (this.isLeaf() || map.get(this.id) == this) {
                return lastId;
            }
            this.id = ++lastId;
            map.put(this.id, this);
            for (MDDNodeShort son : this.sons) {
                lastId = son.renameNodes(lastId, map);
            }
            return lastId;
        }

        public boolean controlUniqueNodes(Map<Integer, MDDNodeShort> map) {
            MDDNodeShort node = map.get(this.id);
            if (node == null) {
                map.put(this.id, this);
            } else {
                Kit.control(node == this, () -> "two nodes with the same id in the MDD " + this.id);
            }
            return this.sons == null || Stream.of(this.sons).noneMatch(child -> !child.controlUniqueNodes(map));
        }

        public void display(int[] cnts, boolean displayClasses) {
            if (this.isLeaf()) {
                return;
            }
            Kit.log.fine(this.id + "@" + this.level + " => ");
            if (cnts != null) {
                int n = this.level;
                cnts[n] = cnts[n] + 1;
            }
            if (this.sons == null) {
                return;
            }
            Kit.log.fine("{" + Stream.of(this.sons).map(child -> child.id + "").collect(Collectors.joining(",")) + "}");
            if (displayClasses) {
                if (this.sonsClasses != null) {
                    for (int i = 0; i < this.sonsClasses.length; ++i) {
                        Kit.log.fine("class " + i + " => {" + Kit.join((Object)this.sonsClasses[i], new String[0]) + "}");
                    }
                }
                Kit.log.fine("nNotFFChilds=" + this.nSonsDifferentFromNodeF);
            }
            Stream.of(this.sons).filter(s -> s.id > this.id).forEach(s -> s.display(cnts, displayClasses));
        }

        public void display() {
            this.display(null, false);
        }

        public int displayTuples(Domain[] doms, int[] currTuple, int currLevel, int cnt) {
            if (this == nodeT) {
                Kit.log.info(Kit.join((Object)currTuple, new String[0]));
                ++cnt;
            }
            if (this.isLeaf()) {
                return cnt;
            }
            for (int i = 0; i < this.sons.length; ++i) {
                currTuple[currLevel] = i == this.sons.length - 1 ? 0x7FFFFFFE : doms[currLevel].toVal(i);
                cnt = this.sons[i].displayTuples(doms, currTuple, currLevel + 1, cnt);
            }
            return cnt;
        }

        private StringBuilder getTransitions(Domain[] doms, StringBuilder sb, Set<MDDNodeShort> processedNodes) {
            if (this.sons != null) {
                for (int i = 0; i < this.sons.length; ++i) {
                    if (this.sons[i] == nodeF) continue;
                    sb.append("(").append(this.name()).append(",").append(i == this.sons.length - 1 ? "*" : Integer.valueOf(doms[this.level].toVal(i))).append(",").append(this.sons[i].name()).append(")");
                }
                processedNodes.add(this);
                for (MDDNodeShort son : this.sons) {
                    if (processedNodes.contains(son)) continue;
                    son.getTransitions(doms, sb, processedNodes);
                }
            }
            return sb;
        }

        public String getTransitions(Domain[] doms) {
            return this.getTransitions(doms, new StringBuilder(), new HashSet<MDDNodeShort>()).toString();
        }

        public void collectCompressedTuples(List<int[][]> list, int[][] t, int level) {
            if (this == nodeT) {
                list.add(Kit.cloneDeeply(t));
            }
            if (this.isLeaf()) {
                return;
            }
            for (int i = 0; i < this.sonsClasses.length; ++i) {
                t[level] = this.sonsClasses[i];
                MDDNodeShort representativeChild = this.sons[this.sonsClasses[i][0]];
                representativeChild.collectCompressedTuples(list, t, level + 1);
            }
        }

        static {
            discardClassForNodeF = true;
        }
    }
}

