/*
 * Decompiled with CFR 0.152.
 */
package constraints.extension;

import constraints.extension.Extension;
import constraints.extension.structures.ExtensionStructure;
import constraints.extension.structures.Table;
import interfaces.Tags;
import java.util.Arrays;
import problem.Problem;
import sets.SetDenseReversible;
import variables.Domain;
import variables.Variable;

public class STR2NEG
extends Extension.ExtensionGlobal
implements Tags.TagNegative {
    protected int[][] tuples;
    protected SetDenseReversible set;
    protected int[][] nConflicts;
    protected int[] nMaxConflicts;
    protected long[] nValidTuples;
    protected int sSupSize;
    protected int[] sSup;

    @Override
    public void afterProblemConstruction() {
        super.afterProblemConstruction();
        this.tuples = ((Table)this.extStructure).tuples;
        this.set = new SetDenseReversible(this.tuples.length, this.problem.variables.length + 1);
        this.nConflicts = Variable.litterals(this.scp).intArray();
        this.nMaxConflicts = new int[this.scp.length];
        this.nValidTuples = new long[this.scp.length];
        this.sSup = new int[this.scp.length];
    }

    @Override
    public void restoreBefore(int depth) {
        this.set.restoreLimitAtLevel(depth);
        Arrays.fill(this.nMaxConflicts, 0);
    }

    public STR2NEG(Problem pb, Variable[] scp) {
        super(pb, scp);
    }

    @Override
    protected ExtensionStructure buildExtensionStructure() {
        return new Table(this);
    }

    protected void initializeStructuresBeforeFiltering() {
        this.sSupSize = 0;
        long nValid = Domain.nValidTuplesBoundedAtMaxValueFor(this.doms);
        for (int i = this.futvars.limit; i >= 0; --i) {
            int x = this.futvars.dense[i];
            long limit = nValid / (long)this.doms[x].size();
            if ((long)this.set.size() < limit || this.set.size() < this.nMaxConflicts[x]) continue;
            this.sSup[this.sSupSize++] = x;
            Arrays.fill(this.nConflicts[x], 0);
            this.nMaxConflicts[x] = 0;
            this.nValidTuples[x] = limit;
        }
    }

    @Override
    public boolean runPropagator(Variable dummy) {
        int depth = this.problem.solver.depth();
        this.initializeStructuresBeforeFiltering();
        for (int i = this.set.limit; i >= 0; --i) {
            int[] tuple = this.tuples[this.set.dense[i]];
            if (this.isValid(tuple)) {
                for (int j = this.sSupSize - 1; j >= 0; --j) {
                    int x = this.sSup[j];
                    int a = tuple[x];
                    int[] nArray = this.nConflicts[x];
                    int n = a;
                    int n2 = nArray[n] + 1;
                    nArray[n] = n2;
                    this.nMaxConflicts[x] = Math.max(this.nMaxConflicts[x], n2);
                    if ((long)this.nConflicts[x][a] == this.nValidTuples[x]) {
                        if (this.scp[x].dom.remove(a)) continue;
                        return false;
                    }
                    if ((long)(this.nMaxConflicts[x] + i) >= this.nValidTuples[x]) continue;
                    this.sSup[j] = this.sSup[--this.sSupSize];
                }
                continue;
            }
            this.set.removeAtPosition(i, depth);
        }
        return true;
    }
}

