/*
 * Decompiled with CFR 0.152.
 */
package constraints.extension;

import constraints.extension.STR1;
import interfaces.Tags;
import java.util.Arrays;
import problem.Problem;
import variables.Domain;
import variables.Variable;

public final class STR1NEG
extends STR1
implements Tags.TagNegative {
    protected int[][] nConflicts;

    @Override
    public void afterProblemConstruction() {
        super.afterProblemConstruction();
        this.nConflicts = Variable.litterals(this.scp).intArray();
    }

    public STR1NEG(Problem pb, Variable[] scp) {
        super(pb, scp);
    }

    @Override
    protected void beforeFiltering() {
        super.beforeFiltering();
        for (int i = this.futvars.limit; i >= 0; --i) {
            Arrays.fill(this.nConflicts[this.futvars.dense[i]], 0);
        }
    }

    @Override
    public boolean runPropagator(Variable evt) {
        int x;
        int depth = this.problem.solver.depth();
        this.beforeFiltering();
        for (int i = this.set.limit; i >= 0; --i) {
            int[] tuple = this.tuples[this.set.dense[i]];
            if (this.isValid(tuple)) {
                for (int j = this.futvars.limit; j >= 0; --j) {
                    x = this.futvars.dense[j];
                    int a = tuple[x];
                    int[] nArray = this.nConflicts[x];
                    int n = a;
                    nArray[n] = nArray[n] + 1;
                }
                continue;
            }
            this.set.removeAtPosition(i, depth);
        }
        long nValidTuples = Domain.nValidTuplesBoundedAtMaxValueFor(this.doms);
        for (int i = this.futvars.limit; i >= 0; --i) {
            x = this.futvars.dense[i];
            Domain dom = this.scp[x].dom;
            long limit = nValidTuples / (long)dom.size();
            int a = dom.first();
            while (a != -1) {
                if ((long)this.nConflicts[x][a] != limit) {
                    --this.cnt;
                    int n = x;
                    this.cnts[n] = this.cnts[n] - 1;
                    this.ac[x][a] = true;
                }
                a = dom.next(a);
            }
        }
        return this.updateDomains();
    }
}

