/*
 * Decompiled with CFR 0.152.
 */
package constraints.extension;

import constraints.extension.Extension;
import constraints.extension.structures.ExtensionStructure;
import constraints.extension.structures.Table;
import java.util.Arrays;
import problem.Problem;
import sets.SetDenseReversible;
import variables.Variable;

public class STR1
extends Extension.ExtensionGlobal {
    protected int[][] tuples;
    public SetDenseReversible set;
    protected boolean[][] ac;
    protected int[] cnts;
    protected int cnt;

    @Override
    public void afterProblemConstruction() {
        super.afterProblemConstruction();
        this.tuples = ((Table)this.extStructure).tuples;
        this.set = new SetDenseReversible(this.tuples.length, this.problem.variables.length + 1);
        this.ac = Variable.litterals(this.scp).booleanArray();
        this.cnts = new int[this.scp.length];
        this.control(this.tuples.length > 0);
    }

    @Override
    public void restoreBefore(int depth) {
        this.set.restoreLimitAtLevel(depth);
    }

    public STR1(Problem pb, Variable[] scp) {
        super(pb, scp);
        this.control(scp.length > 1, "Arity must be at least 2");
    }

    @Override
    protected ExtensionStructure buildExtensionStructure() {
        return new Table(this);
    }

    protected void beforeFiltering() {
        this.cnt = 0;
        for (int i = this.futvars.limit; i >= 0; --i) {
            int x = this.futvars.dense[i];
            this.cnts[x] = this.doms[x].size();
            this.cnt += this.cnts[x];
            Arrays.fill(this.ac[x], false);
        }
    }

    protected boolean updateDomains() {
        for (int i = this.futvars.limit; i >= 0 && this.cnt > 0; --i) {
            int x = this.futvars.dense[i];
            int nRemovals = this.cnts[x];
            if (nRemovals == 0) continue;
            if (!this.doms[x].remove(this.ac[x], nRemovals)) {
                return false;
            }
            this.cnt -= nRemovals;
        }
        return true;
    }

    @Override
    public boolean runPropagator(Variable dummy) {
        int depth = this.problem.solver.depth();
        this.beforeFiltering();
        for (int i = this.set.limit; i >= 0; --i) {
            int[] tuple = this.tuples[this.set.dense[i]];
            if (this.isValid(tuple)) {
                for (int j = this.futvars.limit; j >= 0; --j) {
                    int x = this.futvars.dense[j];
                    int a = tuple[x];
                    if (this.ac[x][a]) continue;
                    --this.cnt;
                    int n = x;
                    this.cnts[n] = this.cnts[n] - 1;
                    this.ac[x][a] = true;
                }
                continue;
            }
            this.set.removeAtPosition(i, depth);
        }
        return this.updateDomains();
    }
}

