/*
 * Decompiled with CFR 0.152.
 */
package constraints.extension;

import constraints.extension.Extension;
import constraints.extension.structures.ExtensionStructure;
import constraints.extension.structures.Table;
import interfaces.Tags;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.IntStream;
import problem.Problem;
import sets.SetDenseReversible;
import utility.Kit;
import variables.Domain;
import variables.Variable;

public class GAC4
extends Extension.ExtensionGlobal
implements Tags.TagPositive {
    protected int[][] ptrs;
    protected SetDenseReversible[][] sups;
    private int[] lastRemoved;

    @Override
    public void afterProblemConstruction() {
        int x;
        super.afterProblemConstruction();
        int[][] tuples = ((Table)this.extStructure).tuples;
        assert (tuples.length > 0);
        List[][] tmp = (List[][])IntStream.range(0, this.scp.length).mapToObj(i -> (List[])IntStream.range(0, this.scp[i].dom.initSize()).mapToObj(j -> new ArrayList()).toArray(List[]::new)).toArray(x$0 -> new List[x$0][]);
        this.ptrs = new int[tuples.length][this.scp.length];
        for (int i2 = 0; i2 < tuples.length; ++i2) {
            for (int x2 = 0; x2 < tuples[i2].length; ++x2) {
                int a2 = tuples[i2][x2];
                tmp[x2][a2].add(i2);
                this.ptrs[i2][x2] = tmp[x2][a2].size() - 1;
            }
        }
        this.sups = new SetDenseReversible[this.scp.length][];
        for (x = 0; x < this.sups.length; ++x) {
            this.sups[x] = new SetDenseReversible[this.scp[x].dom.initSize()];
            for (int a3 = 0; a3 < this.sups[x].length; ++a3) {
                this.sups[x][a3] = new SetDenseReversible(Kit.intArray(tmp[x][a3]), true, this.problem.variables.length + 1);
            }
        }
        this.lastRemoved = Kit.repeat(-1, this.scp.length);
        assert (this.controlStructures());
        for (x = 0; x < this.scp.length; ++x) {
            Domain dom = this.scp[x].dom;
            SetDenseReversible[] set = this.sups[x];
            dom.execute(a -> {
                if (set[a].size() == 0) {
                    dom.removeAtConstructionTime((int)a);
                }
            });
        }
    }

    @Override
    public void restoreBefore(int depth) {
        for (int i = 0; i < this.sups.length; ++i) {
            for (int j = 0; j < this.sups[i].length; ++j) {
                if (this.sups[i][j] == null) continue;
                this.sups[i][j].restoreLimitAtLevel(depth);
            }
        }
        Arrays.fill(this.lastRemoved, -1);
    }

    @Override
    protected ExtensionStructure buildExtensionStructure() {
        return new Table(this);
    }

    public GAC4(Problem pb, Variable[] scp) {
        super(pb, scp);
        this.control(pb.head.control.solving.enablePrepro);
    }

    private boolean handleVariableAt(int x) {
        Domain dom = this.scp[x].dom;
        int depth = this.problem.solver.depth();
        int[][] tuples = ((Table)this.extStructure).tuples;
        int a = dom.lastRemoved();
        while (a != this.lastRemoved[x]) {
            SetDenseReversible droppedSet = this.sups[x][a];
            for (int j = droppedSet.limit; j >= 0; --j) {
                int droppedTuplePosition = droppedSet.dense[j];
                int[] tuple = tuples[droppedTuplePosition];
                assert (!this.isValid(tuple));
                for (int y = 0; y < this.scp.length; ++y) {
                    if (!this.scp[y].dom.present(tuple[y])) continue;
                    SetDenseReversible set = this.sups[y][tuple[y]];
                    int ptr = this.ptrs[droppedTuplePosition][y];
                    if (ptr > set.limit) continue;
                    if (ptr < set.limit) {
                        int last = set.last();
                        assert (this.ptrs[last][y] == set.limit && set.dense[ptr] == droppedTuplePosition);
                        set.removeAtPosition(ptr, depth);
                        this.ptrs[droppedTuplePosition][y] = set.limit + 1;
                        this.ptrs[last][y] = ptr;
                        assert (set.dense[set.limit + 1] == droppedTuplePosition && set.dense[ptr] == last);
                    } else {
                        set.moveLimitAtLevel(1, depth);
                    }
                    if (set.size() != 0 || this.scp[y].dom.remove(tuple[y])) continue;
                    return false;
                }
            }
            droppedSet.storeLimitAtLevel(depth);
            droppedSet.clear();
            a = dom.prevRemoved(a);
        }
        return true;
    }

    @Override
    public boolean runPropagator(Variable x) {
        int i;
        Variable lastPast = this.problem.solver.futVars.lastPast();
        if (x == lastPast && !this.handleVariableAt(this.positionOf(x))) {
            return false;
        }
        for (i = this.futvars.limit; i >= 0; --i) {
            if (this.handleVariableAt(this.futvars.dense[i])) continue;
            return false;
        }
        for (i = this.futvars.limit; i >= 0; --i) {
            this.lastRemoved[this.futvars.dense[i]] = this.scp[this.futvars.dense[i]].dom.lastRemoved();
        }
        assert (this.controlStructures());
        return true;
    }

    private boolean controlStructures() {
        int[][] tuples = ((Table)this.extStructure).tuples;
        for (int i = 0; i < this.ptrs.length; ++i) {
            int[] tuple = tuples[i];
            for (int x = 0; x < tuple.length; ++x) {
                int ptr = this.ptrs[i][x];
                if (this.sups[x][tuple[x]].dense[ptr] == i) continue;
                return false;
            }
        }
        return true;
    }
}

